/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.ivwloader;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.IngresDatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoaderMeta;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class IngresVectorwiseLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = IngresVectorwiseLoaderMeta.class;
    private static final char PASSWD_ECHO_CHAR = '*';
    private int middle;
    private int margin;
    private CCombo serverConnection;
    protected IngresVectorwiseLoaderMeta input;
    private ModifyListener lsMod;
    private SelectionAdapter lsSelMod;
    private TextVar wTable;
    private TextVar wFifoFile;
    private TextVar wSqlPath;
    private TableView wFields;
    private TextVar wDelimiter;
    private TextVar wCharSet;
    private TextVar wErrorFile;
    private TextVar wBufferSize;
    private TextVar wMaxErrors;
    private Button wContinueOnError;
    private Button wUseStandardConversion;
    private Button wUseAuthentication;
    private Button wUseDynamicVNode;
    private Button wUseSSV;
    private Button wEscapeSpecialChars;
    private Button wUseVwload;
    private Button wTruncateTable;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private int verticalPadding = 0;

    public IngresVectorwiseLoaderDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (IngresVectorwiseLoaderMeta)in;
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IngresVectorwiseLoaderDialog.this.input.setChanged();
            }
        };
        this.lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IngresVectorwiseLoaderDialog.this.input.setChanged();
            }
        };
    }

    public String open() {
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("Ingres VectorWise Loader");
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText("Step Name");
        this.wlStepname.setLayoutData((Object)this.standardLabelSpacing(null, null));
        this.props.setLook((Control)this.wlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.wStepname.setLayoutData((Object)this.standardInputSpacing(null, (Control)this.wlStepname));
        this.props.setLook((Control)this.wStepname);
        Control lastControl = this.addDbConnectionInputs();
        lastControl = this.addCustomInputs(lastControl);
        this.addVerticalPadding(2 * this.margin);
        this.addDefaultButtons(this.margin, lastControl);
        lastControl = this.addFieldSelection(lastControl);
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            Display display = this.getParent().getDisplay();
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private Control addFieldSelection(Control lastControl) {
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.InsertFields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(lastControl, 2 * this.margin);
        wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int UpInsRows = this.input.getFieldStream() != null ? this.input.getFieldStream().length : 1;
        ColumnInfo[] ciFields = new ColumnInfo[tableCols];
        ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(ciFields[0]);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciFields, UpInsRows, this.lsMod, this.props);
        Button wGetFields = new Button((Composite)this.shell, 8);
        wGetFields.setText(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGetFields = new FormData();
        fdGetFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdGetFields.right = new FormAttachment(100, 0);
        wGetFields.setLayoutData((Object)fdGetFields);
        Button wDoMapping = new Button((Composite)this.shell, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.Button", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wGetFields, this.margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wGetFields.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                IngresVectorwiseLoaderDialog.this.get();
            }
        });
        wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                IngresVectorwiseLoaderDialog.this.generateMappings();
            }
        });
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment((Control)wDoMapping, -this.margin);
        fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * this.margin);
        this.wFields.setLayoutData(fdFields);
        return this.wFields;
    }

    protected Control addDbConnectionInputs() {
        ArrayList<String> ibConnections = new ArrayList<String>();
        for (DatabaseMeta dbMeta : this.transMeta.getDatabases()) {
            if (!(dbMeta.getDatabaseInterface() instanceof IngresDatabaseMeta)) continue;
            ibConnections.add(dbMeta.getName());
        }
        this.serverConnection = this.addStandardSelect("Connection", (Control)this.wStepname, ibConnections.toArray(new String[ibConnections.size()]));
        return this.serverConnection;
    }

    protected Control addCustomInputs(Control prevControl) {
        this.wTable = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.TargetTable.Label", (String[])new String[0]), prevControl);
        this.wUseDynamicVNode = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.UseDynamicVNode.Label", (String[])new String[0]), (Control)this.wTable);
        this.wUseDynamicVNode.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wFifoFile = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.FifoFile.Label", (String[])new String[0]), (Control)this.wUseDynamicVNode);
        this.wSqlPath = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.SqlPath.Label", (String[])new String[0]), (Control)this.wFifoFile);
        this.wUseSSV = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.UseSSVDelimiter.Label", (String[])new String[0]), (Control)this.wSqlPath);
        this.wUseSSV.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wUseSSV.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (IngresVectorwiseLoaderDialog.this.wUseSSV.getSelection()) {
                    IngresVectorwiseLoaderDialog.this.wDelimiter.setEnabled(false);
                } else {
                    IngresVectorwiseLoaderDialog.this.wDelimiter.setEnabled(true);
                }
            }
        });
        this.wEscapeSpecialChars = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.EscapeSpecialChars.Label", (String[])new String[0]), (Control)this.wUseSSV);
        this.wUseVwload = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.UseVwload.Label", (String[])new String[0]), (Control)this.wEscapeSpecialChars);
        this.wTruncateTable = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.TruncateTable.Label", (String[])new String[0]), (Control)this.wUseVwload);
        this.wDelimiter = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.Delimiter.Label", (String[])new String[0]), (Control)this.wTruncateTable);
        this.wCharSet = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.Charset.Label", (String[])new String[0]), (Control)this.wDelimiter);
        this.wBufferSize = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.BufferSize.Label", (String[])new String[0]), (Control)this.wCharSet);
        this.wUseStandardConversion = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.UseStandardConversion.Label", (String[])new String[0]), (Control)this.wBufferSize);
        this.wUseStandardConversion.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wUseAuthentication = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.UseAuthentication.Label", (String[])new String[0]), (Control)this.wUseStandardConversion);
        this.wUseAuthentication.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wContinueOnError = this.addStandardCheckBox(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.ContinueOnError.Label", (String[])new String[0]), (Control)this.wUseAuthentication);
        this.wContinueOnError.addSelectionListener((SelectionListener)this.lsSelMod);
        this.wErrorFile = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.ErrorFile.Label", (String[])new String[0]), (Control)this.wContinueOnError);
        this.wErrorFile.addModifyListener(this.lsMod);
        this.wErrorFile.setEnabled(true);
        this.wMaxErrors = this.addStandardTextVar(BaseMessages.getString(PKG, (String)"IngresVectorwiseLoaderDialog.MaxErrors.Label", (String[])new String[0]), (Control)this.wErrorFile);
        return this.wMaxErrors;
    }

    protected CCombo addStandardSelect(String labelMessageKey, Control prevControl, String[] choices) {
        int vertPad = this.verticalPadding;
        Label label = this.addStandardLabel(labelMessageKey, prevControl);
        this.verticalPadding = vertPad;
        CCombo combo = new CCombo((Composite)this.shell, 2048);
        combo.setItems(choices);
        combo.addModifyListener(this.lsMod);
        combo.setLayoutData((Object)this.standardInputSpacing(prevControl, (Control)label));
        return combo;
    }

    protected TextVar addStandardTextVar(String labelMessageKey, Control prevControl) {
        int vertPad = this.verticalPadding;
        Label label = this.addStandardLabel(labelMessageKey, prevControl);
        this.verticalPadding = vertPad;
        TextVar targetControl = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        targetControl.addModifyListener(this.lsMod);
        targetControl.setLayoutData(this.standardInputSpacing(prevControl, (Control)label));
        targetControl.addSelectionListener(new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                IngresVectorwiseLoaderDialog.this.ok();
            }
        });
        return targetControl;
    }

    protected TextVar addPasswordTextVar(String labelMessageKey, Control prevControl) {
        TextVar textVar = this.addStandardTextVar(labelMessageKey, prevControl);
        textVar.setEchoChar('*');
        return textVar;
    }

    protected Button addStandardCheckBox(String labelMessageKey, Control prevControl) {
        Label label = this.addStandardLabel(labelMessageKey, prevControl);
        Button targetControl = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)targetControl);
        targetControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IngresVectorwiseLoaderDialog.this.input.setChanged();
            }
        });
        targetControl.setLayoutData((Object)this.standardInputSpacing(prevControl, (Control)label));
        return targetControl;
    }

    private Label addStandardLabel(String messageString, Control previousControl) {
        Label label = new Label((Composite)this.shell, 131072);
        label.setText(messageString);
        label.setLayoutData((Object)this.standardLabelSpacing(previousControl, (Control)label));
        this.props.setLook((Control)label);
        return label;
    }

    private void addVerticalPadding(int amount) {
        this.verticalPadding += amount;
    }

    private FormData standardLabelSpacing(Control control, Control centerControl) {
        return this.standardSpacing(control, centerControl, true);
    }

    private FormData standardInputSpacing(Control control, Control centerControl) {
        return this.standardSpacing(control, centerControl, false);
    }

    private FormData standardSpacing(Control control, Control centerControl, boolean isLabel) {
        FormData fd = new FormData();
        fd.left = isLabel ? new FormAttachment(0, 0) : new FormAttachment(this.middle, 0);
        fd.right = isLabel ? new FormAttachment(this.middle, -4) : new FormAttachment(100, 0);
        if (!isLabel && centerControl != null) {
            fd.top = new FormAttachment(centerControl, 0, 0x1000000);
        } else {
            int extraSpace = isLabel ? 4 + this.verticalPadding : 0;
            fd.top = control != null ? new FormAttachment(control, 4 + this.verticalPadding + extraSpace) : new FormAttachment(0, 4 + this.verticalPadding + extraSpace);
        }
        this.verticalPadding = 0;
        return fd;
    }

    private void addDefaultButtons(int margin, Control lastControl) {
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString(PKG, (String)"System.Button.SQL", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCreate, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                IngresVectorwiseLoaderDialog.this.cancel();
            }
        };
        this.lsCreate = new Listener(){

            public void handleEvent(Event e) {
                IngresVectorwiseLoaderDialog.this.sql();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                IngresVectorwiseLoaderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wCreate.addListener(13, this.lsCreate);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IngresVectorwiseLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                IngresVectorwiseLoaderDialog.this.cancel();
            }
        });
        this.setSize();
    }

    public void getData() {
        if (this.input.getDatabaseMeta() != null) {
            this.serverConnection.setText(this.input.getDatabaseMeta().getName());
        }
        this.wTable.setText(Const.NVL((String)this.input.getTableName(), (String)""));
        this.wFifoFile.setText(Const.NVL((String)this.input.getFifoFileName(), (String)""));
        this.wSqlPath.setText(Const.NVL((String)this.input.getSqlPath(), (String)""));
        this.wUseSSV.setSelection(this.input.isUseSSV());
        this.wEscapeSpecialChars.setSelection(this.input.isEscapingSpecialCharacters());
        this.wUseVwload.setSelection(this.input.isUsingVwload());
        this.wTruncateTable.setSelection(this.input.isTruncatingTable());
        if (this.input.isUseSSV()) {
            this.wDelimiter.setEnabled(false);
        }
        this.wDelimiter.setText(Const.NVL((String)this.input.getDelimiter(), (String)""));
        this.wCharSet.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wBufferSize.setText(Const.NVL((String)this.input.getBufferSize(), (String)""));
        this.wUseStandardConversion.setSelection(this.input.isUseStandardConversion());
        this.wUseAuthentication.setSelection(this.input.isUseAuthentication());
        this.wUseDynamicVNode.setSelection(this.input.isUseDynamicVNode());
        this.wContinueOnError.setSelection(this.input.isContinueOnError());
        this.wErrorFile.setText(Const.NVL((String)this.input.getErrorFileName(), (String)""));
        this.wMaxErrors.setText(Const.NVL((String)this.input.getMaxNrErrors(), (String)""));
        for (int i = 0; i < this.input.getFieldDatabase().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            if (this.input.getFieldDatabase()[i] != null) {
                item.setText(1, this.input.getFieldDatabase()[i]);
            }
            if (this.input.getFieldStream()[i] == null) continue;
            item.setText(2, this.input.getFieldStream()[i]);
        }
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    protected void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(IngresVectorwiseLoaderMeta input) {
        input.setDatabaseMeta(this.transMeta.findDatabase(this.serverConnection.getText()));
        input.setTablename(this.wTable.getText());
        input.setFifoFileName(this.wFifoFile.getText());
        input.setSqlPath(this.wSqlPath.getText());
        input.setUseSSV(this.wUseSSV.getSelection());
        input.setEscapingSpecialCharacters(this.wEscapeSpecialChars.getSelection());
        input.setUsingVwload(this.wUseVwload.getSelection());
        input.setTruncatingTable(this.wTruncateTable.getSelection());
        input.setDelimiter(this.wDelimiter.getText());
        input.setEncoding(this.wCharSet.getText());
        input.setBufferSize(this.wBufferSize.getText());
        input.setUseStandardConversion(this.wUseStandardConversion.getSelection());
        input.setContinueOnError(this.wContinueOnError.getSelection());
        input.setErrorFileName(this.wErrorFile.getText());
        input.setUseDynamicVNode(this.wUseDynamicVNode.getSelection());
        input.setMaxNrErrors(this.wMaxErrors.getText());
        int nrRows = this.wFields.nrNonEmpty();
        input.allocate(nrRows);
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            input.getFieldDatabase()[i] = Const.NVL((String)item.getText(1), (String)"");
            input.getFieldStream()[i] = Const.NVL((String)item.getText(2), (String)"");
        }
    }

    protected void ok() {
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    public BaseStepMeta getInput() {
        return this.input;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.serverConnection.getText()));
        this.input.setTablename(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    private void sql() {
        try {
            MessageBox mb;
            IngresVectorwiseLoaderMeta info = new IngresVectorwiseLoaderMeta();
            this.getInfo(info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            StepMeta stepMeta = this.transMeta.findStep(this.stepname);
            RowMeta prevNew = new RowMeta();
            for (int i = 0; i < info.getFieldDatabase().length; ++i) {
                ValueMetaInterface insValue = prev.searchValueMeta(info.getFieldStream()[i]);
                if (insValue == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.FailedToFindField.Message", (String[])new String[]{info.getFieldStream()[i]}));
                }
                ValueMetaInterface insertValue = insValue.clone();
                insertValue.setName(info.getFieldDatabase()[i]);
                prevNew.addValueMeta(insertValue);
            }
            prev = prevNew;
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.NoSQL.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.NoSQL.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

