/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputMeta;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutputMeta;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.dialog.TransDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class MappingDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MappingMeta.class;
    private MappingMeta mappingMeta;
    private Group gTransGroup;
    private Button radioFilename;
    private Button wbbFilename;
    private TextVar wFilename;
    private Button radioByName;
    private TextVar wTransname;
    private TextVar wDirectory;
    private Button wbTrans;
    private Button radioByReference;
    private Button wbByReference;
    private TextVar wByReference;
    private Button wEditTrans;
    private Button wNewTrans;
    private CTabFolder wTabFolder;
    private TransMeta mappingTransMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private int middle;
    private int margin;
    private MappingParameters mappingParameters;
    private List<MappingIODefinition> inputMappings;
    private List<MappingIODefinition> outputMappings;
    private Button wAddInput;
    private Button wAddOutput;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private Button wMultiInput;
    private Button wMultiOutput;
    private List<ApplyChanges> changeList;

    public MappingDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        int i;
        this.mappingMeta = (MappingMeta)in;
        this.transModified = false;
        this.mappingParameters = (MappingParameters)this.mappingMeta.getMappingParameters().clone();
        this.inputMappings = new ArrayList<MappingIODefinition>();
        this.outputMappings = new ArrayList<MappingIODefinition>();
        for (i = 0; i < this.mappingMeta.getInputMappings().size(); ++i) {
            this.inputMappings.add((MappingIODefinition)((MappingIODefinition)this.mappingMeta.getInputMappings().get(i)).clone());
        }
        for (i = 0; i < this.mappingMeta.getOutputMappings().size(); ++i) {
            this.outputMappings.add((MappingIODefinition)((MappingIODefinition)this.mappingMeta.getOutputMappings().get(i)).clone());
        }
        this.changeList = new ArrayList<ApplyChanges>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.mappingMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingDialog.this.mappingMeta.setChanged();
            }
        };
        this.changed = this.mappingMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(this.middle, -this.margin);
        this.fdlStepname.top = new FormAttachment(0, this.margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(this.middle, 0);
        this.fdStepname.top = new FormAttachment(0, this.margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.gTransGroup = new Group((Composite)this.shell, 16);
        this.gTransGroup.setText(BaseMessages.getString(PKG, (String)"MappingDialog.TransGroup.Label", (String[])new String[0]));
        this.gTransGroup.setBackground(this.shell.getBackground());
        FormLayout transGroupLayout = new FormLayout();
        transGroupLayout.marginLeft = this.margin * 2;
        transGroupLayout.marginTop = this.margin * 2;
        transGroupLayout.marginRight = this.margin * 2;
        transGroupLayout.marginBottom = this.margin * 2;
        this.gTransGroup.setLayout((Layout)transGroupLayout);
        this.radioFilename = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioFilename);
        this.radioFilename.setSelection(false);
        this.radioFilename.setText(BaseMessages.getString(PKG, (String)"MappingDialog.RadioFile.Label", (String[])new String[0]));
        this.radioFilename.setToolTipText(BaseMessages.getString(PKG, (String)"MappingDialog.RadioFile.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdFileRadio = new FormData();
        fdFileRadio.left = new FormAttachment(0, 0);
        fdFileRadio.right = new FormAttachment(100, 0);
        fdFileRadio.top = new FormAttachment(0, 0);
        this.radioFilename.setLayoutData((Object)fdFileRadio);
        this.radioFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                MappingDialog.this.setRadioButtons();
            }
        });
        this.wbbFilename = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.radioFilename, this.margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.selectFileTrans();
            }
        });
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(0, 25);
        fdFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdFilename.top = new FormAttachment((Control)this.wbbFilename, 0, 0x1000000);
        this.wFilename.setLayoutData(fdFilename);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                MappingDialog.this.setRadioButtons();
            }
        });
        this.radioByName = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByName);
        this.radioByName.setSelection(false);
        this.radioByName.setText(BaseMessages.getString(PKG, (String)"MappingDialog.RadioRep.Label", (String[])new String[0]));
        this.radioByName.setToolTipText(BaseMessages.getString(PKG, (String)"MappingDialog.RadioRep.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRepRadio = new FormData();
        fdRepRadio.left = new FormAttachment(0, 0);
        fdRepRadio.right = new FormAttachment(100, 0);
        fdRepRadio.top = new FormAttachment((Control)this.wbbFilename, 2 * this.margin);
        this.radioByName.setLayoutData((Object)fdRepRadio);
        this.radioByName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                MappingDialog.this.setRadioButtons();
            }
        });
        this.wbTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbTrans);
        this.wbTrans.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Select.Button", (String[])new String[0]));
        this.wbTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbTrans = new FormData();
        fdbTrans.right = new FormAttachment(100, 0);
        fdbTrans.top = new FormAttachment((Control)this.radioByName, 2 * this.margin);
        this.wbTrans.setLayoutData((Object)fdbTrans);
        this.wbTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.selectRepositoryTrans();
            }
        });
        this.wDirectory = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wDirectory);
        this.wDirectory.addModifyListener(this.lsMod);
        FormData fdTransDir = new FormData();
        fdTransDir.left = new FormAttachment(this.middle + (100 - this.middle) / 2, 0);
        fdTransDir.right = new FormAttachment((Control)this.wbTrans, -this.margin);
        fdTransDir.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wDirectory.setLayoutData(fdTransDir);
        this.wDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                MappingDialog.this.setRadioButtons();
            }
        });
        this.wTransname = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wTransname);
        this.wTransname.addModifyListener(this.lsMod);
        FormData fdTransName = new FormData();
        fdTransName.left = new FormAttachment(0, 25);
        fdTransName.right = new FormAttachment((Control)this.wDirectory, -this.margin);
        fdTransName.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wTransname.setLayoutData(fdTransName);
        this.wTransname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                MappingDialog.this.setRadioButtons();
            }
        });
        this.radioByReference = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByReference);
        this.radioByReference.setSelection(false);
        this.radioByReference.setText(BaseMessages.getString(PKG, (String)"MappingDialog.RadioRepByReference.Label", (String[])new String[0]));
        this.radioByReference.setToolTipText(BaseMessages.getString(PKG, (String)"MappingDialog.RadioRepByReference.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRadioByReference = new FormData();
        fdRadioByReference.left = new FormAttachment(0, 0);
        fdRadioByReference.right = new FormAttachment(100, 0);
        fdRadioByReference.top = new FormAttachment((Control)this.wTransname, 2 * this.margin);
        this.radioByReference.setLayoutData((Object)fdRadioByReference);
        this.radioByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                MappingDialog.this.setRadioButtons();
            }
        });
        this.wbByReference = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbByReference);
        this.wbByReference.setImage(GUIResource.getInstance().getImageTransGraph());
        this.wbByReference.setToolTipText(BaseMessages.getString(PKG, (String)"MappingDialog.SelectTrans.Tooltip", (String[])new String[0]));
        FormData fdbByReference = new FormData();
        fdbByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdbByReference.right = new FormAttachment(100, 0);
        this.wbByReference.setLayoutData((Object)fdbByReference);
        this.wbByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.selectTransformationByReference();
            }
        });
        this.wByReference = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18444);
        this.props.setLook((Control)this.wByReference);
        this.wByReference.addModifyListener(this.lsMod);
        FormData fdByReference = new FormData();
        fdByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdByReference.left = new FormAttachment(0, 25);
        fdByReference.right = new FormAttachment((Control)this.wbByReference, -this.margin);
        this.wByReference.setLayoutData(fdByReference);
        this.wByReference.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                MappingDialog.this.setRadioButtons();
            }
        });
        this.wNewTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wNewTrans);
        this.wNewTrans.setText(BaseMessages.getString(PKG, (String)"MappingDialog.New.Button", (String[])new String[0]));
        FormData fdNewTrans = new FormData();
        fdNewTrans.left = new FormAttachment(0, 0);
        fdNewTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wNewTrans.setLayoutData((Object)fdNewTrans);
        this.wNewTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.newTransformation();
            }
        });
        this.wEditTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wEditTrans);
        this.wEditTrans.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Edit.Button", (String[])new String[0]));
        this.wEditTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdEditTrans = new FormData();
        fdEditTrans.left = new FormAttachment((Control)this.wNewTrans, 2 * this.margin);
        fdEditTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wEditTrans.setLayoutData((Object)fdEditTrans);
        this.wEditTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog.this.editTrans();
            }
        });
        FormData fdTransGroup = new FormData();
        fdTransGroup.left = new FormAttachment(0, 0);
        fdTransGroup.top = new FormAttachment((Control)this.wStepname, 2 * this.margin);
        fdTransGroup.right = new FormAttachment(100, 0);
        this.gTransGroup.setLayoutData((Object)fdTransGroup);
        Group lastControl = this.gTransGroup;
        this.wMultiInput = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wMultiInput);
        this.wMultiInput.setText(BaseMessages.getString(PKG, (String)"MappingDialog.AllowMultipleInputs.Label", (String[])new String[0]));
        FormData fdMultiInput = new FormData();
        fdMultiInput.left = new FormAttachment(0, 0);
        fdMultiInput.right = new FormAttachment(100, 0);
        fdMultiInput.top = new FormAttachment((Control)lastControl, this.margin * 2);
        this.wMultiInput.setLayoutData((Object)fdMultiInput);
        this.wMultiInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingDialog.this.setFlags();
            }
        });
        lastControl = this.wMultiInput;
        this.wMultiOutput = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wMultiOutput);
        this.wMultiOutput.setText(BaseMessages.getString(PKG, (String)"MappingDialog.AllowMultipleOutputs.Label", (String[])new String[0]));
        FormData fdMultiOutput = new FormData();
        fdMultiOutput.left = new FormAttachment(0, 0);
        fdMultiOutput.right = new FormAttachment(100, 0);
        fdMultiOutput.top = new FormAttachment((Control)lastControl, this.margin);
        this.wMultiOutput.setLayoutData((Object)fdMultiOutput);
        this.wMultiOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingDialog.this.setFlags();
            }
        });
        lastControl = this.wMultiOutput;
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setSimple(false);
        this.wTabFolder.setUnselectedCloseVisible(true);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdTabFolder.bottom = new FormAttachment(100, -75);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wAddInput = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wAddInput);
        this.wAddInput.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.AddInput", (String[])new String[0]));
        this.wAddInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingIODefinition definition = new MappingIODefinition();
                definition.setRenamingOnOutput(true);
                MappingDialog.this.inputMappings.add(definition);
                int index = MappingDialog.this.inputMappings.size() - 1;
                MappingDialog.this.addInputMappingDefinitionTab(definition, index);
                MappingDialog.this.setFlags();
            }
        });
        this.wAddOutput = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wAddOutput);
        this.wAddOutput.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.AddOutput", (String[])new String[0]));
        this.wAddOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MappingIODefinition definition = new MappingIODefinition();
                MappingDialog.this.outputMappings.add(definition);
                int index = MappingDialog.this.outputMappings.size() - 1;
                MappingDialog.this.addOutputMappingDefinitionTab(definition, index);
                MappingDialog.this.setFlags();
            }
        });
        this.setButtonPositions(new Button[]{this.wAddInput, this.wAddOutput}, this.margin, (Control)this.wTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, this.margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MappingDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MappingDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MappingDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addSelectionListener(this.lsDef);
        this.wTransname.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MappingDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.mappingMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void selectTransformationByReference() {
        if (this.repository != null) {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository, true, false);
            sod.open();
            RepositoryElementMetaInterface repositoryObject = sod.getRepositoryObject();
            if (repositoryObject != null) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                this.getByReferenceData(repositoryObject);
                this.referenceObjectId = repositoryObject.getObjectId();
                this.setRadioButtons();
            }
        }
    }

    private void selectRepositoryTrans() {
        try {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository);
            String transName = sod.open();
            RepositoryDirectoryInterface repdir = sod.getDirectory();
            if (transName != null && repdir != null) {
                this.loadRepositoryTrans(transName, repdir);
                this.wTransname.setText(this.mappingTransMeta.getName());
                this.wDirectory.setText(this.mappingTransMeta.getRepositoryDirectory().getPath());
                this.wFilename.setText("");
                this.radioByName.setSelection(true);
                this.radioFilename.setSelection(false);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                this.setRadioButtons();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.mappingTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, true, null);
        this.mappingTransMeta.clearChanged();
    }

    private void selectFileTrans() {
        String curFile = this.wFilename.getText();
        FileObject root = null;
        try {
            root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
            if (file == null) {
                return;
            }
            String fname = null;
            fname = file.getURL().getFile();
            if (fname != null) {
                this.loadFileTrans(fname);
                this.wFilename.setText(this.mappingTransMeta.getFilename());
                this.wTransname.setText(Const.NVL((String)this.mappingTransMeta.getName(), (String)""));
                this.wDirectory.setText("");
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                this.setRadioButtons();
            }
        }
        catch (IOException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.mappingTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname));
        this.mappingTransMeta.clearChanged();
    }

    private void editTrans() {
        try {
            this.loadTransformation();
            SpoonInterface spoon = SpoonFactory.getInstance();
            if (spoon != null) {
                spoon.addTransGraph(this.mappingTransMeta);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorShowingTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorShowingTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadTransformation() throws KettleException {
        switch (this.specificationMethod) {
            case FILENAME: {
                this.loadFileTrans(this.wFilename.getText());
                break;
            }
            case REPOSITORY_BY_NAME: {
                String realDirectory = this.transMeta.environmentSubstitute(this.wDirectory.getText());
                String realTransname = this.transMeta.environmentSubstitute(this.wTransname.getText());
                if (Const.isEmpty((String)realDirectory) || Const.isEmpty((String)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToFindRepositoryDirectory)", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.mappingTransMeta = this.repository.loadTransformation(this.referenceObjectId, null);
                this.mappingTransMeta.clearChanged();
                break;
            }
        }
    }

    public void setActive() {
        boolean supportsReferences = this.repository != null && this.repository.getRepositoryMeta().getRepositoryCapabilities().supportsReferences();
        this.radioByName.setEnabled(this.repository != null);
        this.radioByReference.setEnabled(this.repository != null && supportsReferences);
        this.wFilename.setEnabled(this.radioFilename.getSelection());
        this.wbbFilename.setEnabled(this.radioFilename.getSelection());
        this.wTransname.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wDirectory.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wbTrans.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wByReference.setEnabled(this.repository != null && this.radioByReference.getSelection() && supportsReferences);
        this.wbByReference.setEnabled(this.repository != null && this.radioByReference.getSelection() && supportsReferences);
    }

    protected void setRadioButtons() {
        this.radioFilename.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.FILENAME);
        this.radioByName.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.radioByReference.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.setActive();
    }

    protected void newTransformation() {
        RowMeta inFields = new RowMeta();
        try {
            inFields = this.transMeta.getPrevStepFields(this.stepname);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Unable to get input fields from previous step", e);
        }
        TransMeta newTransMeta = new TransMeta();
        newTransMeta.getDatabases().addAll(this.transMeta.getDatabases());
        newTransMeta.setUsingUniqueConnections(this.transMeta.isUsingUniqueConnections());
        String INPUTSTEP_NAME = "Mapping Input";
        MappingInputMeta inputMeta = new MappingInputMeta();
        inputMeta.allocate(inFields.size());
        for (int i = 0; i < inFields.size(); ++i) {
            ValueMetaInterface valueMeta = inFields.getValueMeta(i);
            inputMeta.getFieldName()[i] = valueMeta.getName();
            inputMeta.getFieldType()[i] = valueMeta.getType();
            inputMeta.getFieldLength()[i] = valueMeta.getLength();
            inputMeta.getFieldPrecision()[i] = valueMeta.getPrecision();
        }
        StepMeta inputStep = new StepMeta(INPUTSTEP_NAME, (StepMetaInterface)inputMeta);
        inputStep.setLocation(50, 50);
        inputStep.setDraw(true);
        newTransMeta.addStep(inputStep);
        String OUTPUTSTEP_NAME = "Mapping Output";
        MappingOutputMeta outputMeta = new MappingOutputMeta();
        outputMeta.allocate(0);
        StepMeta outputStep = new StepMeta(OUTPUTSTEP_NAME, (StepMetaInterface)outputMeta);
        outputStep.setLocation(500, 50);
        outputStep.setDraw(true);
        newTransMeta.addStep(outputStep);
        newTransMeta.addTransHop(new TransHopMeta(inputStep, outputStep));
        TransDialog transDialog = new TransDialog(this.shell, 0, newTransMeta, this.repository);
        if (transDialog.open() != null) {
            Spoon spoon = Spoon.getInstance();
            spoon.addTransGraph(newTransMeta);
            boolean saved = false;
            try {
                if (this.repository != null) {
                    if (!Const.isEmpty((String)newTransMeta.getName())) {
                        this.wStepname.setText(newTransMeta.getName());
                    }
                    saved = spoon.saveToRepository((EngineMetaInterface)newTransMeta, false);
                    this.specificationMethod = this.repository.getRepositoryMeta().getRepositoryCapabilities().supportsReferences() ? ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE : ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                } else {
                    saved = spoon.saveToFile((EngineMetaInterface)newTransMeta);
                    this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error saving new transformation", e);
            }
            if (saved) {
                this.setRadioButtons();
                switch (this.specificationMethod) {
                    case FILENAME: {
                        this.wFilename.setText(Const.NVL((String)newTransMeta.getFilename(), (String)""));
                        break;
                    }
                    case REPOSITORY_BY_NAME: {
                        this.wTransname.setText(Const.NVL((String)newTransMeta.getName(), (String)""));
                        this.wDirectory.setText(newTransMeta.getRepositoryDirectory().getPath());
                        break;
                    }
                    case REPOSITORY_BY_REFERENCE: {
                        this.getByReferenceData(newTransMeta.getObjectId());
                        break;
                    }
                }
            }
        }
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            if (this.repository == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NotConnectedToRepository.Message", (String[])new String[0]));
            }
            RepositoryObject transInf = this.repository.getObjectInformation(transObjectId, RepositoryObjectType.JOB);
            if (transInf != null) {
                this.getByReferenceData((RepositoryElementMetaInterface)transInf);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getByReferenceData(RepositoryElementMetaInterface transInf) {
        String path = transInf.getRepositoryDirectory().getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + transInf.getName();
        this.wByReference.setText(path);
    }

    public void getData() {
        int i;
        this.specificationMethod = this.mappingMeta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wFilename.setText(Const.NVL((String)this.mappingMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                this.wDirectory.setText(Const.NVL((String)this.mappingMeta.getDirectoryPath(), (String)""));
                this.wTransname.setText(Const.NVL((String)this.mappingMeta.getTransName(), (String)""));
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.mappingMeta.getTransObjectId();
                this.wByReference.setText("");
                this.getByReferenceData(this.referenceObjectId);
                break;
            }
        }
        this.setRadioButtons();
        this.addParametersTab(this.mappingParameters);
        this.wTabFolder.setSelection(0);
        this.wMultiInput.setSelection(this.mappingMeta.isAllowingMultipleInputs());
        this.wMultiOutput.setSelection(this.mappingMeta.isAllowingMultipleOutputs());
        for (i = 0; i < this.inputMappings.size(); ++i) {
            this.addInputMappingDefinitionTab(this.inputMappings.get(i), i);
        }
        for (i = 0; i < this.outputMappings.size(); ++i) {
            this.addOutputMappingDefinitionTab(this.outputMappings.get(i), i);
        }
        try {
            this.loadTransformation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setFlags();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void addOutputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(this.outputMappings.get(index), index + 1 + this.inputMappings.size(), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.label.InputSourceStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.label.OutputTargetStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.label.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.OutputTab.column.TargetField", (String[])new String[0]), false);
    }

    private void addInputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(definition, index + 1, BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.label.InputSourceStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.label.OutputTargetStepName", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.label.Description", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.InputTab.column.TargetField", (String[])new String[0]), true);
    }

    private void addParametersTab(MappingParameters parameters) {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 5;
        parameterTabLayout.marginHeight = 5;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        Button wInheritAll = new Button(wParametersComposite, 32);
        wInheritAll.setText(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.bottom = new FormAttachment(100, 0);
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.right = new FormAttachment(100, -30);
        wInheritAll.setLayoutData((Object)fdInheritAll);
        wInheritAll.setSelection(parameters.isInheritingAllVariables());
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingDialog.Parameters.column.ValueOrField", (String[])new String[0]), 1, false, false)};
        colinfo[1].setUsingVariables(true);
        TableView wMappingParameters = new TableView((VariableSpace)this.transMeta, wParametersComposite, 67588, colinfo, parameters.getVariable().length, this.lsMod, this.props);
        this.props.setLook((Control)wMappingParameters);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0, 0);
        fdMappings.right = new FormAttachment(100, 0);
        fdMappings.top = new FormAttachment(0, 0);
        fdMappings.bottom = new FormAttachment((Control)wInheritAll, -this.margin * 2);
        wMappingParameters.setLayoutData(fdMappings);
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = wMappingParameters.table.getItem(i);
            tableItem.setText(1, parameters.getVariable()[i]);
            tableItem.setText(2, parameters.getInputField()[i]);
        }
        wMappingParameters.setRowNums();
        wMappingParameters.optWidth(true);
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
        this.changeList.add(new MappingParametersTab(wMappingParameters, wInheritAll, parameters));
    }

    protected String selectTransformationStepname(boolean getTransformationStep, boolean mappingInput) {
        String dialogTitle = BaseMessages.getString(PKG, (String)"MappingDialog.SelectTransStep.Title", (String[])new String[0]);
        String dialogMessage = BaseMessages.getString(PKG, (String)"MappingDialog.SelectTransStep.Message", (String[])new String[0]);
        if (getTransformationStep) {
            dialogTitle = BaseMessages.getString(PKG, (String)"MappingDialog.SelectTransStep.Title", (String[])new String[0]);
            dialogMessage = BaseMessages.getString(PKG, (String)"MappingDialog.SelectTransStep.Message", (String[])new String[0]);
            String[] stepnames = mappingInput ? this.transMeta.getPrevStepNames(this.stepMeta) : this.transMeta.getNextStepNames(this.stepMeta);
            EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, stepnames, dialogTitle, dialogMessage);
            return dialog.open();
        }
        dialogTitle = BaseMessages.getString(PKG, (String)"MappingDialog.SelectMappingStep.Title", (String[])new String[0]);
        dialogMessage = BaseMessages.getString(PKG, (String)"MappingDialog.SelectMappingStep.Message", (String[])new String[0]);
        String[] stepnames = MappingDialog.getMappingSteps(this.mappingTransMeta, mappingInput);
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, stepnames, dialogTitle, dialogMessage);
        return dialog.open();
    }

    public static String[] getMappingSteps(TransMeta mappingTransMeta, boolean mappingInput) {
        ArrayList<StepMeta> steps = new ArrayList<StepMeta>();
        for (StepMeta stepMeta : mappingTransMeta.getSteps()) {
            if (mappingInput && stepMeta.getStepID().equals("MappingInput")) {
                steps.add(stepMeta);
            }
            if (mappingInput || !stepMeta.getStepID().equals("MappingOutput")) continue;
            steps.add(stepMeta);
        }
        String[] stepnames = new String[steps.size()];
        for (int i = 0; i < stepnames.length; ++i) {
            stepnames[i] = ((StepMeta)steps.get(i)).getName();
        }
        return stepnames;
    }

    public RowMetaInterface getFieldsFromStep(String stepname, boolean getTransformationStep, boolean mappingInput) throws KettleException {
        if (!(mappingInput ^ getTransformationStep)) {
            if (Const.isEmpty((String)stepname)) {
                return this.transMeta.getPrevStepFields(this.stepname);
            }
            StepMeta stepMeta = this.transMeta.findStep(stepname);
            if (stepMeta == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.SpecifiedStepWasNotFound", (String[])new String[]{stepname}));
            }
            return this.transMeta.getStepFields(stepMeta);
        }
        if (this.mappingTransMeta == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.NoMappingSpecified", (String[])new String[0]));
        }
        if (Const.isEmpty((String)stepname)) {
            String[] stepnames = MappingDialog.getMappingSteps(this.mappingTransMeta, mappingInput);
            if (stepnames.length > 1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OnlyOneMappingInputStepAllowed", (String[])new String[]{"" + stepnames.length}));
            }
            if (stepnames.length == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OneMappingInputStepRequired", (String[])new String[]{"" + stepnames.length}));
            }
            return this.mappingTransMeta.getStepFields(stepnames[0]);
        }
        StepMeta stepMeta = this.mappingTransMeta.findStep(stepname);
        if (stepMeta == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.SpecifiedStepWasNotFound", (String[])new String[]{stepname}));
        }
        return this.mappingTransMeta.getStepFields(stepMeta);
    }

    private void addMappingDefinitionTab(final MappingIODefinition definition, int index, final String tabTitle, final String tabTooltip, String inputStepLabel, String outputStepLabel, String descriptionLabel, String sourceColumnLabel, String targetColumnLabel, final boolean input) {
        final CTabItem wTab = index >= this.wTabFolder.getItemCount() ? new CTabItem(this.wTabFolder, 64) : new CTabItem(this.wTabFolder, 64, index);
        this.setMappingDefinitionTabNameAndToolTip(wTab, tabTitle, tabTooltip, definition, input);
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 5;
        tabLayout.marginHeight = 5;
        wInputComposite.setLayout((Layout)tabLayout);
        final Button wbInputStep = new Button(wInputComposite, 8);
        this.props.setLook((Control)wbInputStep);
        wbInputStep.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.SourceStepName", (String[])new String[0]));
        FormData fdbInputStep = new FormData();
        fdbInputStep.top = new FormAttachment(0, 0);
        fdbInputStep.right = new FormAttachment(100, 0);
        wbInputStep.setLayoutData((Object)fdbInputStep);
        final Label wlInputStep = new Label(wInputComposite, 131072);
        this.props.setLook((Control)wlInputStep);
        wlInputStep.setText(inputStepLabel);
        FormData fdlInputStep = new FormData();
        fdlInputStep.top = new FormAttachment((Control)wbInputStep, 0, 0x1000000);
        fdlInputStep.left = new FormAttachment(0, 0);
        fdlInputStep.right = new FormAttachment(this.middle, -this.margin);
        wlInputStep.setLayoutData((Object)fdlInputStep);
        final Text wInputStep = new Text(wInputComposite, 18436);
        this.props.setLook((Control)wInputStep);
        wInputStep.setText(Const.NVL((String)definition.getInputStepname(), (String)""));
        wInputStep.addModifyListener(this.lsMod);
        FormData fdInputStep = new FormData();
        fdInputStep.top = new FormAttachment((Control)wbInputStep, 0, 0x1000000);
        fdInputStep.left = new FormAttachment(this.middle, 0);
        fdInputStep.right = new FormAttachment((Control)wbInputStep, -this.margin);
        wInputStep.setLayoutData((Object)fdInputStep);
        wInputStep.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                definition.setInputStepname(wInputStep.getText());
                MappingDialog.this.setMappingDefinitionTabNameAndToolTip(wTab, tabTitle, tabTooltip, definition, input);
            }
        });
        wbInputStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String stepName = MappingDialog.this.selectTransformationStepname(input, input);
                if (stepName != null) {
                    wInputStep.setText(stepName);
                    definition.setInputStepname(stepName);
                    MappingDialog.this.setMappingDefinitionTabNameAndToolTip(wTab, tabTitle, tabTooltip, definition, input);
                }
            }
        });
        final Button wbOutputStep = new Button(wInputComposite, 8);
        this.props.setLook((Control)wbOutputStep);
        wbOutputStep.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.SourceStepName", (String[])new String[0]));
        FormData fdbOutputStep = new FormData();
        fdbOutputStep.top = new FormAttachment((Control)wbInputStep, this.margin);
        fdbOutputStep.right = new FormAttachment(100, 0);
        wbOutputStep.setLayoutData((Object)fdbOutputStep);
        final Label wlOutputStep = new Label(wInputComposite, 131072);
        this.props.setLook((Control)wlOutputStep);
        wlOutputStep.setText(outputStepLabel);
        FormData fdlOutputStep = new FormData();
        fdlOutputStep.top = new FormAttachment((Control)wbOutputStep, 0, 0x1000000);
        fdlOutputStep.left = new FormAttachment(0, 0);
        fdlOutputStep.right = new FormAttachment(this.middle, -this.margin);
        wlOutputStep.setLayoutData((Object)fdlOutputStep);
        final Text wOutputStep = new Text(wInputComposite, 18436);
        this.props.setLook((Control)wOutputStep);
        wOutputStep.setText(Const.NVL((String)definition.getOutputStepname(), (String)""));
        wOutputStep.addModifyListener(this.lsMod);
        FormData fdOutputStep = new FormData();
        fdOutputStep.top = new FormAttachment((Control)wbOutputStep, 0, 0x1000000);
        fdOutputStep.left = new FormAttachment(this.middle, 0);
        fdOutputStep.right = new FormAttachment((Control)wbOutputStep, -this.margin);
        wOutputStep.setLayoutData((Object)fdOutputStep);
        final Label wlMainPath = new Label(wInputComposite, 131072);
        this.props.setLook((Control)wlMainPath);
        wlMainPath.setText(BaseMessages.getString(PKG, (String)"MappingDialog.input.MainDataPath", (String[])new String[0]));
        FormData fdlMainPath = new FormData();
        fdlMainPath.top = new FormAttachment((Control)wbOutputStep, this.margin);
        fdlMainPath.left = new FormAttachment(0, 0);
        fdlMainPath.right = new FormAttachment(this.middle, -this.margin);
        wlMainPath.setLayoutData((Object)fdlMainPath);
        final Button wMainPath = new Button(wInputComposite, 32);
        this.props.setLook((Control)wMainPath);
        FormData fdMainPath = new FormData();
        fdMainPath.top = new FormAttachment((Control)wbOutputStep, this.margin);
        fdMainPath.left = new FormAttachment(this.middle, 0);
        wMainPath.setLayoutData((Object)fdMainPath);
        wMainPath.setSelection(definition.isMainDataPath());
        wMainPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                definition.setMainDataPath(!definition.isMainDataPath());
            }
        });
        Object lastControl = wMainPath;
        Label wlDescription = new Label(wInputComposite, 131072);
        this.props.setLook((Control)wlDescription);
        wlDescription.setText(descriptionLabel);
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)lastControl, this.margin);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(this.middle, -this.margin);
        wlDescription.setLayoutData((Object)fdlDescription);
        final Text wDescription = new Text(wInputComposite, 19202);
        this.props.setLook((Control)wDescription);
        wDescription.setText(Const.NVL((String)definition.getDescription(), (String)""));
        wDescription.addModifyListener(this.lsMod);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)lastControl, this.margin);
        fdDescription.bottom = new FormAttachment((Control)lastControl, 100 + this.margin);
        fdDescription.left = new FormAttachment(this.middle, 0);
        fdDescription.right = new FormAttachment((Control)wbOutputStep, -this.margin);
        wDescription.setLayoutData((Object)fdDescription);
        wDescription.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                definition.setDescription(wDescription.getText());
            }
        });
        lastControl = wDescription;
        final Button wbEnterMapping = new Button(wInputComposite, 8);
        this.props.setLook((Control)wbEnterMapping);
        wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"MappingDialog.button.EnterMapping", (String[])new String[0]));
        FormData fdbEnterMapping = new FormData();
        fdbEnterMapping.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdbEnterMapping.right = new FormAttachment(100, 0);
        wbEnterMapping.setLayoutData((Object)fdbEnterMapping);
        wbEnterMapping.setEnabled(input);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(sourceColumnLabel, 1, false, false), new ColumnInfo(targetColumnLabel, 1, false, false)};
        final TableView wFieldMappings = new TableView((VariableSpace)this.transMeta, wInputComposite, 67588, colinfo, 1, this.lsMod, this.props);
        this.props.setLook((Control)wFieldMappings);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0, 0);
        fdMappings.right = new FormAttachment((Control)wbEnterMapping, -this.margin);
        fdMappings.top = new FormAttachment((Control)lastControl, this.margin * 2);
        fdMappings.bottom = new FormAttachment(100, -50);
        wFieldMappings.setLayoutData(fdMappings);
        lastControl = wFieldMappings;
        for (MappingValueRename valueRename : definition.getValueRenames()) {
            TableItem tableItem = new TableItem(wFieldMappings.table, 0);
            tableItem.setText(1, valueRename.getSourceValueName());
            tableItem.setText(2, valueRename.getTargetValueName());
        }
        wFieldMappings.removeEmptyRows();
        wFieldMappings.setRowNums();
        wFieldMappings.optWidth(true);
        wbEnterMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    RowMetaInterface sourceRowMeta = MappingDialog.this.getFieldsFromStep(wInputStep.getText(), true, input);
                    RowMetaInterface targetRowMeta = MappingDialog.this.getFieldsFromStep(wOutputStep.getText(), false, input);
                    String[] sourceFields = sourceRowMeta.getFieldNames();
                    String[] targetFields = targetRowMeta.getFieldNames();
                    EnterMappingDialog dialog = new EnterMappingDialog(MappingDialog.this.shell, sourceFields, targetFields);
                    List<SourceToTargetMapping> mappings = dialog.open();
                    if (mappings != null) {
                        wFieldMappings.clearAll(false);
                        definition.getValueRenames().clear();
                        for (int i = 0; i < mappings.size(); ++i) {
                            SourceToTargetMapping mapping = mappings.get(i);
                            TableItem item = new TableItem(wFieldMappings.table, 0);
                            item.setText(1, mapping.getSourceString(sourceFields));
                            item.setText(2, mapping.getTargetString(targetFields));
                            String source = input ? item.getText(1) : item.getText(2);
                            String target = input ? item.getText(2) : item.getText(1);
                            definition.getValueRenames().add(new MappingValueRename(source, target));
                        }
                        wFieldMappings.removeEmptyRows();
                        wFieldMappings.setRowNums();
                        wFieldMappings.optWidth(true);
                    }
                }
                catch (KettleException e) {
                    new ErrorDialog(MappingDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"MappingDialog.Exception.ErrorGettingMappingSourceAndTargetFields", (String[])new String[]{e.toString()}), (Exception)((Object)e));
                }
            }
        });
        wOutputStep.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                definition.setOutputStepname(wOutputStep.getText());
                try {
                    MappingDialog.this.enableMappingButton(wbEnterMapping, input, wInputStep.getText(), wOutputStep.getText());
                }
                catch (KettleException e) {
                    new ErrorDialog(MappingDialog.this.shell, "Error", "Unexpected error", (Exception)((Object)e));
                }
            }
        });
        wbOutputStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String stepName = MappingDialog.this.selectTransformationStepname(!input, input);
                if (stepName != null) {
                    wOutputStep.setText(stepName);
                    definition.setOutputStepname(stepName);
                    try {
                        MappingDialog.this.enableMappingButton(wbEnterMapping, input, wInputStep.getText(), wOutputStep.getText());
                    }
                    catch (KettleException e) {
                        new ErrorDialog(MappingDialog.this.shell, "Error", "Unexpected error", (Exception)((Object)e));
                    }
                }
            }
        });
        if (input) {
            Label wlRenameOutput = new Label(wInputComposite, 131072);
            this.props.setLook((Control)wlRenameOutput);
            wlRenameOutput.setText(BaseMessages.getString(PKG, (String)"MappingDialog.input.RenamingOnOutput", (String[])new String[0]));
            FormData fdlRenameOutput = new FormData();
            fdlRenameOutput.top = new FormAttachment((Control)lastControl, this.margin);
            fdlRenameOutput.left = new FormAttachment(0, 0);
            fdlRenameOutput.right = new FormAttachment(this.middle, -this.margin);
            wlRenameOutput.setLayoutData((Object)fdlRenameOutput);
            Button wRenameOutput = new Button(wInputComposite, 32);
            this.props.setLook((Control)wRenameOutput);
            FormData fdRenameOutput = new FormData();
            fdRenameOutput.top = new FormAttachment((Control)lastControl, this.margin);
            fdRenameOutput.left = new FormAttachment(this.middle, 0);
            wRenameOutput.setLayoutData((Object)fdRenameOutput);
            wRenameOutput.setSelection(definition.isRenamingOnOutput());
            wRenameOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    definition.setRenamingOnOutput(!definition.isRenamingOnOutput());
                }
            });
            lastControl = wRenameOutput;
        }
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wInputComposite.setLayoutData((Object)fdParametersComposite);
        wInputComposite.layout();
        wTab.setControl((Control)wInputComposite);
        final MappingDefinitionTab applyChanges = new MappingDefinitionTab(definition, wInputStep, wOutputStep, wMainPath, wDescription, wFieldMappings);
        this.changeList.add(applyChanges);
        this.wTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (event.item.equals(wTab)) {
                    MessageBox box = new MessageBox(MappingDialog.this.shell, 192);
                    box.setText(BaseMessages.getString((Class)PKG, (String)"MappingDialog.CloseDefinitionTabAreYouSure.Title", (String[])new String[0]));
                    box.setMessage(BaseMessages.getString((Class)PKG, (String)"MappingDialog.CloseDefinitionTabAreYouSure.Message", (String[])new String[0]));
                    int answer = box.open();
                    if (answer != 64) {
                        event.doit = false;
                    } else {
                        if (input) {
                            MappingDialog.this.inputMappings.remove(definition);
                        } else {
                            MappingDialog.this.outputMappings.remove(definition);
                        }
                        MappingDialog.this.changeList.remove(applyChanges);
                    }
                    MappingDialog.this.setFlags();
                }
            }
        });
        this.wMultiInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MappingDialog.this.setTabFlags(input, wlMainPath, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep);
            }
        });
        this.wMultiOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MappingDialog.this.setTabFlags(input, wlMainPath, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep);
            }
        });
        wMainPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MappingDialog.this.setTabFlags(input, wlMainPath, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep);
            }
        });
        this.setTabFlags(input, wlMainPath, wMainPath, wlInputStep, wInputStep, wbInputStep, wlOutputStep, wOutputStep, wbOutputStep);
        this.wTabFolder.setSelection(wTab);
    }

    private void setTabFlags(boolean input, Label wlMainPath, Button wMainPath, Label wlInputStep, Text wInputStep, Button wbInputStep, Label wlOutputStep, Text wOutputStep, Button wbOutputStep) {
        boolean multiInput = this.wMultiInput.getSelection();
        boolean multiOutput = this.wMultiOutput.getSelection();
        if (multiInput) {
            wlMainPath.setEnabled(true);
            wMainPath.setEnabled(true);
        } else {
            wMainPath.setSelection(true);
            wMainPath.setEnabled(false);
            wlMainPath.setEnabled(false);
        }
        boolean mainPath = wMainPath.getSelection();
        if (input) {
            wlInputStep.setEnabled(!mainPath);
            wInputStep.setEnabled(!mainPath);
            wbInputStep.setEnabled(!mainPath);
            wlOutputStep.setEnabled(multiInput);
            wOutputStep.setEnabled(multiInput);
            wbOutputStep.setEnabled(multiInput);
        } else {
            wlInputStep.setEnabled(multiOutput);
            wInputStep.setEnabled(multiOutput);
            wbInputStep.setEnabled(multiOutput);
            wlOutputStep.setEnabled(!mainPath);
            wOutputStep.setEnabled(!mainPath);
            wbOutputStep.setEnabled(!mainPath);
        }
    }

    private void setFlags() {
        boolean allowMultiInput = this.wMultiInput.getSelection();
        boolean allowMultiOutput = this.wMultiOutput.getSelection();
        this.wAddInput.setEnabled(allowMultiInput || this.inputMappings.size() == 0);
        this.wAddOutput.setEnabled(allowMultiOutput || this.outputMappings.size() == 0);
    }

    private void enableMappingButton(Button button, boolean input, String sourceStepname, String targetStepname) throws KettleException {
        StepMeta mappingOutputStep;
        RowMetaInterface requiredFields;
        StepMeta mappingInputStep;
        if (input) {
            return;
        }
        boolean enabled = false;
        if (this.mappingTransMeta != null && (mappingInputStep = this.mappingTransMeta.findMappingInputStep(sourceStepname)) != null && (requiredFields = (mappingOutputStep = this.transMeta.findMappingOutputStep(targetStepname)).getStepMetaInterface().getRequiredFields((VariableSpace)this.transMeta)) != null && requiredFields.size() > 0) {
            enabled = true;
        }
        button.setEnabled(enabled);
    }

    private void setMappingDefinitionTabNameAndToolTip(CTabItem wTab, String tabTitle, String tabTooltip, MappingIODefinition definition, boolean input) {
        String stepname = input ? definition.getInputStepname() : definition.getOutputStepname();
        String description = definition.getDescription();
        if (Const.isEmpty((String)stepname)) {
            wTab.setText(tabTitle);
        } else {
            wTab.setText(tabTitle + " : " + stepname);
        }
        String tooltip = tabTooltip;
        if (!Const.isEmpty((String)stepname)) {
            tooltip = tooltip + Const.CR + Const.CR + stepname;
        }
        if (!Const.isEmpty((String)description)) {
            tooltip = tooltip + Const.CR + Const.CR + description;
        }
        wTab.setToolTipText(tooltip);
    }

    private void cancel() {
        this.stepname = null;
        this.mappingMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.loadTransformation();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MappingDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.mappingMeta.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                this.mappingMeta.setFileName(this.wFilename.getText());
                this.mappingMeta.setDirectoryPath(null);
                this.mappingMeta.setTransName(null);
                this.mappingMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                this.mappingMeta.setDirectoryPath(this.wDirectory.getText());
                this.mappingMeta.setTransName(this.wTransname.getText());
                this.mappingMeta.setFileName(null);
                this.mappingMeta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.mappingMeta.setFileName(null);
                this.mappingMeta.setDirectoryPath(null);
                this.mappingMeta.setTransName(null);
                this.mappingMeta.setTransObjectId(this.referenceObjectId);
                break;
            }
        }
        this.collectInformation();
        this.mappingMeta.setMappingParameters(this.mappingParameters);
        this.mappingMeta.setInputMappings(this.inputMappings);
        this.mappingMeta.searchInfoAndTargetSteps(this.transMeta.getSteps());
        this.mappingMeta.setOutputMappings(this.outputMappings);
        this.mappingMeta.setAllowingMultipleInputs(this.wMultiInput.getSelection());
        this.mappingMeta.setAllowingMultipleOutputs(this.wMultiOutput.getSelection());
        this.mappingMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        for (ApplyChanges applyChanges : this.changeList) {
            applyChanges.applyChanges();
        }
    }

    private class MappingDefinitionTab
    implements ApplyChanges {
        private MappingIODefinition definition;
        private Text wInputStep;
        private Text wOutputStep;
        private Button wMainPath;
        private Text wDescription;
        private TableView wFieldMappings;

        public MappingDefinitionTab(MappingIODefinition definition, Text inputStep, Text outputStep, Button mainPath, Text description, TableView fieldMappings) {
            this.definition = definition;
            this.wInputStep = inputStep;
            this.wOutputStep = outputStep;
            this.wMainPath = mainPath;
            this.wDescription = description;
            this.wFieldMappings = fieldMappings;
        }

        @Override
        public void applyChanges() {
            this.definition.setInputStepname(this.wInputStep.getText());
            this.definition.setOutputStepname(this.wOutputStep.getText());
            this.definition.setDescription(this.wDescription.getText());
            this.definition.setMainDataPath(this.wMainPath.getSelection());
            int nrLines = this.wFieldMappings.nrNonEmpty();
            this.definition.getValueRenames().clear();
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wFieldMappings.getNonEmpty(i);
                this.definition.getValueRenames().add(new MappingValueRename(item.getText(1), item.getText(2)));
            }
        }
    }

    private class MappingParametersTab
    implements ApplyChanges {
        private TableView wMappingParameters;
        private MappingParameters parameters;
        private Button wInheritAll;

        public MappingParametersTab(TableView wMappingParameters, Button wInheritAll, MappingParameters parameters) {
            this.wMappingParameters = wMappingParameters;
            this.wInheritAll = wInheritAll;
            this.parameters = parameters;
        }

        @Override
        public void applyChanges() {
            int nrLines = this.wMappingParameters.nrNonEmpty();
            String[] variables = new String[nrLines];
            String[] inputFields = new String[nrLines];
            this.parameters.setVariable(variables);
            this.parameters.setInputField(inputFields);
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wMappingParameters.getNonEmpty(i);
                this.parameters.getVariable()[i] = item.getText(1);
                this.parameters.getInputField()[i] = item.getText(2);
            }
            this.parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        }
    }

    private static interface ApplyChanges {
        public void applyChanges();
    }
}

