/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.mysqlbulkloader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoaderMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class MySQLBulkLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MySQLBulkLoaderMeta.class;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlFifoFile;
    private TextVar wFifoFile;
    private FormData fdlFifoFile;
    private FormData fdFifoFile;
    private Label wlReplace;
    private Button wReplace;
    private FormData fdlReplace;
    private FormData fdReplace;
    private Label wlIgnore;
    private Button wIgnore;
    private FormData fdlIgnore;
    private FormData fdIgnore;
    private Label wlLocal;
    private Button wLocal;
    private FormData fdlLocal;
    private FormData fdLocal;
    private Label wlDelimiter;
    private Button wbDelimiter;
    private TextVar wDelimiter;
    private FormData fdlDelimiter;
    private FormData fdDelimiter;
    private Label wlEnclosure;
    private TextVar wEnclosure;
    private FormData fdlEnclosure;
    private FormData fdEnclosure;
    private Label wlEscapeChar;
    private TextVar wEscapeChar;
    private FormData fdlEscapeChar;
    private FormData fdEscapeChar;
    private Label wlCharSet;
    private TextVar wCharSet;
    private FormData fdlCharSet;
    private FormData fdCharSet;
    private Label wlBulkSize;
    private TextVar wBulkSize;
    private FormData fdlBulkSize;
    private FormData fdBulkSize;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Button wGetLU;
    private FormData fdGetLU;
    private Listener lsGetLU;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private MySQLBulkLoaderMeta input;
    private ColumnInfo[] ciReturn;
    private Map<String, Integer> inputFields;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public MySQLBulkLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (MySQLBulkLoaderMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MySQLBulkLoaderDialog.this.input.setChanged();
            }
        };
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                MySQLBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.wlFifoFile = new Label((Composite)this.shell, 131072);
        this.wlFifoFile.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.FifoFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFifoFile);
        this.fdlFifoFile = new FormData();
        this.fdlFifoFile.left = new FormAttachment(0, 0);
        this.fdlFifoFile.right = new FormAttachment(middle, -margin);
        this.fdlFifoFile.top = new FormAttachment((Control)this.wTable, margin);
        this.wlFifoFile.setLayoutData((Object)this.fdlFifoFile);
        this.wFifoFile = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFifoFile);
        this.wFifoFile.addModifyListener(lsMod);
        this.fdFifoFile = new FormData();
        this.fdFifoFile.left = new FormAttachment(middle, 0);
        this.fdFifoFile.top = new FormAttachment((Control)this.wTable, margin);
        this.fdFifoFile.right = new FormAttachment(100, 0);
        this.wFifoFile.setLayoutData(this.fdFifoFile);
        this.wlDelimiter = new Label((Composite)this.shell, 131072);
        this.wlDelimiter.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Delimiter.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDelimiter);
        this.fdlDelimiter = new FormData();
        this.fdlDelimiter.left = new FormAttachment(0, 0);
        this.fdlDelimiter.right = new FormAttachment(middle, -margin);
        this.fdlDelimiter.top = new FormAttachment((Control)this.wFifoFile, margin);
        this.wlDelimiter.setLayoutData((Object)this.fdlDelimiter);
        this.wbDelimiter = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbDelimiter);
        this.wbDelimiter.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Delimiter.Button", (String[])new String[0]));
        FormData fdbDelimiter = new FormData();
        fdbDelimiter.top = new FormAttachment((Control)this.wFifoFile, margin);
        fdbDelimiter.right = new FormAttachment(100, 0);
        this.wbDelimiter.setLayoutData((Object)fdbDelimiter);
        this.wDelimiter = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        this.fdDelimiter = new FormData();
        this.fdDelimiter.left = new FormAttachment(middle, 0);
        this.fdDelimiter.top = new FormAttachment((Control)this.wFifoFile, margin);
        this.fdDelimiter.right = new FormAttachment((Control)this.wbDelimiter, -margin);
        this.wDelimiter.setLayoutData(this.fdDelimiter);
        this.wbDelimiter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Text t = MySQLBulkLoaderDialog.this.wDelimiter.getTextWidget();
                if (t != null) {
                    t.insert("\t");
                }
            }
        });
        this.wlEnclosure = new Label((Composite)this.shell, 131072);
        this.wlEnclosure.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Enclosure.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEnclosure);
        this.fdlEnclosure = new FormData();
        this.fdlEnclosure.left = new FormAttachment(0, 0);
        this.fdlEnclosure.right = new FormAttachment(middle, -margin);
        this.fdlEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        this.wlEnclosure.setLayoutData((Object)this.fdlEnclosure);
        this.wEnclosure = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        this.fdEnclosure = new FormData();
        this.fdEnclosure.left = new FormAttachment(middle, 0);
        this.fdEnclosure.top = new FormAttachment((Control)this.wDelimiter, margin);
        this.fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData(this.fdEnclosure);
        this.wlEscapeChar = new Label((Composite)this.shell, 131072);
        this.wlEscapeChar.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.EscapeChar.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEscapeChar);
        this.fdlEscapeChar = new FormData();
        this.fdlEscapeChar.left = new FormAttachment(0, 0);
        this.fdlEscapeChar.right = new FormAttachment(middle, -margin);
        this.fdlEscapeChar.top = new FormAttachment((Control)this.wEnclosure, margin);
        this.wlEscapeChar.setLayoutData((Object)this.fdlEscapeChar);
        this.wEscapeChar = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEscapeChar);
        this.wEscapeChar.addModifyListener(lsMod);
        this.fdEscapeChar = new FormData();
        this.fdEscapeChar.left = new FormAttachment(middle, 0);
        this.fdEscapeChar.top = new FormAttachment((Control)this.wEnclosure, margin);
        this.fdEscapeChar.right = new FormAttachment(100, 0);
        this.wEscapeChar.setLayoutData(this.fdEscapeChar);
        this.wlCharSet = new Label((Composite)this.shell, 131072);
        this.wlCharSet.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.CharSet.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCharSet);
        this.fdlCharSet = new FormData();
        this.fdlCharSet.left = new FormAttachment(0, 0);
        this.fdlCharSet.right = new FormAttachment(middle, -margin);
        this.fdlCharSet.top = new FormAttachment((Control)this.wEscapeChar, margin);
        this.wlCharSet.setLayoutData((Object)this.fdlCharSet);
        this.wCharSet = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCharSet);
        this.wCharSet.addModifyListener(lsMod);
        this.fdCharSet = new FormData();
        this.fdCharSet.left = new FormAttachment(middle, 0);
        this.fdCharSet.top = new FormAttachment((Control)this.wEscapeChar, margin);
        this.fdCharSet.right = new FormAttachment(100, 0);
        this.wCharSet.setLayoutData(this.fdCharSet);
        this.wlBulkSize = new Label((Composite)this.shell, 131072);
        this.wlBulkSize.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.BulkSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBulkSize);
        this.fdlBulkSize = new FormData();
        this.fdlBulkSize.left = new FormAttachment(0, 0);
        this.fdlBulkSize.right = new FormAttachment(middle, -margin);
        this.fdlBulkSize.top = new FormAttachment((Control)this.wCharSet, margin);
        this.wlBulkSize.setLayoutData((Object)this.fdlBulkSize);
        this.wBulkSize = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBulkSize);
        this.wBulkSize.addModifyListener(lsMod);
        this.fdBulkSize = new FormData();
        this.fdBulkSize.left = new FormAttachment(middle, 0);
        this.fdBulkSize.top = new FormAttachment((Control)this.wCharSet, margin);
        this.fdBulkSize.right = new FormAttachment(100, 0);
        this.wBulkSize.setLayoutData(this.fdBulkSize);
        this.wlReplace = new Label((Composite)this.shell, 131072);
        this.wlReplace.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Replace.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReplace);
        this.fdlReplace = new FormData();
        this.fdlReplace.left = new FormAttachment(0, 0);
        this.fdlReplace.right = new FormAttachment(middle, -margin);
        this.fdlReplace.top = new FormAttachment((Control)this.wBulkSize, margin * 2);
        this.wlReplace.setLayoutData((Object)this.fdlReplace);
        this.wReplace = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wReplace);
        this.fdReplace = new FormData();
        this.fdReplace.left = new FormAttachment(middle, 0);
        this.fdReplace.top = new FormAttachment((Control)this.wBulkSize, margin * 2);
        this.fdReplace.right = new FormAttachment(100, 0);
        this.wReplace.setLayoutData((Object)this.fdReplace);
        this.wReplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MySQLBulkLoaderDialog.this.wReplace.getSelection()) {
                    MySQLBulkLoaderDialog.this.wIgnore.setSelection(false);
                }
            }
        });
        this.wlIgnore = new Label((Composite)this.shell, 131072);
        this.wlIgnore.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Ignore.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIgnore);
        this.fdlIgnore = new FormData();
        this.fdlIgnore.left = new FormAttachment(0, 0);
        this.fdlIgnore.right = new FormAttachment(middle, -margin);
        this.fdlIgnore.top = new FormAttachment((Control)this.wReplace, margin * 2);
        this.wlIgnore.setLayoutData((Object)this.fdlIgnore);
        this.wIgnore = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wIgnore);
        this.fdIgnore = new FormData();
        this.fdIgnore.left = new FormAttachment(middle, 0);
        this.fdIgnore.top = new FormAttachment((Control)this.wReplace, margin * 2);
        this.fdIgnore.right = new FormAttachment(100, 0);
        this.wIgnore.setLayoutData((Object)this.fdIgnore);
        this.wIgnore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (MySQLBulkLoaderDialog.this.wIgnore.getSelection()) {
                    MySQLBulkLoaderDialog.this.wReplace.setSelection(false);
                }
            }
        });
        this.wlLocal = new Label((Composite)this.shell, 131072);
        this.wlLocal.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Local.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLocal);
        this.fdlLocal = new FormData();
        this.fdlLocal.left = new FormAttachment(0, 0);
        this.fdlLocal.right = new FormAttachment(middle, -margin);
        this.fdlLocal.top = new FormAttachment((Control)this.wIgnore, margin * 2);
        this.wlLocal.setLayoutData((Object)this.fdlLocal);
        this.wLocal = new Button((Composite)this.shell, 16416);
        this.props.setLook((Control)this.wLocal);
        this.fdLocal = new FormData();
        this.fdLocal.left = new FormAttachment(middle, 0);
        this.fdLocal.top = new FormAttachment((Control)this.wIgnore, margin * 2);
        this.fdLocal.right = new FormAttachment(100, 0);
        this.wLocal.setLayoutData((Object)this.fdLocal);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wSQL}, margin, null);
        this.wlReturn = new Label((Composite)this.shell, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wLocal, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        int UpInsCols = 3;
        int UpInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.ColumnInfo.FormatOK", (String[])new String[0]), 2, MySQLBulkLoaderMeta.getFieldFormatTypeDescriptions(), true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.wGetLU = new Button((Composite)this.shell, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        this.fdGetLU = new FormData();
        this.fdGetLU.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)this.fdGetLU);
        this.wDoMapping = new Button((Composite)this.shell, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wGetLU, margin);
        this.fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MySQLBulkLoaderDialog.this.generateMappings();
            }
        });
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment((Control)this.wDoMapping, -margin);
        this.fdReturn.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wReturn.setLayoutData(this.fdReturn);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = MySQLBulkLoaderDialog.this.transMeta.findStep(MySQLBulkLoaderDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = MySQLBulkLoaderDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            MySQLBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        MySQLBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        MySQLBulkLoaderDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MySQLBulkLoaderDialog.this.ok();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                MySQLBulkLoaderDialog.this.getUpdate();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                MySQLBulkLoaderDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MySQLBulkLoaderDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MySQLBulkLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wFifoFile.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wDelimiter.addSelectionListener(this.lsDef);
        this.wEnclosure.addSelectionListener(this.lsDef);
        this.wCharSet.addSelectionListener(this.lsDef);
        this.wBulkSize.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MySQLBulkLoaderDialog.this.cancel();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MySQLBulkLoaderDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
                item.setText(3, MySQLBulkLoaderMeta.getFieldFormatTypeDescription((int)this.input.getFieldFormatType()[i]));
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wEnclosure.setText(Const.NVL((String)this.input.getEnclosure(), (String)""));
        this.wDelimiter.setText(Const.NVL((String)this.input.getDelimiter(), (String)""));
        this.wEscapeChar.setText(Const.NVL((String)this.input.getEscapeChar(), (String)""));
        this.wCharSet.setText(Const.NVL((String)this.input.getEncoding(), (String)""));
        this.wReplace.setSelection(this.input.isReplacingData());
        this.wIgnore.setSelection(this.input.isIgnoringErrors());
        this.wLocal.setSelection(this.input.isLocalFile());
        this.wBulkSize.setText(Const.NVL((String)this.input.getBulkSize(), (String)""));
        if (this.input.getFieldTable() != null) {
            for (int i = 0; i < this.input.getFieldTable().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getFieldTable()[i] != null) {
                    item.setText(1, this.input.getFieldTable()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                item.setText(3, MySQLBulkLoaderMeta.getFieldFormatTypeDescription((int)this.input.getFieldFormatType()[i]));
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getFifoFileName() != null) {
            this.wFifoFile.setText(this.input.getFifoFileName());
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(MySQLBulkLoaderMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrfields);
        inf.setEnclosure(this.wEnclosure.getText());
        inf.setDelimiter(this.wDelimiter.getText());
        inf.setEscapeChar(this.wEscapeChar.getText());
        inf.setEncoding(this.wCharSet.getText());
        inf.setReplacingData(this.wReplace.getSelection());
        inf.setIgnoringErrors(this.wIgnore.getSelection());
        inf.setLocalFile(this.wLocal.getSelection());
        inf.setBulkSize(this.wBulkSize.getText());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        }
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            inf.getFieldTable()[i] = item.getText(1);
            inf.getFieldStream()[i] = item.getText(2);
            inf.getFieldFormatType()[i] = MySQLBulkLoaderMeta.getFieldFormatType((String)item.getText(3));
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setFifoFileName(this.wFifoFile.getText());
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.getType() == 3) {
                            tableItem.setText(3, "Y");
                        } else {
                            tableItem.setText(3, "Y");
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1, 2}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            MySQLBulkLoaderMeta info = new MySQLBulkLoaderMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MySQLBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                block6: {
                    DatabaseMeta ci;
                    for (int i = 0; i < MySQLBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                        ColumnInfo colInfo = (ColumnInfo)MySQLBulkLoaderDialog.this.tableFieldColumns.get(i);
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Const.isEmpty((String)MySQLBulkLoaderDialog.this.wTable.getText()) && (ci = MySQLBulkLoaderDialog.this.transMeta.findDatabase(MySQLBulkLoaderDialog.this.wConnection.getText())) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(MySQLBulkLoaderDialog.this.transMeta.environmentSubstitute(MySQLBulkLoaderDialog.this.wSchema.getText()), MySQLBulkLoaderDialog.this.transMeta.environmentSubstitute(MySQLBulkLoaderDialog.this.wTable.getText()));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null == r || null == (fieldNames = r.getFieldNames())) break block6;
                            for (int i = 0; i < MySQLBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)MySQLBulkLoaderDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                        catch (Exception e) {
                            for (int i = 0; i < MySQLBulkLoaderDialog.this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = (ColumnInfo)MySQLBulkLoaderDialog.this.tableFieldColumns.get(i);
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

