/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.salesforceinput;

import java.io.IOException;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.pentaho.di.ui.core.gui.GUIResource;

public class SOQLValuesHighlight
implements LineStyleListener {
    JavaScanner scanner = new JavaScanner();
    int[] tokenColors;
    Color[] colors;
    Vector<int[]> blockComments = new Vector();
    public static final int EOF = -1;
    public static final int EOL = 10;
    public static final int WORD = 0;
    public static final int WHITE = 1;
    public static final int KEY = 2;
    public static final int COMMENT = 3;
    public static final int STRING = 5;
    public static final int OTHER = 6;
    public static final int NUMBER = 7;
    public static final int FUNCTIONS = 8;
    public static final int MAXIMUM_TOKEN = 9;

    public SOQLValuesHighlight() {
        this.initializeColors();
        this.scanner = new JavaScanner();
    }

    public SOQLValuesHighlight(String[] strArrSQLFunctions) {
        this.initializeColors();
        this.scanner = new JavaScanner();
        this.scanner.setSQLKeywords(strArrSQLFunctions);
        this.scanner.initializeMDXFunctions();
    }

    Color getColor(int type) {
        if (type < 0 || type >= this.tokenColors.length) {
            return null;
        }
        return this.colors[this.tokenColors[type]];
    }

    boolean inBlockComment(int start, int end) {
        for (int i = 0; i < this.blockComments.size(); ++i) {
            int[] offsets = this.blockComments.elementAt(i);
            if (offsets[0] >= start && offsets[0] <= end) {
                return true;
            }
            if (offsets[1] >= start && offsets[1] <= end) {
                return true;
            }
            if (offsets[0] > start || offsets[1] < end) continue;
            return true;
        }
        return false;
    }

    void initializeColors() {
        this.colors = new Color[]{GUIResource.getInstance().getColor(0, 0, 0), GUIResource.getInstance().getColor(255, 0, 0), GUIResource.getInstance().getColor(63, 127, 95), GUIResource.getInstance().getColor(0, 0, 255), GUIResource.getInstance().getColor(255, 0, 255)};
        this.tokenColors = new int[9];
        this.tokenColors[0] = 0;
        this.tokenColors[1] = 0;
        this.tokenColors[2] = 3;
        this.tokenColors[3] = 2;
        this.tokenColors[5] = 1;
        this.tokenColors[6] = 0;
        this.tokenColors[7] = 0;
        this.tokenColors[8] = 4;
    }

    public void lineGetStyle(LineStyleEvent event) {
        Vector<StyleRange> styles = new Vector<StyleRange>();
        if (this.inBlockComment(event.lineOffset, event.lineOffset + event.lineText.length())) {
            styles.addElement(new StyleRange(event.lineOffset, event.lineText.length() + 4, this.colors[1], null));
            event.styles = new StyleRange[styles.size()];
            styles.copyInto(event.styles);
            return;
        }
        this.scanner.setRange(event.lineText);
        String xs = ((StyledText)event.widget).getText();
        if (xs != null) {
            this.parseBlockComments(xs);
        }
        int token = this.scanner.nextToken();
        while (token != -1) {
            if (token != 6) {
                StyleRange lastStyle;
                if (token == 1 && !styles.isEmpty()) {
                    int start = this.scanner.getStartOffset() + event.lineOffset;
                    lastStyle = (StyleRange)styles.lastElement();
                    if (lastStyle.fontStyle != 0 && lastStyle.start + lastStyle.length == start) {
                        lastStyle.length += this.scanner.getLength();
                    }
                } else {
                    Color color = this.getColor(token);
                    if (color != this.colors[0]) {
                        StyleRange style = new StyleRange(this.scanner.getStartOffset() + event.lineOffset, this.scanner.getLength(), color, null);
                        if (token == 2) {
                            // empty if block
                        }
                        if (styles.isEmpty()) {
                            styles.addElement(style);
                        } else {
                            lastStyle = (StyleRange)styles.lastElement();
                            if (lastStyle.similarTo(style) && lastStyle.start + lastStyle.length == style.start) {
                                lastStyle.length += style.length;
                            } else {
                                styles.addElement(style);
                            }
                        }
                    }
                }
            }
            token = this.scanner.nextToken();
        }
        event.styles = new StyleRange[styles.size()];
        styles.copyInto(event.styles);
    }

    public void parseBlockComments(String text) {
        this.blockComments = new Vector();
        StringReader buffer = new StringReader(text);
        boolean blkComment = false;
        int cnt = 0;
        int[] offsets = new int[2];
        boolean done = false;
        try {
            block7: while (!done) {
                int ch = buffer.read();
                switch (ch) {
                    case -1: {
                        if (blkComment) {
                            offsets[1] = cnt;
                            this.blockComments.addElement(offsets);
                        }
                        done = true;
                        continue block7;
                    }
                    case 47: {
                        ch = buffer.read();
                        if (ch == 42 && !blkComment) {
                            offsets = new int[2];
                            offsets[0] = cnt++;
                            blkComment = true;
                        } else {
                            ++cnt;
                        }
                        ++cnt;
                        continue block7;
                    }
                    case 42: {
                        if (blkComment) {
                            ch = buffer.read();
                            ++cnt;
                            if (ch == 47) {
                                blkComment = false;
                                offsets[1] = cnt;
                                this.blockComments.addElement(offsets);
                            }
                        }
                        ++cnt;
                        continue block7;
                    }
                }
                ++cnt;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public class JavaScanner {
        protected Map<String, Integer> fgKeys = null;
        protected Map<?, ?> fgFunctions = null;
        protected Map<String, Integer> kfKeys = null;
        protected Map<?, ?> kfFunctions = null;
        protected StringBuffer fBuffer = new StringBuffer();
        protected String fDoc;
        protected int fPos;
        protected int fEnd;
        protected int fStartToken;
        protected boolean fEofSeen = false;
        private String[] kfKeywords = new String[]{"count", "max", "min", "like"};
        private String[] fgKeywords = new String[]{"select", "from", "where", "and", "or", "with", "group", "having", "order", "by", "asc", "desc", "nulls", "first", "last", "limit", "rollup", "cube", "true", "false"};

        public JavaScanner() {
            this.initialize();
            this.initializeMDXFunctions();
        }

        public final int getLength() {
            return this.fPos - this.fStartToken;
        }

        void initialize() {
            this.fgKeys = new Hashtable<String, Integer>();
            Integer k = new Integer(2);
            for (int i = 0; i < this.fgKeywords.length; ++i) {
                this.fgKeys.put(this.fgKeywords[i], k);
            }
        }

        public void setSQLKeywords(String[] kfKeywords) {
            this.kfKeywords = kfKeywords;
        }

        void initializeMDXFunctions() {
            this.kfKeys = new Hashtable<String, Integer>();
            Integer k = new Integer(8);
            for (int i = 0; i < this.kfKeywords.length; ++i) {
                this.kfKeys.put(this.kfKeywords[i], k);
            }
        }

        public final int getStartOffset() {
            return this.fStartToken;
        }

        public int nextToken() {
            this.fStartToken = this.fPos;
            int c = this.read();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 47: {
                    c = this.read();
                    if (c == 47) {
                        while ((c = this.read()) != -1 && c != 10) {
                        }
                        this.unread(c);
                        return 3;
                    }
                    this.unread(c);
                    return 6;
                }
                case 45: {
                    c = this.read();
                    if (c == 45) {
                        while ((c = this.read()) != -1 && c != 10) {
                        }
                        this.unread(c);
                        return 3;
                    }
                    this.unread(c);
                    return 6;
                }
                case 39: {
                    block20: while (true) {
                        c = this.read();
                        switch (c) {
                            case 39: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                                continue block20;
                            }
                        }
                    }
                }
                case 34: {
                    block21: while (true) {
                        c = this.read();
                        switch (c) {
                            case 34: {
                                return 5;
                            }
                            case -1: {
                                this.unread(c);
                                return 5;
                            }
                            case 92: {
                                c = this.read();
                                continue block21;
                            }
                        }
                    }
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (Character.isDigit((char)(c = this.read()))) {
                    }
                    this.unread(c);
                    return 7;
                }
            }
            if (Character.isWhitespace((char)c)) {
                while (Character.isWhitespace((char)(c = this.read()))) {
                }
                this.unread(c);
                return 1;
            }
            if (Character.isJavaIdentifierStart((char)c)) {
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append((char)c);
                } while (Character.isJavaIdentifierPart((char)(c = this.read())));
                this.unread(c);
                Integer i = this.fgKeys.get(this.fBuffer.toString());
                if (i != null) {
                    return i;
                }
                i = this.kfKeys.get(this.fBuffer.toString());
                if (i != null) {
                    return i;
                }
                return 0;
            }
            return 6;
        }

        protected int read() {
            if (this.fPos <= this.fEnd) {
                return this.fDoc.charAt(this.fPos++);
            }
            return -1;
        }

        public void setRange(String text) {
            this.fDoc = text.toLowerCase();
            this.fPos = 0;
            this.fEnd = this.fDoc.length() - 1;
        }

        protected void unread(int c) {
            if (c != -1) {
                --this.fPos;
            }
        }
    }
}

