/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JTProtocols;
import org.apache.hadoop.mapred.JobTrackerProxies;
import org.apache.hadoop.security.UserGroupInformation;

public class ConfiguredFailoverProxyProvider<T>
implements FailoverProxyProvider<T> {
    private static final Log LOG = LogFactory.getLog(ConfiguredFailoverProxyProvider.class);
    private final Configuration conf;
    private final List<AddressRpcProxyPair<T>> proxies = new ArrayList<AddressRpcProxyPair<T>>();
    private final UserGroupInformation ugi;
    private final Class<T> xface;
    private int currentProxyIndex = 0;

    public ConfiguredFailoverProxyProvider(Configuration conf, String jtAddress, Class<T> xface) {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(JTProtocols.class), (String)"Interface class %s is not a valid HAServiceProtocol protocol!", (Object[])new Object[]{xface});
        this.xface = xface;
        this.conf = new Configuration(conf);
        int maxRetries = this.conf.getInt("mapred.client.failover.connection.retries", 0);
        this.conf.setInt("ipc.client.connect.max.retries", maxRetries);
        int maxRetriesOnSocketTimeouts = this.conf.getInt("mapred.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", maxRetriesOnSocketTimeouts);
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
            Map<String, InetSocketAddress> addressesInJT = HAUtil.getHaJtRpcAddresses(conf);
            if (addressesInJT == null || addressesInJT.size() == 0) {
                throw new RuntimeException("Could not find any configured addresses for JT " + jtAddress);
            }
            Collection<InetSocketAddress> addressesOfJTs = addressesInJT.values();
            for (InetSocketAddress address : addressesOfJTs) {
                this.proxies.add(new AddressRpcProxyPair(address));
            }
            HAUtil.cloneDelegationTokenForLogicalAddress(this.ugi, jtAddress, addressesOfJTs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<T> getInterface() {
        return this.xface;
    }

    public synchronized T getProxy() {
        AddressRpcProxyPair<T> current = this.proxies.get(this.currentProxyIndex);
        if (current.jtHaDaemon == null) {
            try {
                current.jtHaDaemon = JobTrackerProxies.createNonHAProxy(this.conf, current.address, this.xface, this.ugi, false).getProxy();
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to create RPC proxy to JobTracker HA Daemon", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return current.jtHaDaemon;
    }

    public synchronized void performFailover(T currentProxy) {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.proxies.size();
    }

    public synchronized void close() throws IOException {
        for (AddressRpcProxyPair<T> proxy : this.proxies) {
            if (proxy.jtHaDaemon == null) continue;
            if (proxy.jtHaDaemon instanceof Closeable) {
                ((Closeable)proxy.jtHaDaemon).close();
                continue;
            }
            RPC.stopProxy(proxy.jtHaDaemon);
        }
    }

    private static class AddressRpcProxyPair<T> {
        public InetSocketAddress address;
        public T jtHaDaemon;

        public AddressRpcProxyPair(InetSocketAddress address) {
            this.address = address;
        }
    }
}

