/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;

@KerberosInfo(serverPrincipal="mapreduce.jobtracker.kerberos.principal")
@TokenInfo(value=DelegationTokenSelector.class)
interface JobSubmissionProtocol
extends VersionedProtocol {
    public static final long versionID = 28L;

    public JobID getNewJobId() throws IOException;

    public JobStatus submitJob(JobID var1, String var2, Credentials var3) throws IOException;

    @Idempotent
    public ClusterStatus getClusterStatus(boolean var1) throws IOException;

    @Idempotent
    public AccessControlList getQueueAdmins(String var1) throws IOException;

    public void killJob(JobID var1) throws IOException;

    public void setJobPriority(JobID var1, String var2) throws IOException;

    public boolean killTask(TaskAttemptID var1, boolean var2) throws IOException;

    @Idempotent
    public JobProfile getJobProfile(JobID var1) throws IOException;

    @Idempotent
    public JobStatus getJobStatus(JobID var1) throws IOException;

    @Idempotent
    public Counters getJobCounters(JobID var1) throws IOException;

    @Idempotent
    public TaskReport[] getMapTaskReports(JobID var1) throws IOException;

    @Idempotent
    public TaskReport[] getReduceTaskReports(JobID var1) throws IOException;

    @Idempotent
    public TaskReport[] getCleanupTaskReports(JobID var1) throws IOException;

    @Idempotent
    public TaskReport[] getSetupTaskReports(JobID var1) throws IOException;

    @Idempotent
    public String getFilesystemName() throws IOException;

    @Idempotent
    public JobStatus[] jobsToComplete() throws IOException;

    @Idempotent
    public JobStatus[] getAllJobs() throws IOException;

    @Idempotent
    public TaskCompletionEvent[] getTaskCompletionEvents(JobID var1, int var2, int var3) throws IOException;

    @Idempotent
    public String[] getTaskDiagnostics(TaskAttemptID var1) throws IOException;

    @Idempotent
    public String getSystemDir();

    @Idempotent
    public String getStagingAreaDir() throws IOException;

    @Idempotent
    public JobQueueInfo[] getQueues() throws IOException;

    @Idempotent
    public JobQueueInfo getQueueInfo(String var1) throws IOException;

    @Idempotent
    public JobStatus[] getJobsFromQueue(String var1) throws IOException;

    @Idempotent
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException;

    @Idempotent
    public Token<DelegationTokenIdentifier> getDelegationToken(Text var1) throws IOException, InterruptedException;

    @Idempotent
    public long renewDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException, InterruptedException;

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> var1) throws IOException, InterruptedException;
}

