/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTrackerHADaemon;
import org.apache.hadoop.mapred.JobTrackerHAHttpRedirector;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.ExitUtil;

public class JobTrackerHAServiceProtocol
implements HAServiceProtocol {
    private static final Log LOG = LogFactory.getLog(JobTrackerHAServiceProtocol.class);
    public static final String SYSTEM_DIR_SEQUENCE_PREFIX = "seq-";
    private Configuration conf;
    private JobTrackerHADaemon.JobTrackerRunner jtRunner;
    private HAServiceProtocol.HAServiceState haState = HAServiceProtocol.HAServiceState.STANDBY;
    private FileSystem fs;
    private Path currentSysDir;
    private ScheduledExecutorService sysDirMonitorExecutor;
    private JobTrackerHAHttpRedirector httpRedirector;

    public JobTrackerHAServiceProtocol(Configuration conf, JobTrackerHADaemon.JobTrackerRunner jtRunner) {
        this.conf = conf;
        this.jtRunner = jtRunner;
        this.httpRedirector = new JobTrackerHAHttpRedirector(conf);
        try {
            this.fs = this.createFileSystem(conf);
            this.httpRedirector.start();
        }
        catch (Throwable t) {
            this.doImmediateShutdown(t);
        }
    }

    private FileSystem createFileSystem(final Configuration conf) throws IOException, InterruptedException {
        ACLsManager aclsManager = new ACLsManager(conf, null, null);
        return (FileSystem)aclsManager.getMROwner().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws IOException {
                return FileSystem.get((Configuration)conf);
            }
        });
    }

    @VisibleForTesting
    Thread getJobTrackerThread() {
        return this.jtRunner.getJobTrackerThread();
    }

    public HAServiceStatus getServiceStatus() throws AccessControlException, IOException {
        HAServiceStatus ret = new HAServiceStatus(this.haState);
        if (this.haState == HAServiceProtocol.HAServiceState.STANDBY || this.haState == HAServiceProtocol.HAServiceState.ACTIVE) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive("State is " + this.haState);
        }
        return ret;
    }

    public void monitorHealth() throws HealthCheckFailedException {
        if (this.haState == HAServiceProtocol.HAServiceState.ACTIVE && this.jtRunner.jtThreadIsNotAlive()) {
            throw new HealthCheckFailedException("The JobTracker thread is not running");
        }
    }

    public void transitionToActive(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws ServiceFailedException, AccessControlException, IOException {
        if (this.haState == HAServiceProtocol.HAServiceState.ACTIVE) {
            LOG.info((Object)"Already in active state.");
            return;
        }
        LOG.info((Object)"Transitioning to active");
        try {
            this.httpRedirector.stop();
            JobConf jtConf = new JobConf(this.conf);
            this.currentSysDir = this.rollSystemDirectory(jtConf);
            HAUtil.setJtRpcAddress(jtConf);
            this.jtRunner.startJobTracker(jtConf);
        }
        catch (Throwable t) {
            this.doImmediateShutdown(t);
        }
        long activeCheckMillis = this.conf.getLong("mapred.ha.jobtracker.active-check.millis", 1000L);
        this.sysDirMonitorExecutor = Executors.newSingleThreadScheduledExecutor();
        this.sysDirMonitorExecutor.scheduleWithFixedDelay(new SystemDirectoryMonitor(), activeCheckMillis, activeCheckMillis, TimeUnit.MILLISECONDS);
        this.haState = HAServiceProtocol.HAServiceState.ACTIVE;
        LOG.info((Object)"Transitioned to active");
    }

    @VisibleForTesting
    Path rollSystemDirectory(JobConf jtConf) throws IOException {
        Path nextSysDir;
        Object[] subDirectories;
        Path sysDir = new Path(jtConf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        Path qualifiedSysDir = this.fs.makeQualified(sysDir);
        try {
            subDirectories = this.fs.listStatus(sysDir, new PathFilter(){

                public boolean accept(Path p) {
                    return p.getName().matches("seq-\\d+");
                }
            });
        }
        catch (FileNotFoundException e) {
            subDirectories = null;
        }
        Path prevSysDir = null;
        if (subDirectories != null && subDirectories.length > 0) {
            Arrays.sort(subDirectories);
            prevSysDir = subDirectories[subDirectories.length - 1].getPath();
        }
        if (prevSysDir == null) {
            LOG.info((Object)"No previous system directory found");
            nextSysDir = new Path(qualifiedSysDir, this.createSysDirName(0L));
        } else {
            long previous = Long.parseLong(prevSysDir.getName().substring(SYSTEM_DIR_SEQUENCE_PREFIX.length()));
            nextSysDir = new Path(qualifiedSysDir, this.createSysDirName(previous + 1L));
            LOG.info((Object)("Renaming previous system directory " + prevSysDir + " to " + nextSysDir));
            if (!this.fs.rename(prevSysDir, nextSysDir)) {
                throw new IOException("Could not rename " + prevSysDir + " to " + nextSysDir);
            }
        }
        jtConf.set("mapred.system.dir", nextSysDir.toString());
        return nextSysDir;
    }

    private String createSysDirName(long counter) {
        String paddedCounter = Strings.padStart((String)("" + counter), (int)12, (char)'0');
        return SYSTEM_DIR_SEQUENCE_PREFIX + paddedCounter;
    }

    public void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo reqInfo) throws ServiceFailedException, AccessControlException, IOException {
        if (this.haState == HAServiceProtocol.HAServiceState.STANDBY) {
            LOG.info((Object)"Already in standby state.");
            return;
        }
        LOG.info((Object)"Transitioning to standby");
        try {
            if (this.sysDirMonitorExecutor != null) {
                this.sysDirMonitorExecutor.shutdownNow();
            }
            this.jtRunner.stopJobTracker();
            this.httpRedirector.start();
        }
        catch (Throwable t) {
            this.doImmediateShutdown(t);
        }
        this.sysDirMonitorExecutor = null;
        this.currentSysDir = null;
        this.haState = HAServiceProtocol.HAServiceState.STANDBY;
        LOG.info((Object)"Transitioned to standby");
    }

    public void stop() {
        LOG.info((Object)"Stopping");
        try {
            if (this.sysDirMonitorExecutor != null) {
                this.sysDirMonitorExecutor.shutdownNow();
            }
            this.jtRunner.stopJobTracker();
            this.httpRedirector.stop();
        }
        catch (Throwable t) {
            this.doImmediateShutdown(t);
        }
        this.sysDirMonitorExecutor = null;
        this.currentSysDir = null;
        this.haState = HAServiceProtocol.HAServiceState.STANDBY;
        LOG.info((Object)"Stopped");
    }

    private synchronized void doImmediateShutdown(Throwable t) throws ExitUtil.ExitException {
        String message = "Error encountered requiring JT shutdown. Shutting down immediately.";
        try {
            LOG.fatal((Object)message, t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ExitUtil.terminate((int)1, (Throwable)t);
    }

    private class SystemDirectoryMonitor
    implements Runnable {
        private SystemDirectoryMonitor() {
        }

        @Override
        public void run() {
            try {
                if (!JobTrackerHAServiceProtocol.this.fs.exists(JobTrackerHAServiceProtocol.this.currentSysDir)) {
                    throw new IOException("System directory " + JobTrackerHAServiceProtocol.this.currentSysDir + " no longer exists. New active has started.");
                }
            }
            catch (Throwable t) {
                JobTrackerHAServiceProtocol.this.doImmediateShutdown(t);
            }
        }
    }
}

