/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Child;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.JvmManager;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;

abstract class TaskRunner
extends Thread {
    static final String HADOOP_WORK_DIR = "HADOOP_WORK_DIR";
    static final String MAPRED_ADMIN_USER_ENV = "mapreduce.admin.user.env";
    public static final Log LOG = LogFactory.getLog(TaskRunner.class);
    volatile boolean killed = false;
    private TaskTracker.TaskInProgress tip;
    private Task t;
    private Object lock = new Object();
    private volatile boolean done = false;
    private int exitCode = -1;
    private boolean exitCodeSet = false;
    private static String SYSTEM_PATH_SEPARATOR = System.getProperty("path.separator");
    static final String MAPREDUCE_USER_CLASSPATH_FIRST = "mapreduce.user.classpath.first";
    private TaskTracker tracker;
    private final TaskDistributedCacheManager taskDistributedCacheManager;
    private String[] localdirs;
    private static final Random rand = new Random();
    protected JobConf conf;
    JvmManager jvmManager;
    protected MapOutputFile mapOutputFile;

    public TaskRunner(TaskTracker.TaskInProgress tip, TaskTracker tracker, JobConf conf, TaskTracker.RunningJob rjob) throws IOException {
        this.tip = tip;
        this.t = tip.getTask();
        this.tracker = tracker;
        this.conf = conf;
        this.mapOutputFile = new MapOutputFile();
        this.mapOutputFile.setConf(conf);
        this.jvmManager = tracker.getJvmManagerInstance();
        this.localdirs = conf.getLocalDirs();
        this.taskDistributedCacheManager = rjob.distCacheMgr;
    }

    public Task getTask() {
        return this.t;
    }

    public TaskTracker.TaskInProgress getTaskInProgress() {
        return this.tip;
    }

    public TaskTracker getTracker() {
        return this.tracker;
    }

    public boolean prepare() throws IOException {
        return true;
    }

    public void close() throws IOException {
    }

    @Deprecated
    public String getChildJavaOpts(JobConf jobConf, String defaultValue) {
        return jobConf.get("mapred.child.java.opts", defaultValue);
    }

    @Deprecated
    public int getChildUlimit(JobConf jobConf) {
        return jobConf.getInt("mapred.child.ulimit", -1);
    }

    public String getChildEnv(JobConf jobConf) {
        return jobConf.get("mapred.child.env");
    }

    public abstract Level getLogLevel(JobConf var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        String errorInfo = "Child Error";
        try {
            TaskAttemptID taskid = this.t.getTaskID();
            LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");
            File workDir = new File(new Path(this.localdirs[rand.nextInt(this.localdirs.length)], TaskTracker.getTaskWorkDir(this.t.getUser(), taskid.getJobID().toString(), taskid.toString(), this.t.isTaskCleanupTask())).toString());
            if (!this.prepare()) {
                return;
            }
            List<String> classPaths = TaskRunner.getClassPaths(this.conf, workDir, this.taskDistributedCacheManager);
            long logSize = TaskLog.getTaskLogLength(this.conf);
            Vector<String> vargs = this.getVMArgs(taskid, workDir, classPaths, logSize);
            this.tracker.addToMemoryManager(this.t.getTaskID(), this.t.isMapTask(), this.conf);
            String setup = this.getVMSetupCmd();
            File[] logFiles = this.prepareLogFiles(taskid, this.t.isTaskCleanupTask());
            File stdout = logFiles[0];
            File stderr = logFiles[1];
            this.tracker.getTaskTrackerInstrumentation().reportTaskLaunch(taskid, stdout, stderr);
            HashMap<String, String> env = new HashMap<String, String>();
            errorInfo = this.getVMEnvironment(errorInfo, workDir, this.conf, env, taskid, logSize);
            ArrayList<String> setupCmds = new ArrayList<String>();
            TaskRunner.appendEnvExports(setupCmds, env);
            setupCmds.add(setup);
            this.launchJvmAndWait(setupCmds, vargs, stdout, stderr, logSize, workDir);
            this.tracker.getTaskTrackerInstrumentation().reportTaskEnd(this.t.getTaskID());
            if (this.exitCodeSet && !this.killed && this.exitCode != 0) {
                if (this.exitCode == 65) {
                    this.tracker.getTaskTrackerInstrumentation().taskFailedPing(this.t.getTaskID());
                }
                throw new IOException("Task process exit with nonzero status of " + this.exitCode + ".");
            }
        }
        catch (FSError e) {
            LOG.fatal((Object)"FSError", (Throwable)e);
            try {
                this.tracker.internalFsError(this.t.getTaskID(), e.getMessage());
            }
            catch (IOException ie) {
                LOG.fatal((Object)(this.t.getTaskID() + " reporting FSError"), (Throwable)ie);
            }
        }
        catch (Throwable throwable) {
            LOG.warn((Object)(this.t.getTaskID() + " : " + errorInfo), throwable);
            Throwable causeThrowable = new Throwable(errorInfo, throwable);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            causeThrowable.printStackTrace(new PrintStream(baos));
            try {
                this.tracker.internalReportDiagnosticInfo(this.t.getTaskID(), baos.toString());
            }
            catch (IOException e) {
                LOG.warn((Object)(this.t.getTaskID() + " Reporting Diagnostics"), (Throwable)e);
            }
        }
        finally {
            this.tip.reportTaskFinished(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void launchJvmAndWait(List<String> setup, Vector<String> vargs, File stdout, File stderr, long logSize, File workDir) throws InterruptedException, IOException {
        this.jvmManager.launchJvm(this, this.jvmManager.constructJvmEnv(setup, vargs, stdout, stderr, logSize, workDir, this.conf));
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                this.lock.wait();
            }
        }
    }

    File[] prepareLogFiles(TaskAttemptID taskid, boolean isCleanup) throws IOException {
        File[] logFiles = new File[]{TaskLog.getTaskLogFile(taskid, isCleanup, TaskLog.LogName.STDOUT), TaskLog.getTaskLogFile(taskid, isCleanup, TaskLog.LogName.STDERR)};
        this.getTracker().getTaskController().createLogDir(taskid, isCleanup);
        return logFiles;
    }

    void setupChildTaskConfiguration(LocalDirAllocator lDirAlloc) throws IOException {
        Path localTaskFile = lDirAlloc.getLocalPathForWrite(TaskTracker.getTaskConfFile(this.t.getUser(), this.t.getJobID().toString(), this.t.getTaskID().toString(), this.t.isTaskCleanupTask()), (Configuration)this.conf);
        JobLocalizer.writeLocalJobFile(localTaskFile, this.conf);
        this.t.setJobFile(localTaskFile.toString());
    }

    private String getVMSetupCmd() {
        int ulimit = this.getChildUlimit(this.conf);
        if (ulimit <= 0) {
            return "";
        }
        String[] setup = Shell.getUlimitMemoryCommand((int)ulimit);
        StringBuilder command = new StringBuilder();
        for (String str : setup) {
            command.append('\'');
            command.append(str);
            command.append('\'');
            command.append(" ");
        }
        command.append("\n");
        return command.toString();
    }

    static void appendEnvExports(List<String> commands, Map<String, String> env) {
        for (Map.Entry<String, String> entry : env.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("export ");
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(StringUtils.escapeString((String)entry.getValue(), (char)'\\', (char)'\"'));
            sb.append("\"");
            commands.add(sb.toString());
        }
    }

    static String[] parseChildJavaOpts(String javaOpts, TaskAttemptID taskid) {
        javaOpts = javaOpts.replace("@taskid@", taskid.toString());
        return javaOpts.trim().split("\\s+");
    }

    private Vector<String> getVMArgs(TaskAttemptID taskid, File workDir, List<String> classPaths, long logSize) throws IOException {
        int i;
        Vector<String> vargs = new Vector<String>(8);
        File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
        vargs.add(jvm.toString());
        String[] javaOptsSplit = TaskRunner.parseChildJavaOpts(this.getChildJavaOpts(this.conf, "-Xmx200m"), taskid);
        String libraryPath = System.getProperty("java.library.path");
        libraryPath = libraryPath == null ? workDir.getAbsolutePath() : libraryPath + SYSTEM_PATH_SEPARATOR + workDir;
        boolean hasUserLDPath = false;
        for (i = 0; i < javaOptsSplit.length; ++i) {
            if (!javaOptsSplit[i].startsWith("-Djava.library.path=")) continue;
            int n = i;
            javaOptsSplit[n] = javaOptsSplit[n] + SYSTEM_PATH_SEPARATOR + libraryPath;
            hasUserLDPath = true;
            break;
        }
        if (!hasUserLDPath) {
            vargs.add("-Djava.library.path=" + libraryPath);
        }
        for (i = 0; i < javaOptsSplit.length; ++i) {
            vargs.add(javaOptsSplit[i]);
        }
        Path childTmpDir = TaskRunner.createChildTmpDir(workDir, this.conf, false);
        vargs.add("-Djava.io.tmpdir=" + childTmpDir);
        vargs.add("-classpath");
        String classPath = StringUtils.join((CharSequence)SYSTEM_PATH_SEPARATOR, classPaths);
        vargs.add(classPath);
        this.setupLog4jProperties(vargs, taskid, logSize);
        if (this.conf.getProfileEnabled() && this.conf.getProfileTaskRange(this.t.isMapTask()).isIncluded(this.t.getPartition())) {
            File prof = TaskLog.getTaskLogFile(taskid, this.t.isTaskCleanupTask(), TaskLog.LogName.PROFILE);
            vargs.add(String.format(this.conf.getProfileParams(), prof.toString()));
        }
        vargs.add(Child.class.getName());
        InetSocketAddress address = this.tracker.getTaskTrackerReportAddress();
        vargs.add(address.getAddress().getHostAddress());
        vargs.add(Integer.toString(address.getPort()));
        vargs.add(taskid.toString());
        vargs.add(TaskLog.getAttemptDir(taskid, this.t.isTaskCleanupTask()).toString());
        return vargs;
    }

    private void setupLog4jProperties(Vector<String> vargs, TaskAttemptID taskid, long logSize) {
        vargs.add("-Dhadoop.log.dir=" + new File(System.getProperty("hadoop.log.dir")).getAbsolutePath());
        vargs.add("-Dhadoop.root.logger=" + this.getLogLevel(this.conf).toString() + ",TLA");
        vargs.add("-Dhadoop.tasklog.taskid=" + taskid);
        vargs.add("-Dhadoop.tasklog.iscleanup=" + this.t.isTaskCleanupTask());
        vargs.add("-Dhadoop.tasklog.totalLogFileSize=" + logSize);
    }

    static Path createChildTmpDir(File workDir, JobConf conf, boolean createDir) throws IOException {
        String tmp = conf.get("mapred.child.tmp", "./tmp");
        Path tmpDir = new Path(tmp);
        if (!tmpDir.isAbsolute()) {
            LocalFileSystem localFs;
            tmpDir = new Path(workDir.toString(), tmp);
            if (createDir && !(localFs = FileSystem.getLocal((Configuration)conf)).mkdirs(tmpDir) && !localFs.getFileStatus(tmpDir).isDir()) {
                throw new IOException("Mkdirs failed to create " + tmpDir.toString());
            }
        }
        return tmpDir;
    }

    static List<String> getClassPaths(JobConf conf, File workDir, TaskDistributedCacheManager taskDistributedCacheManager) throws IOException {
        ArrayList<String> classPaths = new ArrayList<String>();
        boolean userClassesTakesPrecedence = conf.userClassesTakesPrecedence();
        if (!userClassesTakesPrecedence) {
            TaskRunner.appendSystemClasspaths(classPaths);
        }
        TaskRunner.appendJobJarClasspaths(conf.getJar(), classPaths);
        if (taskDistributedCacheManager != null) {
            classPaths.addAll(taskDistributedCacheManager.getClassPaths());
        }
        classPaths.add(workDir.toString());
        if (userClassesTakesPrecedence) {
            TaskRunner.appendSystemClasspaths(classPaths);
        }
        return classPaths;
    }

    private String getVMEnvironment(String errorInfo, File workDir, JobConf conf, Map<String, String> env, TaskAttemptID taskid, long logSize) throws Throwable {
        StringBuffer ldLibraryPath = new StringBuffer();
        ldLibraryPath.append(workDir.toString());
        String oldLdLibraryPath = null;
        oldLdLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (oldLdLibraryPath != null) {
            ldLibraryPath.append(SYSTEM_PATH_SEPARATOR);
            ldLibraryPath.append(oldLdLibraryPath);
        }
        env.put("LD_LIBRARY_PATH", ldLibraryPath.toString());
        env.put(HADOOP_WORK_DIR, workDir.toString());
        String jobTokenFile = conf.get("mapreduce.job.jobTokenFile");
        LOG.debug((Object)("putting jobToken file name into environment " + jobTokenFile));
        env.put("HADOOP_TOKEN_FILE_LOCATION", jobTokenFile);
        env.put("HADOOP_ROOT_LOGGER", "INFO,TLA");
        String hadoopClientOpts = System.getenv("HADOOP_CLIENT_OPTS");
        hadoopClientOpts = hadoopClientOpts == null ? "" : hadoopClientOpts + " ";
        hadoopClientOpts = hadoopClientOpts + "-Dhadoop.tasklog.taskid=" + taskid + " -Dhadoop.tasklog.iscleanup=" + this.t.isTaskCleanupTask() + " -Dhadoop.tasklog.totalLogFileSize=" + logSize;
        env.put("HADOOP_CLIENT_OPTS", hadoopClientOpts);
        String mapredChildEnv = this.getChildEnv(conf);
        if (mapredChildEnv != null && mapredChildEnv.length() > 0) {
            String[] childEnvs;
            for (String cEnv : childEnvs = mapredChildEnv.split(",")) {
                try {
                    String[] parts = cEnv.split("=");
                    String value = env.get(parts[0]);
                    value = value != null ? parts[1].replace("$" + parts[0], value) : ((value = System.getenv(parts[0])) != null ? parts[1].replace("$" + parts[0], value) : parts[1].replace("$" + parts[0], ""));
                    env.put(parts[0], value);
                }
                catch (Throwable t) {
                    errorInfo = "Invalid User environment settings : " + mapredChildEnv + ". Failed to parse user-passed environment param." + " Expecting : env1=value1,env2=value2...";
                    LOG.warn((Object)errorInfo);
                    throw t;
                }
            }
        }
        return errorInfo;
    }

    static void setupChildMapredLocalDirs(Task t, JobConf conf) {
        String[] localDirs = conf.getTrimmedStrings("mapred.local.dir");
        String jobId = t.getJobID().toString();
        String taskId = t.getTaskID().toString();
        boolean isCleanup = t.isTaskCleanupTask();
        String user = t.getUser();
        StringBuffer childMapredLocalDir = new StringBuffer(localDirs[0] + "/" + TaskTracker.getLocalTaskDir(user, jobId, taskId, isCleanup));
        for (int i = 1; i < localDirs.length; ++i) {
            childMapredLocalDir.append("," + localDirs[i] + "/" + TaskTracker.getLocalTaskDir(user, jobId, taskId, isCleanup));
        }
        LOG.debug((Object)("mapred.local.dir for child : " + childMapredLocalDir));
        conf.set("mapred.local.dir", childMapredLocalDir.toString());
    }

    static Path formWorkDir(LocalDirAllocator lDirAlloc, JobConf conf) throws IOException {
        Path workDir = lDirAlloc.getLocalPathToRead("work", (Configuration)conf);
        return workDir;
    }

    private static void appendSystemClasspaths(List<String> classPaths) {
        for (String c : System.getProperty("java.class.path").split(SYSTEM_PATH_SEPARATOR)) {
            classPaths.add(c);
        }
    }

    static void appendJobJarClasspaths(String jobJar, List<String> classPaths) {
        if (jobJar == null) {
            return;
        }
        File jobCacheDir = new File(new Path(jobJar).getParent().toString());
        File[] libs = new File(jobCacheDir, "lib").listFiles();
        if (libs != null) {
            for (File l : libs) {
                classPaths.add(l.toString());
            }
        }
        classPaths.add(new File(jobCacheDir, "classes").toString());
        classPaths.add(jobJar);
    }

    public static void setupWorkDir(JobConf conf, File workDir) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fully deleting contents of " + workDir));
        }
        FileUtil.fullyDeleteContents((File)workDir);
        if (DistributedCache.getSymlink(conf)) {
            String target;
            String link;
            int i;
            URI[] archives = DistributedCache.getCacheArchives(conf);
            URI[] files = DistributedCache.getCacheFiles(conf);
            Path[] localArchives = DistributedCache.getLocalCacheArchives(conf);
            Path[] localFiles = DistributedCache.getLocalCacheFiles(conf);
            if (archives != null) {
                for (i = 0; i < archives.length; ++i) {
                    link = archives[i].getFragment();
                    target = localArchives[i].toString();
                    TaskRunner.symlink(workDir, target, link);
                }
            }
            if (files != null) {
                for (i = 0; i < files.length; ++i) {
                    link = files[i].getFragment();
                    target = localFiles[i].toString();
                    TaskRunner.symlink(workDir, target, link);
                }
            }
        }
        if (conf.getJar() != null) {
            File jobCacheDir = new File(new Path(conf.getJar()).getParent().toString());
            try {
                TrackerDistributedCacheManager.createAllSymlink(conf, jobCacheDir, workDir);
            }
            catch (IOException ie) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)ie));
            }
        }
        TaskRunner.createChildTmpDir(workDir, conf, true);
    }

    private static void symlink(File workDir, String target, String link) throws IOException {
        File flink;
        if (link != null && !(flink = new File(link = workDir.toString() + "/" + link)).exists()) {
            LOG.info((Object)String.format("Creating symlink: %s <- %s", target, link));
            if (0 != FileUtil.symLink((String)target, (String)link)) {
                LOG.warn((Object)String.format("Failed to create symlink: %s <- %s", target, link));
            }
        }
    }

    public void kill() throws IOException, InterruptedException {
        this.killed = true;
        this.jvmManager.taskKilled(this);
        this.signalDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalDone() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notify();
        }
    }

    public void setExitCode(int exitCode) {
        this.exitCodeSet = true;
        this.exitCode = exitCode;
    }
}

