/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class jobhistory_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private void printJob(String timestamp, String jobId, String jobName, String user, Path logFile, JspWriter out) throws IOException {
        out.print("<tr>");
        out.print("<td>" + new Date(Long.parseLong(timestamp)) + "</td>");
        out.print("<td><a href=\"jobdetailshistory.jsp?logFile=" + URLEncoder.encode(logFile.toString()) + "\">" + jobId + "</a></td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars((String)jobName) + "</td>");
        out.print("<td>" + HtmlQuoting.quoteHtmlChars((String)user) + "</td>");
        out.print("</tr>");
    }

    private void printNavigationTool(int pageno, int size, int max, String searchPlusScan, JspWriter out) throws IOException {
        int lastPage;
        int firstPage;
        int NUMBER_INDICES_TO_SHOW = 5;
        int numIndexToShow = 5;
        out.print("<center> <");
        if (pageno > 1) {
            out.println("<a href=\"jobhistory.jsp?pageno=" + (pageno - 1) + searchPlusScan + "\">Previous</a>");
        }
        if ((firstPage = pageno - numIndexToShow) < 1) {
            firstPage = 1;
        }
        if ((lastPage = pageno + numIndexToShow) > max) {
            lastPage = max;
        }
        out.println("<!--DEBUG : firstPage : " + firstPage + ", lastPage : " + lastPage + " -->");
        for (int i = firstPage; i <= lastPage; ++i) {
            if (i != pageno) {
                out.println(" <a href=\"jobhistory.jsp?pageno=" + i + searchPlusScan + "\">" + i + "</a> ");
                continue;
            }
            out.println(i);
        }
        if (pageno < max) {
            out.println("<a href=\"jobhistory.jsp?pageno=" + (pageno + 1) + searchPlusScan + "\">Next</a>");
        }
        out.print("></center>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block36: {
            int maxPageNo;
            int size;
            int pageno;
            long lengthEstimate;
            boolean sizeIsExact;
            Path[] jobFiles;
            int numHistoryFiles;
            String dateComponent;
            Comparator<Path> latestFirstCreationTimeComparator;
            String jobname;
            int currentScanSizeIndex;
            String user;
            String soughtDate;
            String search;
            int[] SCAN_SIZES;
            PageContext _jspx_page_context;
            JspWriter _jspx_out;
            JspWriter out;
            block35: {
                block34: {
                    int arrayLimit;
                    String historyLogDir;
                    FileSystem fs;
                    PathFilter jobLogFileFilter;
                    Pattern dateSearchParse;
                    block33: {
                        PageContext pageContext = null;
                        HttpSession session = null;
                        ServletContext application = null;
                        ServletConfig config = null;
                        out = null;
                        jobhistory_jsp page = this;
                        _jspx_out = null;
                        _jspx_page_context = null;
                        response.setContentType("text/html; charset=UTF-8");
                        _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                        application = pageContext.getServletContext();
                        config = pageContext.getServletConfig();
                        session = pageContext.getSession();
                        _jspx_out = out = pageContext.getOut();
                        this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                        out.write(10);
                        JobTracker tracker = (JobTracker)application.getAttribute("job.tracker");
                        String trackerName = StringUtils.simpleHostname((String)tracker.getJobTrackerMachine());
                        out.write(10);
                        out.write(10);
                        out.write("\n<html>\n<head>\n<script type=\"text/JavaScript\">\n<!--\nfunction showUserHistory(search)\n{\nvar url\nif (search == null || \"\".equals(search)) {\n  url=\"jobhistory.jsp\";\n} else {\n  url=\"jobhistory.jsp?pageno=1&search=\" + search;\n}\nwindow.location.href = url;\n}\n//-->\n</script>\n<title>");
                        out.print(trackerName);
                        out.write(" Hadoop Map/Reduce History Viewer</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<link rel=\"icon\" type=\"image/vnd.microsoft.icon\" href=\"/static/images/favicon.ico\" />\n</head>\n<body>\n<h1> <a href=\"jobtracker.jsp\">");
                        out.print(trackerName);
                        out.write("</a> Hadoop Map/Reduce \n     <a href=\"jobhistory.jsp\">History Viewer</a></h1>\n<hr>\n");
                        boolean JOB_ID_START = false;
                        int FILENAME_JOBID_END = 3;
                        int FILENAME_SUBMIT_TIMESTAMP_PART = 3;
                        int FILENAME_USER_PART = 4;
                        int FILENAME_JOBNAME_PART = 5;
                        SCAN_SIZES = new int[]{3, 5, 20, 50, 200};
                        int FILES_PER_SCAN = 1000;
                        int DEFAULT_PAGE_SIZE = 10;
                        String DEFAULT_DATE_GLOB_COMPONENT = "*/*/*";
                        String SERIAL_NUMBER_GLOB_COMPONENT = "/*";
                        search = request.getParameter("search") == null ? "" : request.getParameter("search");
                        String[] dateSplit = search.split(";");
                        soughtDate = dateSplit.length > 1 ? dateSplit[1] : "";
                        String[] parts = dateSplit[0].split(":");
                        user = parts.length >= 1 ? parts[0].toLowerCase() : "";
                        currentScanSizeIndex = request.getParameter("scansize") == null ? 0 : Integer.parseInt(request.getParameter("scansize"));
                        String SEARCH_PARSE_REGEX = "([0-2]?[0-9])/([0-5]?[0-9])/((?:2[0-9])[0-9][0-9])";
                        dateSearchParse = Pattern.compile("([0-2]?[0-9])/([0-5]?[0-9])/((?:2[0-9])[0-9][0-9])");
                        jobname = parts.length >= 2 ? parts[1].toLowerCase() : "";
                        jobLogFileFilter = new PathFilter(){
                            final String uqUser;
                            final String uqJobname;
                            {
                                this.uqUser = JobHistory.JobInfo.encodeJobHistoryFileName(HtmlQuoting.unquoteHtmlChars((String)user));
                                this.uqJobname = JobHistory.JobInfo.encodeJobHistoryFileName(HtmlQuoting.unquoteHtmlChars((String)jobname));
                            }

                            private boolean matchUser(String fileName) {
                                return "".equals(this.uqUser) || this.uqUser.equals(fileName.split("_")[4]);
                            }

                            private boolean matchJobName(String fileName) {
                                return "".equals(this.uqJobname) || fileName.split("_")[5].toLowerCase().contains(this.uqJobname);
                            }

                            private boolean isHistoryFile(String fileName) {
                                String[] tokens = null;
                                try {
                                    String dp = JobHistory.JobInfo.decodeJobHistoryFileName(fileName);
                                    tokens = dp.split("_");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return tokens != null && !fileName.endsWith(".xml") && tokens.length > 3 && tokens[1].matches("\\d+") && tokens[2].matches("\\d+") && tokens[3].matches("\\d+");
                            }

                            public boolean accept(Path path) {
                                return this.isHistoryFile(path.getName()) && this.matchUser(path.getName()) && this.matchJobName(path.getName());
                            }
                        };
                        fs = (FileSystem)application.getAttribute("fileSys");
                        historyLogDir = (String)application.getAttribute("historyLogDir");
                        if (fs != null) break block33;
                        out.println("Null file system. May be namenode is in safemode!");
                        _jspxFactory.releasePageContext(_jspx_page_context);
                        return;
                    }
                    Comparator<Path> lastPathFirst = new Comparator<Path>(){

                        @Override
                        public int compare(Path path1, Path path2) {
                            return path2.getName().compareTo(path1.getName());
                        }
                    };
                    latestFirstCreationTimeComparator = new Comparator<Path>(){

                        @Override
                        public int compare(Path p1, Path p2) {
                            String dp1 = null;
                            String dp2 = null;
                            try {
                                dp1 = JobHistory.JobInfo.decodeJobHistoryFileName(p1.getName());
                                dp2 = JobHistory.JobInfo.decodeJobHistoryFileName(p2.getName());
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                            String[] split1 = dp1.split("_");
                            String[] split2 = dp2.split("_");
                            int res = new Date(Long.parseLong(split2[1])).compareTo(new Date(Long.parseLong(split1[1])));
                            if (res == 0) {
                                res = new Date(Long.parseLong(split2[3])).compareTo(new Date(Long.parseLong(split1[3])));
                            }
                            if (res == 0) {
                                Long l1 = Long.parseLong(split2[2]);
                                res = l1.compareTo(Long.parseLong(split1[2]));
                            }
                            return res;
                        }
                    };
                    String trackerComponent = "*";
                    dateComponent = "*/*/*";
                    Matcher dateMatcher = dateSearchParse.matcher(soughtDate);
                    if (dateMatcher.matches()) {
                        String date;
                        String month;
                        String year = dateMatcher.group(3);
                        if (year.length() == 2) {
                            year = "20" + year;
                        }
                        if ((month = dateMatcher.group(1)).length() == 1) {
                            month = "0" + month;
                        }
                        if ((date = dateMatcher.group(2)).length() == 1) {
                            date = "0" + date;
                        }
                        dateComponent = year + "/" + month + "/" + date;
                    }
                    Path historyPath = new Path(historyLogDir);
                    String leadGlob = trackerComponent + "/" + dateComponent;
                    AtomicBoolean hasLegacyFiles = new AtomicBoolean(false);
                    Path[] snPaths = FileUtil.stat2Paths((FileStatus[])JobHistory.localGlobber(fs, historyPath, "/" + leadGlob, null, hasLegacyFiles));
                    Arrays.sort(snPaths, lastPathFirst);
                    int tranchesSeen = 0;
                    Path lastPath = null;
                    for (arrayLimit = 0; arrayLimit < snPaths.length && tranchesSeen <= SCAN_SIZES[currentScanSizeIndex]; ++arrayLimit) {
                        if (lastPath != null && lastPathFirst.compare(lastPath, snPaths[arrayLimit]) == 0) continue;
                        ++tranchesSeen;
                        lastPath = snPaths[arrayLimit];
                    }
                    if (tranchesSeen > SCAN_SIZES[currentScanSizeIndex]) {
                        --arrayLimit;
                    }
                    numHistoryFiles = 0;
                    jobFiles = null;
                    Path[][] pathVectorVector = new Path[arrayLimit][];
                    for (int i = 0; i < arrayLimit; ++i) {
                        pathVectorVector[i] = FileUtil.stat2Paths((FileStatus[])fs.listStatus(snPaths[i], jobLogFileFilter));
                        numHistoryFiles += pathVectorVector[i].length;
                    }
                    jobFiles = new Path[numHistoryFiles];
                    int pathsCursor = 0;
                    for (int i = 0; i < arrayLimit; ++i) {
                        System.arraycopy(pathVectorVector[i], 0, jobFiles, pathsCursor, pathVectorVector[i].length);
                        pathsCursor += pathVectorVector[i].length;
                    }
                    sizeIsExact = arrayLimit == snPaths.length;
                    long l = lengthEstimate = sizeIsExact ? (long)numHistoryFiles : (long)numHistoryFiles * (long)snPaths.length / (long)arrayLimit;
                    if (hasLegacyFiles.get()) {
                        out.println("<h2>This history has some legacy files.  <a href=\"legacyjobhistory.jsp\">go to Legacy History Viewer</a></h2>");
                    }
                    out.println("<!--  user : " + user + ", jobname : " + jobname + "-->");
                    if (null != jobFiles && jobFiles.length != 0) break block34;
                    out.println("No files found!");
                    _jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                pageno = request.getParameter("pageno") == null ? 1 : Integer.parseInt(request.getParameter("pageno"));
                size = 10;
                if (pageno == -1 || size > jobFiles.length) {
                    size = jobFiles.length;
                }
                if (pageno == -1) {
                    pageno = 1;
                }
                maxPageNo = (jobFiles.length + size - 1) / size;
                if (pageno >= 1 && pageno <= maxPageNo) break block35;
                out.println("Invalid page index");
                _jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                int length = size;
                if (pageno == maxPageNo) {
                    int startOnLast = (pageno - 1) * size + 1;
                    length = jobFiles.length - startOnLast + 1;
                }
                out.println("<form name=search><b> Filter (username:jobname) </b>");
                out.println("<input type=text name=search size=\"20\" value=\"" + search + "\">");
                out.println("<input type=submit value=\"Filter!\" onClick=\"showUserHistory(document.getElementById('search').value)\"></form>");
                out.println("<p><span class=\"small\">Specify [user][:jobname keyword(s)][;MM/DD/YYYY] .  Each of the three components is optional.  Filter components are conjunctive.</span></p>");
                out.println("<p><span class=\"small\">Example: 'smith' will display jobs submitted by user 'smith'. 'smith:sort' will display jobs from user 'smith' having a 'sort' keyword in the jobname. ';07/04/2010' restricts to July 4, 2010</span></p>");
                out.println("<hr>");
                int start = (pageno - 1) * size + 1;
                out.println("<!-- pageno : " + pageno + ", size : " + size + ", length : " + length + ", start : " + start + ", maxpg : " + maxPageNo + "-->");
                out.println("<font size=5><b>Available Jobs in History </b></font>");
                out.println("(<i> <span class=\"small\">Displaying <b>" + length + "</b> jobs from <b>" + start + "</b> to <b>" + (start + length - 1) + "</b> out of " + (sizeIsExact ? "" : "approximately ") + "<b>" + lengthEstimate + "</b> jobs" + (sizeIsExact ? "" : ", <b>" + numHistoryFiles + "</b> gotten"));
                if (!"".equals(user)) {
                    out.println(" for user <b>" + user + "</b>");
                }
                if (!"".equals(jobname)) {
                    out.println(" with jobname having the keyword <b>" + jobname + "</b> in it.");
                }
                if (!"*/*/*".equals(dateComponent)) {
                    out.println(" for the date <b>" + soughtDate + "</b>");
                }
                out.print("</span></i>)");
                String searchPart = "&search=" + search;
                String scansizePart = "&scansize=" + currentScanSizeIndex;
                String searchPlusScan = searchPart + scansizePart;
                if (sizeIsExact || currentScanSizeIndex == SCAN_SIZES.length - 1) {
                    out.println("[<span class=\"small\">get more results</span>]");
                } else {
                    out.println(" [<span class=\"small\"><a href=\"jobhistory.jsp?pageno=1" + searchPart + "&scansize=" + (currentScanSizeIndex + 1) + "\">get more results</a></span>]");
                }
                out.println(" [<span class=\"small\"><a href=\"jobhistory.jsp?pageno=-1" + searchPlusScan + "\">show in one page</a></span>]");
                if (pageno > 1) {
                    out.println(" [<span class=\"small\"><a href=\"jobhistory.jsp?pageno=1" + searchPlusScan + "\">first page</a></span>]");
                } else {
                    out.println("[<span class=\"small\">first page]</span>");
                }
                if (pageno < maxPageNo) {
                    out.println(" [<span class=\"small\"><a href=\"jobhistory.jsp?pageno=" + maxPageNo + searchPlusScan + "\">last page</a></span>]");
                } else {
                    out.println("<span class=\"small\">[last page]</span>");
                }
                Arrays.sort(jobFiles, latestFirstCreationTimeComparator);
                out.println("<br><br>");
                this.printNavigationTool(pageno, size, maxPageNo, searchPlusScan, out);
                out.print("<table class=\"datatable\">");
                out.print("<thead>\n");
                out.print("<tr>");
                out.print("<th>Job submit time</th><th>Job Id</th><th>Name</th><th>User</th>");
                out.print("</tr>");
                out.print("</thead><tbody>\n");
                HashSet<String> displayedJobs = new HashSet<String>();
                for (int i = start - 1; i < start + length - 1; ++i) {
                    Path jobFile = jobFiles[i];
                    String decodedJobFileName = JobHistory.JobInfo.decodeJobHistoryFileName(jobFile.getName());
                    String[] jobDetails = decodedJobFileName.split("_");
                    String trackerStartTime = jobDetails[1];
                    String jobId = jobDetails[0] + "_" + jobDetails[1] + "_" + jobDetails[2];
                    String submitTimestamp = jobDetails[3];
                    String userName = jobDetails[4];
                    String jobName = jobDetails[5];
                    if (displayedJobs.contains(jobId)) continue;
                    displayedJobs.add(jobId);
                    out.write("\n<center>\n");
                    this.printJob(submitTimestamp, jobId, jobName, userName, jobFile, out);
                    out.write("\n</center> \n");
                }
                out.print("</tbody>");
                out.print("</table>");
                this.printNavigationTool(pageno, size, maxPageNo, searchPlusScan, out);
                out.write(10);
                out.write(" \n</body></html>\n");
            }
            catch (Throwable t) {
                try {
                    if (!(t instanceof SkipPageException)) {
                        out = _jspx_out;
                        if (out != null && out.getBufferSize() != 0) {
                            out.clearBuffer();
                        }
                        if (_jspx_page_context != null) {
                            _jspx_page_context.handlePageException(t);
                        }
                    }
                    break block36;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            _jspxFactory.releasePageContext(_jspx_page_context);
        }
    }
}

