/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class TupleWritable
implements Writable,
Iterable<Writable> {
    private long written;
    private Writable[] values;

    public TupleWritable() {
    }

    public TupleWritable(Writable[] vals) {
        this.written = 0L;
        this.values = vals;
    }

    public boolean has(int i) {
        return 0L != (1L << i & this.written);
    }

    public Writable get(int i) {
        return this.values[i];
    }

    public int size() {
        return this.values.length;
    }

    public boolean equals(Object other) {
        if (other instanceof TupleWritable) {
            TupleWritable that = (TupleWritable)other;
            if (this.size() != that.size() || this.written != that.written) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.has(i) || this.values[i].equals(that.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return (int)this.written;
    }

    @Override
    public Iterator<Writable> iterator() {
        final TupleWritable t = this;
        return new Iterator<Writable>(){
            long i;
            long last;
            {
                this.i = TupleWritable.this.written;
                this.last = 0L;
            }

            @Override
            public boolean hasNext() {
                return 0L != this.i;
            }

            @Override
            public Writable next() {
                this.last = Long.lowestOneBit(this.i);
                if (0L == this.last) {
                    throw new NoSuchElementException();
                }
                this.i ^= this.last;
                return t.get(Long.numberOfTrailingZeros(this.last) % 64);
            }

            @Override
            public void remove() {
                t.written ^= this.last;
                if (t.has(Long.numberOfTrailingZeros(this.last))) {
                    throw new IllegalStateException("Attempt to remove non-existent val");
                }
            }
        };
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < this.values.length; ++i) {
            buf.append(this.has(i) ? this.values[i].toString() : "");
            buf.append(",");
        }
        if (this.values.length != 0) {
            buf.setCharAt(buf.length() - 1, ']');
        } else {
            buf.append(']');
        }
        return buf.toString();
    }

    public void write(DataOutput out) throws IOException {
        int i;
        WritableUtils.writeVInt((DataOutput)out, (int)this.values.length);
        WritableUtils.writeVLong((DataOutput)out, (long)this.written);
        for (i = 0; i < this.values.length; ++i) {
            Text.writeString((DataOutput)out, (String)this.values[i].getClass().getName());
        }
        for (i = 0; i < this.values.length; ++i) {
            if (!this.has(i)) continue;
            this.values[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int card = WritableUtils.readVInt((DataInput)in);
        this.values = new Writable[card];
        this.written = WritableUtils.readVLong((DataInput)in);
        Class[] cls = new Class[card];
        try {
            int i;
            for (i = 0; i < card; ++i) {
                cls[i] = Class.forName(Text.readString((DataInput)in)).asSubclass(Writable.class);
            }
            for (i = 0; i < card; ++i) {
                this.values[i] = (Writable)cls[i].newInstance();
                if (!this.has(i)) continue;
                this.values[i].readFields(in);
            }
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Failed tuple init").initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (IOException)new IOException("Failed tuple init").initCause(e);
        }
        catch (InstantiationException e) {
            throw (IOException)new IOException("Failed tuple init").initCause(e);
        }
    }

    void setWritten(int i) {
        this.written |= 1L << i;
    }

    void clearWritten(int i) {
        this.written &= 0xFFFFFFFFFFFFFFFFL ^ 1L << i;
    }

    void clearWritten() {
        this.written = 0L;
    }
}

