/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.tools;

import java.io.PrintStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAAdmin;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobTrackerHAServiceTarget;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class MRHAAdmin
extends HAAdmin {
    private static final Log LOG = LogFactory.getLog(MRHAAdmin.class);

    protected void setErrOut(PrintStream errOut) {
        this.errOut = errOut;
    }

    protected void setOut(PrintStream out) {
        this.out = out;
    }

    public void setConf(Configuration conf) {
        if (conf != null) {
            conf = MRHAAdmin.addSecurityConfiguration(conf);
        }
        super.setConf(conf);
    }

    public static Configuration addSecurityConfiguration(Configuration conf) {
        conf = new JobConf(conf);
        String jobTrackerPrincipal = conf.get("mapreduce.jobtracker.kerberos.principal", "");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using JT principal: " + jobTrackerPrincipal));
        }
        conf.set("hadoop.security.service.user.name.key", jobTrackerPrincipal);
        return conf;
    }

    protected HAServiceTarget resolveTarget(String jtId) {
        JobConf conf = new JobConf(this.getConf());
        return new JobTrackerHAServiceTarget(conf, jtId);
    }

    protected String getUsageString() {
        return "Usage: MRHAAdmin";
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run((Tool)new MRHAAdmin(), (String[])argv);
        System.exit(res);
    }
}

