/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.security.Credentials;

public interface JobContext {
    public static final String INPUT_FORMAT_CLASS_ATTR = "mapreduce.inputformat.class";
    public static final String MAP_CLASS_ATTR = "mapreduce.map.class";
    public static final String MAP_OUTPUT_COLLECTOR_CLASS_ATTR = "mapreduce.job.map.output.collector.class";
    public static final String COMBINE_CLASS_ATTR = "mapreduce.combine.class";
    public static final String SHUFFLE_CONSUMER_PLUGIN_ATTR = "mapreduce.job.reduce.shuffle.consumer.plugin.class";
    public static final String REDUCE_CLASS_ATTR = "mapreduce.reduce.class";
    public static final String OUTPUT_FORMAT_CLASS_ATTR = "mapreduce.outputformat.class";
    public static final String PARTITIONER_CLASS_ATTR = "mapreduce.partitioner.class";
    public static final String JAR_UNPACK_PATTERN = "mapreduce.job.jar.unpack.pattern";
    public static final String JOB_NAMENODES = "mapreduce.job.hdfs-servers";
    public static final String JOB_ACL_VIEW_JOB = "mapreduce.job.acl-view-job";
    public static final String JOB_ACL_MODIFY_JOB = "mapreduce.job.acl-modify-job";
    public static final String CACHE_FILE_VISIBILITIES = "mapreduce.job.cache.files.visibilities";
    public static final String CACHE_ARCHIVES_VISIBILITIES = "mapreduce.job.cache.archives.visibilities";
    public static final String JOB_CANCEL_DELEGATION_TOKEN = "mapreduce.job.complete.cancel.delegation.tokens";
    public static final String USER_LOG_RETAIN_HOURS = "mapred.userlog.retain.hours";
    public static final String MAPREDUCE_TASK_CLASSPATH_PRECEDENCE = "mapreduce.task.classpath.user.precedence";
    public static final String MAP_MEMORY_PHYSICAL_MB = "mapreduce.map.memory.physical.mb";
    public static final String REDUCE_MEMORY_PHYSICAL_MB = "mapreduce.reduce.memory.physical.mb";

    public Configuration getConfiguration();

    public Credentials getCredentials();

    public JobID getJobID();

    public int getNumReduceTasks();

    public Path getWorkingDirectory() throws IOException;

    public Class<?> getOutputKeyClass();

    public Class<?> getOutputValueClass();

    public Class<?> getMapOutputKeyClass();

    public Class<?> getMapOutputValueClass();

    public String getJobName();

    public boolean userClassesTakesPrecedence();

    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException;

    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException;

    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException;

    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException;

    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException;

    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException;

    public RawComparator<?> getSortComparator();

    public String getJar();

    public RawComparator<?> getGroupingComparator();

    public boolean getJobSetupCleanupNeeded();

    public boolean getProfileEnabled();

    public String getProfileParams();

    public String getUser();

    public boolean getSymlink();

    public Path[] getArchiveClassPaths();

    public URI[] getCacheArchives() throws IOException;

    public URI[] getCacheFiles() throws IOException;

    public Path[] getLocalCacheArchives() throws IOException;

    public Path[] getLocalCacheFiles() throws IOException;

    public Path[] getFileClassPaths();

    public String[] getArchiveTimestamps();

    public String[] getFileTimestamps();

    public int getMaxMapAttempts();

    public int getMaxReduceAttempts();
}

