/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security.token;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;

public class DelegationTokenRenewal {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewal.class);
    public static final String SCHEME = "hdfs";
    private static Timer renewalTimer = null;
    private static DelegationTokenCancelThread dtCancelThread = new DelegationTokenCancelThread();
    private static Set<DelegationTokenToRenew> delegationTokens;

    private static void addTokenToList(DelegationTokenToRenew t) {
        delegationTokens.add(t);
    }

    public static synchronized void registerDelegationTokensForRenewal(JobID jobId, Credentials ts, Configuration conf) throws IOException {
        if (ts == null) {
            return;
        }
        Collection tokens = ts.getAllTokens();
        long now = System.currentTimeMillis();
        for (Token t : tokens) {
            if (!t.isManaged()) continue;
            DelegationTokenToRenew dtr = new DelegationTokenToRenew(jobId, t, conf, now);
            DelegationTokenRenewal.addTokenToList(dtr);
            DelegationTokenRenewal.setTimerForTokenRenewal(dtr, true);
            LOG.info((Object)("registering token for renewal for service =" + t.getService() + " and jobID = " + jobId));
        }
    }

    private static synchronized void setTimerForTokenRenewal(DelegationTokenToRenew token, boolean firstTime) throws IOException {
        long renewIn;
        long now = System.currentTimeMillis();
        if (firstTime) {
            renewIn = now;
        } else {
            long expiresIn = token.expirationDate - now;
            renewIn = now + expiresIn - expiresIn / 10L;
        }
        RenewalTimerTask tTask = new RenewalTimerTask(token);
        token.setTimerTask(tTask);
        if (renewalTimer == null) {
            renewalTimer = new Timer(true);
        }
        renewalTimer.schedule(token.timerTask, new Date(renewIn));
    }

    public static synchronized void close() {
        if (renewalTimer != null) {
            renewalTimer.cancel();
        }
        renewalTimer = null;
        delegationTokens.clear();
    }

    private static void cancelToken(DelegationTokenToRenew t) {
        dtCancelThread.cancelToken(t.token, t.conf);
    }

    private static void removeFailedDelegationToken(DelegationTokenToRenew t) {
        JobID jobId = t.jobId;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removing failed delegation token for jobid=" + jobId + ";t=" + t.token.getService()));
        }
        delegationTokens.remove(t);
        if (t.timerTask != null) {
            t.timerTask.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDelegationTokenRenewalForJob(JobID jobId) {
        Set<DelegationTokenToRenew> set = delegationTokens;
        synchronized (set) {
            Iterator<DelegationTokenToRenew> it = delegationTokens.iterator();
            while (it.hasNext()) {
                DelegationTokenToRenew dttr = it.next();
                if (!dttr.jobId.equals(jobId)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("removing delegation token for jobid=" + jobId + ";t=" + dttr.token.getService()));
                }
                if (dttr.timerTask != null) {
                    dttr.timerTask.cancel();
                }
                DelegationTokenRenewal.cancelToken(dttr);
                it.remove();
            }
        }
    }

    static {
        dtCancelThread.start();
        delegationTokens = Collections.synchronizedSet(new HashSet());
    }

    private static class RenewalTimerTask
    extends TimerTask {
        private DelegationTokenToRenew dttr;
        private boolean cancelled = false;

        RenewalTimerTask(DelegationTokenToRenew t) {
            this.dttr = t;
        }

        @Override
        public synchronized void run() {
            if (this.cancelled) {
                return;
            }
            Token<?> token = this.dttr.token;
            try {
                this.dttr.expirationDate = (Long)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

                    @Override
                    public Long run() throws Exception {
                        return ((RenewalTimerTask)RenewalTimerTask.this).dttr.token.renew(((RenewalTimerTask)RenewalTimerTask.this).dttr.conf);
                    }
                });
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("renewing for:" + token.getService() + ";newED=" + this.dttr.expirationDate));
                }
                DelegationTokenRenewal.setTimerForTokenRenewal(this.dttr, false);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception renewing token" + token + ". Not rescheduled"), (Throwable)e);
                DelegationTokenRenewal.removeFailedDelegationToken(this.dttr);
            }
        }

        @Override
        public synchronized boolean cancel() {
            this.cancelled = true;
            return super.cancel();
        }
    }

    private static class DelegationTokenCancelThread
    extends Thread {
        private LinkedBlockingQueue<TokenWithConf> queue = new LinkedBlockingQueue();

        public DelegationTokenCancelThread() {
            super("Delegation Token Canceler");
            this.setDaemon(true);
        }

        public void cancelToken(Token<?> token, Configuration conf) {
            TokenWithConf tokenWithConf = new TokenWithConf(token, conf);
            while (!this.queue.offer(tokenWithConf)) {
                LOG.warn((Object)("Unable to add token " + token + " for cancellation. " + "Will retry.."));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void run() {
            TokenWithConf tokenWithConf = null;
            while (true) {
                try {
                    while (true) {
                        final TokenWithConf current = tokenWithConf = this.queue.take();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Canceling token " + tokenWithConf.token.getService()));
                        }
                        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                            @Override
                            public Void run() throws Exception {
                                current.token.cancel(current.conf);
                                return null;
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to cancel token " + tokenWithConf.token + " " + StringUtils.stringifyException((Throwable)e)));
                    continue;
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Got exception " + StringUtils.stringifyException((Throwable)t) + ". Exiting.."));
                    System.exit(-1);
                    continue;
                }
                break;
            }
        }

        private static class TokenWithConf {
            Token<?> token;
            Configuration conf;

            TokenWithConf(Token<?> token, Configuration conf) {
                this.token = token;
                this.conf = conf;
            }
        }
    }

    private static class DelegationTokenToRenew {
        public final Token<?> token;
        public final JobID jobId;
        public final Configuration conf;
        public long expirationDate;
        public TimerTask timerTask;

        public DelegationTokenToRenew(JobID jId, Token<?> t, Configuration newConf, long newExpirationDate) {
            this.token = t;
            this.jobId = jId;
            this.conf = newConf;
            this.expirationDate = newExpirationDate;
            this.timerTask = null;
            if (this.token == null || this.jobId == null || this.conf == null) {
                throw new IllegalArgumentException("invalid params for Renew Token;t=" + this.token + ";j=" + this.jobId + ";c=" + this.conf);
            }
        }

        public void setTimerTask(TimerTask tTask) {
            this.timerTask = tTask;
        }

        public String toString() {
            return this.token + ";exp=" + this.expirationDate;
        }

        public boolean equals(Object obj) {
            return obj instanceof DelegationTokenToRenew && this.token.equals(((DelegationTokenToRenew)obj).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }
    }
}

