/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplit;

public class JobSplitWriter {
    private static final int splitVersion = 1;
    private static final byte[] SPLIT_FILE_HEADER;

    public static <T extends InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, List<InputSplit> splits) throws IOException, InterruptedException {
        InputSplit[] array = splits.toArray(new InputSplit[splits.size()]);
        JobSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)conf, (FileSystem)fs, (InputSplit[])array);
    }

    public static <T extends InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, T[] splits) throws IOException, InterruptedException {
        FSDataOutputStream out = JobSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile(jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = JobSplitWriter.writeNewSplits((Configuration)conf, splits, (FSDataOutputStream)out);
        out.close();
        JobSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile(jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    public static void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, org.apache.hadoop.mapred.InputSplit[] splits) throws IOException {
        FSDataOutputStream out = JobSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile(jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = JobSplitWriter.writeOldSplits(splits, out);
        out.close();
        JobSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile(jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    private static FSDataOutputStream createFile(FileSystem fs, Path splitFile, Configuration job) throws IOException {
        FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)splitFile, (FsPermission)new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
        int replication = job.getInt("mapred.submit.replication", 10);
        fs.setReplication(splitFile, (short)replication);
        JobSplitWriter.writeSplitHeader(out);
        return out;
    }

    private static void writeSplitHeader(FSDataOutputStream out) throws IOException {
        out.write(SPLIT_FILE_HEADER);
        out.writeInt(1);
    }

    private static <T extends InputSplit> JobSplit.SplitMetaInfo[] writeNewSplits(Configuration conf, T[] array, FSDataOutputStream out) throws IOException, InterruptedException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[array.length];
        if (array.length != 0) {
            SerializationFactory factory = new SerializationFactory(conf);
            int i = 0;
            long offset = out.size();
            for (T split : array) {
                int prevCount = out.size();
                Text.writeString((DataOutput)out, (String)split.getClass().getName());
                Serializer serializer = factory.getSerializer(split.getClass());
                serializer.open((OutputStream)out);
                serializer.serialize(split);
                int currCount = out.size();
                info[i++] = new JobSplit.SplitMetaInfo(((InputSplit)split).getLocations(), offset, ((InputSplit)split).getLength());
                offset += (long)(currCount - prevCount);
            }
        }
        return info;
    }

    private static JobSplit.SplitMetaInfo[] writeOldSplits(org.apache.hadoop.mapred.InputSplit[] splits, FSDataOutputStream out) throws IOException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[splits.length];
        if (splits.length != 0) {
            int i = 0;
            long offset = out.size();
            for (org.apache.hadoop.mapred.InputSplit split : splits) {
                int prevLen = out.size();
                Text.writeString((DataOutput)out, (String)split.getClass().getName());
                split.write((DataOutput)out);
                int currLen = out.size();
                info[i++] = new JobSplit.SplitMetaInfo(split.getLocations(), offset, split.getLength());
                offset += (long)(currLen - prevLen);
            }
        }
        return info;
    }

    private static void writeJobSplitMetaInfo(FileSystem fs, Path filename, FsPermission p, int splitMetaInfoVersion, JobSplit.SplitMetaInfo[] allSplitMetaInfo) throws IOException {
        FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)filename, (FsPermission)p);
        out.write(JobSplit.META_SPLIT_FILE_HEADER);
        WritableUtils.writeVInt((DataOutput)out, (int)splitMetaInfoVersion);
        WritableUtils.writeVInt((DataOutput)out, (int)allSplitMetaInfo.length);
        for (JobSplit.SplitMetaInfo splitMetaInfo : allSplitMetaInfo) {
            splitMetaInfo.write((DataOutput)out);
        }
        out.close();
    }

    static {
        try {
            SPLIT_FILE_HEADER = "SPL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }
}

