/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;

class SecureCmdDoAs {
    private final Path tokenPath;

    SecureCmdDoAs(HiveConf conf) throws HiveException, IOException {
        this.tokenPath = ShimLoader.getHadoopShims().createDelegationTokenFile(conf);
    }

    String addArg(String cmdline) throws HiveException {
        StringBuilder sb = new StringBuilder();
        sb.append(cmdline);
        sb.append(" -hadooptoken ");
        sb.append(this.tokenPath.toUri().getPath());
        return sb.toString();
    }

    void addEnv(Map<String, String> env) {
        env.put("HADOOP_TOKEN_FILE_LOCATION", this.tokenPath.toUri().getPath());
    }
}

