/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class OrcOutputFormat
extends FileOutputFormat<NullWritable, OrcSerde.OrcSerdeRow>
implements HiveOutputFormat<NullWritable, OrcSerde.OrcSerdeRow> {
    public RecordWriter<NullWritable, OrcSerde.OrcSerdeRow> getRecordWriter(FileSystem fileSystem, JobConf conf, String name, Progressable reporter) throws IOException {
        return new OrcRecordWriter(fileSystem, new Path(name), (Configuration)conf, "268435456", "ZLIB", "262144", "10000");
    }

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf conf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable reporter) throws IOException {
        String stripeSize = tableProperties.getProperty("orc.stripe.size", "268435456");
        String compression = tableProperties.getProperty("orc.compress", "ZLIB");
        String compressionSize = tableProperties.getProperty("orc.compress.size", "262144");
        String rowIndexStride = tableProperties.getProperty("orc.row.index.stride", "10000");
        if ("false".equals(tableProperties.getProperty("orc.create.index"))) {
            rowIndexStride = "0";
        }
        return new OrcRecordWriter(path.getFileSystem((Configuration)conf), path, (Configuration)conf, stripeSize, compression, compressionSize, rowIndexStride);
    }

    private static class OrcRecordWriter
    implements RecordWriter<NullWritable, OrcSerde.OrcSerdeRow>,
    FileSinkOperator.RecordWriter {
        private Writer writer = null;
        private final FileSystem fs;
        private final Path path;
        private final Configuration conf;
        private final long stripeSize;
        private final int compressionSize;
        private final CompressionKind compress;
        private final int rowIndexStride;

        OrcRecordWriter(FileSystem fs, Path path, Configuration conf, String stripeSize, String compress, String compressionSize, String rowIndexStride) {
            this.fs = fs;
            this.path = path;
            this.conf = conf;
            this.stripeSize = Long.valueOf(stripeSize);
            this.compress = CompressionKind.valueOf(compress);
            this.compressionSize = Integer.valueOf(compressionSize);
            this.rowIndexStride = Integer.valueOf(rowIndexStride);
        }

        public void write(NullWritable nullWritable, OrcSerde.OrcSerdeRow row) throws IOException {
            if (this.writer == null) {
                this.writer = OrcFile.createWriter(this.fs, this.path, this.conf, row.getInspector(), this.stripeSize, this.compress, this.compressionSize, this.rowIndexStride);
            }
            this.writer.addRow(row.getRow());
        }

        @Override
        public void write(Writable row) throws IOException {
            OrcSerde.OrcSerdeRow serdeRow = (OrcSerde.OrcSerdeRow)row;
            if (this.writer == null) {
                this.writer = OrcFile.createWriter(this.fs, this.path, this.conf, serdeRow.getInspector(), this.stripeSize, this.compress, this.compressionSize, this.rowIndexStride);
            }
            this.writer.addRow(serdeRow.getRow());
        }

        public void close(Reporter reporter) throws IOException {
            this.close(true);
        }

        @Override
        public void close(boolean b) throws IOException {
            if (this.writer == null) {
                StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(new ArrayList<String>(), new ArrayList<ObjectInspector>());
                this.writer = OrcFile.createWriter(this.fs, this.path, this.conf, inspector, this.stripeSize, this.compress, this.compressionSize, this.rowIndexStride);
            }
            this.writer.close();
        }
    }
}

