/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class GenMRRedSink1
implements NodeProcessor {
    private boolean checkMultiparentOps(Operator<? extends OperatorDesc> op) {
        while (op != null && op.getParentOperators() != null) {
            if (op.getParentOperators().size() > 1) {
                return true;
            }
            op = op.getParentOperators().get(0);
        }
        return false;
    }

    private boolean areMultiAncestorsMultiWayOps(ReduceSinkOperator reduceOp) {
        Operator<OperatorDesc> childOp = reduceOp.getChildOperators().get(0);
        List<Operator<OperatorDesc>> parentOps = childOp.getParentOperators();
        if (parentOps.size() > 1) {
            int count = 0;
            for (Operator<OperatorDesc> op : parentOps) {
                if (this.checkMultiparentOps(op)) {
                    ++count;
                }
                if (count <= 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        ReduceSinkOperator op = (ReduceSinkOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        boolean multiWayOp = this.areMultiAncestorsMultiWayOps(op);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(stack.get(stack.size() - 2));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        MapredWork currPlan = (MapredWork)currTask.getWork();
        Operator<? extends OperatorDesc> currTopOp = mapredCtx.getCurrTopOp();
        String currAliasId = mapredCtx.getCurrAliasId();
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        Task<? extends Serializable> opMapTask = opTaskMap.get(reducer);
        ctx.setCurrTopOp(currTopOp);
        ctx.setCurrAliasId(currAliasId);
        ctx.setCurrTask(currTask);
        if (opMapTask == null) {
            if (currPlan.getReducer() == null) {
                if (!multiWayOp) {
                    GenMapRedUtils.initPlan(op, ctx);
                } else {
                    GenMapRedUtils.splitPlan(op, ctx);
                    List<Operator<? extends OperatorDesc>> splitTaskOps = ctx.getSplitTasks();
                    splitTaskOps.add(reducer);
                }
            } else {
                GenMapRedUtils.splitPlan(op, ctx);
            }
        } else {
            Task<? extends Serializable> oldTask = null;
            if (ctx.getSplitTasks().contains(reducer)) {
                multiWayOp = true;
            }
            if (multiWayOp) {
                oldTask = ctx.getCurrTask();
            }
            GenMapRedUtils.joinPlan(op, oldTask, opMapTask, ctx, -1, multiWayOp);
            currTask = opMapTask;
            ctx.setCurrTask(currTask);
        }
        mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
        return null;
    }
}

