/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.io.VersionedWritable;

public class HServerLoadWithSeqIds
extends VersionedWritable {
    private static final byte VERSION = 1;
    private HServerLoad serverLoad;

    public HServerLoadWithSeqIds() {
    }

    public HServerLoadWithSeqIds(HServerLoad serverLoad) {
        this.serverLoad = serverLoad;
    }

    public byte getVersion() {
        return 1;
    }

    public HServerLoad getServerLoad() {
        return this.serverLoad;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.serverLoad.write(out);
        for (HServerLoad.RegionLoad rl : this.serverLoad.regionLoad.values()) {
            out.writeLong(rl.getCompleteSequenceId());
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        if (null == this.serverLoad) {
            this.serverLoad = new HServerLoad();
        }
        List<byte[]> regionKeys = this.serverLoad.readFieldsGetRegionKeys(in);
        for (int i = 0; i < regionKeys.size(); ++i) {
            long lastSequenceId = in.readLong();
            HServerLoad.RegionLoad rl = this.serverLoad.regionLoad.get(regionKeys.get(i));
            rl.setCompleteSequenceId(lastSequenceId);
        }
    }
}

