/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.UnmodifyableHRegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;

public class MetaScanner {
    private static final Log LOG = LogFactory.getLog(MetaScanner.class);

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor) throws IOException {
        MetaScanner.metaScan(configuration, visitor, null);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] userTableName) throws IOException {
        MetaScanner.metaScan(configuration, visitor, userTableName, null, Integer.MAX_VALUE);
    }

    public static void metaScan(Configuration configuration, MetaScannerVisitor visitor, byte[] userTableName, byte[] row, int rowLimit) throws IOException {
        MetaScanner.metaScan(configuration, visitor, userTableName, row, rowLimit, HConstants.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void metaScan(Configuration configuration, final MetaScannerVisitor visitor, final byte[] tableName, final byte[] row, final int rowLimit, final byte[] metaTableName) throws IOException {
        try {
            HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(configuration){

                @Override
                public Void connect(HConnection connection) throws IOException {
                    MetaScanner.metaScan(this.conf, connection, visitor, tableName, row, rowLimit, metaTableName);
                    return null;
                }
            });
        }
        finally {
            visitor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void metaScan(Configuration configuration, HConnection connection, MetaScannerVisitor visitor, byte[] tableName, byte[] row, int rowLimit, byte[] metaTableName) throws IOException {
        byte[] startRow;
        int rowUpperLimit;
        int n = rowUpperLimit = rowLimit > 0 ? rowLimit : Integer.MAX_VALUE;
        if (row != null) {
            assert (tableName != null);
            byte[] searchRow = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            HTable metaTable = null;
            try {
                metaTable = new HTable(configuration, HConstants.META_TABLE_NAME);
                Result startRowResult = metaTable.getRowOrBefore(searchRow, HConstants.CATALOG_FAMILY);
                if (startRowResult == null) {
                    throw new TableNotFoundException("Cannot find row in .META. for table: " + Bytes.toString(tableName) + ", row=" + Bytes.toStringBinary(searchRow));
                }
                byte[] value = startRowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                if (value == null || value.length == 0) {
                    throw new IOException("HRegionInfo was null or empty in Meta for " + Bytes.toString(tableName) + ", row=" + Bytes.toStringBinary(searchRow));
                }
                HRegionInfo regionInfo = Writables.getHRegionInfo(value);
                byte[] rowBefore = regionInfo.getStartKey();
                startRow = HRegionInfo.createRegionName(tableName, rowBefore, "00000000000000", false);
            }
            finally {
                if (metaTable != null) {
                    metaTable.close();
                }
            }
        } else {
            startRow = tableName == null || tableName.length == 0 ? HConstants.EMPTY_START_ROW : HRegionInfo.createRegionName(tableName, HConstants.EMPTY_START_ROW, "00000000000000", false);
        }
        int rows = Math.min(rowLimit, configuration.getInt(HConstants.HBASE_META_SCANNER_CACHING, HConstants.DEFAULT_HBASE_META_SCANNER_CACHING));
        do {
            Scan scan = new Scan(startRow).addFamily(HConstants.CATALOG_FAMILY);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Scanning " + Bytes.toString(metaTableName) + " starting at row=" + Bytes.toStringBinary(startRow) + " for max=" + rowUpperLimit + " rows using " + connection.toString()));
            }
            ScannerCallable callable = new ScannerCallable(connection, metaTableName, scan, null);
            callable.withRetries();
            int processedRows = 0;
            try {
                Result[] rrs;
                callable.setCaching(rows);
                block7: while (processedRows < rowUpperLimit && (rrs = (Result[])callable.withRetries()) != null && rrs.length != 0 && rrs[0].size() != 0) {
                    for (Result rr : rrs) {
                        if (processedRows >= rowUpperLimit || !visitor.processRow(rr)) break block7;
                        ++processedRows;
                    }
                }
                startRow = callable.getHRegionInfo().getEndKey();
            }
            finally {
                callable.setClose();
                callable.withRetries();
            }
        } while (Bytes.compareTo(startRow, HConstants.LAST_ROW) != 0);
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf) throws IOException {
        return MetaScanner.listAllRegions(conf, true);
    }

    public static List<HRegionInfo> listAllRegions(Configuration conf, final boolean offlined) throws IOException {
        final ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        BlockingMetaScannerVisitor visitor = new BlockingMetaScannerVisitor(conf){

            @Override
            public boolean processRowInternal(Result result) throws IOException {
                if (result == null || result.isEmpty()) {
                    return true;
                }
                byte[] bytes = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                if (bytes == null) {
                    LOG.warn((Object)("Null REGIONINFO_QUALIFIER: " + result));
                    return true;
                }
                HRegionInfo regionInfo = Writables.getHRegionInfo(bytes);
                if (regionInfo.isOffline() && !offlined) {
                    return true;
                }
                regions.add(regionInfo);
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor);
        return regions;
    }

    public static NavigableMap<HRegionInfo, ServerName> allTableRegions(Configuration conf, byte[] tablename, boolean offlined) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        TableMetaScannerVisitor visitor = new TableMetaScannerVisitor(conf, tablename){

            @Override
            public boolean processRowInternal(Result rowResult) throws IOException {
                HRegionInfo info = Writables.getHRegionInfo(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                byte[] value = rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                String hostAndPort = null;
                if (value != null && value.length > 0) {
                    hostAndPort = Bytes.toString(value);
                }
                value = rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER);
                long startcode = -1L;
                if (value != null && value.length > 0) {
                    startcode = Bytes.toLong(value);
                }
                if (!info.isOffline() && !info.isSplit()) {
                    ServerName sn = null;
                    if (hostAndPort != null && hostAndPort.length() > 0) {
                        sn = new ServerName(hostAndPort, startcode);
                    }
                    regions.put(new UnmodifyableHRegionInfo(info), sn);
                }
                return true;
            }
        };
        MetaScanner.metaScan(conf, visitor, tablename);
        return regions;
    }

    public static abstract class TableMetaScannerVisitor
    extends BlockingMetaScannerVisitor {
        private byte[] tableName;

        public TableMetaScannerVisitor(Configuration conf, byte[] tableName) {
            super(conf);
            this.tableName = tableName;
        }

        @Override
        public final boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = Writables.getHRegionInfoOrNull(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
            if (info == null) {
                return true;
            }
            if (!Bytes.equals(info.getTableName(), this.tableName)) {
                return false;
            }
            return super.processRow(rowResult);
        }
    }

    public static abstract class BlockingMetaScannerVisitor
    extends MetaScannerVisitorBase {
        private static final int DEFAULT_BLOCKING_TIMEOUT = 10000;
        private Configuration conf;
        private TreeSet<byte[]> daughterRegions = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        private int blockingTimeout;
        private HTable metaTable;

        public BlockingMetaScannerVisitor(Configuration conf) {
            this.conf = conf;
            this.blockingTimeout = conf.getInt("hbase.client.operation.timeout", 10000);
        }

        public abstract boolean processRowInternal(Result var1) throws IOException;

        @Override
        public void close() throws IOException {
            super.close();
            if (this.metaTable != null) {
                this.metaTable.close();
                this.metaTable = null;
            }
        }

        public HTable getMetaTable() throws IOException {
            if (this.metaTable == null) {
                this.metaTable = new HTable(this.conf, HConstants.META_TABLE_NAME);
            }
            return this.metaTable;
        }

        @Override
        public boolean processRow(Result rowResult) throws IOException {
            HRegionInfo info = Writables.getHRegionInfoOrNull(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
            if (info == null) {
                return true;
            }
            if (this.daughterRegions.remove(info.getRegionName())) {
                return true;
            }
            if (info.isSplitParent()) {
                HRegionInfo splitA = Writables.getHRegionInfoOrNull(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER));
                HRegionInfo splitB = Writables.getHRegionInfoOrNull(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER));
                HTable metaTable = this.getMetaTable();
                long start = System.currentTimeMillis();
                if (splitA != null) {
                    Result resultA = this.getRegionResultBlocking(metaTable, this.blockingTimeout, splitA.getRegionName());
                    if (resultA != null) {
                        this.processRow(resultA);
                        this.daughterRegions.add(splitA.getRegionName());
                    } else {
                        throw new RegionOfflineException("Split daughter region " + splitA.getRegionNameAsString() + " cannot be found in META.");
                    }
                }
                long rem = (long)this.blockingTimeout - (System.currentTimeMillis() - start);
                if (splitB != null) {
                    Result resultB = this.getRegionResultBlocking(metaTable, rem, splitB.getRegionName());
                    if (resultB != null) {
                        this.processRow(resultB);
                        this.daughterRegions.add(splitB.getRegionName());
                    } else {
                        throw new RegionOfflineException("Split daughter region " + splitB.getRegionNameAsString() + " cannot be found in META.");
                    }
                }
            }
            return this.processRowInternal(rowResult);
        }

        private Result getRegionResultBlocking(HTable metaTable, long timeout, byte[] regionName) throws IOException {
            boolean logged = false;
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < timeout) {
                Get get2 = new Get(regionName);
                Result result = metaTable.get(get2);
                HRegionInfo info = Writables.getHRegionInfoOrNull(result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                if (info != null) {
                    return result;
                }
                try {
                    if (!logged) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("blocking until region is in META: " + Bytes.toStringBinary(regionName)));
                        }
                        logged = true;
                    }
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            return null;
        }
    }

    public static abstract class MetaScannerVisitorBase
    implements MetaScannerVisitor {
        @Override
        public void close() throws IOException {
        }
    }

    public static interface MetaScannerVisitor
    extends Closeable {
        public boolean processRow(Result var1) throws IOException;
    }
}

