/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class RegexStringComparator
extends WritableByteArrayComparable {
    private static final Log LOG = LogFactory.getLog(RegexStringComparator.class);
    private Charset charset = Charset.forName("UTF-8");
    private Pattern pattern;

    public RegexStringComparator() {
    }

    public RegexStringComparator(String expr) {
        super(Bytes.toBytes(expr));
        this.pattern = Pattern.compile(expr, 32);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public int compareTo(byte[] value, int offset, int length) {
        return this.pattern.matcher(new String(value, offset, length, this.charset)).find() ? 0 : 1;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String expr = in.readUTF();
        this.value = Bytes.toBytes(expr);
        this.pattern = Pattern.compile(expr);
        String charset = in.readUTF();
        if (charset.length() > 0) {
            try {
                this.charset = Charset.forName(charset);
            }
            catch (IllegalCharsetNameException e) {
                LOG.error((Object)"invalid charset", (Throwable)e);
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.pattern.toString());
        out.writeUTF(this.charset.name());
    }
}

