/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;

class CatalogJanitor
extends Chore {
    private static final Log LOG = LogFactory.getLog((String)CatalogJanitor.class.getName());
    private final Server server;
    private final MasterServices services;
    private boolean enabled = true;

    CatalogJanitor(Server server, MasterServices services) {
        super(server.getServerName() + "-CatalogJanitor", server.getConfiguration().getInt("hbase.catalogjanitor.interval", 300000), server);
        this.server = server;
        this.services = services;
    }

    @Override
    protected boolean initialChore() {
        try {
            if (this.enabled) {
                this.scan();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed initial scan of catalog table", (Throwable)e);
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    protected void chore() {
        try {
            this.scan();
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed scan of catalog table", (Throwable)e);
        }
    }

    Pair<Integer, Map<HRegionInfo, Result>> getSplitParents() throws IOException {
        final AtomicInteger count = new AtomicInteger(0);
        final TreeMap splitParents = new TreeMap(new SplitParentFirstComparator());
        MetaReader.Visitor visitor = new MetaReader.Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                count.incrementAndGet();
                HRegionInfo info = CatalogJanitor.getHRegionInfo(r);
                if (info == null) {
                    return true;
                }
                if (info.isSplitParent()) {
                    splitParents.put(info, r);
                }
                return true;
            }
        };
        MetaReader.fullScan(this.server.getCatalogTracker(), visitor);
        return new Pair<Integer, Map<HRegionInfo, Result>>(count.get(), splitParents);
    }

    int scan() throws IOException {
        Pair<Integer, Map<HRegionInfo, Result>> pair = this.getSplitParents();
        int count = pair.getFirst();
        Map<HRegionInfo, Result> splitParents = pair.getSecond();
        int cleaned = 0;
        HashSet<String> parentNotCleaned = new HashSet<String>();
        for (Map.Entry<HRegionInfo, Result> e : splitParents.entrySet()) {
            if (!parentNotCleaned.contains(e.getKey().getEncodedName()) && this.cleanParent(e.getKey(), e.getValue())) {
                ++cleaned;
                continue;
            }
            parentNotCleaned.add(this.getDaughterRegionInfo(e.getValue(), HConstants.SPLITA_QUALIFIER).getEncodedName());
            parentNotCleaned.add(this.getDaughterRegionInfo(e.getValue(), HConstants.SPLITB_QUALIFIER).getEncodedName());
        }
        if (cleaned != 0) {
            LOG.info((Object)("Scanned " + count + " catalog row(s) and gc'd " + cleaned + " unreferenced parent region(s)"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scanned " + count + " catalog row(s) and gc'd " + cleaned + " unreferenced parent region(s)"));
        }
        return cleaned;
    }

    static HRegionInfo getHRegionInfo(Result result) throws IOException {
        byte[] bytes = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
        if (bytes == null) {
            LOG.warn((Object)("REGIONINFO_QUALIFIER is empty in " + result));
            return null;
        }
        return Writables.getHRegionInfo(bytes);
    }

    boolean cleanParent(HRegionInfo parent, Result rowContent) throws IOException {
        boolean result = false;
        HRegionInfo a_region = this.getDaughterRegionInfo(rowContent, HConstants.SPLITA_QUALIFIER);
        HRegionInfo b_region = this.getDaughterRegionInfo(rowContent, HConstants.SPLITB_QUALIFIER);
        Pair<Boolean, Boolean> a = this.checkDaughterInFs(parent, a_region, HConstants.SPLITA_QUALIFIER);
        Pair<Boolean, Boolean> b = this.checkDaughterInFs(parent, b_region, HConstants.SPLITB_QUALIFIER);
        if (this.hasNoReferences(a) && this.hasNoReferences(b)) {
            LOG.debug((Object)("Deleting region " + parent.getRegionNameAsString() + " because daughter splits no longer hold references"));
            if (this.services.getAssignmentManager() != null) {
                this.services.getAssignmentManager().regionOffline(parent);
            }
            FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
            HFileArchiver.archiveRegion(this.services.getConfiguration(), fs, parent);
            MetaEditor.deleteRegion(this.server.getCatalogTracker(), parent);
            result = true;
        }
        return result;
    }

    private boolean hasNoReferences(Pair<Boolean, Boolean> p) {
        return p.getFirst() == false || p.getSecond() == false;
    }

    private HRegionInfo getDaughterRegionInfo(Result result, byte[] which) throws IOException {
        byte[] bytes = result.getValue(HConstants.CATALOG_FAMILY, which);
        return Writables.getHRegionInfoOrNull(bytes);
    }

    Pair<Boolean, Boolean> checkDaughterInFs(HRegionInfo parent, HRegionInfo split, byte[] qualifier) throws IOException {
        Path rootdir;
        Path tabledir;
        Path regiondir;
        boolean references = false;
        boolean exists2 = false;
        if (split == null) {
            return new Pair<Boolean, Boolean>(Boolean.FALSE, Boolean.FALSE);
        }
        FileSystem fs = this.services.getMasterFileSystem().getFileSystem();
        exists2 = fs.exists(regiondir = new Path(tabledir = new Path(rootdir = this.services.getMasterFileSystem().getRootDir(), split.getTableNameAsString()), split.getEncodedName()));
        if (!exists2) {
            LOG.warn((Object)("Daughter regiondir does not exist: " + regiondir.toString()));
            return new Pair<Boolean, Boolean>(exists2, Boolean.FALSE);
        }
        HTableDescriptor parentDescriptor = this.getTableDescriptor(parent.getTableName());
        for (HColumnDescriptor family : parentDescriptor.getFamilies()) {
            FileStatus[] ps;
            Path p = Store.getStoreHomedir(tabledir, split.getEncodedName(), family.getName());
            if (!fs.exists(p) || (ps = FSUtils.listStatus(fs, p, new PathFilter(){

                public boolean accept(Path path) {
                    return StoreFile.isReference(path);
                }
            })) == null || ps.length <= 0) continue;
            references = true;
            break;
        }
        return new Pair<Boolean, Boolean>(exists2, references);
    }

    private HTableDescriptor getTableDescriptor(byte[] tableName) throws FileNotFoundException, IOException {
        return this.services.getTableDescriptors().get(Bytes.toString(tableName));
    }

    static class SplitParentFirstComparator
    implements Comparator<HRegionInfo> {
        SplitParentFirstComparator() {
        }

        @Override
        public int compare(HRegionInfo left, HRegionInfo right) {
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int result = Bytes.compareTo(left.getTableName(), right.getTableName());
            if (result != 0) {
                return result;
            }
            result = Bytes.compareTo(left.getStartKey(), right.getStartKey());
            if (result != 0) {
                return result;
            }
            result = Bytes.compareTo(left.getEndKey(), right.getEndKey());
            if (result != 0) {
                if (left.getStartKey().length != 0 && left.getEndKey().length == 0) {
                    return -1;
                }
                if (right.getStartKey().length != 0 && right.getEndKey().length == 0) {
                    return 1;
                }
                return -result;
            }
            return result;
        }
    }
}

