/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.cleaner.FileCleanerDelegate;
import org.apache.hadoop.hbase.util.FSUtils;

public abstract class CleanerChore<T extends FileCleanerDelegate>
extends Chore {
    private static final Log LOG = LogFactory.getLog((String)CleanerChore.class.getName());
    private final FileSystem fs;
    private final Path oldFileDir;
    private final Configuration conf;
    List<T> cleanersChain;

    public CleanerChore(String name, int sleepPeriod, Stoppable s, Configuration conf, FileSystem fs, Path oldFileDir, String confKey) {
        super(name, sleepPeriod, s);
        this.fs = fs;
        this.oldFileDir = oldFileDir;
        this.conf = conf;
        this.initCleanerChain(confKey);
    }

    protected abstract boolean validate(Path var1);

    private void initCleanerChain(String confKey) {
        this.cleanersChain = new LinkedList<T>();
        String[] logCleaners = this.conf.getStrings(confKey);
        if (logCleaners != null) {
            for (String className : logCleaners) {
                T logCleaner = this.newFileCleaner(className, this.conf);
                if (logCleaner == null) continue;
                LOG.debug((Object)("initialize cleaner=" + className));
                this.cleanersChain.add(logCleaner);
            }
        }
    }

    public T newFileCleaner(String className, Configuration conf) {
        try {
            Class<FileCleanerDelegate> c = Class.forName(className).asSubclass(FileCleanerDelegate.class);
            FileCleanerDelegate cleaner = c.newInstance();
            cleaner.setConf(conf);
            return (T)cleaner;
        }
        catch (Exception e) {
            LOG.warn((Object)("Can NOT create CleanerDelegate: " + className), (Throwable)e);
            return null;
        }
    }

    @Override
    protected void chore() {
        try {
            FileStatus[] files = FSUtils.listStatus(this.fs, this.oldFileDir, null);
            if (files == null) {
                return;
            }
            for (FileStatus file : files) {
                try {
                    if (file.isDir()) {
                        this.checkAndDeleteDirectory(file.getPath());
                        continue;
                    }
                    this.checkAndDelete(file.getPath());
                }
                catch (IOException e) {
                    e = RemoteExceptionHandler.checkIOException(e);
                    LOG.warn((Object)"Error while cleaning the logs", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to get status of:" + this.oldFileDir));
        }
    }

    public boolean checkAndDeleteDirectory(Path toCheck) throws IOException {
        FileStatus[] children;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Checking directory: " + toCheck));
        }
        if ((children = FSUtils.listStatus(this.fs, toCheck, null)) == null) {
            try {
                return this.fs.delete(toCheck, false);
            }
            catch (IOException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Couldn't delete directory: " + toCheck), (Throwable)e);
                }
                return false;
            }
        }
        boolean canDeleteThis = true;
        for (FileStatus child : children) {
            Path path = child.getPath();
            if (child.isDir()) {
                if (this.checkAndDeleteDirectory(path)) continue;
                canDeleteThis = false;
                continue;
            }
            if (this.checkAndDelete(path)) continue;
            canDeleteThis = false;
        }
        if (!canDeleteThis) {
            return false;
        }
        try {
            return this.fs.delete(toCheck, false);
        }
        catch (IOException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Couldn't delete directory: " + toCheck), (Throwable)e);
            }
            return false;
        }
    }

    private boolean checkAndDelete(Path filePath) throws IOException, IllegalArgumentException {
        boolean success;
        if (!this.validate(filePath)) {
            LOG.warn((Object)("Found a wrongly formatted file: " + filePath.getName() + " deleting it."));
            boolean success2 = this.fs.delete(filePath, true);
            if (!success2) {
                LOG.warn((Object)("Attempted to delete:" + filePath + ", but couldn't. Run cleaner chain and attempt to delete on next pass."));
            }
            return success2;
        }
        for (FileCleanerDelegate cleaner : this.cleanersChain) {
            if (cleaner.isStopped() || this.stopper.isStopped()) {
                LOG.warn((Object)("A file cleaner" + this.getName() + " is stopped, won't delete any file in:" + this.oldFileDir));
                return false;
            }
            if (cleaner.isFileDeletable(filePath)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(filePath + " is not deletable according to:" + cleaner));
            }
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing:" + filePath + " from archive"));
        }
        if (!(success = this.fs.delete(filePath, false))) {
            LOG.warn((Object)("Attempted to delete:" + filePath + ", but couldn't. Run cleaner chain and attempt to delete on next pass."));
        }
        return success;
    }

    @Override
    public void cleanup() {
        for (FileCleanerDelegate lc : this.cleanersChain) {
            try {
                lc.stop("Exiting");
            }
            catch (Throwable t) {
                LOG.warn((Object)"Stopping", t);
            }
        }
    }
}

