/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.handler.CreateTableHandler;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;

@InterfaceAudience.Private
public class CloneSnapshotHandler
extends CreateTableHandler
implements SnapshotSentinel {
    private static final Log LOG = LogFactory.getLog(CloneSnapshotHandler.class);
    private static final String NAME = "Master CloneSnapshotHandler";
    private final HBaseProtos.SnapshotDescription snapshot;
    private final ForeignExceptionDispatcher monitor;
    private volatile boolean stopped = false;

    public CloneSnapshotHandler(MasterServices masterServices, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws NotAllMetaRegionsOnlineException, TableExistsException, IOException {
        super(masterServices, masterServices.getMasterFileSystem(), masterServices.getServerManager(), hTableDescriptor, masterServices.getConfiguration(), null, masterServices.getCatalogTracker(), masterServices.getAssignmentManager());
        this.snapshot = snapshot;
        this.monitor = new ForeignExceptionDispatcher();
    }

    @Override
    protected List<HRegionInfo> handleCreateHdfsRegions(Path tableRootDir, String tableName) throws IOException {
        FileSystem fs = this.fileSystemManager.getFileSystem();
        Path rootDir = this.fileSystemManager.getRootDir();
        Path tableDir = new Path(tableRootDir, tableName);
        try {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(this.snapshot, rootDir);
            RestoreSnapshotHelper restoreHelper = new RestoreSnapshotHelper(this.conf, fs, this.snapshot, snapshotDir, this.hTableDescriptor, tableDir, this.monitor);
            RestoreSnapshotHelper.RestoreMetaChanges metaChanges = restoreHelper.restoreHdfsRegions();
            Preconditions.checkArgument((!metaChanges.hasRegionsToRestore() ? 1 : 0) != 0, (Object)"A clone should not have regions to restore");
            Preconditions.checkArgument((!metaChanges.hasRegionsToRemove() ? 1 : 0) != 0, (Object)"A clone should not have regions to remove");
            LOG.info((Object)("Clone snapshot=" + this.snapshot.getName() + " on table=" + tableName + " completed!"));
            return metaChanges.getRegionsToAdd();
        }
        catch (Exception e) {
            String msg = "clone snapshot=" + SnapshotDescriptionUtils.toString(this.snapshot) + " failed";
            LOG.error((Object)msg, (Throwable)e);
            RestoreSnapshotException rse = new RestoreSnapshotException(msg, e, this.snapshot);
            this.monitor.receive(new ForeignException(NAME, rse));
            throw rse;
        }
    }

    @Override
    protected void completed(Throwable exception) {
        this.stopped = true;
    }

    @Override
    public boolean isFinished() {
        return this.stopped;
    }

    @Override
    public HBaseProtos.SnapshotDescription getSnapshot() {
        return this.snapshot;
    }

    @Override
    public void cancel(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        LOG.info((Object)("Stopping clone snapshot=" + this.snapshot + " because: " + why));
        this.monitor.receive(new ForeignException(NAME, new CancellationException(why)));
    }

    @Override
    public ForeignException getExceptionIfFailed() {
        return this.monitor.getException();
    }
}

