/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class EnabledTableSnapshotHandler
extends TakeSnapshotHandler {
    private static final Log LOG = LogFactory.getLog(EnabledTableSnapshotHandler.class);
    private final ProcedureCoordinator coordinator;

    public EnabledTableSnapshotHandler(HBaseProtos.SnapshotDescription snapshot, MasterServices master, SnapshotManager manager) throws IOException {
        super(snapshot, master);
        this.coordinator = manager.getCoordinator();
    }

    @Override
    protected void snapshotRegions(List<Pair<HRegionInfo, ServerName>> regions) throws HBaseSnapshotException {
        HashSet<String> regionServers = new HashSet<String>(regions.size());
        for (Pair<HRegionInfo, ServerName> region : regions) {
            regionServers.add(region.getSecond().toString());
        }
        Procedure proc = this.coordinator.startProcedure(this.monitor, this.snapshot.getName(), this.snapshot.toByteArray(), Lists.newArrayList(regionServers));
        if (proc == null) {
            String msg = "Failed to submit distributed procedure for snapshot '" + this.snapshot.getName() + "'";
            LOG.error((Object)msg);
            throw new HBaseSnapshotException(msg);
        }
        try {
            proc.waitForCompleted();
            LOG.info((Object)("Done waiting - snapshot for " + this.snapshot.getName() + " finished!"));
        }
        catch (InterruptedException e) {
            ForeignException ee = new ForeignException("Interrupted while waiting for snapshot to finish", e);
            this.monitor.receive(ee);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            this.monitor.receive(e);
        }
    }
}

