/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.SnapshotSentinel;
import org.apache.hadoop.hbase.master.cleaner.HFileLinkCleaner;
import org.apache.hadoop.hbase.master.snapshot.CloneSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.DisabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.EnabledTableSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.RestoreSnapshotHandler;
import org.apache.hadoop.hbase.master.snapshot.SnapshotHFileCleaner;
import org.apache.hadoop.hbase.master.snapshot.SnapshotLogCleaner;
import org.apache.hadoop.hbase.master.snapshot.TakeSnapshotHandler;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinatorRpcs;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotExistsException;
import org.apache.hadoop.hbase.snapshot.TablePartiallyOpenException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SnapshotManager
implements Stoppable {
    private static final Log LOG = LogFactory.getLog(SnapshotManager.class);
    private static final int SNAPSHOT_WAKE_MILLIS_DEFAULT = 500;
    public static final String HBASE_SNAPSHOT_ENABLED = "hbase.snapshot.enabled";
    private static final String SNAPSHOT_WAKE_MILLIS_KEY = "hbase.snapshot.master.wakeMillis";
    private static final int SNAPSHOT_TIMEOUT_MILLIS_DEFAULT = 5000;
    private static final String SNAPSHOT_TIMEOUT_MILLIS_KEY = "hbase.snapshot.master.timeoutMillis";
    public static final String ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION = "online-snapshot";
    private static final int opThreads = 1;
    private boolean stopped;
    private final long wakeFrequency;
    private final MasterServices master;
    private final ProcedureCoordinator coordinator;
    private boolean isSnapshotSupported = false;
    private TakeSnapshotHandler handler;
    private final Path rootDir;
    private final ExecutorService executorService;
    private Map<String, SnapshotSentinel> restoreHandlers = new HashMap<String, SnapshotSentinel>();

    public SnapshotManager(MasterServices master) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        this.checkSnapshotSupport(master.getConfiguration(), master.getMasterFileSystem());
        Configuration conf = master.getConfiguration();
        this.wakeFrequency = conf.getInt(SNAPSHOT_WAKE_MILLIS_KEY, 500);
        long keepAliveTime = conf.getLong(SNAPSHOT_TIMEOUT_MILLIS_KEY, 5000L);
        String name = master.getServerName().toString();
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool(name, keepAliveTime, 1, this.wakeFrequency);
        ZKProcedureCoordinatorRpcs comms = new ZKProcedureCoordinatorRpcs(master.getZooKeeper(), ONLINE_SNAPSHOT_CONTROLLER_DESCRIPTION, name);
        this.coordinator = new ProcedureCoordinator(comms, tpool);
        this.executorService = master.getExecutorService();
        this.resetTempDir();
    }

    public SnapshotManager(MasterServices master, ProcedureCoordinator coordinator, ExecutorService pool) throws IOException, UnsupportedOperationException {
        this.master = master;
        this.rootDir = master.getMasterFileSystem().getRootDir();
        this.checkSnapshotSupport(master.getConfiguration(), master.getMasterFileSystem());
        this.wakeFrequency = master.getConfiguration().getInt(SNAPSHOT_WAKE_MILLIS_KEY, 500);
        this.coordinator = coordinator;
        this.executorService = pool;
        this.resetTempDir();
    }

    public List<HBaseProtos.SnapshotDescription> getCompletedSnapshots() throws IOException {
        return this.getCompletedSnapshots(SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HBaseProtos.SnapshotDescription> getCompletedSnapshots(Path snapshotDir) throws IOException {
        FileStatus[] snapshots;
        FileSystem fs;
        ArrayList<HBaseProtos.SnapshotDescription> snapshotDescs = new ArrayList<HBaseProtos.SnapshotDescription>();
        if (snapshotDir == null) {
            snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(this.rootDir);
        }
        if (!(fs = this.master.getMasterFileSystem().getFileSystem()).exists(snapshotDir)) {
            return snapshotDescs;
        }
        for (FileStatus snapshot : snapshots = fs.listStatus(snapshotDir, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs))) {
            Path info = new Path(snapshot.getPath(), ".snapshotinfo");
            if (!fs.exists(info)) {
                LOG.error((Object)("Snapshot information for " + snapshot.getPath() + " doesn't exist"));
                continue;
            }
            FSDataInputStream in = null;
            try {
                in = fs.open(info);
                HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.parseFrom((InputStream)in);
                snapshotDescs.add(desc);
            }
            catch (IOException e) {
                LOG.warn((Object)("Found a corrupted snapshot " + snapshot.getPath()), (Throwable)e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return snapshotDescs;
    }

    void resetTempDir() throws IOException {
        Path tmpdir = SnapshotDescriptionUtils.getWorkingSnapshotDir(this.rootDir);
        if (!this.master.getMasterFileSystem().getFileSystem().delete(tmpdir, true)) {
            LOG.warn((Object)("Couldn't delete working snapshot directory: " + tmpdir));
        }
    }

    public void deleteSnapshot(HBaseProtos.SnapshotDescription snapshot) throws SnapshotDoesNotExistException, IOException {
        MasterCoprocessorHost cpHost = this.master.getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preDeleteSnapshot(snapshot);
        }
        if (!this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotDoesNotExistException(snapshot);
        }
        String snapshotName = snapshot.getName();
        LOG.debug((Object)("Deleting snapshot: " + snapshotName));
        MasterFileSystem fs = this.master.getMasterFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, this.rootDir);
        if (!fs.getFileSystem().delete(snapshotDir, true)) {
            throw new HBaseSnapshotException("Failed to delete snapshot directory: " + snapshotDir);
        }
        if (cpHost != null) {
            cpHost.postDeleteSnapshot(snapshot);
        }
    }

    private synchronized TakeSnapshotHandler getTakeSnapshotHandler(HBaseProtos.SnapshotDescription snapshot) {
        TakeSnapshotHandler h = this.handler;
        if (h == null) {
            return null;
        }
        if (!h.getSnapshot().getName().equals(snapshot.getName())) {
            return null;
        }
        return h;
    }

    public boolean isSnapshotDone(HBaseProtos.SnapshotDescription expected) throws IOException {
        if (expected == null) {
            throw new UnknownSnapshotException("No snapshot name passed in request, can't figure out which snapshot you want to check.");
        }
        String ssString = SnapshotDescriptionUtils.toString(expected);
        TakeSnapshotHandler handler = this.getTakeSnapshotHandler(expected);
        if (handler == null) {
            if (!this.isSnapshotCompleted(expected)) {
                throw new UnknownSnapshotException("Snapshot " + ssString + " is not currently running or one of the known completed snapshots.");
            }
            return true;
        }
        try {
            handler.rethrowException();
        }
        catch (ForeignException e) {
            Procedure p = this.coordinator.getProcedure(expected.getName());
            String status = p != null ? p.getStatus() : expected.getName() + " not found in proclist " + this.coordinator.getProcedureNames();
            throw new HBaseSnapshotException("Snapshot " + ssString + " had an error.  " + status, e, expected);
        }
        if (handler.isFinished()) {
            LOG.debug((Object)("Snapshot '" + ssString + "' has completed, notifying client."));
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Snapshoting '" + ssString + "' is still in progress!"));
        }
        return false;
    }

    synchronized boolean isTakingSnapshot() throws SnapshotCreationException {
        return this.handler != null && !this.handler.isFinished();
    }

    private boolean isTakingSnapshot(String tableName) {
        if (this.handler != null && this.handler.getSnapshot().getTable().equals(tableName)) {
            return !this.handler.isFinished();
        }
        return false;
    }

    private synchronized void prepareToTakeSnapshot(HBaseProtos.SnapshotDescription snapshot) throws HBaseSnapshotException {
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir);
        if (this.isTakingSnapshot()) {
            throw new SnapshotCreationException("Rejected taking " + SnapshotDescriptionUtils.toString(snapshot) + " because we are already running another snapshot " + SnapshotDescriptionUtils.toString(this.handler.getSnapshot()), snapshot);
        }
        if (this.isRestoringTable(snapshot.getTable())) {
            throw new SnapshotCreationException("Rejected taking " + SnapshotDescriptionUtils.toString(snapshot) + " because we are already have a restore in progress on the same snapshot " + SnapshotDescriptionUtils.toString(this.handler.getSnapshot()), snapshot);
        }
        try {
            fs.delete(workingDir, true);
            if (!fs.mkdirs(workingDir)) {
                throw new SnapshotCreationException("Couldn't create working directory (" + workingDir + ") for snapshot", snapshot);
            }
        }
        catch (HBaseSnapshotException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Exception while checking to see if snapshot could be started.", e, snapshot);
        }
    }

    private synchronized void snapshotEnabledTable(HBaseProtos.SnapshotDescription snapshot) throws HBaseSnapshotException {
        try {
            EnabledTableSnapshotHandler handler = new EnabledTableSnapshotHandler(snapshot, this.master, this);
            this.executorService.submit(handler);
            this.handler = handler;
        }
        catch (IOException e) {
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir);
            try {
                if (!this.master.getMasterFileSystem().getFileSystem().delete(workingDir, true)) {
                    LOG.warn((Object)("Couldn't delete working directory (" + workingDir + " for snapshot:" + SnapshotDescriptionUtils.toString(snapshot)));
                }
            }
            catch (IOException e1) {
                LOG.warn((Object)("Couldn't delete working directory (" + workingDir + " for snapshot:" + SnapshotDescriptionUtils.toString(snapshot)));
            }
            throw new SnapshotCreationException("Could not build snapshot handler", e, snapshot);
        }
    }

    public void takeSnapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (this.isSnapshotCompleted(snapshot)) {
            throw new SnapshotExistsException("Snapshot '" + snapshot.getName() + "' already stored on the filesystem.", snapshot);
        }
        LOG.debug((Object)"No existing snapshot, attempting snapshot...");
        HTableDescriptor desc = null;
        try {
            desc = this.master.getTableDescriptors().get(snapshot.getTable());
        }
        catch (FileNotFoundException e) {
            String msg = "Table:" + snapshot.getTable() + " info doesn't exist!";
            LOG.error((Object)msg);
            throw new SnapshotCreationException(msg, e, snapshot);
        }
        catch (IOException e) {
            throw new SnapshotCreationException("Error while geting table description for table " + snapshot.getTable(), e, snapshot);
        }
        if (desc == null) {
            throw new SnapshotCreationException("Table '" + snapshot.getTable() + "' doesn't exist, can't take snapshot.", snapshot);
        }
        snapshot = snapshot.toBuilder().setVersion(0).build();
        MasterCoprocessorHost cpHost = this.master.getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preSnapshot(snapshot, desc);
        }
        this.prepareToTakeSnapshot(snapshot);
        AssignmentManager assignmentMgr = this.master.getAssignmentManager();
        if (assignmentMgr.getZKTable().isEnabledTable(snapshot.getTable())) {
            LOG.debug((Object)"Table enabled, starting distributed snapshot.");
            this.snapshotEnabledTable(snapshot);
            LOG.debug((Object)("Started snapshot: " + SnapshotDescriptionUtils.toString(snapshot)));
        } else if (assignmentMgr.getZKTable().isDisabledTable(snapshot.getTable())) {
            LOG.debug((Object)"Table is disabled, running snapshot entirely on master.");
            this.snapshotDisabledTable(snapshot);
            LOG.debug((Object)("Started snapshot: " + SnapshotDescriptionUtils.toString(snapshot)));
        } else {
            LOG.error((Object)("Can't snapshot table '" + snapshot.getTable() + "', isn't open or closed, we don't know what to do!"));
            TablePartiallyOpenException tpoe = new TablePartiallyOpenException(snapshot.getTable() + " isn't fully open.");
            throw new SnapshotCreationException("Table is not entirely open or closed", tpoe, snapshot);
        }
        if (cpHost != null) {
            cpHost.postSnapshot(snapshot, desc);
        }
    }

    private synchronized void snapshotDisabledTable(HBaseProtos.SnapshotDescription snapshot) throws HBaseSnapshotException {
        snapshot = snapshot.toBuilder().setType(HBaseProtos.SnapshotDescription.Type.DISABLED).build();
        try {
            DisabledTableSnapshotHandler handler = new DisabledTableSnapshotHandler(snapshot, this.master);
            this.executorService.submit(handler);
            this.handler = handler;
        }
        catch (IOException e) {
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, this.rootDir);
            try {
                if (!this.master.getMasterFileSystem().getFileSystem().delete(workingDir, true)) {
                    LOG.error((Object)("Couldn't delete working directory (" + workingDir + " for snapshot:" + SnapshotDescriptionUtils.toString(snapshot)));
                }
            }
            catch (IOException e1) {
                LOG.error((Object)("Couldn't delete working directory (" + workingDir + " for snapshot:" + SnapshotDescriptionUtils.toString(snapshot)));
            }
            throw new SnapshotCreationException("Could not build snapshot handler", e, snapshot);
        }
    }

    public synchronized void setSnapshotHandlerForTesting(TakeSnapshotHandler handler) {
        this.handler = handler;
    }

    ProcedureCoordinator getCoordinator() {
        return this.coordinator;
    }

    private boolean isSnapshotCompleted(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        try {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshot, this.rootDir);
            FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
            return fs.exists(snapshotDir);
        }
        catch (IllegalArgumentException iae) {
            throw new UnknownSnapshotException("Unexpected exception thrown", iae);
        }
    }

    synchronized void cloneSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws HBaseSnapshotException {
        String tableName = hTableDescriptor.getNameAsString();
        if (this.isTakingSnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            CloneSnapshotHandler handler = new CloneSnapshotHandler(this.master, snapshot, hTableDescriptor);
            this.executorService.submit(handler);
            this.restoreHandlers.put(tableName, handler);
        }
        catch (Exception e) {
            String msg = "Couldn't clone the snapshot=" + SnapshotDescriptionUtils.toString(snapshot) + " on table=" + tableName;
            LOG.error((Object)msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, e);
        }
    }

    public void restoreSnapshot(HBaseProtos.SnapshotDescription reqSnapshot) throws IOException {
        FileSystem fs = this.master.getMasterFileSystem().getFileSystem();
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(reqSnapshot, this.rootDir);
        MasterCoprocessorHost cpHost = this.master.getCoprocessorHost();
        if (!fs.exists(snapshotDir)) {
            LOG.error((Object)("A Snapshot named '" + reqSnapshot.getName() + "' does not exist."));
            throw new SnapshotDoesNotExistException(reqSnapshot);
        }
        HBaseProtos.SnapshotDescription fsSnapshot = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        HTableDescriptor snapshotTableDesc = FSTableDescriptors.getTableDescriptor(fs, snapshotDir);
        String tableName = reqSnapshot.getTable();
        this.cleanupRestoreSentinels();
        if (MetaReader.tableExists(this.master.getCatalogTracker(), tableName)) {
            if (this.master.getAssignmentManager().getZKTable().isEnabledTable(fsSnapshot.getTable())) {
                throw new UnsupportedOperationException("Table '" + fsSnapshot.getTable() + "' must be disabled in order to perform a restore operation.");
            }
            if (cpHost != null) {
                cpHost.preRestoreSnapshot(reqSnapshot, snapshotTableDesc);
            }
            this.restoreSnapshot(fsSnapshot, snapshotTableDesc);
            LOG.info((Object)("Restore snapshot=" + fsSnapshot.getName() + " as table=" + tableName));
            if (cpHost != null) {
                cpHost.postRestoreSnapshot(reqSnapshot, snapshotTableDesc);
            }
        } else {
            HTableDescriptor htd = RestoreSnapshotHelper.cloneTableSchema(snapshotTableDesc, Bytes.toBytes(tableName));
            if (cpHost != null) {
                cpHost.preCloneSnapshot(reqSnapshot, htd);
            }
            this.cloneSnapshot(fsSnapshot, htd);
            LOG.info((Object)("Clone snapshot=" + fsSnapshot.getName() + " as table=" + tableName));
            if (cpHost != null) {
                cpHost.postCloneSnapshot(reqSnapshot, htd);
            }
        }
    }

    private synchronized void restoreSnapshot(HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws HBaseSnapshotException {
        String tableName = hTableDescriptor.getNameAsString();
        if (this.isTakingSnapshot(tableName)) {
            throw new RestoreSnapshotException("Snapshot in progress on the restore table=" + tableName);
        }
        if (this.isRestoringTable(tableName)) {
            throw new RestoreSnapshotException("Restore already in progress on the table=" + tableName);
        }
        try {
            RestoreSnapshotHandler handler = new RestoreSnapshotHandler(this.master, snapshot, hTableDescriptor);
            this.executorService.submit(handler);
            this.restoreHandlers.put(hTableDescriptor.getNameAsString(), handler);
        }
        catch (Exception e) {
            String msg = "Couldn't restore the snapshot=" + SnapshotDescriptionUtils.toString(snapshot) + " on table=" + tableName;
            LOG.error((Object)msg, (Throwable)e);
            throw new RestoreSnapshotException(msg, e);
        }
    }

    private boolean isRestoringTable(String tableName) {
        SnapshotSentinel sentinel = this.restoreHandlers.get(tableName);
        return sentinel != null && !sentinel.isFinished();
    }

    public boolean isRestoringTable(HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (!this.isSnapshotCompleted(snapshot)) {
            throw new UnknownSnapshotException("Snapshot:" + snapshot.getName() + " is not one of the known completed snapshots.");
        }
        SnapshotSentinel sentinel = this.getRestoreSnapshotSentinel(snapshot.getTable());
        if (sentinel == null) {
            return false;
        }
        if (!sentinel.getSnapshot().getName().equals(snapshot.getName())) {
            return false;
        }
        LOG.debug((Object)("Verify snapshot=" + snapshot.getName() + " against=" + sentinel.getSnapshot().getName() + " table=" + snapshot.getTable()));
        ForeignException e = sentinel.getExceptionIfFailed();
        if (e != null) {
            throw e;
        }
        if (sentinel.isFinished()) {
            LOG.debug((Object)("Restore snapshot=" + SnapshotDescriptionUtils.toString(snapshot) + " has completed. Notifying the client."));
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sentinel is not yet finished with restoring snapshot=" + SnapshotDescriptionUtils.toString(snapshot)));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SnapshotSentinel getRestoreSnapshotSentinel(String tableName) {
        try {
            SnapshotSentinel snapshotSentinel = this.restoreHandlers.get(tableName);
            return snapshotSentinel;
        }
        finally {
            this.cleanupRestoreSentinels();
        }
    }

    private synchronized void cleanupRestoreSentinels() {
        Iterator<Map.Entry<String, SnapshotSentinel>> it = this.restoreHandlers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SnapshotSentinel> entry = it.next();
            SnapshotSentinel sentinel = entry.getValue();
            if (!sentinel.isFinished()) continue;
            it.remove();
        }
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.handler != null) {
            this.handler.cancel(why);
        }
        for (SnapshotSentinel restoreHandler : this.restoreHandlers.values()) {
            restoreHandler.cancel(why);
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public void checkSnapshotSupport() throws UnsupportedOperationException {
        if (!this.isSnapshotSupported) {
            throw new UnsupportedOperationException("To use snapshots, You must add to the hbase-site.xml of the HBase Master: 'hbase.snapshot.enabled' property with value 'true'.");
        }
    }

    private void checkSnapshotSupport(Configuration conf, MasterFileSystem mfs) throws IOException, UnsupportedOperationException {
        String enabled = conf.get(HBASE_SNAPSHOT_ENABLED);
        boolean snapshotEnabled = conf.getBoolean(HBASE_SNAPSHOT_ENABLED, false);
        boolean userDisabled = enabled != null && enabled.trim().length() > 0 && !snapshotEnabled;
        HashSet<String> hfileCleaners = new HashSet<String>();
        String[] cleaners = conf.getStrings("hbase.master.hfilecleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(hfileCleaners, cleaners);
        }
        HashSet<String> logCleaners = new HashSet<String>();
        cleaners = conf.getStrings("hbase.master.logcleaner.plugins");
        if (cleaners != null) {
            Collections.addAll(logCleaners, cleaners);
        }
        Path oldSnapshotDir = new Path(mfs.getRootDir(), ".snapshot");
        FileSystem fs = mfs.getFileSystem();
        List<HBaseProtos.SnapshotDescription> ss = this.getCompletedSnapshots(new Path(this.rootDir, oldSnapshotDir));
        if (ss != null && !ss.isEmpty()) {
            LOG.error((Object)("Snapshots from an earlier release were found under: " + oldSnapshotDir));
            LOG.error((Object)"Please rename the directory as .hbase-snapshot");
        }
        if (snapshotEnabled) {
            hfileCleaners.add(SnapshotHFileCleaner.class.getName());
            hfileCleaners.add(HFileLinkCleaner.class.getName());
            logCleaners.add(SnapshotLogCleaner.class.getName());
            conf.setStrings("hbase.master.hfilecleaner.plugins", hfileCleaners.toArray(new String[hfileCleaners.size()]));
            conf.setStrings("hbase.master.logcleaner.plugins", logCleaners.toArray(new String[logCleaners.size()]));
        } else {
            boolean bl = snapshotEnabled = logCleaners.contains(SnapshotLogCleaner.class.getName()) && hfileCleaners.contains(SnapshotHFileCleaner.class.getName()) && hfileCleaners.contains(HFileLinkCleaner.class.getName());
            if (snapshotEnabled) {
                LOG.warn((Object)("Snapshot log and hfile cleaners are present in the configuration, but the 'hbase.snapshot.enabled' property " + (userDisabled ? "is set to 'false'." : "is not set.")));
            }
        }
        boolean bl = this.isSnapshotSupported = snapshotEnabled && !userDisabled;
        if (!snapshotEnabled) {
            FileStatus[] snapshots;
            LOG.info((Object)"Snapshot feature is not enabled, missing log and hfile cleaners.");
            Path snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(mfs.getRootDir());
            if (fs.exists(snapshotDir) && (snapshots = FSUtils.listStatus(fs, snapshotDir, new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(fs))) != null) {
                LOG.error((Object)"Snapshots are present, but cleaners are not enabled.");
                this.checkSnapshotSupport();
            }
        }
    }
}

