/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinatorRpcs;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ProcedureCoordinator {
    private static final Log LOG = LogFactory.getLog(ProcedureCoordinator.class);
    static final long TIMEOUT_MILLIS_DEFAULT = 60000L;
    static final long WAKE_MILLIS_DEFAULT = 500L;
    private final ProcedureCoordinatorRpcs rpcs;
    private final ExecutorService pool;
    private final ConcurrentMap<String, Procedure> procedures = new MapMaker().concurrencyLevel(4).weakValues().makeMap();

    public ProcedureCoordinator(ProcedureCoordinatorRpcs rpcs, ThreadPoolExecutor pool) {
        this.rpcs = rpcs;
        this.pool = pool;
        this.rpcs.start(this);
    }

    public static ThreadPoolExecutor defaultPool(String coordName, long keepAliveTime, int opThreads, long wakeFrequency) {
        return new ThreadPoolExecutor(1, opThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory("(" + coordName + ")-proc-coordinator-pool"));
    }

    public void close() throws IOException {
        this.pool.shutdownNow();
        this.rpcs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean submitProcedure(Procedure proc) {
        Object oldProc;
        if (proc == null) {
            return false;
        }
        String procName = proc.getName();
        ConcurrentMap<String, Procedure> concurrentMap = this.procedures;
        synchronized (concurrentMap) {
            oldProc = (Procedure)this.procedures.get(procName);
            if (oldProc != null) {
                if (((Procedure)oldProc).completedLatch.getCount() != 0L) {
                    LOG.warn((Object)("Procedure " + procName + " currently running.  Rejecting new request"));
                    return false;
                }
                LOG.debug((Object)("Procedure " + procName + " was in running list but was completed.  Accepting new attempt."));
                this.procedures.remove(procName);
            }
        }
        Future<Void> f = null;
        try {
            oldProc = this.procedures;
            synchronized (oldProc) {
                f = this.pool.submit(proc);
                this.procedures.put(procName, proc);
            }
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.warn((Object)("Procedure " + procName + " rejected by execution pool.  Propagating error and " + "cancelling operation."), (Throwable)e);
            proc.receive(new ForeignException(procName, e));
            if (f != null) {
                f.cancel(true);
            }
            return false;
        }
    }

    void rpcConnectionFailure(String message, IOException cause) {
        Collection toNotify = this.procedures.values();
        for (Procedure proc : toNotify) {
            if (proc == null) continue;
            proc.receive(new ForeignException(proc.getName(), cause));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortProcedure(String procName, ForeignException reason) {
        ConcurrentMap<String, Procedure> concurrentMap = this.procedures;
        synchronized (concurrentMap) {
            Procedure proc = (Procedure)this.procedures.get(procName);
            if (proc == null) {
                return;
            }
            proc.receive(reason);
        }
    }

    Procedure createProcedure(ForeignExceptionDispatcher fed, String procName, byte[] procArgs, List<String> expectedMembers) {
        return new Procedure(this, fed, 500L, 60000L, procName, procArgs, expectedMembers);
    }

    public Procedure startProcedure(ForeignExceptionDispatcher fed, String procName, byte[] procArgs, List<String> expectedMembers) throws RejectedExecutionException {
        Procedure proc = this.createProcedure(fed, procName, procArgs, expectedMembers);
        if (!this.submitProcedure(proc)) {
            LOG.error((Object)("Failed to submit procedure '" + procName + "'"));
            return null;
        }
        return proc;
    }

    void memberAcquiredBarrier(String procName, String member) {
        Procedure proc = (Procedure)this.procedures.get(procName);
        if (proc != null) {
            proc.barrierAcquiredByMember(member);
        }
    }

    void memberFinishedBarrier(String procName, String member) {
        Procedure proc = (Procedure)this.procedures.get(procName);
        if (proc != null) {
            proc.barrierReleasedByMember(member);
        }
    }

    ProcedureCoordinatorRpcs getRpcs() {
        return this.rpcs;
    }

    public Procedure getProcedure(String name) {
        return (Procedure)this.procedures.get(name);
    }

    public Set<String> getProcedureNames() {
        return new HashSet<String>(this.procedures.keySet());
    }
}

