/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.Syncable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.HLogPrettyPrinter;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class HLog
implements Syncable {
    static final Log LOG;
    public static final byte[] METAFAMILY;
    static final byte[] METAROW;
    public static final String SPLITTING_EXT = "-splitting";
    public static final boolean SPLIT_SKIP_ERRORS_DEFAULT = false;
    public static final String META_HLOG_FILE_EXTN = ".meta";
    public static final String SEPARATE_HLOG_FOR_META = "hbase.regionserver.separate.hlog.for.meta";
    public static final String RECOVERED_EDITS_DIR = "recovered.edits";
    private static final Pattern EDITFILES_NAME_PATTERN;
    public static final String RECOVERED_LOG_TMPFILE_SUFFIX = ".temp";
    private final FileSystem fs;
    private final Path dir;
    private final Configuration conf;
    private List<WALActionsListener> listeners = new CopyOnWriteArrayList<WALActionsListener>();
    private final long optionalFlushInterval;
    private final long blocksize;
    private final String prefix;
    private final AtomicLong unflushedEntries = new AtomicLong(0L);
    private volatile long syncedTillHere = 0L;
    private long lastDeferredTxid;
    private final Path oldLogDir;
    private volatile boolean logRollRunning;
    private static Class<? extends Writer> logWriterClass;
    private static Class<? extends Reader> logReaderClass;
    private WALCoprocessorHost coprocessorHost;
    private FSDataOutputStream hdfs_out;
    private int minTolerableReplication;
    private Method getNumCurrentReplicas;
    static final Object[] NO_ARGS;
    Writer writer;
    final SortedMap<Long, Path> outputfiles = Collections.synchronizedSortedMap(new TreeMap());
    private final ConcurrentSkipListMap<byte[], Long> lastSeqWritten = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private volatile boolean closed = false;
    private final AtomicLong logSeqNum = new AtomicLong(0L);
    private boolean forMeta = false;
    private volatile long filenum = -1L;
    private final AtomicInteger numEntries = new AtomicInteger(0);
    private volatile int consecutiveLogRolls = 0;
    private final int lowReplicationRollLimit;
    private volatile boolean lowReplicationRollEnabled = true;
    private final long logrollsize;
    private final Lock cacheFlushLock = new ReentrantLock();
    private final Object updateLock = new Object();
    private final Object flushLock = new Object();
    private final boolean enabled;
    private final int maxLogs;
    private final LogSyncer logSyncer;
    private final int closeErrorsTolerated;
    private final AtomicInteger closeErrorCount = new AtomicInteger();
    private static final Pattern pattern;
    static byte[] COMPLETE_CACHE_FLUSH;
    private static Metric writeTime;
    private static Metric writeSize;
    private static Metric syncTime;
    private static AtomicLong slowHLogAppendCount;
    private static Metric slowHLogAppendTime;
    public static final long FIXED_OVERHEAD;

    static void resetLogReaderClass() {
        logReaderClass = null;
    }

    public static Metric getWriteTime() {
        return writeTime.get();
    }

    public static Metric getWriteSize() {
        return writeSize.get();
    }

    public static Metric getSyncTime() {
        return syncTime.get();
    }

    public static long getSlowAppendCount() {
        return slowHLogAppendCount.get();
    }

    public static Metric getSlowAppendTime() {
        return slowHLogAppendTime.get();
    }

    public HLog(FileSystem fs, Path dir, Path oldLogDir, Configuration conf) throws IOException {
        this(fs, dir, oldLogDir, conf, null, true, null, false);
    }

    public HLog(FileSystem fs, Path dir, Path oldLogDir, Configuration conf, List<WALActionsListener> listeners, String prefix) throws IOException {
        this(fs, dir, oldLogDir, conf, listeners, true, prefix, false);
    }

    public HLog(FileSystem fs, Path dir, Path oldLogDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfLogDirExists, String prefix, boolean forMeta) throws IOException {
        this.fs = fs;
        this.dir = dir;
        this.conf = conf;
        if (listeners != null) {
            for (WALActionsListener i : listeners) {
                this.registerWALActionsListener(i);
            }
        }
        this.blocksize = conf.getLong("hbase.regionserver.hlog.blocksize", this.getDefaultBlockSize());
        float multi = conf.getFloat("hbase.regionserver.logroll.multiplier", 0.95f);
        this.logrollsize = (long)((float)this.blocksize * multi);
        this.optionalFlushInterval = conf.getLong("hbase.regionserver.optionallogflushinterval", 1000L);
        boolean dirExists = false;
        if (failIfLogDirExists && (dirExists = this.fs.exists(dir))) {
            throw new IOException("Target HLog directory already exists: " + dir);
        }
        if (!dirExists && !fs.mkdirs(dir)) {
            throw new IOException("Unable to mkdir " + dir);
        }
        this.oldLogDir = oldLogDir;
        if (!fs.exists(oldLogDir) && !fs.mkdirs(this.oldLogDir)) {
            throw new IOException("Unable to mkdir " + this.oldLogDir);
        }
        this.forMeta = forMeta;
        this.maxLogs = conf.getInt("hbase.regionserver.maxlogs", 32);
        this.minTolerableReplication = conf.getInt("hbase.regionserver.hlog.tolerable.lowreplication", (int)this.fs.getDefaultReplication());
        this.lowReplicationRollLimit = conf.getInt("hbase.regionserver.hlog.lowreplication.rolllimit", 5);
        this.enabled = conf.getBoolean("hbase.regionserver.hlog.enabled", true);
        this.closeErrorsTolerated = conf.getInt("hbase.regionserver.logroll.errors.tolerated", 0);
        LOG.info((Object)("HLog configuration: blocksize=" + StringUtils.byteDesc((long)this.blocksize) + ", rollsize=" + StringUtils.byteDesc((long)this.logrollsize) + ", enabled=" + this.enabled + ", optionallogflushinternal=" + this.optionalFlushInterval + "ms"));
        this.prefix = prefix == null || prefix.isEmpty() ? "hlog" : URLEncoder.encode(prefix, "UTF8");
        this.rollWriter();
        this.getNumCurrentReplicas = this.getGetNumCurrentReplicas(this.hdfs_out);
        this.logSyncer = new LogSyncer(this.optionalFlushInterval);
        if (this.optionalFlushInterval > 0L) {
            Threads.setDaemonThreadRunning(this.logSyncer.getThread(), Thread.currentThread().getName() + ".logSyncer");
        } else {
            LOG.info((Object)("hbase.regionserver.optionallogflushinterval is set as " + this.optionalFlushInterval + ". Deferred log syncing won't work. " + "Any Mutation, marked to be deferred synced, will be flushed immediately."));
        }
        this.coprocessorHost = new WALCoprocessorHost(this, conf);
    }

    private long getDefaultBlockSize() throws IOException {
        Method m = null;
        Class<?> cls = this.fs.getClass();
        try {
            m = cls.getMethod("getDefaultBlockSize", Path.class);
        }
        catch (NoSuchMethodException e) {
            LOG.info((Object)"FileSystem doesn't support getDefaultBlockSize");
        }
        catch (SecurityException e) {
            LOG.info((Object)"Doesn't have access to getDefaultBlockSize on FileSystems", (Throwable)e);
            m = null;
        }
        if (null == m) {
            return this.fs.getDefaultBlockSize();
        }
        try {
            Object ret = m.invoke((Object)this.fs, this.dir);
            return (Long)ret;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Method getGetNumCurrentReplicas(FSDataOutputStream os) {
        Method m = null;
        if (os != null) {
            Class<?> wrappedStreamClass = os.getWrappedStream().getClass();
            try {
                m = wrappedStreamClass.getDeclaredMethod("getNumCurrentReplicas", new Class[0]);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.info((Object)("FileSystem's output stream doesn't support getNumCurrentReplicas; --HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()));
            }
            catch (SecurityException e) {
                LOG.info((Object)("Doesn't have access to getNumCurrentReplicas on FileSystems's output stream --HDFS-826 not available; fsOut=" + wrappedStreamClass.getName()), (Throwable)e);
                m = null;
            }
        }
        if (m != null) {
            LOG.info((Object)"Using getNumCurrentReplicas--HDFS-826");
        }
        return m;
    }

    public void registerWALActionsListener(WALActionsListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterWALActionsListener(WALActionsListener listener) {
        return this.listeners.remove(listener);
    }

    public long getFilenum() {
        return this.filenum;
    }

    public void setSequenceNumber(long newvalue) {
        long id = this.logSeqNum.get();
        while (id < newvalue && !this.logSeqNum.compareAndSet(id, newvalue)) {
            LOG.debug((Object)("Changed sequenceid from " + this.logSeqNum + " to " + newvalue));
            id = this.logSeqNum.get();
        }
    }

    public long getSequenceNumber() {
        return this.logSeqNum.get();
    }

    OutputStream getOutputStream() {
        return this.hdfs_out.getWrappedStream();
    }

    public byte[][] rollWriter() throws FailedLogCloseException, IOException {
        return this.rollWriter(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
        if (!force && this.writer != null && this.numEntries.get() <= 0) {
            return null;
        }
        byte[][] regionsToFlush = null;
        this.cacheFlushLock.lock();
        this.logRollRunning = true;
        try {
            if (this.closed) {
                LOG.debug((Object)"HLog closed.  Skipping rolling of writer");
                byte[][] byArray = regionsToFlush;
                return byArray;
            }
            long currentFilenum = this.filenum;
            Path oldPath = null;
            if (currentFilenum > 0L) {
                oldPath = this.computeFilename(currentFilenum);
            }
            this.filenum = System.currentTimeMillis();
            Path newPath = this.computeFilename();
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener i : this.listeners) {
                    i.preLogRoll(oldPath, newPath);
                }
            }
            Writer nextWriter = this.createWriterInstance(this.fs, newPath, this.conf);
            FSDataOutputStream nextHdfsOut = null;
            if (nextWriter instanceof SequenceFileLogWriter) {
                nextHdfsOut = ((SequenceFileLogWriter)nextWriter).getWriterFSDataOutputStream();
            }
            Object object = this.updateLock;
            synchronized (object) {
                Path path = this.cleanupCurrentWriter(currentFilenum);
                this.writer = nextWriter;
                this.hdfs_out = nextHdfsOut;
                LOG.info((Object)((path != null ? "Roll " + FSUtils.getPath(path) + ", entries=" + this.numEntries.get() + ", filesize=" + this.fs.getFileStatus(path).getLen() + ". " : "") + " for " + FSUtils.getPath(newPath)));
                this.numEntries.set(0);
            }
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener wALActionsListener : this.listeners) {
                    wALActionsListener.postLogRoll(oldPath, newPath);
                }
            }
            if (this.outputfiles.size() > 0) {
                if (this.lastSeqWritten.isEmpty()) {
                    LOG.debug((Object)"Last sequenceid written is empty. Deleting all old hlogs");
                    for (Map.Entry entry : this.outputfiles.entrySet()) {
                        this.archiveLogFile((Path)entry.getValue(), (Long)entry.getKey());
                    }
                    this.outputfiles.clear();
                } else {
                    regionsToFlush = this.cleanOldLogs();
                }
            }
        }
        finally {
            this.logRollRunning = false;
            this.cacheFlushLock.unlock();
        }
        return regionsToFlush;
    }

    protected Writer createWriterInstance(FileSystem fs, Path path, Configuration conf) throws IOException {
        if (this.forMeta) {
            // empty if block
        }
        return HLog.createWriter(fs, path, conf);
    }

    public static Reader getReader(FileSystem fs, Path path, Configuration conf) throws IOException {
        try {
            if (logReaderClass == null) {
                logReaderClass = conf.getClass("hbase.regionserver.hlog.reader.impl", SequenceFileLogReader.class, Reader.class);
            }
            Reader reader = logReaderClass.newInstance();
            reader.init(fs, path, conf);
            return reader;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Cannot get log reader", e);
        }
    }

    public static Writer createWriter(FileSystem fs, Path path, Configuration conf) throws IOException {
        try {
            if (logWriterClass == null) {
                logWriterClass = conf.getClass("hbase.regionserver.hlog.writer.impl", SequenceFileLogWriter.class, Writer.class);
            }
            Writer writer = logWriterClass.newInstance();
            writer.init(fs, path, conf);
            return writer;
        }
        catch (Exception e) {
            throw new IOException("cannot get log writer", e);
        }
    }

    private byte[][] cleanOldLogs() throws IOException {
        int logCount;
        Long oldestOutstandingSeqNum = this.getOldestOutstandingSeqNum();
        TreeSet<Long> sequenceNumbers = new TreeSet<Long>(this.outputfiles.headMap((long)oldestOutstandingSeqNum).keySet());
        int logsToRemove = sequenceNumbers.size();
        if (logsToRemove > 0) {
            if (LOG.isDebugEnabled()) {
                byte[] oldestRegion = this.getOldestRegion(oldestOutstandingSeqNum);
                LOG.debug((Object)("Found " + logsToRemove + " hlogs to remove" + " out of total " + this.outputfiles.size() + ";" + " oldest outstanding sequenceid is " + oldestOutstandingSeqNum + " from region " + Bytes.toStringBinary(oldestRegion)));
            }
            for (Long seq : sequenceNumbers) {
                this.archiveLogFile((Path)this.outputfiles.remove(seq), seq);
            }
        }
        byte[][] regions = null;
        int n = logCount = this.outputfiles == null ? 0 : this.outputfiles.size();
        if (logCount > this.maxLogs && logCount > 0 && (regions = HLog.findMemstoresWithEditsEqualOrOlderThan(this.outputfiles.firstKey(), this.lastSeqWritten)) != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < regions.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Bytes.toStringBinary(regions[i]));
            }
            LOG.info((Object)("Too many hlogs: logs=" + logCount + ", maxlogs=" + this.maxLogs + "; forcing flush of " + regions.length + " regions(s): " + sb.toString()));
        }
        return regions;
    }

    static byte[][] findMemstoresWithEditsEqualOrOlderThan(long oldestWALseqid, Map<byte[], Long> regionsToSeqids) {
        ArrayList<byte[]> regions = null;
        for (Map.Entry<byte[], Long> e : regionsToSeqids.entrySet()) {
            if (e.getValue() > oldestWALseqid) continue;
            if (regions == null) {
                regions = new ArrayList<byte[]>();
            }
            regions.add(e.getKey());
        }
        return regions == null ? (byte[][])null : (byte[][])regions.toArray((T[])new byte[][]{HConstants.EMPTY_BYTE_ARRAY});
    }

    private Long getOldestOutstandingSeqNum() {
        return Collections.min(this.lastSeqWritten.values());
    }

    private byte[] getOldestRegion(Long oldestOutstandingSeqNum) {
        byte[] oldestRegion = null;
        for (Map.Entry<byte[], Long> e : this.lastSeqWritten.entrySet()) {
            if (e.getValue().longValue() != oldestOutstandingSeqNum.longValue()) continue;
            oldestRegion = e.getKey();
            break;
        }
        return oldestRegion;
    }

    Path cleanupCurrentWriter(long currentfilenum) throws IOException {
        Path oldFile = null;
        if (this.writer != null) {
            try {
                if (this.unflushedEntries.get() != this.syncedTillHere) {
                    LOG.debug((Object)("cleanupCurrentWriter  waiting for transactions to get synced  total " + this.unflushedEntries.get() + " synced till here " + this.syncedTillHere));
                    this.sync();
                }
                this.writer.close();
                this.writer = null;
                this.closeErrorCount.set(0);
            }
            catch (IOException e) {
                LOG.error((Object)"Failed close of HLog writer", (Throwable)e);
                int errors = this.closeErrorCount.incrementAndGet();
                if (errors <= this.closeErrorsTolerated && !this.hasDeferredEntries()) {
                    LOG.warn((Object)("Riding over HLog close failure! error count=" + errors));
                }
                if (this.hasDeferredEntries()) {
                    LOG.error((Object)"Aborting due to unflushed edits in HLog");
                }
                FailedLogCloseException flce = new FailedLogCloseException("#" + currentfilenum);
                flce.initCause(e);
                throw flce;
            }
            if (currentfilenum >= 0L) {
                oldFile = this.computeFilename(currentfilenum);
                this.outputfiles.put(this.logSeqNum.get(), oldFile);
            }
        }
        return oldFile;
    }

    private void archiveLogFile(Path p, Long seqno) throws IOException {
        Path newPath = HLog.getHLogArchivePath(this.oldLogDir, p);
        LOG.info((Object)("moving old hlog file " + FSUtils.getPath(p) + " whose highest sequenceid is " + seqno + " to " + FSUtils.getPath(newPath)));
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.preLogArchive(p, newPath);
            }
        }
        if (!this.fs.rename(p, newPath)) {
            throw new IOException("Unable to rename " + p + " to " + newPath);
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(p, newPath);
            }
        }
    }

    protected Path computeFilename() {
        return this.computeFilename(this.filenum);
    }

    protected Path computeFilename(long filenum) {
        if (filenum < 0L) {
            throw new RuntimeException("hlog file number can't be < 0");
        }
        String child = this.prefix + "." + filenum;
        if (this.forMeta) {
            child = child + META_HLOG_FILE_EXTN;
        }
        return new Path(this.dir, child);
    }

    public static boolean isMetaFile(Path p) {
        return p.getName().endsWith(META_HLOG_FILE_EXTN);
    }

    public void closeAndDelete() throws IOException {
        FileStatus[] files;
        this.close();
        if (!this.fs.exists(this.dir)) {
            return;
        }
        for (FileStatus file : files = this.fs.listStatus(this.dir)) {
            Path p = HLog.getHLogArchivePath(this.oldLogDir, file.getPath());
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener i : this.listeners) {
                    i.preLogArchive(file.getPath(), p);
                }
            }
            if (!this.fs.rename(file.getPath(), p)) {
                throw new IOException("Unable to rename " + file.getPath() + " to " + p);
            }
            if (this.listeners.isEmpty()) continue;
            for (WALActionsListener i : this.listeners) {
                i.postLogArchive(file.getPath(), p);
            }
        }
        LOG.debug((Object)("Moved " + files.length + " log files to " + FSUtils.getPath(this.oldLogDir)));
        if (!this.fs.delete(this.dir, true)) {
            LOG.info((Object)("Unable to delete " + this.dir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.optionalFlushInterval > 0L) {
            try {
                this.logSyncer.close();
                this.logSyncer.join(this.optionalFlushInterval * 2L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Exception while waiting for syncer thread to die", (Throwable)e);
            }
        }
        this.cacheFlushLock.lock();
        try {
            if (!this.listeners.isEmpty()) {
                for (WALActionsListener i : this.listeners) {
                    i.logCloseRequested();
                }
            }
            Object object = this.updateLock;
            synchronized (object) {
                this.closed = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing hlog writer in " + this.dir.toString()));
                }
                if (this.writer != null) {
                    this.writer.close();
                }
            }
        }
        finally {
            this.cacheFlushLock.unlock();
        }
    }

    protected HLogKey makeKey(byte[] regionName, byte[] tableName, long seqnum, long now, UUID clusterId) {
        return new HLogKey(regionName, tableName, seqnum, now, clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long append(HRegionInfo regionInfo, HLogKey logKey, WALEdit logEdit, HTableDescriptor htd, boolean doSync) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        long txid = 0L;
        Object object = this.updateLock;
        synchronized (object) {
            long seqNum = this.obtainSeqNum();
            logKey.setLogSeqNum(seqNum);
            this.lastSeqWritten.putIfAbsent(regionInfo.getEncodedNameAsBytes(), seqNum);
            this.doWrite(regionInfo, logKey, logEdit, htd);
            txid = this.unflushedEntries.incrementAndGet();
            this.numEntries.incrementAndGet();
            if (htd.isDeferredLogFlush()) {
                this.lastDeferredTxid = txid;
            }
        }
        if (doSync && (regionInfo.isMetaRegion() || !htd.isDeferredLogFlush())) {
            this.sync(txid);
        }
        return txid;
    }

    public void append(HRegionInfo info, byte[] tableName, WALEdit edits, long now, HTableDescriptor htd) throws IOException {
        this.append(info, tableName, edits, HConstants.DEFAULT_CLUSTER_ID, now, htd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long append(HRegionInfo info, byte[] tableName, WALEdit edits, UUID clusterId, long now, HTableDescriptor htd, boolean doSync) throws IOException {
        if (edits.isEmpty()) {
            return this.unflushedEntries.get();
        }
        if (this.closed) {
            throw new IOException("Cannot append; log is closed");
        }
        long txid = 0L;
        Object object = this.updateLock;
        synchronized (object) {
            long seqNum = this.obtainSeqNum();
            byte[] encodedRegionName = info.getEncodedNameAsBytes();
            this.lastSeqWritten.putIfAbsent(encodedRegionName, seqNum);
            HLogKey logKey = this.makeKey(encodedRegionName, tableName, seqNum, now, clusterId);
            this.doWrite(info, logKey, edits, htd);
            this.numEntries.incrementAndGet();
            txid = this.unflushedEntries.incrementAndGet();
            if (htd.isDeferredLogFlush()) {
                this.lastDeferredTxid = txid;
            }
        }
        if (doSync && (info.isMetaRegion() || !htd.isDeferredLogFlush())) {
            this.sync(txid);
        }
        return txid;
    }

    public long appendNoSync(HRegionInfo info, byte[] tableName, WALEdit edits, UUID clusterId, long now, HTableDescriptor htd) throws IOException {
        return this.append(info, tableName, edits, clusterId, now, htd, false);
    }

    public long append(HRegionInfo info, byte[] tableName, WALEdit edits, UUID clusterId, long now, HTableDescriptor htd) throws IOException {
        return this.append(info, tableName, edits, clusterId, now, htd, true);
    }

    private void syncer() throws IOException {
        this.syncer(this.unflushedEntries.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncer(long txid) throws IOException {
        block29: {
            Writer tempWriter;
            Object object = this.updateLock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                tempWriter = this.writer;
            }
            if (txid <= this.syncedTillHere) {
                return;
            }
            try {
                Object object2;
                long doneUpto;
                long now = System.currentTimeMillis();
                IOException ioe = null;
                List<Entry> pending = null;
                Object object3 = this.flushLock;
                synchronized (object3) {
                    if (txid <= this.syncedTillHere) {
                        return;
                    }
                    doneUpto = this.unflushedEntries.get();
                    pending = this.logSyncer.getPendingWrites();
                    try {
                        this.logSyncer.hlogFlush(tempWriter, pending);
                    }
                    catch (IOException io) {
                        ioe = io;
                        LOG.error((Object)("syncer encountered error, will retry. txid=" + txid), (Throwable)ioe);
                    }
                }
                if (ioe != null && pending != null) {
                    object3 = this.updateLock;
                    synchronized (object3) {
                        object2 = this.flushLock;
                        synchronized (object2) {
                            tempWriter = this.writer;
                            this.logSyncer.hlogFlush(tempWriter, pending);
                        }
                    }
                }
                if (txid <= this.syncedTillHere) {
                    return;
                }
                try {
                    tempWriter.sync();
                }
                catch (IOException io) {
                    object2 = this.updateLock;
                    synchronized (object2) {
                        tempWriter = this.writer;
                        tempWriter.sync();
                    }
                }
                this.syncedTillHere = Math.max(this.syncedTillHere, doneUpto);
                syncTime.inc(System.currentTimeMillis() - now);
                if (this.logRollRunning) break block29;
                this.checkLowReplication();
                try {
                    if (tempWriter.getLength() > this.logrollsize) {
                        this.requestLogRoll();
                    }
                }
                catch (IOException x) {
                    LOG.debug((Object)"Log roll failed and will be retried. (This is not an error)");
                }
            }
            catch (IOException e) {
                LOG.fatal((Object)"Could not sync. Requesting close of hlog", (Throwable)e);
                this.requestLogRoll();
                throw e;
            }
        }
    }

    private void checkLowReplication() {
        try {
            int numCurrentReplicas = this.getLogReplication();
            if (numCurrentReplicas != 0 && numCurrentReplicas < this.minTolerableReplication) {
                if (this.lowReplicationRollEnabled) {
                    if (this.consecutiveLogRolls < this.lowReplicationRollLimit) {
                        LOG.warn((Object)("HDFS pipeline error detected. Found " + numCurrentReplicas + " replicas but expecting no less than " + this.minTolerableReplication + " replicas. " + " Requesting close of hlog."));
                        this.requestLogRoll();
                        ++this.consecutiveLogRolls;
                    } else {
                        LOG.warn((Object)"Too many consecutive RollWriter requests, it's a sign of the total number of live datanodes is lower than the tolerable replicas.");
                        this.consecutiveLogRolls = 0;
                        this.lowReplicationRollEnabled = false;
                    }
                }
            } else if (numCurrentReplicas >= this.minTolerableReplication && !this.lowReplicationRollEnabled) {
                if (this.numEntries.get() <= 1) {
                    return;
                }
                this.lowReplicationRollEnabled = true;
                LOG.info((Object)"LowReplication-Roller was enabled.");
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to invoke DFSOutputStream.getNumCurrentReplicas" + e + " still proceeding ahead..."));
        }
    }

    int getLogReplication() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object repl;
        if (this.getNumCurrentReplicas != null && this.hdfs_out != null && (repl = this.getNumCurrentReplicas.invoke((Object)this.getOutputStream(), NO_ARGS)) instanceof Integer) {
            return (Integer)repl;
        }
        return 0;
    }

    boolean canGetCurReplicas() {
        return this.getNumCurrentReplicas != null;
    }

    public void hsync() throws IOException {
        this.syncer();
    }

    public void hflush() throws IOException {
        this.syncer();
    }

    public void sync() throws IOException {
        this.syncer();
    }

    public void sync(long txid) throws IOException {
        this.syncer(txid);
    }

    private void requestLogRoll() {
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.logRollRequested();
            }
        }
    }

    protected void doWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit, HTableDescriptor htd) throws IOException {
        if (!this.enabled) {
            return;
        }
        if (!this.listeners.isEmpty()) {
            for (WALActionsListener i : this.listeners) {
                i.visitLogEntryBeforeWrite(htd, logKey, logEdit);
            }
        }
        try {
            long now = System.currentTimeMillis();
            if (!this.coprocessorHost.preWALWrite(info, logKey, logEdit)) {
                this.logSyncer.append(new Entry(logKey, logEdit));
            }
            long took = System.currentTimeMillis() - now;
            this.coprocessorHost.postWALWrite(info, logKey, logEdit);
            writeTime.inc(took);
            long len = 0L;
            for (KeyValue kv : logEdit.getKeyValues()) {
                len += (long)kv.getLength();
            }
            writeSize.inc(len);
            if (took > 1000L) {
                LOG.warn((Object)String.format("%s took %d ms appending an edit to hlog; editcount=%d, len~=%s", Thread.currentThread().getName(), took, this.numEntries.get(), StringUtils.humanReadableInt((long)len)));
                slowHLogAppendCount.incrementAndGet();
                slowHLogAppendTime.inc(took);
            }
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not append. Requesting close of hlog", (Throwable)e);
            this.requestLogRoll();
            throw e;
        }
    }

    int getNumEntries() {
        return this.numEntries.get();
    }

    private long obtainSeqNum() {
        return this.logSeqNum.incrementAndGet();
    }

    int getNumLogFiles() {
        return this.outputfiles.size();
    }

    private byte[] getSnapshotName(byte[] encodedRegionName) {
        byte[] snp = new byte[encodedRegionName.length + 3];
        snp[0] = 115;
        snp[1] = 110;
        snp[2] = 112;
        for (int i = 0; i < encodedRegionName.length; ++i) {
            snp[i + 3] = encodedRegionName[i];
        }
        return snp;
    }

    public long startCacheFlush(byte[] encodedRegionName) {
        Long oldseq;
        this.cacheFlushLock.lock();
        Long seq = this.lastSeqWritten.remove(encodedRegionName);
        if (seq != null && (oldseq = this.lastSeqWritten.put(this.getSnapshotName(encodedRegionName), seq)) != null) {
            LOG.error((Object)("Logic Error Snapshot seq id from earlier flush still present! for region " + Bytes.toString(encodedRegionName) + " overwritten oldseq=" + oldseq + "with new seq=" + seq));
            Runtime.getRuntime().halt(1);
        }
        return this.obtainSeqNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeCacheFlush(byte[] encodedRegionName, byte[] tableName, long logSeqId, boolean isMetaRegion) throws IOException {
        try {
            if (this.closed) {
                return;
            }
            long txid = 0L;
            Object object = this.updateLock;
            synchronized (object) {
                long now = System.currentTimeMillis();
                WALEdit edit = this.completeCacheFlushLogEdit();
                HLogKey key = this.makeKey(encodedRegionName, tableName, logSeqId, System.currentTimeMillis(), HConstants.DEFAULT_CLUSTER_ID);
                this.logSyncer.append(new Entry(key, edit));
                txid = this.unflushedEntries.incrementAndGet();
                writeTime.inc(System.currentTimeMillis() - now);
                long len = 0L;
                for (KeyValue kv : edit.getKeyValues()) {
                    len += (long)kv.getLength();
                }
                writeSize.inc(len);
                this.numEntries.incrementAndGet();
            }
            this.sync(txid);
        }
        finally {
            this.lastSeqWritten.remove(this.getSnapshotName(encodedRegionName));
            this.cacheFlushLock.unlock();
        }
    }

    private WALEdit completeCacheFlushLogEdit() {
        KeyValue kv = new KeyValue(METAROW, METAFAMILY, null, System.currentTimeMillis(), COMPLETE_CACHE_FLUSH);
        WALEdit e = new WALEdit();
        e.add(kv);
        return e;
    }

    public void abortCacheFlush(byte[] encodedRegionName) {
        Long current_memstore_earliest_seq;
        Long snapshot_seq = this.lastSeqWritten.remove(this.getSnapshotName(encodedRegionName));
        if (snapshot_seq != null && (current_memstore_earliest_seq = this.lastSeqWritten.put(encodedRegionName, snapshot_seq)) != null && current_memstore_earliest_seq <= snapshot_seq) {
            LOG.error((Object)("Logic Error region " + Bytes.toString(encodedRegionName) + "acquired edits out of order current memstore seq=" + current_memstore_earliest_seq + " snapshot seq=" + snapshot_seq));
            Runtime.getRuntime().halt(1);
        }
        this.cacheFlushLock.unlock();
    }

    public static boolean isMetaFamily(byte[] family) {
        return Bytes.equals(METAFAMILY, family);
    }

    public boolean isLowReplicationRollEnabled() {
        return this.lowReplicationRollEnabled;
    }

    public static Class<? extends HLogKey> getKeyClass(Configuration conf) {
        return conf.getClass("hbase.regionserver.hlog.keyclass", HLogKey.class);
    }

    public static HLogKey newKey(Configuration conf) throws IOException {
        Class<? extends HLogKey> keyClass = HLog.getKeyClass(conf);
        try {
            return keyClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("cannot create hlog key");
        }
        catch (IllegalAccessException e) {
            throw new IOException("cannot create hlog key");
        }
    }

    public static String getHLogDirectoryName(String serverName) {
        StringBuilder dirName = new StringBuilder(".logs");
        dirName.append("/");
        dirName.append(serverName);
        return dirName.toString();
    }

    protected Path getDir() {
        return this.dir;
    }

    public static boolean validateHLogFilename(String filename) {
        return pattern.matcher(filename).matches();
    }

    static Path getHLogArchivePath(Path oldLogDir, Path p) {
        return new Path(oldLogDir, p.getName());
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    public static NavigableSet<Path> getSplitEditFilesSorted(final FileSystem fs, Path regiondir) throws IOException {
        TreeSet<Path> filesSorted = new TreeSet<Path>();
        Path editsdir = HLog.getRegionDirRecoveredEditsDir(regiondir);
        if (!fs.exists(editsdir)) {
            return filesSorted;
        }
        FileStatus[] files = FSUtils.listStatus(fs, editsdir, new PathFilter(){

            public boolean accept(Path p) {
                boolean result = false;
                try {
                    Matcher m = EDITFILES_NAME_PATTERN.matcher(p.getName());
                    boolean bl = result = fs.isFile(p) && m.matches();
                    if (p.getName().endsWith(HLog.RECOVERED_LOG_TMPFILE_SUFFIX)) {
                        result = false;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed isFile check on " + p));
                }
                return result;
            }
        });
        if (files == null) {
            return filesSorted;
        }
        for (FileStatus status : files) {
            filesSorted.add(status.getPath());
        }
        return filesSorted;
    }

    public static Path moveAsideBadEditsFile(FileSystem fs, Path edits) throws IOException {
        Path moveAsideName = new Path(edits.getParent(), edits.getName() + "." + System.currentTimeMillis());
        if (!fs.rename(edits, moveAsideName)) {
            LOG.warn((Object)("Rename failed from " + edits + " to " + moveAsideName));
        }
        return moveAsideName;
    }

    public static Path getRegionDirRecoveredEditsDir(Path regiondir) {
        return new Path(regiondir, RECOVERED_EDITS_DIR);
    }

    private static void usage() {
        System.err.println("Usage: HLog <ARGS>");
        System.err.println("Arguments:");
        System.err.println(" --dump  Dump textual representation of passed one or more files");
        System.err.println("         For example: HLog --dump hdfs://example.com:9000/hbase/.logs/MACHINE/LOGFILE");
        System.err.println(" --split Split the passed directory of WAL logs");
        System.err.println("         For example: HLog --split hdfs://example.com:9000/hbase/.logs/DIR");
    }

    private static void split(Configuration conf, Path p) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(p)) {
            throw new FileNotFoundException(p.toString());
        }
        Path baseDir = new Path(conf.get("hbase.rootdir"));
        Path oldLogDir = new Path(baseDir, ".oldlogs");
        if (!fs.getFileStatus(p).isDir()) {
            throw new IOException(p + " is not a directory");
        }
        HLogSplitter logSplitter = HLogSplitter.createLogSplitter(conf, baseDir, p, oldLogDir, fs);
        logSplitter.splitLog();
    }

    public WALCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    boolean hasDeferredEntries() {
        return this.lastDeferredTxid > this.syncedTillHere;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            HLog.usage();
            System.exit(-1);
        }
        if (args[0].compareTo("--dump") == 0) {
            HLogPrettyPrinter.run(Arrays.copyOfRange(args, 1, args.length));
        } else if (args[0].compareTo("--split") == 0) {
            Configuration conf = HBaseConfiguration.create();
            for (int i = 1; i < args.length; ++i) {
                try {
                    conf.set("fs.default.name", args[i]);
                    conf.set("fs.defaultFS", args[i]);
                    Path logPath = new Path(args[i]);
                    HLog.split(conf, logPath);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    System.exit(-1);
                }
            }
        } else {
            HLog.usage();
            System.exit(-1);
        }
    }

    static {
        block2: {
            LOG = LogFactory.getLog(HLog.class);
            METAFAMILY = Bytes.toBytes("METAFAMILY");
            METAROW = Bytes.toBytes("METAROW");
            EDITFILES_NAME_PATTERN = Pattern.compile("-?[0-9]+");
            NO_ARGS = new Object[0];
            pattern = Pattern.compile(".*\\.\\d*(.meta)*");
            try {
                COMPLETE_CACHE_FLUSH = "HBASE::CACHEFLUSH".getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        writeTime = new Metric();
        writeSize = new Metric();
        syncTime = new Metric();
        slowHLogAppendCount = new AtomicLong();
        slowHLogAppendTime = new Metric();
        FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 5 * ClassSize.REFERENCE + ClassSize.ATOMIC_INTEGER + 4 + 24);
    }

    public static class Entry
    implements Writable {
        private WALEdit edit;
        private HLogKey key;

        public Entry() {
            this.edit = new WALEdit();
            this.key = new HLogKey();
        }

        public Entry(HLogKey key, WALEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public WALEdit getEdit() {
            return this.edit;
        }

        public HLogKey getKey() {
            return this.key;
        }

        public void setCompressionContext(CompressionContext compressionContext) {
            this.edit.setCompressionContext(compressionContext);
            this.key.setCompressionContext(compressionContext);
        }

        public String toString() {
            return this.key + "=" + this.edit;
        }

        public void write(DataOutput dataOutput) throws IOException {
            this.key.write(dataOutput);
            this.edit.write(dataOutput);
        }

        public void readFields(DataInput dataInput) throws IOException {
            this.key.readFields(dataInput);
            this.edit.readFields(dataInput);
        }
    }

    class LogSyncer
    extends HasThread {
        private final long optionalFlushInterval;
        private AtomicBoolean closeLogSyncer = new AtomicBoolean(false);
        private List<Entry> pendingWrites = new LinkedList<Entry>();

        LogSyncer(long optionalFlushInterval) {
            this.optionalFlushInterval = optionalFlushInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.isInterrupted() && !this.closeLogSyncer.get()) {
                    try {
                        if (HLog.this.unflushedEntries.get() <= HLog.this.syncedTillHere) {
                            AtomicBoolean atomicBoolean = this.closeLogSyncer;
                            synchronized (atomicBoolean) {
                                this.closeLogSyncer.wait(this.optionalFlushInterval);
                            }
                        }
                        HLog.this.sync();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Error while syncing, requesting close of hlog ", (Throwable)e);
                        HLog.this.requestLogRoll();
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.debug((Object)(this.getName() + " interrupted while waiting for sync requests"));
            }
            finally {
                LOG.info((Object)(this.getName() + " exiting"));
            }
        }

        synchronized void append(Entry e) throws IOException {
            this.pendingWrites.add(e);
        }

        synchronized List<Entry> getPendingWrites() {
            List<Entry> save = this.pendingWrites;
            this.pendingWrites = new LinkedList<Entry>();
            return save;
        }

        void hlogFlush(Writer writer, List<Entry> pending) throws IOException {
            if (pending == null) {
                return;
            }
            for (Entry e : pending) {
                writer.append(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            AtomicBoolean atomicBoolean = this.closeLogSyncer;
            synchronized (atomicBoolean) {
                this.closeLogSyncer.set(true);
                this.closeLogSyncer.notifyAll();
            }
        }
    }

    public static class Metric {
        public long min = Long.MAX_VALUE;
        public long max = 0L;
        public long total = 0L;
        public int count = 0;

        synchronized void inc(long val) {
            this.min = Math.min(this.min, val);
            this.max = Math.max(this.max, val);
            this.total += val;
            ++this.count;
        }

        synchronized Metric get() {
            Metric copy = new Metric();
            copy.min = this.min;
            copy.max = this.max;
            copy.total = this.total;
            copy.count = this.count;
            this.min = Long.MAX_VALUE;
            this.max = 0L;
            this.total = 0L;
            this.count = 0;
            return copy;
        }
    }

    public static interface Writer {
        public void init(FileSystem var1, Path var2, Configuration var3) throws IOException;

        public void close() throws IOException;

        public void sync() throws IOException;

        public void append(Entry var1) throws IOException;

        public long getLength() throws IOException;
    }

    public static interface Reader {
        public void init(FileSystem var1, Path var2, Configuration var3) throws IOException;

        public void close() throws IOException;

        public Entry next() throws IOException;

        public Entry next(Entry var1) throws IOException;

        public void seek(long var1) throws IOException;

        public long getPosition() throws IOException;

        public void reset() throws IOException;
    }
}

