/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.OrphanHLogAfterSplitException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.io.MultipleIOException;

public class HLogSplitter {
    private static final String LOG_SPLITTER_IMPL = "hbase.hlog.splitter.impl";
    public static final String RECOVERED_EDITS = "recovered.edits";
    static final Log LOG = LogFactory.getLog(HLogSplitter.class);
    private boolean hasSplit = false;
    private long splitTime = 0L;
    private long splitSize = 0L;
    protected final Path rootDir;
    protected final Path srcDir;
    protected final Path oldLogDir;
    protected final FileSystem fs;
    protected final Configuration conf;
    OutputSink outputSink;
    EntryBuffers entryBuffers;
    protected AtomicReference<Throwable> thrown = new AtomicReference();
    Object dataAvailable = new Object();
    private MonitoredTask status;
    private DistributedLogSplittingHelper distributedLogSplittingHelper = null;
    protected final LastSequenceId sequenceIdChecker;

    public static HLogSplitter createLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs, LastSequenceId idChecker) {
        return HLogSplitter.createLogSplitter(conf, rootDir, srcDir, oldLogDir, fs, idChecker, false);
    }

    public static HLogSplitter createLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs) {
        return HLogSplitter.createLogSplitter(conf, rootDir, srcDir, oldLogDir, fs, null, true);
    }

    private static HLogSplitter createLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs, LastSequenceId seqId, boolean createViaOldCtor) {
        Class splitterClass = conf.getClass(LOG_SPLITTER_IMPL, HLogSplitter.class);
        try {
            ArrayList<Class<LastSequenceId>> ctorArgs = new ArrayList<Class<LastSequenceId>>(6);
            ctorArgs.add(Configuration.class);
            ctorArgs.add(Path.class);
            ctorArgs.add(Path.class);
            ctorArgs.add(Path.class);
            ctorArgs.add(FileSystem.class);
            if (!createViaOldCtor) {
                ctorArgs.add(LastSequenceId.class);
            }
            Constructor ctor = splitterClass.getConstructor(ctorArgs.toArray(new Class[0]));
            return !createViaOldCtor ? (HLogSplitter)ctor.newInstance(conf, rootDir, srcDir, oldLogDir, fs, seqId) : (HLogSplitter)ctor.newInstance(conf, rootDir, srcDir, oldLogDir, fs);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            if (!createViaOldCtor) {
                LOG.info((Object)"Unable to create HLogSplitter with sequence ID checker, trying old ctor");
                return HLogSplitter.createLogSplitter(conf, rootDir, srcDir, oldLogDir, fs, null, true);
            }
            throw new RuntimeException(e);
        }
    }

    public HLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs) {
        this(conf, rootDir, srcDir, oldLogDir, fs, null);
    }

    public HLogSplitter(Configuration conf, Path rootDir, Path srcDir, Path oldLogDir, FileSystem fs, LastSequenceId idChecker) {
        this.conf = conf;
        this.rootDir = rootDir;
        this.srcDir = srcDir;
        this.oldLogDir = oldLogDir;
        this.fs = fs;
        this.sequenceIdChecker = idChecker;
        this.entryBuffers = new EntryBuffers(conf.getInt("hbase.regionserver.hlog.splitlog.buffersize", 0x8000000));
        this.outputSink = new OutputSink();
    }

    public List<Path> splitLog() throws IOException {
        Preconditions.checkState((!this.hasSplit ? 1 : 0) != 0, (Object)"An HLogSplitter instance may only be used once");
        this.hasSplit = true;
        this.status = TaskMonitor.get().createStatus("Splitting logs in " + this.srcDir);
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        this.status.setStatus("Determining files to split...");
        List<Path> splits = null;
        if (!this.fs.exists(this.srcDir)) {
            this.status.markComplete("No log directory existed to split.");
            return splits;
        }
        FileStatus[] logfiles = this.fs.listStatus(this.srcDir);
        if (logfiles == null || logfiles.length == 0) {
            return splits;
        }
        this.logAndReport("Splitting " + logfiles.length + " hlog(s) in " + this.srcDir.toString());
        splits = this.splitLog(logfiles);
        this.splitTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
        String msg = "hlog file splitting completed in " + this.splitTime + " ms for " + this.srcDir.toString();
        this.status.markComplete(msg);
        LOG.info((Object)msg);
        return splits;
    }

    private void logAndReport(String msg) {
        this.status.setStatus(msg);
        LOG.info((Object)msg);
    }

    public long getTime() {
        return this.splitTime;
    }

    public long getSize() {
        return this.splitSize;
    }

    Map<byte[], Long> getOutputCounts() {
        Preconditions.checkState((boolean)this.hasSplit);
        return this.outputSink.getOutputCounts();
    }

    void setDistributedLogSplittingHelper(DistributedLogSplittingHelper helper) {
        this.distributedLogSplittingHelper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Path> splitLog(FileStatus[] logfiles) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        List<Path> splits = null;
        boolean skipErrors = this.conf.getBoolean("hbase.hlog.split.skip.errors", true);
        HLogSplitter.countTotalBytes(logfiles);
        this.splitSize = 0L;
        this.outputSink.startWriterThreads();
        try {
            int i = 0;
            for (FileStatus log : logfiles) {
                Path logPath = log.getPath();
                long logLength = log.getLen();
                this.splitSize += logLength;
                this.logAndReport("Splitting hlog " + (i++ + 1) + " of " + logfiles.length + ": " + logPath + ", length=" + logLength);
                try {
                    HLog.Reader in = this.getReader(this.fs, log, this.conf, skipErrors);
                    if (in != null) {
                        this.parseHLog(in, logPath, this.entryBuffers, this.fs, this.conf, skipErrors);
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            LOG.warn((Object)"Close log reader threw exception -- continuing", (Throwable)e);
                        }
                    }
                    processedLogs.add(logPath);
                }
                catch (CorruptedLogFileException e) {
                    LOG.info((Object)("Got while parsing hlog " + logPath + ". Marking as corrupted"), (Throwable)e);
                    corruptedLogs.add(logPath);
                }
            }
            this.status.setStatus("Log splits complete. Checking for orphaned logs.");
            if (this.fs.listStatus(this.srcDir).length > processedLogs.size() + corruptedLogs.size()) {
                throw new OrphanHLogAfterSplitException("Discovered orphan hlog after split. Maybe the HRegionServer was not dead when we started");
            }
        }
        finally {
            this.status.setStatus("Finishing writing output logs and closing down.");
            splits = this.outputSink.finishWritingAndClose();
        }
        this.status.setStatus("Archiving logs after completed split");
        HLogSplitter.archiveLogs(this.srcDir, corruptedLogs, processedLogs, this.oldLogDir, this.fs, this.conf);
        return splits;
    }

    private static long countTotalBytes(FileStatus[] logfiles) {
        long ret = 0L;
        for (FileStatus stat : logfiles) {
            ret += stat.getLen();
        }
        return ret;
    }

    public static boolean splitLogFile(Path rootDir, FileStatus logfile, FileSystem fs, Configuration conf, CancelableProgressable reporter, LastSequenceId idChecker) throws IOException {
        HLogSplitter s = new HLogSplitter(conf, rootDir, null, null, fs, idChecker);
        return s.splitLogFile(logfile, reporter);
    }

    /*
     * Exception decompiling
     */
    public boolean splitLogFile(FileStatus logfile, CancelableProgressable reporter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void finishSplitLogFile(String logfile, Configuration conf) throws IOException {
        Path rootdir = FSUtils.getRootDir(conf);
        Path oldLogDir = new Path(rootdir, ".oldlogs");
        HLogSplitter.finishSplitLogFile(rootdir, oldLogDir, logfile, conf);
    }

    public static void finishSplitLogFile(Path rootdir, Path oldLogDir, String logfile, Configuration conf) throws IOException {
        ArrayList<Path> processedLogs = new ArrayList<Path>();
        ArrayList<Path> corruptedLogs = new ArrayList<Path>();
        FileSystem fs = rootdir.getFileSystem(conf);
        Path logPath = new Path(logfile);
        if (ZKSplitLog.isCorrupted(rootdir, logPath.getName(), fs)) {
            corruptedLogs.add(logPath);
        } else {
            processedLogs.add(logPath);
        }
        HLogSplitter.archiveLogs(null, corruptedLogs, processedLogs, oldLogDir, fs, conf);
        Path stagingDir = ZKSplitLog.getSplitLogDir(rootdir, logPath.getName());
        fs.delete(stagingDir, true);
    }

    private static void archiveLogs(Path srcDir, List<Path> corruptedLogs, List<Path> processedLogs, Path oldLogDir, FileSystem fs, Configuration conf) throws IOException {
        Path corruptDir = new Path(conf.get("hbase.rootdir"), conf.get("hbase.regionserver.hlog.splitlog.corrupt.dir", ".corrupt"));
        if (!fs.mkdirs(corruptDir)) {
            LOG.info((Object)("Unable to mkdir " + corruptDir));
        }
        fs.mkdirs(oldLogDir);
        for (Path corrupted : corruptedLogs) {
            Path p = new Path(corruptDir, corrupted.getName());
            if (!fs.exists(corrupted)) continue;
            if (!fs.rename(corrupted, p)) {
                LOG.warn((Object)("Unable to move corrupted log " + corrupted + " to " + p));
                continue;
            }
            LOG.warn((Object)("Moving corrupted log " + corrupted + " to " + p));
        }
        for (Path p : processedLogs) {
            Path newPath = HLog.getHLogArchivePath(oldLogDir, p);
            if (!fs.exists(p)) continue;
            if (!fs.rename(p, newPath)) {
                LOG.warn((Object)("Unable to move  " + p + " to " + newPath));
                continue;
            }
            LOG.debug((Object)("Archived processed log " + p + " to " + newPath));
        }
        if (srcDir != null && !fs.delete(srcDir, true)) {
            throw new IOException("Unable to delete src dir: " + srcDir);
        }
    }

    static Path getRegionSplitEditsPath(FileSystem fs, HLog.Entry logEntry, Path rootDir, boolean isCreate) throws IOException {
        Path tableDir = HTableDescriptor.getTableDir(rootDir, logEntry.getKey().getTablename());
        Path regiondir = HRegion.getRegionDir(tableDir, Bytes.toString(logEntry.getKey().getEncodedRegionName()));
        Path dir = HLog.getRegionDirRecoveredEditsDir(regiondir);
        if (!fs.exists(regiondir)) {
            LOG.info((Object)("This region's directory doesn't exist: " + regiondir.toString() + ". It is very likely that it was" + " already split so it's safe to discard those edits."));
            return null;
        }
        if (isCreate && !fs.exists(dir) && !fs.mkdirs(dir)) {
            LOG.warn((Object)("mkdir failed on " + dir));
        }
        String fileName = HLogSplitter.formatRecoveredEditsFileName(logEntry.getKey().getLogSeqNum());
        fileName = HLogSplitter.getTmpRecoveredEditsFileName(fileName);
        return new Path(dir, fileName);
    }

    static String getTmpRecoveredEditsFileName(String fileName) {
        return fileName + ".temp";
    }

    static Path getCompletedRecoveredEditsFilePath(Path srcPath, Long maximumEditLogSeqNum) {
        String fileName = HLogSplitter.formatRecoveredEditsFileName(maximumEditLogSeqNum);
        return new Path(srcPath.getParent(), fileName);
    }

    static String formatRecoveredEditsFileName(long seqid) {
        return String.format("%019d", seqid);
    }

    private void parseHLog(HLog.Reader in, Path path, EntryBuffers entryBuffers, FileSystem fs, Configuration conf, boolean skipErrors) throws IOException, CorruptedLogFileException {
        int editsCount = 0;
        try {
            HLog.Entry entry;
            while ((entry = HLogSplitter.getNextLogLine(in, path, skipErrors)) != null) {
                entryBuffers.appendEntry(entry);
                ++editsCount;
            }
        }
        catch (InterruptedException ie) {
            InterruptedIOException t = new InterruptedIOException();
            t.initCause(ie);
            throw t;
        }
        finally {
            LOG.debug((Object)("Pushed=" + editsCount + " entries from " + path));
        }
    }

    protected HLog.Reader getReader(FileSystem fs, FileStatus file, Configuration conf, boolean skipErrors) throws IOException, CorruptedLogFileException {
        HLog.Reader in;
        Path path = file.getPath();
        long length = file.getLen();
        if (length <= 0L) {
            LOG.warn((Object)("File " + path + " might be still open, length is 0"));
        }
        try {
            FSUtils.getInstance(fs, conf).recoverFileLease(fs, path, conf);
            try {
                in = this.getReader(fs, path, conf);
            }
            catch (EOFException e) {
                if (length <= 0L) {
                    LOG.warn((Object)("Could not open " + path + " for reading. File is empty"), (Throwable)e);
                    return null;
                }
                return null;
            }
        }
        catch (IOException e) {
            if (!skipErrors) {
                throw e;
            }
            CorruptedLogFileException t = new CorruptedLogFileException("skipErrors=true Could not open hlog " + path + " ignoring");
            t.initCause(e);
            throw t;
        }
        return in;
    }

    private static HLog.Entry getNextLogLine(HLog.Reader in, Path path, boolean skipErrors) throws CorruptedLogFileException, IOException {
        try {
            return in.next();
        }
        catch (EOFException eof) {
            LOG.info((Object)("EOF from hlog " + path + ".  continuing"));
            return null;
        }
        catch (IOException e) {
            if (e.getCause() != null && (e.getCause() instanceof ParseException || e.getCause() instanceof ChecksumException)) {
                LOG.warn((Object)("Parse exception " + e.getCause().toString() + " from hlog " + path + ".  continuing"));
                return null;
            }
            if (!skipErrors) {
                throw e;
            }
            CorruptedLogFileException t = new CorruptedLogFileException("skipErrors=true Ignoring exception while parsing hlog " + path + ". Marking as corrupted");
            t.initCause(e);
            throw t;
        }
    }

    private void writerThreadError(Throwable t) {
        this.thrown.compareAndSet(null, t);
    }

    private void checkForErrors() throws IOException {
        Throwable thrown = this.thrown.get();
        if (thrown == null) {
            return;
        }
        if (thrown instanceof IOException) {
            throw (IOException)thrown;
        }
        throw new RuntimeException(thrown);
    }

    protected HLog.Writer createWriter(FileSystem fs, Path logfile, Configuration conf) throws IOException {
        return HLog.createWriter(fs, logfile, conf);
    }

    protected HLog.Reader getReader(FileSystem fs, Path curLogFile, Configuration conf) throws IOException {
        return HLog.getReader(fs, curLogFile, conf);
    }

    private WriterAndPath createWAP(byte[] region, HLog.Entry entry, Path rootdir, FileSystem fs, Configuration conf) throws IOException {
        Path regionedits = HLogSplitter.getRegionSplitEditsPath(fs, entry, rootdir, true);
        if (regionedits == null) {
            return null;
        }
        if (fs.exists(regionedits)) {
            LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + regionedits + ", length=" + fs.getFileStatus(regionedits).getLen()));
            if (!fs.delete(regionedits, false)) {
                LOG.warn((Object)("Failed delete of old " + regionedits));
            }
        }
        HLog.Writer w = this.createWriter(fs, regionedits, conf);
        LOG.debug((Object)("Creating writer path=" + regionedits + " region=" + Bytes.toStringBinary(region)));
        return new WriterAndPath(regionedits, w);
    }

    private boolean reportProgressIfIsDistributedLogSplitting() {
        if (this.distributedLogSplittingHelper != null) {
            return this.distributedLogSplittingHelper.reportProgress();
        }
        return true;
    }

    static class CorruptedLogFileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        CorruptedLogFileException(String s) {
            super(s);
        }
    }

    private static final class WriterAndPath {
        final Path p;
        final HLog.Writer w;
        long editsWritten = 0L;
        long editsSkipped = 0L;
        long nanosSpent = 0L;
        boolean writerClosed = false;

        WriterAndPath(Path p, HLog.Writer w) {
            this.p = p;
            this.w = w;
        }

        void incrementEdits(int edits) {
            this.editsWritten += (long)edits;
        }

        void incrementSkipped(int edits) {
            this.editsSkipped += (long)edits;
        }

        void incrementNanoTime(long nanos) {
            this.nanosSpent += nanos;
        }
    }

    class OutputSink {
        private final Map<byte[], WriterAndPath> logWriters = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        private final Map<byte[], Long> regionMaximumEditLogSeqNum = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        private final List<WriterThread> writerThreads = Lists.newArrayList();
        private final Map<byte[], Long> regionLastFlushedSequenceIds = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        private final Set<byte[]> blacklistedRegions = Collections.synchronizedSet(new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR));
        private boolean closeAndCleanCompleted = false;
        private boolean logWritersClosed = false;
        private final int numThreads;

        public OutputSink() {
            this.numThreads = HLogSplitter.this.conf.getInt("hbase.regionserver.hlog.splitlog.writer.threads", 3);
        }

        synchronized void startWriterThreads() {
            for (int i = 0; i < this.numThreads; ++i) {
                WriterThread t = new WriterThread(i);
                t.start();
                this.writerThreads.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Path> finishWritingAndClose() throws IOException {
            LOG.info((Object)"Waiting for split writer threads to finish");
            boolean progress_failed = false;
            try {
                List<Path> list;
                for (WriterThread t : this.writerThreads) {
                    t.finish();
                }
                for (WriterThread t : this.writerThreads) {
                    if (!progress_failed && !HLogSplitter.this.reportProgressIfIsDistributedLogSplitting()) {
                        progress_failed = true;
                    }
                    try {
                        t.join();
                    }
                    catch (InterruptedException ie) {
                        InterruptedIOException iie = new InterruptedIOException();
                        iie.initCause(ie);
                        throw iie;
                    }
                    HLogSplitter.this.checkForErrors();
                }
                LOG.info((Object)"Split writers finished");
                if (progress_failed) {
                    list = null;
                    return list;
                }
                list = this.closeStreams();
                return list;
            }
            finally {
                List<IOException> thrown = this.closeLogWriters(null);
                if (thrown != null && !thrown.isEmpty()) {
                    throw MultipleIOException.createIOException(thrown);
                }
            }
        }

        private List<Path> closeStreams() throws IOException {
            Preconditions.checkState((!this.closeAndCleanCompleted ? 1 : 0) != 0);
            final ArrayList<Path> paths = new ArrayList<Path>();
            final ArrayList thrown = Lists.newArrayList();
            ThreadPoolExecutor closeThreadPool = Threads.getBoundedCachedThreadPool(this.numThreads, 30L, TimeUnit.SECONDS, new ThreadFactory(){
                private int count = 1;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "split-log-closeStream-" + this.count++);
                    return t;
                }
            });
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(closeThreadPool);
            for (final Map.Entry<byte[], WriterAndPath> logWritersEntry : this.logWriters.entrySet()) {
                completionService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        WriterAndPath wap = (WriterAndPath)logWritersEntry.getValue();
                        try {
                            wap.w.close();
                        }
                        catch (IOException ioe) {
                            LOG.error((Object)("Couldn't close log at " + wap.p), (Throwable)ioe);
                            thrown.add(ioe);
                            return null;
                        }
                        LOG.info((Object)("Closed path " + wap.p + " (wrote " + wap.editsWritten + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms)"));
                        Path dst = HLogSplitter.getCompletedRecoveredEditsFilePath(wap.p, (Long)OutputSink.this.regionMaximumEditLogSeqNum.get(logWritersEntry.getKey()));
                        try {
                            if (!dst.equals((Object)wap.p) && HLogSplitter.this.fs.exists(dst)) {
                                LOG.warn((Object)("Found existing old edits file. It could be the result of a previous failed split attempt. Deleting " + dst + ", length=" + HLogSplitter.this.fs.getFileStatus(dst).getLen()));
                                if (!HLogSplitter.this.fs.delete(dst, false)) {
                                    LOG.warn((Object)("Failed deleting of old " + dst));
                                    throw new IOException("Failed deleting of old " + dst);
                                }
                            }
                            if (HLogSplitter.this.fs.exists(wap.p)) {
                                if (!HLogSplitter.this.fs.rename(wap.p, dst)) {
                                    throw new IOException("Failed renaming " + wap.p + " to " + dst);
                                }
                                LOG.debug((Object)("Rename " + wap.p + " to " + dst));
                            }
                        }
                        catch (IOException ioe) {
                            LOG.error((Object)("Couldn't rename " + wap.p + " to " + dst), (Throwable)ioe);
                            thrown.add(ioe);
                            return null;
                        }
                        paths.add(dst);
                        return null;
                    }
                });
            }
            boolean progress_failed = false;
            try {
                for (int i = 0; i < this.logWriters.size(); ++i) {
                    Future future = completionService.take();
                    future.get();
                    if (progress_failed || HLogSplitter.this.reportProgressIfIsDistributedLogSplitting()) continue;
                    progress_failed = true;
                }
            }
            catch (InterruptedException e) {
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(e);
                throw iie;
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
            finally {
                closeThreadPool.shutdownNow();
            }
            if (!thrown.isEmpty()) {
                throw MultipleIOException.createIOException((List)thrown);
            }
            this.logWritersClosed = true;
            this.closeAndCleanCompleted = true;
            if (progress_failed) {
                return null;
            }
            return paths;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<IOException> closeLogWriters(List<IOException> thrown) throws IOException {
            if (!this.logWritersClosed) {
                Map<byte[], WriterAndPath> map;
                if (thrown == null) {
                    thrown = Lists.newArrayList();
                }
                try {
                    for (WriterThread t : this.writerThreads) {
                        while (t.isAlive()) {
                            t.shouldStop = true;
                            t.interrupt();
                            try {
                                t.join(10L);
                            }
                            catch (InterruptedException e) {
                                InterruptedIOException iie = new InterruptedIOException();
                                iie.initCause(e);
                                throw iie;
                            }
                        }
                    }
                    map = this.logWriters;
                }
                catch (Throwable throwable) {
                    Map<byte[], WriterAndPath> map2 = this.logWriters;
                    synchronized (map2) {
                        for (WriterAndPath wap : this.logWriters.values()) {
                            try {
                                wap.w.close();
                            }
                            catch (IOException ioe) {
                                LOG.error((Object)("Couldn't close log at " + wap.p), (Throwable)ioe);
                                thrown.add(ioe);
                                continue;
                            }
                            LOG.info((Object)("Closed path " + wap.p + " (wrote " + wap.editsWritten + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms)"));
                        }
                    }
                    this.logWritersClosed = true;
                    throw throwable;
                }
                synchronized (map) {
                    for (WriterAndPath wap : this.logWriters.values()) {
                        try {
                            wap.w.close();
                        }
                        catch (IOException ioe) {
                            LOG.error((Object)("Couldn't close log at " + wap.p), (Throwable)ioe);
                            thrown.add(ioe);
                            continue;
                        }
                        LOG.info((Object)("Closed path " + wap.p + " (wrote " + wap.editsWritten + " edits in " + wap.nanosSpent / 1000L / 1000L + "ms)"));
                    }
                }
                this.logWritersClosed = true;
            }
            return thrown;
        }

        WriterAndPath getWriterAndPath(HLog.Entry entry) throws IOException {
            byte[] region = entry.getKey().getEncodedRegionName();
            WriterAndPath ret = this.logWriters.get(region);
            if (ret != null) {
                return ret;
            }
            if (this.blacklistedRegions.contains(region)) {
                return null;
            }
            ret = HLogSplitter.this.createWAP(region, entry, HLogSplitter.this.rootDir, HLogSplitter.this.fs, HLogSplitter.this.conf);
            if (ret == null) {
                this.blacklistedRegions.add(region);
                return null;
            }
            this.logWriters.put(region, ret);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateRegionMaximumEditLogSeqNum(byte[] region, long logSeqNum) {
            Map<byte[], Long> map = this.regionMaximumEditLogSeqNum;
            synchronized (map) {
                Long currentMaxSeqNum = this.regionMaximumEditLogSeqNum.get(region);
                if (currentMaxSeqNum == null || logSeqNum > currentMaxSeqNum) {
                    this.regionMaximumEditLogSeqNum.put(region, logSeqNum);
                }
            }
        }

        Long getRegionMaximumEditLogSeqNum(byte[] region) {
            return this.regionMaximumEditLogSeqNum.get(region);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean shouldSkipEntry(byte[] region, long logSeqNum) {
            Long lastFlushedSequenceId = Long.MIN_VALUE;
            if (HLogSplitter.this.sequenceIdChecker != null) {
                Map<byte[], Long> map = this.regionLastFlushedSequenceIds;
                synchronized (map) {
                    lastFlushedSequenceId = this.regionLastFlushedSequenceIds.get(region);
                }
                if (lastFlushedSequenceId == null) {
                    lastFlushedSequenceId = HLogSplitter.this.sequenceIdChecker.getLastSequenceId(region);
                    map = this.regionLastFlushedSequenceIds;
                    synchronized (map) {
                        this.regionLastFlushedSequenceIds.put(region, lastFlushedSequenceId);
                    }
                }
            }
            return lastFlushedSequenceId >= logSeqNum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<byte[], Long> getOutputCounts() {
            TreeMap<byte[], Long> ret = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            Map<byte[], WriterAndPath> map = this.logWriters;
            synchronized (map) {
                for (Map.Entry<byte[], WriterAndPath> entry : this.logWriters.entrySet()) {
                    ret.put(entry.getKey(), entry.getValue().editsWritten);
                }
            }
            return ret;
        }

        static /* synthetic */ Map access$100(OutputSink x0) {
            return x0.logWriters;
        }
    }

    class DistributedLogSplittingHelper {
        private final CancelableProgressable splitReporter;
        private final int report_period;
        private long last_report_at = 0L;

        public DistributedLogSplittingHelper(CancelableProgressable reporter) {
            this.splitReporter = reporter;
            this.report_period = HLogSplitter.this.conf.getInt("hbase.splitlog.report.period", HLogSplitter.this.conf.getInt("hbase.splitlog.manager.timeout", 300000) / 2);
        }

        private boolean reportProgress() {
            if (this.splitReporter == null) {
                return true;
            }
            long t = EnvironmentEdgeManager.currentTimeMillis();
            if (t - this.last_report_at > (long)this.report_period) {
                this.last_report_at = t;
                if (!this.splitReporter.progress()) {
                    LOG.warn((Object)"Failed: reporter.progress asked us to terminate");
                    return false;
                }
            }
            return true;
        }
    }

    class WriterThread
    extends Thread {
        private volatile boolean shouldStop;

        WriterThread(int i) {
            super("WriterThread-" + i);
            this.shouldStop = false;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in log splitting write thread", t);
                HLogSplitter.this.writerThreadError(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws IOException {
            LOG.debug((Object)("Writer thread " + this + ": starting"));
            while (true) {
                RegionEntryBuffer buffer;
                if ((buffer = HLogSplitter.this.entryBuffers.getChunkToWrite()) == null) {
                    Object object = HLogSplitter.this.dataAvailable;
                    synchronized (object) {
                        block12: {
                            if (this.shouldStop) {
                                return;
                            }
                            try {
                                HLogSplitter.this.dataAvailable.wait(1000L);
                            }
                            catch (InterruptedException ie) {
                                if (this.shouldStop) break block12;
                                throw new RuntimeException(ie);
                            }
                        }
                    }
                }
                assert (buffer != null);
                try {
                    this.writeBuffer(buffer);
                    continue;
                }
                finally {
                    HLogSplitter.this.entryBuffers.doneWriting(buffer);
                    continue;
                }
                break;
            }
        }

        private void writeBuffer(RegionEntryBuffer buffer) throws IOException {
            List<HLog.Entry> entries = buffer.entryBuffer;
            if (entries.isEmpty()) {
                LOG.warn((Object)(this.getName() + " got an empty buffer, skipping"));
                return;
            }
            WriterAndPath wap = null;
            long startTime = System.nanoTime();
            try {
                int editsCount = 0;
                int editsSkipped = 0;
                for (HLog.Entry logEntry : entries) {
                    long logSeqNum;
                    if (wap == null && (wap = HLogSplitter.this.outputSink.getWriterAndPath(logEntry)) == null) {
                        return;
                    }
                    byte[] region = logEntry.getKey().getEncodedRegionName();
                    if (HLogSplitter.this.outputSink.shouldSkipEntry(region, logSeqNum = logEntry.getKey().getLogSeqNum())) {
                        ++editsSkipped;
                        continue;
                    }
                    wap.w.append(logEntry);
                    HLogSplitter.this.outputSink.updateRegionMaximumEditLogSeqNum(region, logSeqNum);
                    ++editsCount;
                }
                wap.incrementEdits(editsCount);
                wap.incrementSkipped(editsSkipped);
                wap.incrementNanoTime(System.nanoTime() - startTime);
            }
            catch (IOException e) {
                e = RemoteExceptionHandler.checkIOException(e);
                LOG.fatal((Object)(this.getName() + " Got while writing log entry to log"), (Throwable)e);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finish() {
            Object object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                this.shouldStop = true;
                HLogSplitter.this.dataAvailable.notifyAll();
            }
        }
    }

    static class RegionEntryBuffer
    implements HeapSize {
        long heapInBuffer = 0L;
        List<HLog.Entry> entryBuffer;
        byte[] tableName;
        byte[] encodedRegionName;

        RegionEntryBuffer(byte[] table, byte[] region) {
            this.tableName = table;
            this.encodedRegionName = region;
            this.entryBuffer = new LinkedList<HLog.Entry>();
        }

        long appendEntry(HLog.Entry entry) {
            this.internify(entry);
            this.entryBuffer.add(entry);
            long incrHeap = entry.getEdit().heapSize() + (long)ClassSize.align(2 * ClassSize.REFERENCE) + 0L;
            this.heapInBuffer += incrHeap;
            return incrHeap;
        }

        private void internify(HLog.Entry entry) {
            HLogKey k = entry.getKey();
            k.internTableName(this.tableName);
            k.internEncodedRegionName(this.encodedRegionName);
        }

        @Override
        public long heapSize() {
            return this.heapInBuffer;
        }
    }

    class EntryBuffers {
        Map<byte[], RegionEntryBuffer> buffers = new TreeMap<byte[], RegionEntryBuffer>(Bytes.BYTES_COMPARATOR);
        Set<byte[]> currentlyWriting = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        long totalBuffered = 0L;
        long maxHeapUsage;

        EntryBuffers(long maxHeapUsage) {
            this.maxHeapUsage = maxHeapUsage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void appendEntry(HLog.Entry entry) throws InterruptedException, IOException {
            long incrHeap;
            HLogKey key = entry.getKey();
            Object object = this;
            synchronized (object) {
                RegionEntryBuffer buffer = this.buffers.get(key.getEncodedRegionName());
                if (buffer == null) {
                    buffer = new RegionEntryBuffer(key.getTablename(), key.getEncodedRegionName());
                    this.buffers.put(key.getEncodedRegionName(), buffer);
                }
                incrHeap = buffer.appendEntry(entry);
            }
            object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                this.totalBuffered += incrHeap;
                while (this.totalBuffered > this.maxHeapUsage && HLogSplitter.this.thrown.get() == null) {
                    LOG.debug((Object)("Used " + this.totalBuffered + " bytes of buffered edits, waiting for IO threads..."));
                    HLogSplitter.this.dataAvailable.wait(3000L);
                }
                HLogSplitter.this.dataAvailable.notifyAll();
            }
            HLogSplitter.this.checkForErrors();
        }

        synchronized RegionEntryBuffer getChunkToWrite() {
            long biggestSize = 0L;
            byte[] biggestBufferKey = null;
            for (Map.Entry<byte[], RegionEntryBuffer> entry : this.buffers.entrySet()) {
                long size = entry.getValue().heapSize();
                if (size <= biggestSize || this.currentlyWriting.contains(entry.getKey())) continue;
                biggestSize = size;
                biggestBufferKey = entry.getKey();
            }
            if (biggestBufferKey == null) {
                return null;
            }
            RegionEntryBuffer buffer = this.buffers.remove(biggestBufferKey);
            this.currentlyWriting.add(biggestBufferKey);
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doneWriting(RegionEntryBuffer buffer) {
            EntryBuffers entryBuffers = this;
            synchronized (entryBuffers) {
                boolean removed = this.currentlyWriting.remove(buffer.encodedRegionName);
                assert (removed);
            }
            long size = buffer.heapSize();
            Object object = HLogSplitter.this.dataAvailable;
            synchronized (object) {
                this.totalBuffered -= size;
                HLogSplitter.this.dataAvailable.notifyAll();
            }
        }

        synchronized boolean isRegionCurrentlyWriting(byte[] region) {
            return this.currentlyWriting.contains(region);
        }
    }
}

