/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class HBaseMultiRealmUserAuthentication {
    private static final Log LOG = LogFactory.getLog(HBaseMultiRealmUserAuthentication.class);
    public static String KERBEROS_USER_REALM_PRINCIPAL = "hadoop.security.authentication.userrealm.principal";
    public static String KERBEROS_USER_REALM = "hadoop.security.authentication.userrealm";
    private static UserGroupInformation ugi;
    private static boolean isInitialized;
    private static boolean isEnabled;
    private static Method isAUserInADifferentRealmMethod;
    private static Method getServerUGIForUserRealmMethod;
    private static Method loginServerFromCurrentKeytabAndReturnUGIMethod;
    private static Method replaceRealmWithUserRealmMethod;

    private static synchronized void initialize(boolean isEnabled) throws IOException {
        if (!isEnabled) {
            return;
        }
        String className = "org.apache.hadoop.security.MultiRealmUserAuthentication";
        try {
            Class<?> c = Class.forName(className, true, UserGroupInformation.class.getClassLoader());
            isAUserInADifferentRealmMethod = c.getDeclaredMethod("isAUserInADifferentRealm", UserGroupInformation.class, Configuration.class);
            getServerUGIForUserRealmMethod = c.getDeclaredMethod("getServerUGIForUserRealm", Configuration.class);
            replaceRealmWithUserRealmMethod = c.getDeclaredMethod("replaceRealmWithUserRealm", String.class, Configuration.class);
            loginServerFromCurrentKeytabAndReturnUGIMethod = UserGroupInformation.class.getDeclaredMethod("loginServerFromCurrentKeytabAndReturnUGI", String.class);
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to load the required class" + className + " or get methods: " + t));
            throw new IOException("Underlying Hadoop version doesn't support multi-realm authentication", t);
        }
    }

    private static void ensureInitialized(Configuration conf) throws IOException {
        if (!isInitialized) {
            isEnabled = conf.get(KERBEROS_USER_REALM) != null;
            HBaseMultiRealmUserAuthentication.initialize(isEnabled);
            isInitialized = true;
        }
    }

    public static boolean isAUserInADifferentRealm(UserGroupInformation ticket, Configuration conf) throws IOException {
        HBaseMultiRealmUserAuthentication.ensureInitialized(conf);
        if (!isEnabled) {
            return false;
        }
        try {
            return (Boolean)isAUserInADifferentRealmMethod.invoke(null, ticket, conf);
        }
        catch (IllegalAccessException iae) {
            throw new IOException("Hadoop version does not support multi-realm", iae);
        }
        catch (InvocationTargetException ite) {
            throw new IOException(ite.getTargetException());
        }
    }

    public static synchronized UserGroupInformation getServerUGIForUserRealm(Configuration conf) throws IOException {
        block8: {
            HBaseMultiRealmUserAuthentication.ensureInitialized(conf);
            if (ugi != null) {
                return ugi;
            }
            String kurp = conf.get(KERBEROS_USER_REALM_PRINCIPAL);
            try {
                if (kurp != null) {
                    try {
                        ugi = (UserGroupInformation)loginServerFromCurrentKeytabAndReturnUGIMethod.invoke(null, kurp);
                    }
                    catch (InvocationTargetException ite) {
                        LOG.warn((Object)"Current user information cannot be obtained", (Throwable)ite);
                    }
                    break block8;
                }
                try {
                    ugi = (UserGroupInformation)getServerUGIForUserRealmMethod.invoke(null, conf);
                }
                catch (InvocationTargetException ite) {
                    throw new IOException(ite.getTargetException());
                }
            }
            catch (IllegalAccessException iae) {
                throw new IOException("Hadoop version does not support multi-realm", iae);
            }
        }
        return ugi;
    }

    public static String replaceRealmWithUserRealm(String principalName, Configuration conf) throws IOException {
        HBaseMultiRealmUserAuthentication.ensureInitialized(conf);
        String kurp = conf.get(KERBEROS_USER_REALM_PRINCIPAL);
        if (kurp != null) {
            return kurp;
        }
        try {
            return (String)replaceRealmWithUserRealmMethod.invoke(null, principalName, conf);
        }
        catch (IllegalAccessException iae) {
            throw new IOException("Hadoop version does not support multi-realm", iae);
        }
        catch (InvocationTargetException ite) {
            throw new IOException(ite.getTargetException());
        }
    }
}

