/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.coprocessor.BaseEndpointCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.RequestContext;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.SecureBulkLoadProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class SecureBulkLoadEndpoint
extends BaseEndpointCoprocessor
implements SecureBulkLoadProtocol {
    public static final long VERSION = 0L;
    private static final int RANDOM_WIDTH = 320;
    private static final int RANDOM_RADIX = 32;
    private static Log LOG = LogFactory.getLog(SecureBulkLoadEndpoint.class);
    private static final FsPermission PERM_ALL_ACCESS = FsPermission.valueOf((String)"-rwxrwxrwx");
    private static final FsPermission PERM_HIDDEN = FsPermission.valueOf((String)"-rwx--x--x");
    private static final String BULKLOAD_STAGING_DIR = "hbase.bulkload.staging.dir";
    private SecureRandom random;
    private FileSystem fs;
    private Configuration conf;
    private Path baseStagingDir;
    private RegionCoprocessorEnvironment env;

    @Override
    public void start(CoprocessorEnvironment env) {
        super.start(env);
        this.env = (RegionCoprocessorEnvironment)env;
        this.random = new SecureRandom();
        this.conf = env.getConfiguration();
        this.baseStagingDir = SecureBulkLoadEndpoint.getBaseStagingDir(this.conf);
        try {
            this.fs = FileSystem.get((Configuration)this.conf);
            this.fs.mkdirs(this.baseStagingDir, PERM_HIDDEN);
            this.fs.setPermission(this.baseStagingDir, PERM_HIDDEN);
            this.fs.mkdirs(new Path(this.baseStagingDir, "DONOTERASE"), PERM_HIDDEN);
            FileStatus status = this.fs.getFileStatus(this.baseStagingDir);
            if (status == null) {
                throw new IllegalStateException("Failed to create staging directory");
            }
            if (!status.getPermission().equals((Object)PERM_HIDDEN)) {
                throw new IllegalStateException("Directory already exists but permissions aren't set to '-rwx--x--x' ");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get FileSystem instance", e);
        }
    }

    @Override
    public String prepareBulkLoad(byte[] tableName) throws IOException {
        this.getAccessController().prePrepareBulkLoad(this.env);
        return this.createStagingDir(this.baseStagingDir, this.getActiveUser(), tableName).toString();
    }

    @Override
    public void cleanupBulkLoad(String bulkToken) throws IOException {
        this.getAccessController().preCleanupBulkLoad(this.env);
        this.fs.delete(this.createStagingDir(this.baseStagingDir, this.getActiveUser(), this.env.getRegion().getTableDesc().getName(), new Path(bulkToken).getName()), true);
    }

    @Override
    public boolean bulkLoadHFiles(final List<Pair<byte[], String>> familyPaths, Token<?> userToken, final String bulkToken) throws IOException {
        User user = this.getActiveUser();
        UserGroupInformation ugi = user.getUGI();
        if (userToken != null) {
            ugi.addToken(userToken);
        } else if (User.isSecurityEnabled()) {
            throw new DoNotRetryIOException("User token cannot be null");
        }
        HRegion region = this.env.getRegion();
        boolean bypass = false;
        if (region.getCoprocessorHost() != null) {
            bypass = region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
        }
        boolean loaded = false;
        if (!bypass) {
            loaded = (Boolean)ugi.doAs((PrivilegedAction)new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    FileSystem fs = null;
                    try {
                        Configuration conf = SecureBulkLoadEndpoint.this.env.getConfiguration();
                        fs = FileSystem.get((Configuration)conf);
                        for (Pair el : familyPaths) {
                            Path p = new Path((String)el.getSecond());
                            LOG.debug((Object)("Setting permission for: " + p));
                            fs.setPermission(p, PERM_ALL_ACCESS);
                            Path stageFamily = new Path(bulkToken, Bytes.toString((byte[])el.getFirst()));
                            if (fs.exists(stageFamily)) continue;
                            fs.mkdirs(stageFamily);
                            fs.setPermission(stageFamily, PERM_ALL_ACCESS);
                        }
                        return SecureBulkLoadEndpoint.this.env.getRegion().bulkLoadHFiles(familyPaths, new SecureBulkLoadListener(fs, bulkToken));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Failed to complete bulk load", (Throwable)e);
                        return false;
                    }
                }
            });
        }
        if (region.getCoprocessorHost() != null) {
            loaded = region.getCoprocessorHost().postBulkLoadHFile(familyPaths, loaded);
        }
        return loaded;
    }

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (SecureBulkLoadProtocol.class.getName().equals(protocol)) {
            return 0L;
        }
        LOG.warn((Object)("Unknown protocol requested: " + protocol));
        return -1L;
    }

    private AccessController getAccessController() {
        return (AccessController)this.env.getRegion().getCoprocessorHost().findCoprocessor(AccessController.class.getName());
    }

    private Path createStagingDir(Path baseDir, User user, byte[] tableName) throws IOException {
        String randomDir = user.getShortName() + "__" + Bytes.toString(tableName) + "__" + new BigInteger(320, this.random).toString(32);
        return this.createStagingDir(baseDir, user, tableName, randomDir);
    }

    private Path createStagingDir(Path baseDir, User user, byte[] tableName, String randomDir) throws IOException {
        Path p = new Path(baseDir, randomDir);
        this.fs.mkdirs(p, PERM_ALL_ACCESS);
        this.fs.setPermission(p, PERM_ALL_ACCESS);
        return p;
    }

    private User getActiveUser() throws IOException {
        User user = RequestContext.getRequestUser();
        if (!RequestContext.isInRequestContext()) {
            throw new DoNotRetryIOException("Failed to get requesting user");
        }
        if ("simple".equalsIgnoreCase(this.conf.get("hbase.security.authentication"))) {
            return User.createUserForTesting(this.conf, user.getShortName(), new String[0]);
        }
        return user;
    }

    public static Path getStagingPath(Configuration conf, String bulkToken, byte[] family) {
        Path stageP = new Path(SecureBulkLoadEndpoint.getBaseStagingDir(conf), bulkToken);
        return new Path(stageP, Bytes.toString(family));
    }

    private static Path getBaseStagingDir(Configuration conf) {
        return new Path(conf.get(BULKLOAD_STAGING_DIR, "/tmp/hbase-staging"));
    }

    private static class SecureBulkLoadListener
    implements HRegion.BulkLoadListener {
        private FileSystem fs;
        private String stagingDir;

        public SecureBulkLoadListener(FileSystem fs, String stagingDir) {
            this.fs = fs;
            this.stagingDir = stagingDir;
        }

        @Override
        public String prepareBulkLoad(byte[] family, String srcPath) throws IOException {
            Path p = new Path(srcPath);
            Path stageP = new Path(this.stagingDir, new Path(Bytes.toString(family), p.getName()));
            if (!this.isFile(p)) {
                throw new IOException("Path does not reference a file: " + p);
            }
            LOG.debug((Object)("Moving " + p + " to " + stageP));
            if (!this.fs.rename(p, stageP)) {
                throw new IOException("Failed to move HFile: " + p + " to " + stageP);
            }
            return stageP.toString();
        }

        @Override
        public void doneBulkLoad(byte[] family, String srcPath) throws IOException {
            LOG.debug((Object)("Bulk Load done for: " + srcPath));
        }

        @Override
        public void failedBulkLoad(byte[] family, String srcPath) throws IOException {
            Path p = new Path(srcPath);
            Path stageP = new Path(this.stagingDir, new Path(Bytes.toString(family), p.getName()));
            LOG.debug((Object)("Moving " + stageP + " back to " + p));
            if (!this.fs.rename(stageP, p)) {
                throw new IOException("Failed to move HFile: " + stageP + " to " + p);
            }
        }

        private boolean isFile(Path p) throws IOException {
            FileStatus status = this.fs.getFileStatus(p);
            boolean isFile = !status.isDir();
            try {
                isFile = isFile && (Boolean)Methods.call(FileStatus.class, status, "isSymlink", null, null) == false;
            }
            catch (Exception e) {
                // empty catch block
            }
            return isFile;
        }
    }
}

