/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.net.NodeBase;

public class DFSUtil {
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static int compareBytes(byte[] a1, byte[] a2) {
        if (a1 == a2) {
            return 0;
        }
        int len1 = a1 == null ? 0 : a1.length;
        int len2 = a2 == null ? 0 : a2.length;
        int n = Math.min(len1, len2);
        for (int i = 0; i < n; ++i) {
            byte b1 = a1[i];
            byte b2 = a2[i];
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    public static String bytes2String(byte[] bytes) {
        return DFSUtil.bytes2String(bytes, 0, bytes.length);
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static String byteArray2PathString(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return "";
        }
        if (pathComponents.length == 1 && (pathComponents[0] == null || pathComponents[0].length == 0)) {
            return "/";
        }
        try {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < pathComponents.length; ++i) {
                result.append(new String(pathComponents[i], "UTF-8"));
                if (i >= pathComponents.length - 1) continue;
                result.append('/');
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)"UTF-8 encoding is not supported.");
        }
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        assert (len <= bytes.length);
        int splits = 0;
        if (len == 0) {
            return new byte[][]{null};
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[i] != separator) continue;
            ++splits;
        }
        int last = len - 1;
        while (last > -1 && bytes[last--] == separator) {
            --splits;
        }
        if (splits == 0 && bytes[0] == separator) {
            return new byte[][]{null};
        }
        byte[][] result = new byte[++splits][];
        int startIndex = 0;
        int nextIndex = 0;
        for (int index = 0; index < splits; ++index) {
            while (nextIndex < len && bytes[nextIndex] != separator) {
                ++nextIndex;
            }
            result[index] = new byte[nextIndex - startIndex];
            System.arraycopy(bytes, startIndex, result[index], 0, nextIndex - startIndex);
            nextIndex = startIndex = nextIndex + 1;
        }
        return result;
    }

    public static byte[] byteArray2bytes(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return EMPTY_BYTES;
        }
        if (pathComponents.length == 1 && (pathComponents[0] == null || pathComponents[0].length == 0)) {
            return new byte[]{47};
        }
        int length = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            length += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            ++length;
        }
        byte[] path = new byte[length];
        int index = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            System.arraycopy(pathComponents[i], 0, path, index, pathComponents[i].length);
            index += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            path[index] = 47;
            ++index;
        }
        return path;
    }

    public static String path2String(Object path) {
        return path == null ? null : (path instanceof String ? (String)path : (path instanceof byte[][] ? DFSUtil.byteArray2PathString((byte[][])path) : path.toString()));
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.locatedBlockCount();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        int idx = 0;
        for (LocatedBlock blk : blocks.getLocatedBlocks()) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] names = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                names[hCnt] = locations[hCnt].getName();
                NodeBase node = new NodeBase(names[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            blkLocations[idx] = new BlockLocation(names, hosts, racks, blk.getStartOffset(), blk.getBlockSize());
            ++idx;
        }
        return blkLocations;
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        try {
            return new URI(scheme, null, address.getHostName(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException(ue);
        }
    }

    public static float getInvalidateWorkPctPerIteration(Configuration conf) {
        float blocksInvalidateWorkPct = conf.getFloat("dfs.namenode.invalidate.work.pct.per.iteration", 0.32f);
        if (blocksInvalidateWorkPct <= 0.0f || blocksInvalidateWorkPct > 1.0f) {
            throw new IllegalArgumentException("dfs.namenode.invalidate.work.pct.per.iteration = '" + blocksInvalidateWorkPct + "' is invalid. " + "It should be a positive, non-zero float value " + "indicating a percentage.");
        }
        return blocksInvalidateWorkPct;
    }

    public static int getReplWorkMultiplier(Configuration conf) {
        int blocksReplWorkMultiplier = conf.getInt("dfs.namenode.replication.work.multiplier.per.iteration", 2);
        if (blocksReplWorkMultiplier <= 0) {
            throw new IllegalArgumentException("dfs.namenode.replication.work.multiplier.per.iteration = '" + blocksReplWorkMultiplier + "' is invalid. " + "It should be a positive, non-zero integer value.");
        }
        return blocksReplWorkMultiplier;
    }

    public static class StaleComparator
    implements Comparator<DatanodeInfo> {
        private long staleInterval;

        public StaleComparator(long interval) {
            this.staleInterval = interval;
        }

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            boolean bStale;
            boolean aStale = a.isStale(this.staleInterval);
            return aStale == (bStale = b.isStale(this.staleInterval)) ? 0 : (aStale ? 1 : -1);
        }
    }
}

