/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public class DistributedFileSystem
extends FileSystem {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;

    public DistributedFileSystem() {
    }

    public DistributedFileSystem(InetSocketAddress namenode, Configuration conf) throws IOException {
        this.initialize(NameNode.getUri(namenode), conf);
    }

    @Override
    public String getName() {
        return this.uri.getAuthority();
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        InetSocketAddress namenode = NameNode.getAddress(uri.getAuthority());
        this.dfs = new DFSClient(namenode, conf, this.statistics);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = this.getHomeDirectory();
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public long getDefaultBlockSize() {
        return this.dfs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication() {
        return this.dfs.getDefaultReplication();
    }

    private Path makeAbsolute(Path f) {
        if (f.isAbsolute()) {
            return f;
        }
        return new Path(this.workingDir, f);
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        String result = this.makeAbsolute(dir).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.makeAbsolute(dir);
    }

    @Override
    public Path getHomeDirectory() {
        return new Path("/user/" + this.dfs.ugi.getShortUserName()).makeQualified(this);
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = this.makeAbsolute(file).toUri().getPath();
        if (!DFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        this.statistics.incrementReadOps(1);
        return this.dfs.getBlockLocations(this.getPathName(file.getPath()), start, len);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        return new DFSClient.DFSDataInputStream(this.dfs.open(this.getPathName(f), bufferSize, this.verifyChecksum, this.statistics));
    }

    public boolean isFileClosed(Path src) throws IOException {
        return this.dfs.isFileClosed(this.getPathName(src));
    }

    public boolean recoverLease(Path f) throws IOException {
        return this.dfs.recoverLease(this.getPathName(f));
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.append(this.getPathName(f), bufferSize, progress, this.statistics);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        return new FSDataOutputStream(this.dfs.create(this.getPathName(f), permission, overwrite, true, replication, blockSize, progress, bufferSize), this.statistics);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        return new FSDataOutputStream(this.dfs.create(this.getPathName(f), permission, overwrite, false, replication, blockSize, progress, bufferSize), this.statistics);
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.setReplication(this.getPathName(src), replication);
    }

    @Override
    public void concat(Path trg, Path[] psrcs) throws IOException {
        String[] srcs = new String[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            srcs[i] = this.getPathName(psrcs[i]);
        }
        this.statistics.incrementWriteOps(1);
        this.dfs.concat(this.getPathName(trg), srcs);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.rename(this.getPathName(src), this.getPathName(dst));
    }

    @Override
    @Deprecated
    public boolean delete(Path f) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.delete(this.getPathName(f));
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.delete(this.getPathName(f), recursive);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getContentSummary(this.getPathName(f));
    }

    public void setQuota(Path src, long namespaceQuota, long diskspaceQuota) throws IOException {
        this.dfs.setQuota(this.getPathName(src), namespaceQuota, diskspaceQuota);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.getFullPath(parent).makeQualified(this));
    }

    @Override
    public FileStatus[] listStatus(Path p) throws IOException {
        String src = this.getPathName(p);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            return null;
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = this.makeQualified(partialListing[i], p);
            }
            this.statistics.incrementReadOps(1);
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(this.makeQualified(fileStatus, p));
        }
        this.statistics.incrementLargeReadOps(1);
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                return null;
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(this.makeQualified(fileStatus, p));
            }
            this.statistics.incrementLargeReadOps(1);
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.dfs.mkdirs(this.getPathName(f), permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.processDeleteOnExit();
            this.dfs.close();
        }
        finally {
            super.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    public DFSClient getClient() {
        return this.dfs;
    }

    public DiskStatus getDiskStatus() throws IOException {
        return this.dfs.getDiskStatus();
    }

    public long getRawCapacity() throws IOException {
        return this.dfs.totalRawCapacity();
    }

    public long getRawUsed() throws IOException {
        return this.dfs.totalRawUsed();
    }

    public long getMissingBlocksCount() throws IOException {
        return this.dfs.getMissingBlocksCount();
    }

    public long getUnderReplicatedBlocksCount() throws IOException {
        return this.dfs.getUnderReplicatedBlocksCount();
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.dfs.getCorruptBlocksCount();
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.dfs.datanodeReport(FSConstants.DatanodeReportType.ALL);
    }

    public boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        return this.dfs.setSafeMode(action);
    }

    public void saveNamespace() throws AccessControlException, IOException {
        this.dfs.saveNamespace();
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.dfs.distributedUpgradeProgress(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    public boolean reportChecksumFailure(Path f, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        LocatedBlock[] lblocks = new LocatedBlock[2];
        DFSClient.DFSDataInputStream dfsIn = (DFSClient.DFSDataInputStream)in;
        Block dataBlock = dfsIn.getCurrentBlock();
        if (dataBlock == null) {
            LOG.error((Object)"Error: Current block in data stream is null! ");
            return false;
        }
        DatanodeInfo[] dataNode = new DatanodeInfo[]{dfsIn.getCurrentDatanode()};
        lblocks[0] = new LocatedBlock(dataBlock, dataNode);
        LOG.info((Object)("Found checksum error in data stream at block=" + dataBlock + " on datanode=" + dataNode[0].getName()));
        DFSClient.DFSDataInputStream dfsSums = (DFSClient.DFSDataInputStream)sums;
        Block sumsBlock = dfsSums.getCurrentBlock();
        if (sumsBlock == null) {
            LOG.error((Object)"Error: Current block in checksum stream is null! ");
            return false;
        }
        DatanodeInfo[] sumsNode = new DatanodeInfo[]{dfsSums.getCurrentDatanode()};
        lblocks[1] = new LocatedBlock(sumsBlock, sumsNode);
        LOG.info((Object)("Found checksum error in checksum stream at block=" + sumsBlock + " on datanode=" + sumsNode[0].getName()));
        this.dfs.reportChecksumFailure(f.toString(), lblocks);
        return true;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        HdfsFileStatus fi = this.dfs.getFileInfo(this.getPathName(f));
        if (fi != null) {
            return this.makeQualified(fi, f);
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    @Override
    public MD5MD5CRC32FileChecksum getFileChecksum(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.dfs.getFileChecksum(this.getPathName(f));
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.dfs.setPermission(this.getPathName(p), permission);
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.statistics.incrementWriteOps(1);
        this.dfs.setOwner(this.getPathName(p), username, groupname);
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.dfs.setTimes(this.getPathName(p), mtime, atime);
    }

    @Override
    protected int getDefaultPort() {
        return 8020;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        Token<DelegationTokenIdentifier> result = this.dfs.getDelegationToken(renewer == null ? null : new Text(renewer));
        return result;
    }

    @Deprecated
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        return this.getDelegationToken(renewer.toString());
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        try {
            return token.renew(this.getConf());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Caught interrupted", ie);
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        try {
            token.cancel(this.getConf());
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Caught interrupted", ie);
        }
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.dfs.setBalancerBandwidth(bandwidth);
    }

    public void allowSnapshot(Path path) throws IOException {
        this.dfs.allowSnapshot(this.getPathName(path));
    }

    public void disallowSnapshot(Path path) throws IOException {
        this.dfs.disallowSnapshot(this.getPathName(path));
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return new Path(this.dfs.createSnapshot(this.getPathName(path), snapshotName));
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.dfs.renameSnapshot(this.getPathName(path), snapshotOldName, snapshotNewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHealthy(URI uri) {
        boolean bl;
        String scheme = uri.getScheme();
        if (!"hdfs".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("This scheme is not hdfs, uri=" + uri);
        }
        Configuration conf = new Configuration();
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", scheme), true);
        conf.setBoolean("dfs.client.retry.policy.enabled", false);
        conf.setInt("ipc.client.connect.max.retries", 0);
        DistributedFileSystem fs = null;
        try {
            fs = (DistributedFileSystem)FileSystem.get(uri, conf);
            boolean safemode = fs.setSafeMode(FSConstants.SafeModeAction.SAFEMODE_GET);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Is namenode in safemode? " + safemode + "; uri=" + uri));
            }
            fs.close();
            fs = null;
            bl = !safemode;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Got an exception for uri=" + uri), (Throwable)e);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, fs);
                throw throwable;
            }
            IOUtils.cleanup(LOG, fs);
            return bl2;
        }
        IOUtils.cleanup(LOG, fs);
        return bl;
    }

    @Override
    public void deleteSnapshot(Path snapshotDir, String snapshotName) throws IOException {
        this.dfs.deleteSnapshot(this.getPathName(snapshotDir), snapshotName);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        return this.dfs.getSnapshottableDirListing();
    }

    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        return this.dfs.getSnapshotDiffReport(snapshotDir, fromSnapshot, toSnapshot);
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
    }

    public static class DiskStatus {
        private long capacity;
        private long dfsUsed;
        private long remaining;

        public DiskStatus(long capacity, long dfsUsed, long remaining) {
            this.capacity = capacity;
            this.dfsUsed = dfsUsed;
            this.remaining = remaining;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public long getDfsUsed() {
            return this.dfsUsed;
        }

        public long getRemaining() {
            return this.remaining;
        }
    }
}

