/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.mount;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ExtendedHdfsFileStatus;
import org.apache.hadoop.mount.MountEntry;
import org.apache.hadoop.mount.MountInterface;
import org.apache.hadoop.mount.MountResponse;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.channel.Channel;

public class RpcProgramMountd
extends RpcProgram
implements MountInterface {
    private static final Log LOG = LogFactory.getLog(RpcProgramMountd.class);
    public static int PROGRAM = 100005;
    public static int VERSION_1 = 1;
    public static int VERSION_2 = 2;
    public static int VERSION_3 = 3;
    public static int PORT = 4242;
    private final DFSClient dfsClient;
    private final List<MountEntry> mounts = Collections.synchronizedList(new ArrayList());
    private final List<String> exports;

    public RpcProgramMountd() throws IOException {
        this(new ArrayList<String>(0));
    }

    public RpcProgramMountd(List<String> exports) throws IOException {
        this(exports, new Configuration());
    }

    public RpcProgramMountd(List<String> exports, Configuration config) throws IOException {
        super("mountd", "localhost", PORT, PROGRAM, VERSION_1, VERSION_3, 0);
        this.exports = Collections.unmodifiableList(exports);
        this.dfsClient = new DFSClient(config);
    }

    @Override
    public XDR nullOp(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT NULLOP :  client: " + client));
        }
        return RpcAcceptedReply.voidReply(out, xid);
    }

    @Override
    public XDR mnt(XDR xdr, XDR out, int xid, InetAddress client) {
        String path = xdr.readString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT MNT path: " + path + " client: " + client));
        }
        String host = client.getHostName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got host: " + host + " path: " + path));
        }
        if (!this.exports.contains(path)) {
            LOG.info((Object)("Path " + path + " is not shared."));
            MountResponse.writeMNTResponse(Nfs3Status.NFS3ERR_NOENT, out, xid, null);
            return out;
        }
        FileHandle handle = null;
        try {
            ExtendedHdfsFileStatus exFileStatus = this.dfsClient.getExtendedFileInfo(path);
            handle = new FileHandle(exFileStatus.getFileId());
        }
        catch (IOException e) {
            LOG.error((Object)("Can't get handle for export:" + path + ", exception:" + e));
            MountResponse.writeMNTResponse(Nfs3Status.NFS3ERR_NOENT, out, xid, null);
            return out;
        }
        assert (handle != null);
        LOG.info((Object)("Giving handle (fileId:" + handle.getFileId() + ") to client for export " + path));
        this.mounts.add(new MountEntry(host, path));
        MountResponse.writeMNTResponse(Nfs3Status.NFS3_OK, out, xid, handle.getContent());
        return out;
    }

    @Override
    public XDR dump(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT NULLOP :  client: " + client));
        }
        ArrayList<MountEntry> copy = new ArrayList<MountEntry>(this.mounts);
        MountResponse.writeMountList(out, xid, copy);
        return out;
    }

    @Override
    public XDR umnt(XDR xdr, XDR out, int xid, InetAddress client) {
        String path = xdr.readString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT UMNT path: " + path + " client: " + client));
        }
        String host = client.getHostName();
        this.mounts.remove(new MountEntry(host, path));
        RpcAcceptedReply.voidReply(out, xid);
        return out;
    }

    @Override
    public XDR umntall(XDR out, int xid, InetAddress client) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MOUNT UMNTALL :  client: " + client));
        }
        this.mounts.clear();
        return RpcAcceptedReply.voidReply(out, xid);
    }

    @Override
    public XDR handleInternal(RpcCall rpcCall, XDR xdr, XDR out, InetAddress client, Channel channel) {
        int procedure = rpcCall.getProcedure();
        int xid = rpcCall.getXid();
        if (procedure == 0) {
            out = this.nullOp(out, xid, client);
        } else if (procedure == 1) {
            out = this.mnt(xdr, out, xid, client);
        } else if (procedure == 2) {
            out = this.dump(out, xid, client);
        } else if (procedure == 3) {
            out = this.umnt(xdr, out, xid, client);
        } else if (procedure == 4) {
            this.umntall(out, xid, client);
        } else if (procedure == 5) {
            out = MountResponse.writeExportList(out, xid, this.exports);
        } else {
            RpcAcceptedReply.voidReply(out, xid, RpcAcceptedReply.AcceptState.PROC_UNAVAIL);
        }
        return out;
    }

    @Override
    protected boolean isIdempotent(RpcCall call) {
        return false;
    }
}

