/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.nfs.nfs3.LruCache;
import org.apache.hadoop.security.UserGroupInformation;

public class DFSClientCache {
    static final Log LOG = LogFactory.getLog(DFSClientCache.class);
    private final LruCache<String, DFSClient> lruTable;
    private final Configuration config;

    public DFSClientCache(Configuration config) {
        this(config, 256);
    }

    public DFSClientCache(Configuration config, int size) {
        this.lruTable = new LruCache(size);
        this.config = config;
    }

    public void put(String uname, DFSClient client) {
        this.lruTable.put(uname, client);
    }

    public synchronized DFSClient get(String uname) {
        DFSClient client = this.lruTable.get(uname);
        if (client != null) {
            return client;
        }
        try {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser(uname);
            client = ugi.doAs(new PrivilegedExceptionAction<DFSClient>(){

                @Override
                public DFSClient run() throws IOException {
                    return new DFSClient(DFSClientCache.this.config);
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)("Create DFSClient failed for user:" + uname));
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.lruTable.put(uname, client);
        return client;
    }

    public int usedSize() {
        return this.lruTable.usedSize();
    }

    public boolean containsKey(String key) {
        return this.lruTable.containsKey(key);
    }
}

