/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<K, V> {
    private final int maxSize;
    private final LinkedHashMap<K, V> map;
    private static final float hashTableLoadFactor = 0.75f;

    public LruCache(int maxSize) {
        this.maxSize = maxSize;
        int hashTableCapacity = (int)Math.ceil((float)maxSize / 0.75f) + 1;
        this.map = new LinkedHashMap<K, V>(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > LruCache.this.maxSize;
            }
        };
    }

    public synchronized V get(K key) {
        return this.map.get(key);
    }

    public synchronized void put(K key, V value) {
        this.map.put(key, value);
    }

    public synchronized int usedSize() {
        return this.map.size();
    }

    public synchronized boolean containsKey(K key) {
        return this.map.containsKey(key);
    }
}

