/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ExtendedHdfsFileStatus;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.WccAttr;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;

public class Nfs3Utils {
    public static final String INODEID_PATH_PREFIX = "/.reserved/.inodes/";

    public static String getFileIdPath(FileHandle handle) {
        return Nfs3Utils.getFileIdPath(handle.getFileId());
    }

    public static String getFileIdPath(long fileId) {
        return INODEID_PATH_PREFIX + fileId;
    }

    public static ExtendedHdfsFileStatus getFileStatus(DFSClient client, String fileIdPath) throws IOException {
        return client.getExtendedFileInfo(fileIdPath);
    }

    public static Nfs3FileAttributes getNfs3FileAttrFromFileStatus(ExtendedHdfsFileStatus fs, IdUserGroup iug) {
        return new Nfs3FileAttributes(fs.isDir(), (int)fs.getChildrenNum(), fs.getPermission().toShort(), iug.getUidAllowingUnknown(fs.getOwner()), iug.getGidAllowingUnknown(fs.getGroup()), fs.getLen(), 0L, fs.getFileId(), fs.getModificationTime(), fs.getAccessTime());
    }

    public static Nfs3FileAttributes getFileAttr(DFSClient client, String fileIdPath, IdUserGroup iug) throws IOException {
        ExtendedHdfsFileStatus fs = Nfs3Utils.getFileStatus(client, fileIdPath);
        return fs == null ? null : Nfs3Utils.getNfs3FileAttrFromFileStatus(fs, iug);
    }

    public static WccAttr getWccAttr(DFSClient client, String fileIdPath) throws IOException {
        ExtendedHdfsFileStatus fstat = Nfs3Utils.getFileStatus(client, fileIdPath);
        if (fstat == null) {
            return null;
        }
        long size = fstat.isDir() ? Nfs3FileAttributes.getDirSize((int)fstat.getChildrenNum()) : fstat.getLen();
        return new WccAttr(size, new NfsTime(fstat.getModificationTime()), new NfsTime(fstat.getModificationTime()));
    }

    public static WccAttr getWccAttr(Nfs3FileAttributes attr) {
        return new WccAttr(attr.getSize(), attr.getMtime(), attr.getCtime());
    }

    public static WccData createWccData(WccAttr preOpAttr, DFSClient dfsClient, String fileIdPath, IdUserGroup iug) throws IOException {
        Nfs3FileAttributes postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, fileIdPath, iug);
        return new WccData(preOpAttr, postOpDirAttr);
    }

    public static void writeChannel(Channel channel, XDR out) {
        ChannelBuffer outBuf = XDR.writeRequest(out, true);
        channel.write((Object)outBuf);
    }

    private static boolean isSet(int access, int bits) {
        return (access & bits) == bits;
    }

    public static int getAccessRights(int mode, int type) {
        int rtn = 0;
        if (Nfs3Utils.isSet(mode, 4)) {
            rtn |= 1;
            if (type == NfsFileType.NFSDIR.toValue()) {
                rtn |= 2;
            }
        }
        if (Nfs3Utils.isSet(mode, 2)) {
            rtn |= 4;
            rtn |= 8;
            rtn |= 0x10;
        }
        if (Nfs3Utils.isSet(mode, 1) && type == NfsFileType.NFSREG.toValue()) {
            rtn |= 0x20;
        }
        return rtn;
    }

    public static int getAccessRightsForUserGroup(int uid, int gid, Nfs3FileAttributes attr) {
        int mode = attr.getMode();
        int rtn = 0;
        if (uid == attr.getUid()) {
            return rtn |= Nfs3Utils.getAccessRights(mode >> 6, attr.getType());
        }
        if (gid == attr.getGid()) {
            return rtn |= Nfs3Utils.getAccessRights(mode >> 3, attr.getType());
        }
        return rtn |= Nfs3Utils.getAccessRights(mode, attr.getType());
    }

    public static long bytesToLong(byte[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            buffer.put(data[i]);
        }
        buffer.flip();
        return buffer.getLong();
    }

    public static byte[] longToByte(long v) {
        byte[] data = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        return data;
    }
}

