/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

public class OffsetRange
implements Comparable<OffsetRange> {
    private final long min;
    private final long max;

    OffsetRange(long min, long max) {
        if (min >= max || min < 0L || max < 0L) {
            throw new IllegalArgumentException("Wrong offset range: (" + min + "," + max + ")");
        }
        this.min = min;
        this.max = max;
    }

    long getMin() {
        return this.min;
    }

    long getMax() {
        return this.max;
    }

    public int hashCode() {
        return (int)(this.min ^ this.max);
    }

    public boolean equals(Object o) {
        assert (o instanceof OffsetRange);
        OffsetRange range = (OffsetRange)o;
        return this.min == range.getMin() && this.max == range.getMax();
    }

    boolean hasOverlap(OffsetRange range) {
        long rangeMin = range.getMin();
        long rangeMax = range.getMax();
        if (this.min == rangeMin && this.max == rangeMax) {
            return false;
        }
        if (this.min == rangeMin || this.max == rangeMax) {
            return true;
        }
        if (this.min < rangeMin && this.max > rangeMin) {
            return true;
        }
        return this.min > rangeMin && this.min < rangeMax;
    }

    @Override
    public int compareTo(OffsetRange other) {
        if (this.hasOverlap(other)) {
            return 2;
        }
        if (this.min < other.getMin()) {
            return -1;
        }
        if (this.min > other.getMin()) {
            return 1;
        }
        assert (this.max == other.getMax());
        return 0;
    }
}

