/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.InvalidParameterException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.nfs.nfs3.AsyncDataService;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.hdfs.nfs.nfs3.OffsetRange;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteManager;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.nfs.nfs3.response.WRITE3Response;
import org.apache.hadoop.nfs.nfs3.response.WccAttr;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.channel.Channel;

class OpenFileCtx {
    public static final Log LOG = LogFactory.getLog(OpenFileCtx.class);
    private final ReentrantLock ctxLock;
    private boolean activeState;
    private boolean asyncStatus;
    private final FSDataOutputStream fos;
    private final Nfs3FileAttributes latestAttr;
    private long nextOffset;
    private final SortedMap<OffsetRange, WriteCtx> pendingWrites;
    private long lastAccessTime;
    private static int DUMP_WRITE_WATER_MARK = 0x100000;
    private FileOutputStream dumpOut;
    private long nonSequentialWriteInMemory;
    private boolean enabledDump;
    private RandomAccessFile raf;
    private final String dumpFilePath;
    public static final int COMMIT_FINISHED = 0;
    public static final int COMMIT_WAIT = 1;
    public static final int COMMIT_INACTIVE_CTX = 2;
    public static final int COMMIT_ERROR = 3;

    private void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    private boolean checkStreamTimeout(long streamTimeout) {
        return System.currentTimeMillis() - this.lastAccessTime > streamTimeout;
    }

    private long updateNonSequentialWriteInMemory(long count) {
        this.nonSequentialWriteInMemory += count;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Update nonSequentialWriteInMemory by " + count + " new value:" + this.nonSequentialWriteInMemory));
        }
        if (this.nonSequentialWriteInMemory < 0L) {
            throw new InvalidParameterException("nonSequentialWriteInMemory is negative after update with count " + count);
        }
        return this.nonSequentialWriteInMemory;
    }

    SortedMap<OffsetRange, WriteCtx> getPendingWrites() {
        return this.pendingWrites;
    }

    OpenFileCtx(FSDataOutputStream fos, Nfs3FileAttributes latestAttr, String dumpFilePath) {
        this.fos = fos;
        this.latestAttr = latestAttr;
        this.pendingWrites = new TreeMap<OffsetRange, WriteCtx>();
        this.updateLastAccessTime();
        this.activeState = true;
        this.asyncStatus = false;
        this.dumpOut = null;
        this.raf = null;
        this.nonSequentialWriteInMemory = 0L;
        this.dumpFilePath = dumpFilePath;
        this.enabledDump = dumpFilePath != null;
        this.ctxLock = new ReentrantLock();
    }

    public Nfs3FileAttributes copyLatestAttr() {
        this.ctxLock.lock();
        Nfs3FileAttributes ret = new Nfs3FileAttributes(this.latestAttr);
        this.ctxLock.unlock();
        return ret;
    }

    public long getNextOffset() {
        this.ctxLock.lock();
        long ret = this.nextOffset;
        this.ctxLock.unlock();
        return ret;
    }

    private long getFlushedOffset() throws IOException {
        return this.fos.getPos();
    }

    private void checkDump(long count) {
        assert (this.ctxLock.isLocked());
        if (!this.enabledDump) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Do nothing, dump is disabled.");
            }
            return;
        }
        this.updateNonSequentialWriteInMemory(count);
        if (this.nonSequentialWriteInMemory < (long)DUMP_WRITE_WATER_MARK) {
            return;
        }
        if (this.dumpOut == null) {
            LOG.info((Object)("Create dump file:" + this.dumpFilePath));
            File dumpFile = new File(this.dumpFilePath);
            try {
                if (dumpFile.exists()) {
                    throw new RuntimeException("The dump file should not exist:" + this.dumpFilePath);
                }
                this.dumpOut = new FileOutputStream(dumpFile);
                if (dumpFile.createNewFile()) {
                    LOG.error((Object)("Can't create dump file:" + this.dumpFilePath));
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Got failure when creating dump stream " + this.dumpFilePath + " with error:" + e));
                this.enabledDump = false;
                if (this.dumpOut != null) {
                    try {
                        this.dumpOut.close();
                    }
                    catch (IOException e1) {
                        LOG.error((Object)("Can't close dump stream " + this.dumpFilePath + " with error:" + e));
                    }
                }
                return;
            }
        }
        if (this.raf == null) {
            try {
                this.raf = new RandomAccessFile(this.dumpFilePath, "r");
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Can't get random access to file " + this.dumpFilePath));
                this.enabledDump = false;
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start dump, current write number:" + this.pendingWrites.size()));
        }
        for (OffsetRange key : this.pendingWrites.keySet()) {
            WriteCtx writeCtx = (WriteCtx)this.pendingWrites.get(key);
            try {
                long dumpedDataSize = writeCtx.dumpData(this.dumpOut, this.raf);
                if (dumpedDataSize <= 0L) continue;
                if (dumpedDataSize != (long)writeCtx.getCount()) {
                    throw new RuntimeException("Dumped size, " + dumpedDataSize + ", is not write size:" + writeCtx.getCount());
                }
                this.updateNonSequentialWriteInMemory(-dumpedDataSize);
                WccData fileWcc = new WccData(this.latestAttr.getWccAttr(), this.latestAttr);
                WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3_OK, fileWcc, (int)dumpedDataSize, writeCtx.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel(writeCtx.getChannel(), response.send(new XDR(), writeCtx.getXid()));
                writeCtx.setReplied(true);
            }
            catch (IOException e) {
                LOG.error((Object)("Dump data failed:" + writeCtx + " with error:" + e));
                this.enabledDump = false;
                return;
            }
        }
        if (this.nonSequentialWriteInMemory != 0L) {
            throw new RuntimeException("After dump, nonSequentialWriteInMemory is not zero: " + this.nonSequentialWriteInMemory);
        }
    }

    private boolean checkRepeatedWriteRequest(WRITE3Request request, Channel channel, int xid) {
        OffsetRange range = new OffsetRange(request.getOffset(), request.getOffset() + (long)request.getCount());
        WriteCtx writeCtx = (WriteCtx)this.pendingWrites.get(range);
        if (writeCtx == null) {
            return false;
        }
        if (xid != writeCtx.getXid()) {
            LOG.warn((Object)("Got a repeated request, same range, with a different xid:" + xid + " xid in old request:" + writeCtx.getXid()));
        }
        return true;
    }

    public void receivedNewWrite(DFSClient dfsClient, WRITE3Request request, Channel channel, int xid, AsyncDataService asyncDataService, IdUserGroup iug) {
        long offset = request.getOffset();
        int count = request.getCount();
        Nfs3Constant.WriteStableHow stableHow = request.getStableHow();
        this.ctxLock.lock();
        if (!this.activeState) {
            LOG.info((Object)("OpenFileCtx is inactive, fileId:" + request.getHandle().getFileId()));
            WccData fileWcc = new WccData(this.latestAttr.getWccAttr(), this.latestAttr);
            WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3ERR_IO, fileWcc, 0, stableHow, Nfs3Constant.WRITE_COMMIT_VERF);
            Nfs3Utils.writeChannel(channel, response.send(new XDR(), xid));
            return;
        }
        if (this.checkRepeatedWriteRequest(request, channel, xid)) {
            LOG.debug((Object)("Repeated unstable write request: xid=" + xid + " reqeust:" + request + " just drop it."));
            this.updateLastAccessTime();
            this.ctxLock.lock();
            return;
        }
        WccAttr preOpAttr = this.latestAttr.getWccAttr();
        LOG.info((Object)("requesed offset=" + offset + " and current filesize=" + preOpAttr.getSize()));
        long nextOffset = this.getNextOffset();
        if (offset == nextOffset) {
            LOG.info((Object)("Add to the list, update nextOffset and notify the writer, nextOffset:" + nextOffset));
            this.addWrite(new WriteCtx(request.getHandle(), request.getOffset(), request.getCount(), request.getStableHow(), request.getData(), channel, xid, true, 1));
            nextOffset = offset + (long)count;
            if (!this.asyncStatus) {
                this.asyncStatus = true;
                asyncDataService.execute(new AsyncDataService.WriteBackTask(this));
            }
            this.updateLastAccessTime();
            this.ctxLock.unlock();
            if (request.getStableHow() == Nfs3Constant.WriteStableHow.UNSTABLE) {
                WccData fileWcc = new WccData(preOpAttr, this.latestAttr);
                WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3_OK, fileWcc, count, stableHow, Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel(channel, response.send(new XDR(), xid));
            }
        } else if (offset > nextOffset) {
            LOG.info((Object)("Add new write to the list but not update nextOffset:" + nextOffset));
            this.addWrite(new WriteCtx(request.getHandle(), request.getOffset(), request.getCount(), request.getStableHow(), request.getData(), channel, xid, true, 0));
            this.checkDump(request.getCount());
            this.updateLastAccessTime();
            this.ctxLock.unlock();
            if (request.getStableHow() == Nfs3Constant.WriteStableHow.UNSTABLE) {
                WccData fileWcc = new WccData(preOpAttr, this.latestAttr);
                WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3_OK, fileWcc, count, stableHow, Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel(channel, response.send(new XDR(), xid));
            }
        } else {
            WccData wccData = new WccData(preOpAttr, null);
            WRITE3Response response = offset + (long)count > nextOffset ? new WRITE3Response(Nfs3Status.NFS3ERR_INVAL, wccData, 0, Nfs3Constant.WriteStableHow.UNSTABLE, 0L) : this.processPerfectOverWrite(dfsClient, offset, count, stableHow, request.getData(), Nfs3Utils.getFileIdPath(request.getHandle()), wccData, iug);
            this.updateLastAccessTime();
            this.ctxLock.unlock();
            Nfs3Utils.writeChannel(channel, response.send(new XDR(), xid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WRITE3Response processPerfectOverWrite(DFSClient dfsClient, long offset, int count, Nfs3Constant.WriteStableHow stableHow, byte[] data, String path, WccData wccData, IdUserGroup iug) {
        assert (this.ctxLock.isLocked());
        WRITE3Response response = null;
        byte[] readbuffer = new byte[count];
        int readCount = 0;
        DFSClient.DFSDataInputStream fis = null;
        try {
            fis = new DFSClient.DFSDataInputStream(dfsClient.open(path));
            readCount = fis.read((int)offset, readbuffer, 0, count);
            if (readCount < count) {
                LOG.error((Object)("Can't read back " + count + " bytes, partial read size:" + readCount));
                WRITE3Response wRITE3Response = response = new WRITE3Response(Nfs3Status.NFS3ERR_IO, wccData, 0, stableHow, Nfs3Constant.WRITE_COMMIT_VERF);
                return wRITE3Response;
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Read failed when processing possible perfect overwrite, path=" + path + " error:" + e));
            WRITE3Response e2 = response = new WRITE3Response(Nfs3Status.NFS3ERR_IO, wccData, 0, stableHow, Nfs3Constant.WRITE_COMMIT_VERF);
            return e2;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't close inputstream for " + path + " error:" + e));
                }
            }
        }
        BytesWritable.Comparator comparator = new BytesWritable.Comparator();
        if (comparator.compare(readbuffer, 0, readCount, data, 0, count) != 0) {
            response = new WRITE3Response(Nfs3Status.NFS3ERR_INVAL, wccData, 0, stableHow, 0L);
        } else {
            Nfs3FileAttributes postOpAttr = null;
            try {
                dfsClient.setTimes(path, System.currentTimeMillis(), -1L);
                postOpAttr = Nfs3Utils.getFileAttr(dfsClient, path, iug);
            }
            catch (IOException e) {
                LOG.info((Object)("Got error when processing perfect overwrite, path=" + path + " error:" + e));
                response = new WRITE3Response(Nfs3Status.NFS3ERR_IO, wccData, 0, stableHow, 0L);
                return response;
            }
            wccData.setPostOpAttr(postOpAttr);
            response = new WRITE3Response(Nfs3Status.NFS3_OK, wccData, count, stableHow, 0L);
        }
        return response;
    }

    public int checkCommit(long commitOffset) {
        this.ctxLock.lock();
        if (!this.activeState) {
            this.ctxLock.unlock();
            return 2;
        }
        if (commitOffset == 0L) {
            commitOffset = this.getNextOffset();
        }
        long flushed = 0L;
        try {
            flushed = this.getFlushedOffset();
        }
        catch (IOException e) {
            LOG.error((Object)("Can't get flushed offset, error:" + e));
            this.ctxLock.unlock();
            return 3;
        }
        LOG.info((Object)("getFlushedOffset=" + flushed + " commitOffset=" + commitOffset));
        if (flushed < commitOffset) {
            this.updateLastAccessTime();
            this.ctxLock.unlock();
            return 1;
        }
        int ret = 1;
        try {
            this.fos.sync();
            ret = 0;
        }
        catch (IOException e) {
            LOG.error((Object)("Got stream error during data sync:" + e));
            ret = 3;
        }
        this.updateLastAccessTime();
        this.ctxLock.unlock();
        return ret;
    }

    private void addWrite(WriteCtx writeCtx) {
        long offset = writeCtx.getOffset();
        int count = writeCtx.getCount();
        this.ctxLock.lock();
        SortedMap<OffsetRange, WriteCtx> writes = this.getPendingWrites();
        writes.put(new OffsetRange(offset, offset + (long)count), writeCtx);
        this.ctxLock.unlock();
    }

    public boolean streamCleanup(long fileId, long streamTimeout) {
        if (streamTimeout < WriteManager.MINIMIUM_STREAM_TIMEOUT) {
            throw new InvalidParameterException("StreamTimeout" + streamTimeout + "ms is less than MINIMIUM_STREAM_TIMEOUT " + WriteManager.MINIMIUM_STREAM_TIMEOUT + "ms");
        }
        if (!this.ctxLock.tryLock()) {
            return false;
        }
        boolean flag = false;
        if (this.checkStreamTimeout(streamTimeout)) {
            LOG.info((Object)("closing stream for fileId:" + fileId));
            this.cleanup();
            flag = true;
        }
        this.ctxLock.unlock();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWriteBack() {
        this.ctxLock.lock();
        try {
            if (!this.asyncStatus) {
                LOG.fatal((Object)"The openFileCtx has false async status");
                System.exit(-1);
            }
            if (this.getPendingWrites().isEmpty()) {
                LOG.fatal((Object)("The asyn write task has no pendding writes! fileId:" + this.latestAttr.getFileId()));
                System.exit(-2);
            }
            this.doWrites();
        }
        catch (IOException e) {
            LOG.info((Object)("got exception when writing back:" + e));
        }
        finally {
            this.asyncStatus = false;
            this.ctxLock.unlock();
        }
    }

    private void doSingleWrite(WriteCtx writeCtx) {
        assert (this.ctxLock.isLocked());
        Channel channel = writeCtx.getChannel();
        int xid = writeCtx.getXid();
        long offset = writeCtx.getOffset();
        int count = writeCtx.getCount();
        Nfs3Constant.WriteStableHow stableHow = writeCtx.getStableHow();
        byte[] data = null;
        try {
            data = writeCtx.getData();
        }
        catch (IOException e1) {
            LOG.error((Object)("Failed to get request data offset:" + offset + " count:" + count + " error:" + e1));
            this.cleanup();
        }
        assert (data.length == count);
        FileHandle handle = writeCtx.getHandle();
        LOG.info((Object)("do write, fileId: " + handle.getFileId() + " offset: " + offset + " length:" + count + " stableHow:" + stableHow.getValue()));
        try {
            this.fos.write(data, 0, count);
            if (this.fos.getPos() != offset + (long)count) {
                throw new IOException("output stream is out of sync, pos=" + this.fos.getPos() + " and nextOffset should be" + (offset + (long)count));
            }
            this.nextOffset = this.fos.getPos();
            if (writeCtx.getDataState() == 0) {
                this.updateNonSequentialWriteInMemory(-count);
            }
            if (!writeCtx.getReplied()) {
                WccAttr preOpAttr = this.latestAttr.getWccAttr();
                WccData fileWcc = new WccData(preOpAttr, this.latestAttr);
                WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3_OK, fileWcc, count, stableHow, Nfs3Constant.WRITE_COMMIT_VERF);
                Nfs3Utils.writeChannel(channel, response.send(new XDR(), xid));
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Error writing to fileId " + handle.getFileId() + " at offset " + offset + " and length " + data.length), (Throwable)e);
            if (!writeCtx.getReplied()) {
                WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3ERR_IO);
                Nfs3Utils.writeChannel(channel, response.send(new XDR(), xid));
            }
            LOG.info((Object)("Clean up open file context for fileId: " + this.latestAttr.getFileid()));
            this.cleanup();
        }
    }

    private void cleanup() {
        this.activeState = false;
        try {
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Can't close stream for fileId:" + this.latestAttr.getFileid() + ", error:" + e));
        }
        LOG.info((Object)("There are " + this.pendingWrites.size() + " pending writes."));
        WccAttr preOpAttr = this.latestAttr.getWccAttr();
        while (!this.pendingWrites.isEmpty()) {
            OffsetRange key = this.pendingWrites.firstKey();
            LOG.info((Object)("Fail pending write: (" + key.getMin() + "," + key.getMax() + "), nextOffset=" + this.getNextOffset()));
            WriteCtx writeCtx = (WriteCtx)this.pendingWrites.remove(key);
            WccData fileWcc = new WccData(preOpAttr, this.latestAttr);
            WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3ERR_IO, fileWcc, 0, writeCtx.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
            Nfs3Utils.writeChannel(writeCtx.getChannel(), response.send(new XDR(), writeCtx.getXid()));
        }
        if (this.dumpOut != null) {
            try {
                this.dumpOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File dumpFile = new File(this.dumpFilePath);
        dumpFile.delete();
    }

    private void doWrites() throws IOException {
        assert (this.ctxLock.isLocked());
        SortedMap<OffsetRange, WriteCtx> pendingWrites = this.getPendingWrites();
        while (!pendingWrites.isEmpty() && this.activeState) {
            long nextOffset = this.getNextOffset();
            OffsetRange key = pendingWrites.firstKey();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("key.getMin()=" + key.getMin() + " nextOffset=" + nextOffset));
            }
            if (key.getMin() > nextOffset) {
                LOG.info((Object)"The next sequencial write has not arrived yet");
                return;
            }
            if (key.getMin() < nextOffset && key.getMax() > nextOffset) {
                throw new IOException("Got a overlapping write (" + key.getMin() + "," + key.getMax() + "), nextOffset=" + nextOffset);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Remove write(" + key.getMin() + "-" + key.getMax() + ") from the list"));
            }
            WriteCtx writeCtx = (WriteCtx)pendingWrites.remove(key);
            this.doSingleWrite(writeCtx);
            this.updateLastAccessTime();
        }
    }
}

