/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.nfs.nfs3.DFSClientCache;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteManager;
import org.apache.hadoop.hdfs.protocol.ExtendedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedHdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.Nfs3Interface;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.nfs.nfs3.request.ACCESS3Request;
import org.apache.hadoop.nfs.nfs3.request.COMMIT3Request;
import org.apache.hadoop.nfs.nfs3.request.CREATE3Request;
import org.apache.hadoop.nfs.nfs3.request.FSINFO3Request;
import org.apache.hadoop.nfs.nfs3.request.FSSTAT3Request;
import org.apache.hadoop.nfs.nfs3.request.GETATTR3Request;
import org.apache.hadoop.nfs.nfs3.request.LOOKUP3Request;
import org.apache.hadoop.nfs.nfs3.request.MKDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.PATHCONF3Request;
import org.apache.hadoop.nfs.nfs3.request.READ3Request;
import org.apache.hadoop.nfs.nfs3.request.READDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.READDIRPLUS3Request;
import org.apache.hadoop.nfs.nfs3.request.REMOVE3Request;
import org.apache.hadoop.nfs.nfs3.request.RENAME3Request;
import org.apache.hadoop.nfs.nfs3.request.RMDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.SETATTR3Request;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.nfs.nfs3.response.ACCESS3Response;
import org.apache.hadoop.nfs.nfs3.response.COMMIT3Response;
import org.apache.hadoop.nfs.nfs3.response.CREATE3Response;
import org.apache.hadoop.nfs.nfs3.response.FSINFO3Response;
import org.apache.hadoop.nfs.nfs3.response.FSSTAT3Response;
import org.apache.hadoop.nfs.nfs3.response.GETATTR3Response;
import org.apache.hadoop.nfs.nfs3.response.LOOKUP3Response;
import org.apache.hadoop.nfs.nfs3.response.MKDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.PATHCONF3Response;
import org.apache.hadoop.nfs.nfs3.response.READ3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIRPLUS3Response;
import org.apache.hadoop.nfs.nfs3.response.READLINK3Response;
import org.apache.hadoop.nfs.nfs3.response.REMOVE3Response;
import org.apache.hadoop.nfs.nfs3.response.RENAME3Response;
import org.apache.hadoop.nfs.nfs3.response.RMDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.SETATTR3Response;
import org.apache.hadoop.nfs.nfs3.response.SYMLINK3Response;
import org.apache.hadoop.nfs.nfs3.response.VoidResponse;
import org.apache.hadoop.nfs.nfs3.response.WRITE3Response;
import org.apache.hadoop.nfs.nfs3.response.WccAttr;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcAuthInfo;
import org.apache.hadoop.oncrpc.RpcAuthSys;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.security.AccessControlException;
import org.jboss.netty.channel.Channel;

public class RpcProgramNfs3
extends RpcProgram
implements Nfs3Interface {
    public static final int DEFAULT_UMASK = 18;
    public static final FsPermission umask = new FsPermission(18);
    private static final Log LOG = LogFactory.getLog(RpcProgramNfs3.class);
    private static final int MAX_READ_TRANSFER_SIZE = 65536;
    private static final int MAX_WRITE_TRANSFER_SIZE = 65536;
    private static final int MAX_READDIR_TRANSFER_SIZE = 65536;
    private final Configuration config = new Configuration();
    private final WriteManager writeManager;
    private final IdUserGroup iug;
    private final DFSClientCache clientCache;
    private final DFSClient superUserClient;
    private final short replication;
    private final long blockSize;
    private final int bufferSize;
    private FileSystem.Statistics statistics;
    private String writeDumpDir;
    private static final String UNKNOWN_USER = "nobody";
    private static final String UNKNOWN_GROUP = "nobody";

    public RpcProgramNfs3(List<String> exports) throws IOException {
        this(exports, new Configuration());
    }

    public RpcProgramNfs3(List<String> exports, Configuration config) throws IOException {
        super("NFS3", "localhost", 2049, 100003, 3, 3, 100);
        config.set("dfs.umaskmode", "000");
        this.iug = new IdUserGroup();
        this.writeManager = new WriteManager(this.iug, config);
        this.clientCache = new DFSClientCache(config);
        this.superUserClient = new DFSClient(config);
        this.replication = (short)config.getInt("dfs.replication", 3);
        this.blockSize = config.getLong("dfs.block.size", 0x4000000L);
        this.bufferSize = config.getInt("io.file.buffer.size", 4096);
        this.writeDumpDir = config.get("dfs.nfs3.dump.dir", "/tmp/.hdfs-nfs");
        boolean enableDump = config.getBoolean("dfs.nfs3.enableDump", true);
        if (!enableDump) {
            this.writeDumpDir = null;
        } else {
            this.clearDirectory(this.writeDumpDir);
        }
    }

    private void clearDirectory(String writeDumpDir) throws IOException {
        File dumpDir = new File(writeDumpDir);
        if (dumpDir.exists()) {
            LOG.info((Object)("Delete current dump directory " + writeDumpDir));
            if (!FileUtil.fullyDelete(dumpDir)) {
                throw new IOException("Cannot remove current dump directory: " + dumpDir);
            }
        }
        LOG.info((Object)("Create new dump directory " + writeDumpDir));
        if (!dumpDir.mkdirs()) {
            throw new IOException("Cannot create dump directory " + dumpDir);
        }
    }

    @Override
    public NFS3Response nullProcedure() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"NFS NULL");
        }
        return new VoidResponse(Nfs3Status.NFS3_OK);
    }

    @Override
    public GETATTR3Response getattr(XDR xdr, RpcAuthSys authSys) {
        GETATTR3Response response = new GETATTR3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        GETATTR3Request request = null;
        try {
            request = new GETATTR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid GETATTR request");
            response.setStatus(Nfs3Status.NFS3ERR_INVAL);
            return response;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GETATTR for fileId: " + handle.getFileId()));
        }
        Nfs3FileAttributes attrs = null;
        try {
            attrs = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
        }
        catch (IOException e) {
            LOG.info((Object)("Can't get file attribute, fileId=" + handle.getFileId()));
            response.setStatus(Nfs3Status.NFS3ERR_IO);
            return response;
        }
        if (attrs == null) {
            LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
            response.setStatus(Nfs3Status.NFS3ERR_STALE);
            return response;
        }
        response.setPostOpAttr(attrs);
        return response;
    }

    private void setattrInternal(DFSClient dfsClient, String fileIdPath, SetAttr3 newAttr, boolean setMode) throws IOException {
        long mtime;
        EnumSet<SetAttr3.SetAttrField> updateFields = newAttr.getUpdateFields();
        if (setMode && updateFields.contains((Object)SetAttr3.SetAttrField.MODE)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("set new mode:" + newAttr.getMode()));
            }
            dfsClient.setPermission(fileIdPath, new FsPermission((short)newAttr.getMode()));
        }
        if (updateFields.contains((Object)SetAttr3.SetAttrField.UID) || updateFields.contains((Object)SetAttr3.SetAttrField.GID)) {
            String uname = updateFields.contains((Object)SetAttr3.SetAttrField.UID) ? this.iug.getUserName(newAttr.getUid(), "nobody") : null;
            String gname = updateFields.contains((Object)SetAttr3.SetAttrField.GID) ? this.iug.getGroupName(newAttr.getGid(), "nobody") : null;
            dfsClient.setOwner(fileIdPath, uname, gname);
        }
        long atime = updateFields.contains((Object)SetAttr3.SetAttrField.ATIME) ? newAttr.getAtime().getMilliSeconds() : -1L;
        long l = mtime = updateFields.contains((Object)SetAttr3.SetAttrField.MTIME) ? newAttr.getMtime().getMilliSeconds() : -1L;
        if (atime != -1L || mtime != -1L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("set atime:" + atime + " mtime:" + mtime));
            }
            dfsClient.setTimes(fileIdPath, mtime, atime);
        }
    }

    @Override
    public SETATTR3Response setattr(XDR xdr, RpcAuthSys authSys) {
        SETATTR3Response response = new SETATTR3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        SETATTR3Request request = null;
        try {
            request = new SETATTR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid SETATTR request");
            response.setStatus(Nfs3Status.NFS3ERR_INVAL);
            return response;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS SETATTR fileId: " + handle.getFileId()));
        }
        if (request.getAttr().getUpdateFields().contains((Object)SetAttr3.SetAttrField.SIZE)) {
            LOG.error((Object)("Setting file size is not supported when setattr, fileId: " + handle.getFileId()));
            response.setStatus(Nfs3Status.NFS3ERR_INVAL);
            return response;
        }
        String fileIdPath = Nfs3Utils.getFileIdPath(handle);
        WccAttr preOpAttr = null;
        try {
            preOpAttr = Nfs3Utils.getWccAttr(dfsClient, fileIdPath);
            if (preOpAttr == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                response.setStatus(Nfs3Status.NFS3ERR_STALE);
                return response;
            }
            if (request.isCheck() && !preOpAttr.getCtime().equals(request.getCtime())) {
                WccData wccData = Nfs3Utils.createWccData(preOpAttr, dfsClient, fileIdPath, this.iug);
                return new SETATTR3Response(Nfs3Status.NFS3ERR_NOT_SYNC, wccData);
            }
            this.setattrInternal(dfsClient, fileIdPath, request.getAttr(), true);
            Nfs3FileAttributes postOpAttr = Nfs3Utils.getFileAttr(dfsClient, fileIdPath, this.iug);
            WccData wccData = new WccData(preOpAttr, postOpAttr);
            return new SETATTR3Response(Nfs3Status.NFS3_OK, wccData);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            WccData wccData = null;
            try {
                wccData = Nfs3Utils.createWccData(preOpAttr, dfsClient, fileIdPath, this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpAttr for fileIdPath: " + fileIdPath));
            }
            if (e instanceof AccessControlException) {
                return new SETATTR3Response(Nfs3Status.NFS3ERR_ACCES, wccData);
            }
            return new SETATTR3Response(Nfs3Status.NFS3ERR_IO, wccData);
        }
    }

    @Override
    public LOOKUP3Response lookup(XDR xdr, RpcAuthSys authSys) {
        LOOKUP3Response response = new LOOKUP3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        LOOKUP3Request request = null;
        try {
            request = new LOOKUP3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid LOOKUP request");
            return new LOOKUP3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS LOOKUP dir fileId: " + dirHandle.getFileId() + " name: " + fileName));
        }
        try {
            String dirFileIdPath = Nfs3Utils.getFileIdPath(dirHandle);
            Nfs3FileAttributes postOpObjAttr = this.writeManager.getFileAttr(dfsClient, dirHandle, fileName);
            if (postOpObjAttr == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("NFS LOOKUP fileId: " + dirHandle.getFileId() + " name:" + fileName + " does not exist"));
                }
                Nfs3FileAttributes postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
                return new LOOKUP3Response(Nfs3Status.NFS3ERR_NOENT, null, null, postOpDirAttr);
            }
            Nfs3FileAttributes postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
            if (postOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new LOOKUP3Response(Nfs3Status.NFS3ERR_STALE);
            }
            FileHandle fileHandle = new FileHandle(postOpObjAttr.getFileId());
            return new LOOKUP3Response(Nfs3Status.NFS3_OK, fileHandle, postOpObjAttr, postOpDirAttr);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new LOOKUP3Response(Nfs3Status.NFS3ERR_IO);
        }
    }

    @Override
    public ACCESS3Response access(XDR xdr, RpcAuthSys authSys) {
        ACCESS3Response response = new ACCESS3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        ACCESS3Request request = null;
        try {
            request = new ACCESS3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid ACCESS request");
            return new ACCESS3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS ACCESS fileId: " + handle.getFileId()));
        }
        try {
            Nfs3FileAttributes attrs = this.writeManager.getFileAttr(this.superUserClient, handle, this.iug);
            if (attrs == null) {
                LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new ACCESS3Response(Nfs3Status.NFS3ERR_STALE);
            }
            int access = Nfs3Utils.getAccessRightsForUserGroup(authSys.getUid(), authSys.getGid(), attrs);
            return new ACCESS3Response(Nfs3Status.NFS3_OK, attrs, access);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new ACCESS3Response(Nfs3Status.NFS3ERR_IO);
        }
    }

    public READLINK3Response readlink(XDR xdr, RpcAuthSys authSys) {
        return new READLINK3Response(Nfs3Status.NFS3ERR_NOTSUPP);
    }

    @Override
    public READ3Response read(XDR xdr, RpcAuthSys authSys) {
        READ3Response response = new READ3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        READ3Request request = null;
        try {
            request = new READ3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid READ request");
            return new READ3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        long offset = request.getOffset();
        int count = request.getCount();
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS READ fileId: " + handle.getFileId() + " offset: " + offset + " count: " + count));
        }
        if (count == 0) {
            Nfs3FileAttributes attrs;
            try {
                attrs = Nfs3Utils.getFileAttr(this.superUserClient, Nfs3Utils.getFileIdPath(handle), this.iug);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Get error accessing file, fileId:" + handle.getFileId()));
                }
                return new READ3Response(Nfs3Status.NFS3ERR_IO);
            }
            if (attrs == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Can't get path for fileId:" + handle.getFileId()));
                }
                return new READ3Response(Nfs3Status.NFS3ERR_NOENT);
            }
            int access = Nfs3Utils.getAccessRightsForUserGroup(authSys.getUid(), authSys.getGid(), attrs);
            if ((access & 1) != 0) {
                boolean eof = offset >= attrs.getSize();
                return new READ3Response(Nfs3Status.NFS3_OK, attrs, 0, eof, new byte[0]);
            }
            return new READ3Response(Nfs3Status.NFS3ERR_ACCES);
        }
        try {
            int buffSize = Math.min(65536, count);
            byte[] readbuffer = new byte[buffSize];
            DFSClient.DFSInputStream is = dfsClient.open(Nfs3Utils.getFileIdPath(handle));
            DFSClient.DFSDataInputStream fis = new DFSClient.DFSDataInputStream(is);
            int readCount = fis.read(offset, readbuffer, 0, count);
            fis.close();
            Nfs3FileAttributes attrs = Nfs3Utils.getFileAttr(dfsClient, Nfs3Utils.getFileIdPath(handle), this.iug);
            if (readCount < count) {
                LOG.info((Object)("Partical read. Asked offset:" + offset + " count:" + count + " and read back:" + readCount + "file size:" + attrs.getSize()));
            }
            if (readCount < 0) {
                readCount = 0;
            }
            boolean eof = offset + (long)readCount >= attrs.getSize();
            return new READ3Response(Nfs3Status.NFS3_OK, attrs, readCount, eof, readbuffer);
        }
        catch (IOException e) {
            LOG.warn((Object)("Read error: " + e.getClass() + " offset: " + offset + " count: " + count), (Throwable)e);
            return new READ3Response(Nfs3Status.NFS3ERR_IO);
        }
    }

    @Override
    public WRITE3Response write(XDR xdr, Channel channel, int xid, RpcAuthSys authSys) {
        WRITE3Response response = new WRITE3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        WRITE3Request request = null;
        try {
            request = new WRITE3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid WRITE request");
            return new WRITE3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        long offset = request.getOffset();
        int count = request.getCount();
        Nfs3Constant.WriteStableHow stableHow = request.getStableHow();
        byte[] data = request.getData();
        if (data.length < count) {
            LOG.error((Object)"Invalid argument, data size is less than count in request");
            return new WRITE3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS WRITE fileId: " + handle.getFileId() + " offset: " + offset + " length:" + count + " stableHow:" + stableHow.getValue() + " xid:" + xid));
        }
        Nfs3FileAttributes preOpAttr = null;
        try {
            preOpAttr = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            if (preOpAttr == null) {
                LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new WRITE3Response(Nfs3Status.NFS3ERR_STALE);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("requesed offset=" + offset + " and current filesize=" + preOpAttr.getSize()));
            }
            this.writeManager.handleWrite(dfsClient, request, channel, xid, preOpAttr);
        }
        catch (IOException e) {
            LOG.info((Object)("Error writing to fileId " + handle.getFileId() + " at offset " + offset + " and length " + data.length), (Throwable)e);
            Nfs3FileAttributes postOpAttr = null;
            try {
                postOpAttr = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpAttr for fileId: " + handle.getFileId()));
            }
            WccAttr attr = preOpAttr == null ? null : Nfs3Utils.getWccAttr(preOpAttr);
            WccData fileWcc = new WccData(attr, postOpAttr);
            return new WRITE3Response(Nfs3Status.NFS3ERR_IO, fileWcc, 0, request.getStableHow(), Nfs3Constant.WRITE_COMMIT_VERF);
        }
        return null;
    }

    @Override
    public CREATE3Response create(XDR xdr, RpcAuthSys authSys) {
        int createMode;
        CREATE3Response response = new CREATE3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        CREATE3Request request = null;
        try {
            request = new CREATE3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid CREATE request");
            return new CREATE3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS CREATE dir fileId: " + dirHandle.getFileId() + " filename: " + fileName));
        }
        if ((createMode = request.getMode()) != 2 && request.getObjAttr().getUpdateFields().contains((Object)SetAttr3.SetAttrField.SIZE)) {
            LOG.error((Object)("Setting file size is not supported when creating file: " + fileName + " dir fileId:" + dirHandle.getFileId()));
            return new CREATE3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FSDataOutputStream fos = null;
        String dirFileIdPath = Nfs3Utils.getFileIdPath(dirHandle);
        WccAttr preOpDirAttr = null;
        Nfs3FileAttributes postOpObjAttr = null;
        FileHandle fileHandle = null;
        WccData dirWcc = null;
        try {
            preOpDirAttr = Nfs3Utils.getWccAttr(dfsClient, dirFileIdPath);
            if (preOpDirAttr == null) {
                LOG.error((Object)("Can't get path for dirHandle:" + dirHandle));
                return new CREATE3Response(Nfs3Status.NFS3ERR_STALE);
            }
            String fileIdPath = Nfs3Utils.getFileIdPath(dirHandle) + "/" + fileName;
            SetAttr3 setAttr3 = request.getObjAttr();
            assert (setAttr3 != null);
            FsPermission permission = setAttr3.getUpdateFields().contains((Object)SetAttr3.SetAttrField.MODE) ? new FsPermission((short)setAttr3.getMode()) : FsPermission.getDefault().applyUMask(umask);
            fos = new FSDataOutputStream(dfsClient.create(fileIdPath, permission, false, false, this.replication, this.blockSize, null, this.bufferSize), this.statistics);
            if (createMode == 0 || createMode == 1) {
                if (!setAttr3.getUpdateFields().contains((Object)SetAttr3.SetAttrField.GID)) {
                    setAttr3.getUpdateFields().add(SetAttr3.SetAttrField.GID);
                    setAttr3.setGid(authSys.getGid());
                }
                this.setattrInternal(dfsClient, fileIdPath, setAttr3, false);
            }
            postOpObjAttr = Nfs3Utils.getFileAttr(dfsClient, fileIdPath, this.iug);
            dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    LOG.error((Object)("Can't close stream for dirFileId:" + dirHandle.getFileId() + " filename: " + fileName));
                }
            }
            if (dirWcc == null) {
                try {
                    dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                }
                catch (IOException e1) {
                    LOG.error((Object)("Can't get postOpDirAttr for dirFileId:" + dirHandle.getFileId()));
                }
            }
            if (e instanceof AccessControlException) {
                return new CREATE3Response(Nfs3Status.NFS3ERR_ACCES, fileHandle, postOpObjAttr, dirWcc);
            }
            return new CREATE3Response(Nfs3Status.NFS3ERR_IO, fileHandle, postOpObjAttr, dirWcc);
        }
        OpenFileCtx openFileCtx = new OpenFileCtx(fos, postOpObjAttr, this.writeDumpDir + "/" + postOpObjAttr.getFileId());
        fileHandle = new FileHandle(postOpObjAttr.getFileId());
        this.writeManager.addOpenFileStream(fileHandle, openFileCtx);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("open stream for file:" + fileName + ", fileId:" + fileHandle.getFileId()));
        }
        return new CREATE3Response(Nfs3Status.NFS3_OK, fileHandle, postOpObjAttr, dirWcc);
    }

    @Override
    public MKDIR3Response mkdir(XDR xdr, RpcAuthSys authSys) {
        MKDIR3Response response = new MKDIR3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        MKDIR3Request request = null;
        try {
            request = new MKDIR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid MKDIR request");
            return new MKDIR3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (request.getObjAttr().getUpdateFields().contains((Object)SetAttr3.SetAttrField.SIZE)) {
            LOG.error((Object)("Setting file size is not supported when mkdir: " + fileName + " in dirHandle" + dirHandle));
            return new MKDIR3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        String dirFileIdPath = Nfs3Utils.getFileIdPath(dirHandle);
        WccAttr preOpDirAttr = null;
        Nfs3FileAttributes postOpDirAttr = null;
        Nfs3FileAttributes postOpObjAttr = null;
        FileHandle objFileHandle = null;
        try {
            FsPermission permission;
            preOpDirAttr = Nfs3Utils.getWccAttr(dfsClient, dirFileIdPath);
            if (preOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new MKDIR3Response(Nfs3Status.NFS3ERR_STALE);
            }
            String fileIdPath = dirFileIdPath + "/" + fileName;
            SetAttr3 setAttr3 = request.getObjAttr();
            FsPermission fsPermission = permission = setAttr3.getUpdateFields().contains((Object)SetAttr3.SetAttrField.MODE) ? new FsPermission((short)setAttr3.getMode()) : FsPermission.getDefault().applyUMask(umask);
            if (!dfsClient.mkdirs(fileIdPath, permission)) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new MKDIR3Response(Nfs3Status.NFS3ERR_IO, null, null, dirWcc);
            }
            if (!setAttr3.getUpdateFields().contains((Object)SetAttr3.SetAttrField.GID)) {
                setAttr3.getUpdateFields().add(SetAttr3.SetAttrField.GID);
                setAttr3.setGid(authSys.getGid());
            }
            this.setattrInternal(dfsClient, fileIdPath, setAttr3, false);
            postOpObjAttr = Nfs3Utils.getFileAttr(dfsClient, fileIdPath, this.iug);
            objFileHandle = new FileHandle(postOpObjAttr.getFileId());
            WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
            return new MKDIR3Response(Nfs3Status.NFS3_OK, new FileHandle(postOpObjAttr.getFileId()), postOpObjAttr, dirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            if (postOpDirAttr == null) {
                try {
                    postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
                }
                catch (IOException e1) {
                    LOG.info((Object)("Can't get postOpDirAttr for " + dirFileIdPath));
                }
            }
            WccData dirWcc = new WccData(preOpDirAttr, postOpDirAttr);
            if (e instanceof AccessControlException) {
                return new MKDIR3Response(Nfs3Status.NFS3ERR_PERM, objFileHandle, postOpObjAttr, dirWcc);
            }
            return new MKDIR3Response(Nfs3Status.NFS3ERR_IO, objFileHandle, postOpObjAttr, dirWcc);
        }
    }

    public READDIR3Response mknod(XDR xdr, RpcAuthSys authSys) {
        return new READDIR3Response(Nfs3Status.NFS3ERR_NOTSUPP);
    }

    @Override
    public REMOVE3Response remove(XDR xdr, RpcAuthSys authSys) {
        REMOVE3Response response = new REMOVE3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        REMOVE3Request request = null;
        try {
            request = new REMOVE3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid REMOVE request");
            return new REMOVE3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS REMOVE dir fileId: " + dirHandle.getFileId() + " fileName: " + fileName));
        }
        String dirFileIdPath = Nfs3Utils.getFileIdPath(dirHandle);
        WccAttr preOpDirAttr = null;
        Nfs3FileAttributes postOpDirAttr = null;
        try {
            preOpDirAttr = Nfs3Utils.getWccAttr(dfsClient, dirFileIdPath);
            if (preOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new REMOVE3Response(Nfs3Status.NFS3ERR_STALE);
            }
            String fileIdPath = dirFileIdPath + "/" + fileName;
            ExtendedHdfsFileStatus fstat = Nfs3Utils.getFileStatus(dfsClient, fileIdPath);
            if (fstat == null) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new REMOVE3Response(Nfs3Status.NFS3ERR_NOENT, dirWcc);
            }
            if (fstat.isDir()) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new REMOVE3Response(Nfs3Status.NFS3ERR_ISDIR, dirWcc);
            }
            if (!dfsClient.delete(fileIdPath, false)) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new REMOVE3Response(Nfs3Status.NFS3ERR_ACCES, dirWcc);
            }
            WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
            return new REMOVE3Response(Nfs3Status.NFS3_OK, dirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            if (postOpDirAttr == null) {
                try {
                    postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
                }
                catch (IOException e1) {
                    LOG.info((Object)("Can't get postOpDirAttr for " + dirFileIdPath));
                }
            }
            WccData dirWcc = new WccData(preOpDirAttr, postOpDirAttr);
            if (e instanceof AccessControlException) {
                return new REMOVE3Response(Nfs3Status.NFS3ERR_PERM, dirWcc);
            }
            return new REMOVE3Response(Nfs3Status.NFS3ERR_IO, dirWcc);
        }
    }

    @Override
    public RMDIR3Response rmdir(XDR xdr, RpcAuthSys authSys) {
        RMDIR3Response response = new RMDIR3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        RMDIR3Request request = null;
        try {
            request = new RMDIR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid RMDIR request");
            return new RMDIR3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle dirHandle = request.getHandle();
        String fileName = request.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS RMDIR dir fileId: " + dirHandle.getFileId() + " fileName: " + fileName));
        }
        String dirFileIdPath = Nfs3Utils.getFileIdPath(dirHandle);
        WccAttr preOpDirAttr = null;
        Nfs3FileAttributes postOpDirAttr = null;
        try {
            preOpDirAttr = Nfs3Utils.getWccAttr(dfsClient, dirFileIdPath);
            if (preOpDirAttr == null) {
                LOG.info((Object)("Can't get path for dir fileId:" + dirHandle.getFileId()));
                return new RMDIR3Response(Nfs3Status.NFS3ERR_STALE);
            }
            String fileIdPath = dirFileIdPath + "/" + fileName;
            ExtendedHdfsFileStatus fstat = Nfs3Utils.getFileStatus(dfsClient, fileIdPath);
            if (fstat == null) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new RMDIR3Response(Nfs3Status.NFS3ERR_NOENT, dirWcc);
            }
            if (!fstat.isDir()) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new RMDIR3Response(Nfs3Status.NFS3ERR_NOTDIR, dirWcc);
            }
            if (fstat.getChildrenNum() > 0L) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new RMDIR3Response(Nfs3Status.NFS3ERR_NOTEMPTY, dirWcc);
            }
            if (!dfsClient.delete(fileIdPath, false)) {
                WccData dirWcc = Nfs3Utils.createWccData(preOpDirAttr, dfsClient, dirFileIdPath, this.iug);
                return new RMDIR3Response(Nfs3Status.NFS3ERR_ACCES, dirWcc);
            }
            postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
            WccData wccData = new WccData(preOpDirAttr, postOpDirAttr);
            return new RMDIR3Response(Nfs3Status.NFS3_OK, wccData);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            if (postOpDirAttr == null) {
                try {
                    postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
                }
                catch (IOException e1) {
                    LOG.info((Object)("Can't get postOpDirAttr for " + dirFileIdPath));
                }
            }
            WccData dirWcc = new WccData(preOpDirAttr, postOpDirAttr);
            if (e instanceof AccessControlException) {
                return new RMDIR3Response(Nfs3Status.NFS3ERR_PERM, dirWcc);
            }
            return new RMDIR3Response(Nfs3Status.NFS3ERR_IO, dirWcc);
        }
    }

    @Override
    public RENAME3Response rename(XDR xdr, RpcAuthSys authSys) {
        RENAME3Response response = new RENAME3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        RENAME3Request request = null;
        try {
            request = new RENAME3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid RENAME request");
            return new RENAME3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle fromHandle = request.getFromDirHandle();
        String fromName = request.getFromName();
        FileHandle toHandle = request.getToDirHandle();
        String toName = request.getToName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS RENAME from: " + fromHandle.getFileId() + "/" + fromName + " to: " + toHandle.getFileId() + "/" + toName));
        }
        String fromDirFileIdPath = Nfs3Utils.getFileIdPath(fromHandle);
        String toDirFileIdPath = Nfs3Utils.getFileIdPath(toHandle);
        WccAttr fromPreOpAttr = null;
        WccAttr toPreOpAttr = null;
        WccData fromDirWcc = null;
        WccData toDirWcc = null;
        try {
            String dst;
            fromPreOpAttr = Nfs3Utils.getWccAttr(dfsClient, fromDirFileIdPath);
            if (fromPreOpAttr == null) {
                LOG.info((Object)("Can't get path for fromHandle fileId:" + fromHandle.getFileId()));
                return new RENAME3Response(Nfs3Status.NFS3ERR_STALE);
            }
            toPreOpAttr = Nfs3Utils.getWccAttr(dfsClient, toDirFileIdPath);
            if (toPreOpAttr == null) {
                LOG.info((Object)("Can't get path for toHandle fileId:" + toHandle.getFileId()));
                return new RENAME3Response(Nfs3Status.NFS3ERR_STALE);
            }
            String src = fromDirFileIdPath + "/" + fromName;
            if (!dfsClient.rename(src, dst = toDirFileIdPath + "/" + toName)) {
                fromDirWcc = Nfs3Utils.createWccData(fromPreOpAttr, dfsClient, fromDirFileIdPath, this.iug);
                toDirWcc = Nfs3Utils.createWccData(toPreOpAttr, dfsClient, toDirFileIdPath, this.iug);
                LOG.error((Object)("Couldn't rename " + src + " to " + dst));
                return new RENAME3Response(Nfs3Status.NFS3ERR_ACCES, fromDirWcc, toDirWcc);
            }
            fromDirWcc = Nfs3Utils.createWccData(fromPreOpAttr, dfsClient, fromDirFileIdPath, this.iug);
            toDirWcc = Nfs3Utils.createWccData(toPreOpAttr, dfsClient, toDirFileIdPath, this.iug);
            return new RENAME3Response(Nfs3Status.NFS3_OK, fromDirWcc, toDirWcc);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            try {
                fromDirWcc = Nfs3Utils.createWccData(fromPreOpAttr, dfsClient, fromDirFileIdPath, this.iug);
                toDirWcc = Nfs3Utils.createWccData(toPreOpAttr, dfsClient, toDirFileIdPath, this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpDirAttr for " + fromDirFileIdPath + " or" + toDirFileIdPath));
            }
            if (e instanceof AccessControlException) {
                return new RENAME3Response(Nfs3Status.NFS3ERR_PERM, fromDirWcc, toDirWcc);
            }
            return new RENAME3Response(Nfs3Status.NFS3ERR_IO, fromDirWcc, toDirWcc);
        }
    }

    @Override
    public SYMLINK3Response symlink(XDR xdr, RpcAuthSys authSys) {
        return new SYMLINK3Response(Nfs3Status.NFS3ERR_NOTSUPP);
    }

    public READDIR3Response link(XDR xdr, RpcAuthSys authSys) {
        return new READDIR3Response(Nfs3Status.NFS3ERR_NOTSUPP);
    }

    @Override
    public READDIR3Response readdir(XDR xdr, RpcAuthSys authSys) {
        int i;
        READDIR3Response.Entry3[] entries;
        boolean eof;
        ExtendedHdfsFileStatus dirStatus;
        READDIR3Response response = new READDIR3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        READDIR3Request request = null;
        try {
            request = new READDIR3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid READDIR request");
            return new READDIR3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle handle = request.getHandle();
        long cookie = request.getCookie();
        if (cookie < 0L) {
            LOG.error((Object)("Invalid READDIR request, with negitve cookie:" + cookie));
            return new READDIR3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        long count = request.getCount();
        if (count <= 0L) {
            LOG.info((Object)("Nonpositive count in invalid READDIR request:" + count));
            return new READDIR3Response(Nfs3Status.NFS3_OK);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS READDIR fileId: " + handle.getFileId() + " cookie: " + cookie + " count: " + count));
        }
        ExtendedDirectoryListing dlisting = null;
        Nfs3FileAttributes postOpAttr = null;
        long dotdotFileId = 0L;
        try {
            byte[] startAfter;
            String dirFileIdPath = Nfs3Utils.getFileIdPath(handle);
            dirStatus = dfsClient.getExtendedFileInfo(dirFileIdPath);
            if (dirStatus == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIR3Response(Nfs3Status.NFS3ERR_STALE);
            }
            if (!dirStatus.isDir()) {
                LOG.error((Object)("Can't readdir for regular file, fileId:" + handle.getFileId()));
                return new READDIR3Response(Nfs3Status.NFS3ERR_NOTDIR);
            }
            long cookieVerf = request.getCookieVerf();
            if (cookieVerf != 0L && cookieVerf != dirStatus.getModificationTime()) {
                LOG.error((Object)("CookierVerf mismatch. request cookierVerf:" + cookieVerf + " dir cookieVerf:" + dirStatus.getModificationTime()));
                return new READDIR3Response(Nfs3Status.NFS3ERR_BAD_COOKIE);
            }
            if (cookie == 0L) {
                String dotdotFileIdPath = dirFileIdPath + "/..";
                ExtendedHdfsFileStatus dotdotStatus = dfsClient.getExtendedFileInfo(dotdotFileIdPath);
                if (dotdotStatus == null) {
                    throw new IOException("Can't get path for handle path:" + dotdotFileIdPath);
                }
                dotdotFileId = dotdotStatus.getFileId();
            }
            if (cookie == 0L) {
                startAfter = HdfsFileStatus.EMPTY_NAME;
            } else {
                String inodeIdPath = Nfs3Utils.getFileIdPath(cookie);
                startAfter = inodeIdPath.getBytes();
            }
            dlisting = dfsClient.listExtendedPaths(dirFileIdPath, startAfter);
            postOpAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
            if (postOpAttr == null) {
                LOG.error((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIR3Response(Nfs3Status.NFS3ERR_STALE);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new READDIR3Response(Nfs3Status.NFS3ERR_IO);
        }
        ExtendedHdfsFileStatus[] fstatus = dlisting.getPartialListing();
        int n = (int)Math.min((long)fstatus.length, count - 2L);
        boolean bl = n < fstatus.length ? false : (eof = dlisting.getRemainingEntries() == 0);
        if (cookie == 0L) {
            entries = new READDIR3Response.Entry3[n + 2];
            entries[0] = new READDIR3Response.Entry3(postOpAttr.getFileId(), ".", 0L);
            entries[1] = new READDIR3Response.Entry3(dotdotFileId, "..", dotdotFileId);
            for (i = 2; i < n + 2; ++i) {
                entries[i] = new READDIR3Response.Entry3(fstatus[i - 2].getFileId(), fstatus[i - 2].getLocalName(), fstatus[i - 2].getFileId());
            }
        } else {
            entries = new READDIR3Response.Entry3[n];
            for (i = 0; i < n; ++i) {
                entries[i] = new READDIR3Response.Entry3(fstatus[i].getFileId(), fstatus[i].getLocalName(), fstatus[i].getFileId());
            }
        }
        READDIR3Response.DirList3 dirList = new READDIR3Response.DirList3(entries, eof);
        return new READDIR3Response(Nfs3Status.NFS3_OK, postOpAttr, dirStatus.getModificationTime(), dirList);
    }

    public READDIRPLUS3Response readdirplus(XDR xdr, RpcAuthSys authSys) {
        int i;
        READDIRPLUS3Response.EntryPlus3[] entries;
        boolean eof;
        ExtendedHdfsFileStatus dirStatus;
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_SERVERFAULT);
        }
        READDIRPLUS3Request request = null;
        try {
            request = new READDIRPLUS3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid READDIRPLUS request");
            return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle handle = request.getHandle();
        long cookie = request.getCookie();
        if (cookie < 0L) {
            LOG.error((Object)("Invalid READDIRPLUS request, with negitve cookie:" + cookie));
            return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        long dirCount = request.getDirCount();
        if (dirCount <= 0L) {
            LOG.info((Object)("Nonpositive count in invalid READDIRPLUS request:" + dirCount));
            return new READDIRPLUS3Response(Nfs3Status.NFS3_OK);
        }
        int maxCount = request.getMaxCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS READDIRPLUS fileId: " + handle.getFileId() + " cookie: " + cookie + " dirCount: " + dirCount + " maxCount: " + maxCount));
        }
        ExtendedDirectoryListing dlisting = null;
        Nfs3FileAttributes postOpDirAttr = null;
        long dotdotFileId = 0L;
        try {
            byte[] startAfter;
            String dirFileIdPath = Nfs3Utils.getFileIdPath(handle);
            dirStatus = dfsClient.getExtendedFileInfo(dirFileIdPath);
            if (dirStatus == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_STALE);
            }
            if (!dirStatus.isDir()) {
                LOG.error((Object)("Can't readdirplus for regular file, fileId:" + handle.getFileId()));
                return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_NOTDIR);
            }
            long cookieVerf = request.getCookieVerf();
            if (cookieVerf != 0L && cookieVerf != dirStatus.getModificationTime()) {
                LOG.error((Object)("CookierVerf mismatch. request cookierVerf:" + cookieVerf + " dir cookieVerf:" + dirStatus.getModificationTime()));
                return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_BAD_COOKIE);
            }
            if (cookie == 0L) {
                String dotdotFileIdPath = dirFileIdPath + "/..";
                ExtendedHdfsFileStatus dotdotStatus = dfsClient.getExtendedFileInfo(dotdotFileIdPath);
                if (dotdotStatus == null) {
                    throw new IOException("Can't get path for handle path:" + dotdotFileIdPath);
                }
                dotdotFileId = dotdotStatus.getFileId();
            }
            if (cookie == 0L) {
                startAfter = HdfsFileStatus.EMPTY_NAME;
            } else {
                String inodeIdPath = Nfs3Utils.getFileIdPath(cookie);
                startAfter = inodeIdPath.getBytes();
            }
            dlisting = dfsClient.listExtendedPaths(dirFileIdPath, startAfter);
            postOpDirAttr = Nfs3Utils.getFileAttr(dfsClient, dirFileIdPath, this.iug);
            if (postOpDirAttr == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_STALE);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new READDIRPLUS3Response(Nfs3Status.NFS3ERR_IO);
        }
        ExtendedHdfsFileStatus[] fstatus = dlisting.getPartialListing();
        int n = (int)Math.min((long)fstatus.length, dirCount - 2L);
        boolean bl = n < fstatus.length ? false : (eof = dlisting.getRemainingEntries() == 0);
        if (cookie == 0L) {
            entries = new READDIRPLUS3Response.EntryPlus3[n + 2];
            entries[0] = new READDIRPLUS3Response.EntryPlus3(postOpDirAttr.getFileId(), ".", 0L, postOpDirAttr, new FileHandle(postOpDirAttr.getFileid()));
            entries[1] = new READDIRPLUS3Response.EntryPlus3(dotdotFileId, "..", dotdotFileId, postOpDirAttr, new FileHandle(dotdotFileId));
            for (i = 2; i < n + 2; ++i) {
                Nfs3FileAttributes attr;
                long fileId = fstatus[i - 2].getFileId();
                FileHandle childHandle = new FileHandle(fileId);
                try {
                    attr = this.writeManager.getFileAttr(dfsClient, childHandle, this.iug);
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't get file attributes for fileId:" + fileId + " error:" + e));
                    continue;
                }
                entries[i] = new READDIRPLUS3Response.EntryPlus3(fileId, fstatus[i - 2].getLocalName(), fileId, attr, childHandle);
            }
        } else {
            entries = new READDIRPLUS3Response.EntryPlus3[n];
            for (i = 0; i < n; ++i) {
                Nfs3FileAttributes attr;
                long fileId = fstatus[i].getFileId();
                FileHandle childHandle = new FileHandle(fileId);
                try {
                    attr = this.writeManager.getFileAttr(dfsClient, childHandle, this.iug);
                }
                catch (IOException e) {
                    LOG.error((Object)("Can't get file attributes for fileId:" + fileId + " error:" + e));
                    continue;
                }
                entries[i] = new READDIRPLUS3Response.EntryPlus3(fileId, fstatus[i].getLocalName(), fileId, attr, childHandle);
            }
        }
        READDIRPLUS3Response.DirListPlus3 dirListPlus = new READDIRPLUS3Response.DirListPlus3(entries, eof);
        return new READDIRPLUS3Response(Nfs3Status.NFS3_OK, postOpDirAttr, dirStatus.getModificationTime(), dirListPlus);
    }

    @Override
    public FSSTAT3Response fsstat(XDR xdr, RpcAuthSys authSys) {
        FSSTAT3Response response = new FSSTAT3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        FSSTAT3Request request = null;
        try {
            request = new FSSTAT3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid FSSTAT request");
            return new FSSTAT3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS FSSTAT fileId: " + handle.getFileId()));
        }
        try {
            DistributedFileSystem.DiskStatus diskStatus = this.superUserClient.getDiskStatus();
            long totalBytes = diskStatus.getCapacity();
            long freeBytes = diskStatus.getRemaining();
            Nfs3FileAttributes attrs = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            if (attrs == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new FSSTAT3Response(Nfs3Status.NFS3ERR_STALE);
            }
            long maxFsObjects = this.config.getLong("dfs.max.objects", 0L);
            if (maxFsObjects == 0L) {
                maxFsObjects = Integer.MAX_VALUE;
            }
            return new FSSTAT3Response(Nfs3Status.NFS3_OK, attrs, totalBytes, freeBytes, freeBytes, maxFsObjects, maxFsObjects, maxFsObjects, 0);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new FSSTAT3Response(Nfs3Status.NFS3ERR_IO);
        }
    }

    @Override
    public FSINFO3Response fsinfo(XDR xdr, RpcAuthSys authSys) {
        FSINFO3Response response = new FSINFO3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        FSINFO3Request request = null;
        try {
            request = new FSINFO3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid FSINFO request");
            return new FSINFO3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS FSINFO fileId: " + handle.getFileId()));
        }
        try {
            int rtmax = 65536;
            int wtmax = 65536;
            int dtperf = 65536;
            Nfs3FileAttributes attrs = Nfs3Utils.getFileAttr(dfsClient, Nfs3Utils.getFileIdPath(handle), this.iug);
            if (attrs == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new FSINFO3Response(Nfs3Status.NFS3ERR_STALE);
            }
            int fsProperty = 24;
            return new FSINFO3Response(Nfs3Status.NFS3_OK, attrs, rtmax, rtmax, 1, wtmax, wtmax, 1, dtperf, Long.MAX_VALUE, new NfsTime(1L), fsProperty);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new FSINFO3Response(Nfs3Status.NFS3ERR_IO);
        }
    }

    @Override
    public PATHCONF3Response pathconf(XDR xdr, RpcAuthSys authSys) {
        PATHCONF3Response response = new PATHCONF3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        PATHCONF3Request request = null;
        try {
            request = new PATHCONF3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid PATHCONF request");
            return new PATHCONF3Response(Nfs3Status.NFS3ERR_INVAL);
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS PATHCONF fileId: " + handle.getFileId()));
        }
        try {
            Nfs3FileAttributes attrs = Nfs3Utils.getFileAttr(dfsClient, Nfs3Utils.getFileIdPath(handle), this.iug);
            if (attrs == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new PATHCONF3Response(Nfs3Status.NFS3ERR_STALE);
            }
            return new PATHCONF3Response(Nfs3Status.NFS3_OK, attrs, 0, 8000, true, false, false, true);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            return new PATHCONF3Response(Nfs3Status.NFS3ERR_IO);
        }
    }

    @Override
    public COMMIT3Response commit(XDR xdr, RpcAuthSys authSys) {
        COMMIT3Response response = new COMMIT3Response(Nfs3Status.NFS3_OK);
        String uname = this.authSysCheck(authSys);
        DFSClient dfsClient = this.clientCache.get(uname);
        if (dfsClient == null) {
            response.setStatus(Nfs3Status.NFS3ERR_SERVERFAULT);
            return response;
        }
        COMMIT3Request request = null;
        try {
            request = new COMMIT3Request(xdr);
        }
        catch (IOException e) {
            LOG.error((Object)"Invalid COMMIT request");
            response.setStatus(Nfs3Status.NFS3ERR_INVAL);
            return response;
        }
        FileHandle handle = request.getHandle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NFS COMMIT fileId: " + handle.getFileId() + " offset=" + request.getOffset() + " count=" + request.getCount()));
        }
        String fileIdPath = Nfs3Utils.getFileIdPath(handle);
        WccAttr preOpAttr = null;
        try {
            preOpAttr = Nfs3Utils.getWccAttr(dfsClient, fileIdPath);
            if (preOpAttr == null) {
                LOG.info((Object)("Can't get path for fileId:" + handle.getFileId()));
                return new COMMIT3Response(Nfs3Status.NFS3ERR_STALE);
            }
            long commitOffset = request.getCount() == 0 ? 0L : request.getOffset() + (long)request.getCount();
            int status = this.writeManager.handleCommit(handle, commitOffset) ? Nfs3Status.NFS3_OK : Nfs3Status.NFS3ERR_IO;
            Nfs3FileAttributes postOpAttr = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            WccData fileWcc = new WccData(preOpAttr, postOpAttr);
            return new COMMIT3Response(status, fileWcc, Nfs3Constant.WRITE_COMMIT_VERF);
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception ", (Throwable)e);
            Nfs3FileAttributes postOpAttr = null;
            try {
                postOpAttr = this.writeManager.getFileAttr(dfsClient, handle, this.iug);
            }
            catch (IOException e1) {
                LOG.info((Object)("Can't get postOpAttr for fileId: " + handle.getFileId()));
            }
            WccData fileWcc = new WccData(preOpAttr, postOpAttr);
            return new COMMIT3Response(Nfs3Status.NFS3ERR_IO, fileWcc, Nfs3Constant.WRITE_COMMIT_VERF);
        }
    }

    private String authSysCheck(RpcAuthSys authSys) {
        return this.iug.getUserName(authSys.getUid(), "nobody");
    }

    @Override
    public XDR handleInternal(RpcCall rpcCall, XDR xdr, XDR out, InetAddress client, Channel channel) {
        int procedure = rpcCall.getProcedure();
        int xid = rpcCall.getXid();
        RpcAuthSys authSys = null;
        if (procedure != 0) {
            if (rpcCall.getCredential().getFlavor() != RpcAuthInfo.AuthFlavor.AUTH_SYS) {
                LOG.info((Object)("Wrong RPC AUTH flavor, " + (Object)((Object)rpcCall.getCredential().getFlavor()) + " is not AUTH_SYS."));
                XDR reply = new XDR();
                reply = RpcDeniedReply.voidReply(reply, xid, RpcReply.ReplyState.MSG_ACCEPTED, RpcDeniedReply.RejectState.AUTH_ERROR);
                return reply;
            }
            authSys = RpcAuthSys.from(rpcCall.getCredential().getBody());
        }
        NFS3Response response = null;
        if (procedure == 0) {
            response = this.nullProcedure();
        } else if (procedure == 1) {
            response = this.getattr(xdr, authSys);
        } else if (procedure == 2) {
            response = this.setattr(xdr, authSys);
        } else if (procedure == 3) {
            response = this.lookup(xdr, authSys);
        } else if (procedure == 4) {
            response = this.access(xdr, authSys);
        } else if (procedure == 5) {
            response = this.readlink(xdr, authSys);
        } else if (procedure == 6) {
            response = this.read(xdr, authSys);
        } else if (procedure == 7) {
            response = this.write(xdr, channel, xid, authSys);
        } else if (procedure == 8) {
            response = this.create(xdr, authSys);
        } else if (procedure == 9) {
            response = this.mkdir(xdr, authSys);
        } else if (procedure == 10) {
            response = this.symlink(xdr, authSys);
        } else if (procedure == 11) {
            response = this.mknod(xdr, authSys);
        } else if (procedure == 12) {
            response = this.remove(xdr, authSys);
        } else if (procedure == 13) {
            response = this.rmdir(xdr, authSys);
        } else if (procedure == 14) {
            response = this.rename(xdr, authSys);
        } else if (procedure == 15) {
            response = this.link(xdr, authSys);
        } else if (procedure == 16) {
            response = this.readdir(xdr, authSys);
        } else if (procedure == 17) {
            response = this.readdirplus(xdr, authSys);
        } else if (procedure == 18) {
            response = this.fsstat(xdr, authSys);
        } else if (procedure == 19) {
            response = this.fsinfo(xdr, authSys);
        } else if (procedure == 20) {
            response = this.pathconf(xdr, authSys);
        } else if (procedure == 21) {
            response = this.commit(xdr, authSys);
        } else {
            RpcAcceptedReply.voidReply(out, xid, RpcAcceptedReply.AcceptState.PROC_UNAVAIL);
        }
        if (response != null) {
            out = response.send(out, xid);
        }
        return out;
    }

    @Override
    protected boolean isIdempotent(RpcCall call) {
        return RpcProgramNfs3.isIdempotent(call.getProcedure());
    }

    public static boolean isIdempotent(int procedure) {
        return procedure != 8 && procedure != 12 && procedure != 9 && procedure != 11 && procedure != 15 && procedure != 13 && procedure != 10 && procedure != 14;
    }
}

