/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.jboss.netty.channel.Channel;

class WriteCtx {
    public static final Log LOG = LogFactory.getLog(WriteCtx.class);
    private final FileHandle handle;
    private final long offset;
    private final int count;
    private final Nfs3Constant.WriteStableHow stableHow;
    private byte[] data;
    private final Channel channel;
    private final int xid;
    private boolean replied;
    public static final int ALLOW_DUMP = 0;
    public static final int NO_DUMP = 1;
    public static final int DUMPED = 2;
    private int dataState;
    private RandomAccessFile raf;
    private long dumpFileOffset;

    public int getDataState() {
        return this.dataState;
    }

    public void setDataState(int dataState) {
        this.dataState = dataState;
    }

    public long dumpData(FileOutputStream dumpOut, RandomAccessFile raf) throws IOException {
        if (this.dataState != 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No need to dump with status(replied,dataState):(" + this.replied + "," + this.dataState + ")"));
            }
            return 0L;
        }
        this.raf = raf;
        this.dumpFileOffset = dumpOut.getChannel().position();
        dumpOut.write(this.data, 0, this.count);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("After dump, new dumpFileOffset:" + this.dumpFileOffset));
        }
        this.data = null;
        this.dataState = 2;
        return this.count;
    }

    public FileHandle getHandle() {
        return this.handle;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    public Nfs3Constant.WriteStableHow getStableHow() {
        return this.stableHow;
    }

    public byte[] getData() throws IOException {
        if (this.dataState != 2) {
            if (this.data == null) {
                throw new IOException("Data is not dumpted but has null:" + this);
            }
        } else {
            if (this.data != null) {
                throw new IOException("Data is dumpted but not null");
            }
            this.data = new byte[this.count];
            this.raf.seek(this.dumpFileOffset);
            this.raf.read(this.data, 0, this.count);
        }
        return this.data;
    }

    Channel getChannel() {
        return this.channel;
    }

    int getXid() {
        return this.xid;
    }

    boolean getReplied() {
        return this.replied;
    }

    void setReplied(boolean replied) {
        this.replied = replied;
    }

    WriteCtx(FileHandle handle, long offset, int count, Nfs3Constant.WriteStableHow stableHow, byte[] data, Channel channel, int xid, boolean replied, int dataState) {
        this.handle = handle;
        this.offset = offset;
        this.count = count;
        this.stableHow = stableHow;
        this.data = data;
        this.channel = channel;
        this.xid = xid;
        this.replied = replied;
        this.dataState = dataState;
        this.raf = null;
    }

    public String toString() {
        return "Id:" + this.handle.getFileId() + " offset:" + this.offset + " count:" + this.count + " stableHow:" + (Object)((Object)this.stableHow) + " replied:" + this.replied + " dataState:" + this.dataState + " xid:" + this.xid;
    }
}

