/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.ExtendedHdfsFileStatus;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class ExtendedDirectoryListing
implements Writable {
    private ExtendedHdfsFileStatus[] partialListing;
    private int remainingEntries;

    public ExtendedDirectoryListing() {
    }

    public ExtendedDirectoryListing(ExtendedHdfsFileStatus[] partialListing, int remainingEntries) {
        if (partialListing == null) {
            throw new IllegalArgumentException("partial listing should not be null");
        }
        if (partialListing.length == 0 && remainingEntries != 0) {
            throw new IllegalArgumentException("Partial listing is empty but the number of remaining entries is not zero");
        }
        this.partialListing = partialListing;
        this.remainingEntries = remainingEntries;
    }

    public ExtendedHdfsFileStatus[] getPartialListing() {
        return this.partialListing;
    }

    public int getRemainingEntries() {
        return this.remainingEntries;
    }

    public boolean hasMore() {
        return this.remainingEntries != 0;
    }

    public byte[] getLastName() {
        if (this.partialListing.length == 0) {
            return null;
        }
        return this.partialListing[this.partialListing.length - 1].getLocalNameInBytes();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int numEntries = in.readInt();
        this.partialListing = new ExtendedHdfsFileStatus[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            this.partialListing[i] = new ExtendedHdfsFileStatus();
            this.partialListing[i].readFields(in);
        }
        this.remainingEntries = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.partialListing.length);
        for (ExtendedHdfsFileStatus fileStatus : this.partialListing) {
            fileStatus.write(out);
        }
        out.writeInt(this.remainingEntries);
    }

    static {
        WritableFactories.setFactory(ExtendedDirectoryListing.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new ExtendedDirectoryListing();
            }
        });
    }
}

