/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class ExtendedHdfsFileStatus
extends HdfsFileStatus {
    private long fileId;
    private int childrenNum;

    public ExtendedHdfsFileStatus() {
        this(0L, 0, 0L, false, 0, 0L, 0L, 0L, null, null, null, null);
    }

    public ExtendedHdfsFileStatus(long fileId, int childrenNum, long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, byte[] path) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, path);
        this.fileId = fileId;
        this.childrenNum = childrenNum;
    }

    public final long getFileId() {
        return this.fileId;
    }

    public final long getChildrenNum() {
        return this.childrenNum;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.fileId);
        out.writeInt(this.childrenNum);
        super.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.fileId = in.readLong();
        this.childrenNum = in.readInt();
        super.readFields(in);
    }

    static {
        WritableFactories.setFactory(ExtendedHdfsFileStatus.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new ExtendedHdfsFileStatus();
            }
        });
    }
}

