/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;

public class SnapshotDiffReport
implements Writable {
    private static final String LINE_SEPARATOR;
    private String snapshotRoot;
    private String fromSnapshot;
    private String toSnapshot;
    private final List<DiffReportEntry> diffList;

    public SnapshotDiffReport() {
        this.snapshotRoot = "";
        this.fromSnapshot = "";
        this.toSnapshot = "";
        this.diffList = new ArrayList<DiffReportEntry>();
    }

    public SnapshotDiffReport(String snapshotRoot, String fromSnapshot, String toSnapshot, List<DiffReportEntry> entryList) {
        this.snapshotRoot = snapshotRoot;
        this.fromSnapshot = fromSnapshot;
        this.toSnapshot = toSnapshot;
        this.diffList = entryList != null ? entryList : Collections.emptyList();
    }

    public String getSnapshotRoot() {
        return this.snapshotRoot;
    }

    public String getFromSnapshot() {
        return this.fromSnapshot;
    }

    public String getLaterSnapshotName() {
        return this.toSnapshot;
    }

    public List<DiffReportEntry> getDiffList() {
        return this.diffList;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        String from = this.fromSnapshot == null || this.fromSnapshot.isEmpty() ? "current directory" : "snapshot " + this.fromSnapshot;
        String to = this.toSnapshot == null || this.toSnapshot.isEmpty() ? "current directory" : "snapshot " + this.toSnapshot;
        str.append("Difference between " + from + " and " + to + " under directory " + this.snapshotRoot + ":" + LINE_SEPARATOR);
        for (DiffReportEntry entry : this.diffList) {
            str.append(entry.toString() + LINE_SEPARATOR);
        }
        return str.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.snapshotRoot);
        Text.writeString(out, this.fromSnapshot);
        Text.writeString(out, this.toSnapshot);
        out.writeInt(this.diffList.size());
        for (DiffReportEntry entry : this.diffList) {
            entry.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.snapshotRoot = Text.readString(in);
        this.fromSnapshot = Text.readString(in);
        this.toSnapshot = Text.readString(in);
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            DiffReportEntry entry = new DiffReportEntry();
            entry.readFields(in);
            this.diffList.add(entry);
        }
    }

    static {
        WritableFactories.setFactory(SnapshotDiffReport.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new SnapshotDiffReport();
            }
        });
        LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    }

    public static class DiffReportEntry
    implements Writable {
        private DiffType type;
        private byte[] relativePath;

        public DiffReportEntry() {
            this.relativePath = DFSUtil.EMPTY_BYTES;
        }

        public DiffReportEntry(DiffType type, byte[] path) {
            this.type = type;
            this.relativePath = path;
        }

        public DiffReportEntry(DiffType type, byte[][] pathComponents) {
            this.type = type;
            this.relativePath = DFSUtil.byteArray2bytes(pathComponents);
        }

        public String toString() {
            return this.type.getLabel() + "\t" + this.getRelativePathString();
        }

        public DiffType getType() {
            return this.type;
        }

        public String getRelativePathString() {
            String path = DFSUtil.bytes2String(this.relativePath);
            if (path.isEmpty()) {
                return ".";
            }
            return "./" + path;
        }

        public byte[] getRelativePath() {
            return this.relativePath;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other != null && other instanceof DiffReportEntry) {
                DiffReportEntry entry = (DiffReportEntry)other;
                return this.type.equals((Object)entry.getType()) && Arrays.equals(this.relativePath, entry.getRelativePath());
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.relativePath);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            Text.writeString(out, this.type.label);
            out.writeShort(this.relativePath.length);
            out.write(this.relativePath);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.type = DiffType.getTypeFromLabel(Text.readString(in));
            short length = in.readShort();
            byte[] byArray = this.relativePath = length == 0 ? DFSUtil.EMPTY_BYTES : new byte[length];
            if (length > 0) {
                in.readFully(this.relativePath);
            }
        }

        static {
            WritableFactories.setFactory(DiffReportEntry.class, new WritableFactory(){

                @Override
                public Writable newInstance() {
                    return new DiffReportEntry();
                }
            });
        }
    }

    public static enum DiffType {
        CREATE("+"),
        MODIFY("M"),
        DELETE("-"),
        RENAME("R");

        private String label;

        private DiffType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static DiffType getTypeFromLabel(String label) {
            if (label.equals(CREATE.getLabel())) {
                return CREATE;
            }
            if (label.equals(MODIFY.getLabel())) {
                return MODIFY;
            }
            if (label.equals(DELETE.getLabel())) {
                return DELETE;
            }
            if (label.equals(RENAME.getLabel())) {
                return RENAME;
            }
            return null;
        }
    }
}

