/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common;

import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;

public interface HdfsConstants {
    public static final int READ_TIMEOUT = 60000;
    public static final int READ_TIMEOUT_EXTENSION = 3000;
    public static final int WRITE_TIMEOUT = 480000;
    public static final int WRITE_TIMEOUT_EXTENSION = 5000;
    public static final long QUOTA_DONT_SET = Long.MAX_VALUE;
    public static final String NN_RECOVERY_LEASEHOLDER = "NN_Recovery";
    public static final String DOT_SNAPSHOT_DIR = ".snapshot";
    public static final byte[] DOT_SNAPSHOT_DIR_BYTES = DFSUtil.string2Bytes(".snapshot");
    public static final String SEPARATOR_DOT_SNAPSHOT_DIR = "/.snapshot";

    public static enum StartupOption {
        FORMAT("-format"),
        REGULAR("-regular"),
        UPGRADE("-upgrade"),
        RECOVER("-recover"),
        FORCE("-force"),
        ROLLBACK("-rollback"),
        FINALIZE("-finalize"),
        IMPORT("-importCheckpoint"),
        NONINTERACTIVE("-nonInteractive");

        private int force = 0;
        private boolean isConfirmationNeeded = true;
        private boolean isInteractive = true;
        private String name = null;

        private StartupOption(String arg) {
            this.name = arg;
        }

        public String getName() {
            return this.name;
        }

        public MetaRecoveryContext createRecoveryContext() {
            if (!this.name.equals(StartupOption.RECOVER.name)) {
                return null;
            }
            return new MetaRecoveryContext(this.force);
        }

        public void setForce(int force) {
            this.force = force;
        }

        public int getForce() {
            return this.force;
        }

        public void setConfirmationNeeded(boolean confirmationNeeded) {
            this.isConfirmationNeeded = confirmationNeeded;
        }

        public boolean getConfirmationNeeded() {
            return this.isConfirmationNeeded;
        }

        public void setInteractive(boolean interactive) {
            this.isInteractive = interactive;
        }

        public boolean getInteractive() {
            return this.isInteractive;
        }
    }

    public static enum NodeType {
        NAME_NODE,
        DATA_NODE;

    }
}

