/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Iterator;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.util.GSet;
import org.apache.hadoop.hdfs.util.LightWeightGSet;

public class BlocksMap {
    private final int capacity = LightWeightGSet.computeCapacity(2.0, "BlocksMap");
    private GSet<Block, BlockInfo> blocks = new LightWeightGSet<Block, BlockInfo>(this.capacity);

    BlocksMap(int initialCapacity, float loadFactor) {
    }

    void close() {
        if (this.blocks != null) {
            this.blocks.clear();
            this.blocks = null;
        }
    }

    private BlockInfo checkBlockInfo(Block b, int replication) {
        BlockInfo info = this.blocks.get(b);
        if (info == null) {
            info = new BlockInfo(b, replication);
            this.blocks.put(info);
        }
        return info;
    }

    INodeFile getINode(Block b) {
        BlockInfo info = this.blocks.get(b);
        return info != null ? info.inode : null;
    }

    BlockInfo addINode(Block b, INodeFile iNode) {
        BlockInfo info = this.checkBlockInfo(b, iNode.getBlockReplication());
        info.inode = iNode;
        return info;
    }

    void removeINode(Block b) {
        BlockInfo info = this.blocks.get(b);
        if (info != null) {
            info.inode = null;
            if (info.getDatanode(0) == null) {
                this.blocks.remove(b);
            }
        }
    }

    void removeBlock(BlockInfo blockInfo) {
        if (blockInfo == null) {
            return;
        }
        blockInfo.inode = null;
        for (int idx = blockInfo.numNodes() - 1; idx >= 0; --idx) {
            DatanodeDescriptor dn = blockInfo.getDatanode(idx);
            dn.removeBlock(blockInfo);
        }
        this.blocks.remove(blockInfo);
    }

    BlockInfo getStoredBlock(Block b) {
        return this.blocks.get(b);
    }

    BlockInfo getStoredBlockWithoutMatchingGS(Block b) {
        return this.blocks.get(new Block(b.getBlockId()));
    }

    Iterator<DatanodeDescriptor> nodeIterator(Block b) {
        return new NodeIterator(this.blocks.get(b));
    }

    int numNodes(Block b) {
        BlockInfo info = this.blocks.get(b);
        return info == null ? 0 : info.numNodes();
    }

    boolean addNode(Block b, DatanodeDescriptor node, int replication) {
        BlockInfo info = this.checkBlockInfo(b, replication);
        return node.addBlock(info);
    }

    boolean removeNode(Block b, DatanodeDescriptor node) {
        BlockInfo info = this.blocks.get(b);
        if (info == null) {
            return false;
        }
        boolean removed = node.removeBlock(info);
        if (info.getDatanode(0) == null && info.inode == null) {
            this.blocks.remove(b);
        }
        return removed;
    }

    int size() {
        return this.blocks.size();
    }

    Iterable<BlockInfo> getBlocks() {
        return this.blocks;
    }

    boolean contains(Block block) {
        return this.blocks.contains(block);
    }

    boolean contains(Block block, DatanodeDescriptor datanode) {
        BlockInfo info = this.blocks.get(block);
        if (info == null) {
            return false;
        }
        return -1 != info.findDatanode(datanode);
    }

    public int getCapacity() {
        return this.capacity;
    }

    private static class NodeIterator
    implements Iterator<DatanodeDescriptor> {
        private BlockInfo blockInfo;
        private int nextIdx = 0;

        NodeIterator(BlockInfo blkInfo) {
            this.blockInfo = blkInfo;
        }

        @Override
        public boolean hasNext() {
            return this.blockInfo != null && this.nextIdx < this.blockInfo.getCapacity() && this.blockInfo.getDatanode(this.nextIdx) != null;
        }

        @Override
        public DatanodeDescriptor next() {
            return this.blockInfo.getDatanode(this.nextIdx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }

    public static class BlockInfo
    extends Block
    implements LightWeightGSet.LinkedElement {
        public static final BlockInfo[] EMPTY_ARRAY = new BlockInfo[0];
        private INodeFile inode;
        private LightWeightGSet.LinkedElement nextLinkedElement;
        private Object[] triplets;

        public BlockInfo(int replication) {
            this.triplets = new Object[3 * replication];
            this.inode = null;
        }

        BlockInfo(Block blk, int replication) {
            super(blk);
            this.triplets = new Object[3 * replication];
            this.inode = null;
        }

        public INodeFile getINode() {
            return this.inode;
        }

        void setINode(INodeFile inode) {
            this.inode = inode;
        }

        DatanodeDescriptor getDatanode(int index) {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
            DatanodeDescriptor node = (DatanodeDescriptor)this.triplets[index * 3];
            assert (node == null || DatanodeDescriptor.class.getName().equals(node.getClass().getName())) : "DatanodeDescriptor is expected at " + index * 3;
            return node;
        }

        BlockInfo getPrevious(int index) {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
            BlockInfo info = (BlockInfo)this.triplets[index * 3 + 1];
            assert (info == null || BlockInfo.class.getName().equals(info.getClass().getName())) : "BlockInfo is expected at " + index * 3;
            return info;
        }

        BlockInfo getNext(int index) {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
            BlockInfo info = (BlockInfo)this.triplets[index * 3 + 2];
            assert (info == null || BlockInfo.class.getName().equals(info.getClass().getName())) : "BlockInfo is expected at " + index * 3;
            return info;
        }

        void setDatanode(int index, DatanodeDescriptor node) {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (index >= 0 && index * 3 < this.triplets.length) : "Index is out of bound";
            this.triplets[index * 3] = node;
        }

        void setPrevious(int index, BlockInfo to) {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (index >= 0 && index * 3 + 1 < this.triplets.length) : "Index is out of bound";
            this.triplets[index * 3 + 1] = to;
        }

        void setNext(int index, BlockInfo to) {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (index >= 0 && index * 3 + 2 < this.triplets.length) : "Index is out of bound";
            this.triplets[index * 3 + 2] = to;
        }

        private int getCapacity() {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
            return this.triplets.length / 3;
        }

        private int ensureCapacity(int num) {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            int last = this.numNodes();
            if (this.triplets.length >= (last + num) * 3) {
                return last;
            }
            Object[] old = this.triplets;
            this.triplets = new Object[(last + num) * 3];
            for (int i = 0; i < last * 3; ++i) {
                this.triplets[i] = old[i];
            }
            return last;
        }

        int numNodes() {
            assert (this.triplets != null) : "BlockInfo is not initialized";
            assert (this.triplets.length % 3 == 0) : "Malformed BlockInfo";
            for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
                if (this.getDatanode(idx) == null) continue;
                return idx + 1;
            }
            return 0;
        }

        boolean addNode(DatanodeDescriptor node) {
            if (this.findDatanode(node) >= 0) {
                return false;
            }
            int lastNode = this.ensureCapacity(1);
            this.setDatanode(lastNode, node);
            this.setNext(lastNode, null);
            this.setPrevious(lastNode, null);
            return true;
        }

        boolean removeNode(DatanodeDescriptor node) {
            int dnIndex = this.findDatanode(node);
            if (dnIndex < 0) {
                return false;
            }
            assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is still in the list and must be removed first.";
            int lastNode = this.numNodes() - 1;
            this.setDatanode(dnIndex, this.getDatanode(lastNode));
            this.setNext(dnIndex, this.getNext(lastNode));
            this.setPrevious(dnIndex, this.getPrevious(lastNode));
            this.setDatanode(lastNode, null);
            this.setNext(lastNode, null);
            this.setPrevious(lastNode, null);
            return true;
        }

        int findDatanode(DatanodeDescriptor dn) {
            int len = this.getCapacity();
            for (int idx = 0; idx < len; ++idx) {
                DatanodeDescriptor cur = this.getDatanode(idx);
                if (cur == dn) {
                    return idx;
                }
                if (cur == null) break;
            }
            return -1;
        }

        BlockInfo listInsert(BlockInfo head, DatanodeDescriptor dn) {
            int dnIndex = this.findDatanode(dn);
            assert (dnIndex >= 0) : "Data node is not found: current";
            assert (this.getPrevious(dnIndex) == null && this.getNext(dnIndex) == null) : "Block is already in the list and cannot be inserted.";
            this.setPrevious(dnIndex, null);
            this.setNext(dnIndex, head);
            if (head != null) {
                head.setPrevious(head.findDatanode(dn), this);
            }
            return this;
        }

        BlockInfo listRemove(BlockInfo head, DatanodeDescriptor dn) {
            if (head == null) {
                return null;
            }
            int dnIndex = this.findDatanode(dn);
            if (dnIndex < 0) {
                return head;
            }
            BlockInfo next = this.getNext(dnIndex);
            BlockInfo prev = this.getPrevious(dnIndex);
            this.setNext(dnIndex, null);
            this.setPrevious(dnIndex, null);
            if (prev != null) {
                prev.setNext(prev.findDatanode(dn), next);
            }
            if (next != null) {
                next.setPrevious(next.findDatanode(dn), prev);
            }
            if (this == head) {
                head = next;
            }
            return head;
        }

        int listCount(DatanodeDescriptor dn) {
            int count = 0;
            for (BlockInfo cur = this; cur != null; cur = cur.getNext(cur.findDatanode(dn))) {
                ++count;
            }
            return count;
        }

        boolean listIsConsistent(DatanodeDescriptor dn) {
            int count = 0;
            BlockInfo cur = this;
            while (cur != null) {
                BlockInfo nextPrev;
                BlockInfo next = cur.getNext(cur.findDatanode(dn));
                if (next != null && cur != (nextPrev = next.getPrevious(next.findDatanode(dn)))) {
                    System.out.println("Inconsistent list: cur->next->prev != cur");
                    return false;
                }
                cur = next;
                ++count;
            }
            return true;
        }

        @Override
        public LightWeightGSet.LinkedElement getNext() {
            return this.nextLinkedElement;
        }

        @Override
        public void setNext(LightWeightGSet.LinkedElement next) {
            this.nextLinkedElement = next;
        }
    }
}

