/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedHdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotAccessControlException;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotException;
import org.apache.hadoop.hdfs.util.ByteArray;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

public class FSDirectory
implements FSConstants,
Closeable {
    static boolean CHECK_RESERVED_FILE_NAMES = true;
    public static final String DOT_RESERVED_STRING = ".reserved";
    public static final String DOT_RESERVED_PATH_PREFIX = "/.reserved";
    public static final byte[] DOT_RESERVED = DFSUtil.string2Bytes(".reserved");
    public static final String DOT_INODES_STRING = ".inodes";
    public static final byte[] DOT_INODES = DFSUtil.string2Bytes(".inodes");
    final FSNamesystem namesystem;
    final INodeDirectoryWithQuota rootDir;
    FSImage fsImage;
    private boolean ready = false;
    private final int lsLimit;
    private final INodeMap inodeMap;
    private final NameCache<ByteArray> nameCache;

    private static INodeDirectoryWithQuota createRoot(FSNamesystem namesystem) {
        INodeDirectoryWithQuota r = new INodeDirectoryWithQuota(16385L, INodeDirectory.ROOT_NAME, namesystem.createFsOwnerPermissions(new FsPermission(493)));
        INodeDirectorySnapshottable s = new INodeDirectorySnapshottable(r);
        s.setSnapshotQuota(0);
        return s;
    }

    FSDirectory(FSNamesystem ns, Configuration conf) {
        this(new FSImage(), ns, conf);
        this.fsImage.setCheckpointDirectories(FSImage.getCheckpointDirs(conf, null), FSImage.getCheckpointEditsDirs(conf, null));
    }

    FSDirectory(FSImage fsImage, FSNamesystem ns, Configuration conf) {
        this.rootDir = FSDirectory.createRoot(ns);
        this.fsImage = fsImage;
        fsImage.setRestoreRemovedDirs(conf.getBoolean("dfs.namenode.name.dir.restore", false));
        fsImage.setEditsTolerationLength(conf.getInt("dfs.namenode.edits.toleration.length", 0));
        this.namesystem = ns;
        int configuredLimit = conf.getInt("dfs.ls.limit", 1000);
        this.lsLimit = configuredLimit > 0 ? configuredLimit : 1000;
        int threshold = conf.getInt("dfs.namenode.name.cache.threshold", 10);
        NameNode.LOG.info((Object)("Caching file names occuring more than " + threshold + " times "));
        this.nameCache = new NameCache(threshold);
        this.inodeMap = INodeMap.newInstance(this.rootDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFSImage(Collection<File> dataDirs, Collection<File> editsDirs, HdfsConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsConstants.StartupOption.FORMAT) {
            this.fsImage.setStorageDirectories(dataDirs, editsDirs);
            this.fsImage.format();
            startOpt = HdfsConstants.StartupOption.REGULAR;
        }
        try {
            if (this.fsImage.recoverTransitionRead(dataDirs, editsDirs, startOpt)) {
                this.fsImage.saveNamespace(true);
            }
            FSEditLog editLog = this.fsImage.getEditLog();
            assert (editLog != null) : "editLog must be initialized";
            if (!editLog.isOpen()) {
                editLog.open();
            }
            this.fsImage.setCheckpointDirectories(null, null);
        }
        catch (IOException e) {
            this.fsImage.close();
            throw e;
        }
        FSDirectory fSDirectory = this;
        synchronized (fSDirectory) {
            this.ready = true;
            this.nameCache.initialized();
            this.notifyAll();
        }
    }

    private void incrDeletedFileCount(long count) {
        if (this.namesystem != null) {
            NameNode.getNameNodeMetrics().incrFilesDeleted(count);
        }
    }

    @Override
    public void close() throws IOException {
        this.fsImage.close();
    }

    public INodeDirectoryWithQuota getRoot() {
        return this.rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForReady() {
        if (!this.ready) {
            FSDirectory fSDirectory = this;
            synchronized (fSDirectory) {
                while (!this.ready) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INodeFileUnderConstruction addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine, DatanodeDescriptor clientNode, long generationStamp) throws IOException {
        this.waitForReady();
        long modTime = FSNamesystem.now();
        if (!this.mkdirs(new Path(path).getParent().toString(), permissions, true, modTime)) {
            return null;
        }
        boolean added = false;
        INodeFileUnderConstruction newNode = new INodeFileUnderConstruction(this.namesystem.allocateNewInodeId(), permissions, replication, preferredBlockSize, modTime, clientName, clientMachine, clientNode);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            added = this.addINode(path, newNode, false);
        }
        if (!added) {
            NameNode.stateChangeLog.info((Object)("DIR* addFile: failed to add " + path));
            return null;
        }
        this.fsImage.getEditLog().logOpenFile(path, newNode);
        NameNode.stateChangeLog.debug((Object)("DIR* addFile: " + path + " is added"));
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedAddFile(long id, String path, PermissionStatus permissions, Block[] blocks, short replication, long modificationTime, long atime, long preferredBlockSize) {
        INodeWithAdditionalFields newNode = blocks == null ? new INodeDirectory(id, null, permissions, modificationTime) : new INodeFile(id, null, permissions, modificationTime, atime, BlocksMap.BlockInfo.EMPTY_ARRAY, replication, preferredBlockSize);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            try {
                if (this.addINode(path, newNode, false) && blocks != null) {
                    int nrBlocks = blocks.length;
                    INodeFile newF = newNode.asFile();
                    for (int i = 0; i < nrBlocks; ++i) {
                        newF.addBlock(this.namesystem.blocksMap.addINode(blocks[i], newF));
                    }
                }
            }
            catch (IOException e) {
                return null;
            }
            return newNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block addBlock(String path, INodesInPath inodesInPath, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeFileUnderConstruction fileNode = INodeFileUnderConstruction.valueOf(inodesInPath.getLastINode(), path);
            this.updateCount(inodesInPath, 0L, fileNode.getBlockDiskspace(), true);
            this.namesystem.blocksMap.addINode(block, fileNode);
            BlocksMap.BlockInfo blockInfo = this.namesystem.blocksMap.getStoredBlock(block);
            fileNode.addBlock(blockInfo);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " is added to the in-memory " + "file system"));
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistBlocks(String path, INodeFileUnderConstruction file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logOpenFile(path, file);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.persistBlocks: " + path + " with " + file.getBlocks().length + " blocks is persisted"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFile(String path, INodeFile file) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.fsImage.getEditLog().logCloseFile(path, file);
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.closeFile: " + path + " with " + file.getBlocks().length + " blocks is persisted"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBlock(String path, INodeFileUnderConstruction fileNode, Block block) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            fileNode.removeBlock(block);
            this.namesystem.blocksMap.removeINode(block);
            this.namesystem.corruptReplicas.removeFromCorruptReplicasMap(block);
            this.fsImage.getEditLog().logOpenFile(path, fileNode);
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addFile: " + path + " with " + block + " is added to the"));
            INodesInPath iip = this.rootDir.getINodesInPath4Write(path);
            this.updateCount(iip, 0L, -fileNode.getBlockDiskspace(), true);
        }
        return true;
    }

    boolean renameTo(String src, String dst) throws QuotaExceededException, SnapshotAccessControlException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        if (!this.unprotectedRenameTo(src, dst, now)) {
            return false;
        }
        this.fsImage.getEditLog().logRename(src, dst, now);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp) throws QuotaExceededException, SnapshotAccessControlException, IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeReference.WithCount withCount;
            int srcRefDstSnapshot;
            INodesInPath srcIIP = this.rootDir.getINodesInPath4Write(src);
            INode srcInode = srcIIP.getLastINode();
            if (srcInode == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source does not exist"));
                return false;
            }
            if (srcIIP.getINodes().length == 1) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because source is the root"));
                return false;
            }
            FSDirectory.checkSnapshot(srcInode, null);
            if (this.isDir(dst)) {
                dst = dst + "/" + new Path(src).getName();
            }
            if (dst.equals(src)) {
                return true;
            }
            if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination starts with src"));
                return false;
            }
            byte[][] dstComponents = INode.getPathComponents(dst);
            INodesInPath dstIIP = this.getExistingPathINodes(dstComponents);
            if (dstIIP.isSnapshot()) {
                throw new SnapshotAccessControlException("Modification on RO snapshot is disallowed");
            }
            if (dstIIP.getLastINode() != null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists"));
                return false;
            }
            INode dstParent = dstIIP.getINode(-2);
            if (dstParent == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist"));
                return false;
            }
            this.verifyQuotaForRename(srcIIP.getINodes(), dstIIP.getINodes());
            boolean added = false;
            INode srcChild = srcIIP.getLastINode();
            byte[] srcChildName = srcChild.getLocalNameBytes();
            boolean isSrcInSnapshot = srcChild.isInLatestSnapshot(srcIIP.getLatestSnapshot());
            boolean srcChildIsReference = srcChild.isReference();
            if (isSrcInSnapshot) {
                srcChild = srcChild.recordModification(srcIIP.getLatestSnapshot(), this.inodeMap);
                srcIIP.setLastINode(srcChild);
            }
            Quota.Counts oldSrcCounts = Quota.Counts.newInstance();
            int n = srcRefDstSnapshot = srcChildIsReference ? srcChild.asReference().getDstSnapshotId() : -1;
            if (isSrcInSnapshot) {
                INodeReference.WithName withName = srcIIP.getINode(-2).asDirectory().replaceChild4ReferenceWithName(srcChild, srcIIP.getLatestSnapshot());
                withCount = (INodeReference.WithCount)withName.getReferredINode();
                srcChild = withName;
                srcIIP.setLastINode(srcChild);
                withCount.getReferredINode().computeQuotaUsage(oldSrcCounts, true, -1);
            } else {
                withCount = srcChildIsReference ? (INodeReference.WithCount)srcChild.asReference().getReferredINode() : null;
            }
            try {
                INode toDst;
                long removedSrc = this.removeLastINode(srcIIP);
                if (removedSrc == -1L) {
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed"));
                    boolean bl = false;
                    return bl;
                }
                if (dstParent.getParent() == null) {
                    dstIIP = this.getExistingPathINodes(dstComponents);
                    dstParent = dstIIP.getINode(-2);
                }
                srcChild = srcIIP.getLastINode();
                byte[] dstChildName = dstIIP.getLastLocalName();
                if (withCount == null) {
                    srcChild.setLocalName(dstChildName);
                    toDst = srcChild;
                } else {
                    withCount.getReferredINode().setLocalName(dstChildName);
                    Snapshot dstSnapshot = dstIIP.getLatestSnapshot();
                    INodeReference.DstReference ref = new INodeReference.DstReference(dstParent.asDirectory(), withCount, dstSnapshot == null ? -1 : dstSnapshot.getId());
                    toDst = ref;
                }
                added = this.addLastINodeNoQuotaCheck(dstIIP, toDst, false);
                if (added) {
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                    }
                    INode srcParent = srcIIP.getINode(-2);
                    srcParent.updateModificationTime(timestamp, srcIIP.getLatestSnapshot(), this.inodeMap);
                    dstParent = dstIIP.getINode(-2);
                    dstParent.updateModificationTime(timestamp, dstIIP.getLatestSnapshot(), this.inodeMap);
                    if (isSrcInSnapshot) {
                        Quota.Counts newSrcCounts = srcChild.computeQuotaUsage(Quota.Counts.newInstance(), false, -1);
                        newSrcCounts.subtract(oldSrcCounts);
                        srcParent.addSpaceConsumed(newSrcCounts.get(Quota.NAMESPACE), newSrcCounts.get(Quota.DISKSPACE), false, -1);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (!added) {
                    INodeDirectory srcParent = srcIIP.getINode(-2).asDirectory();
                    INode oldSrcChild = srcChild;
                    if (withCount == null) {
                        srcChild.setLocalName(srcChildName);
                    } else if (!srcChildIsReference) {
                        INode originalChild;
                        srcChild = originalChild = withCount.getReferredINode();
                    } else {
                        withCount.removeReference(oldSrcChild.asReference());
                        INodeReference.DstReference originalRef = new INodeReference.DstReference(srcParent, withCount, srcRefDstSnapshot);
                        srcChild = originalRef;
                    }
                    if (isSrcInSnapshot) {
                        ((INodeDirectoryWithSnapshot)srcParent).undoRename4ScrParent(oldSrcChild.asReference(), srcChild, srcIIP.getLatestSnapshot());
                    } else {
                        this.addLastINodeNoQuotaCheck(srcIIP, srcChild, false);
                    }
                }
            }
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] setReplication(String src, short replication, short[] blockRepls) throws IOException {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            Block[] fileBlocks = this.unprotectedSetReplication(src, replication, blockRepls);
            if (fileBlocks != null) {
                this.fsImage.getEditLog().logSetReplication(src, replication);
            }
            return fileBlocks;
        }
    }

    Block[] unprotectedSetReplication(String src, short replication, short[] blockRepls) throws QuotaExceededException, SnapshotAccessControlException {
        short newBR;
        INodesInPath iip = this.rootDir.getINodesInPath4Write(src);
        INode inode = iip.getLastINode();
        if (inode == null || !inode.isFile()) {
            return null;
        }
        INodeFile file = inode.asFile();
        short oldBR = file.getBlockReplication();
        if (replication > oldBR) {
            long dsDelta = (long)(replication - oldBR) * (file.diskspaceConsumed() / (long)oldBR);
            this.updateCount(iip, 0L, dsDelta, true);
        }
        if ((newBR = (file = file.setFileReplication(replication, iip.getLatestSnapshot(), this.inodeMap)).getBlockReplication()) < oldBR) {
            long dsDelta = (long)(newBR - oldBR) * (file.diskspaceConsumed() / (long)newBR);
            this.updateCount(iip, 0L, dsDelta, true);
        }
        if (blockRepls != null) {
            blockRepls[0] = oldBR;
            blockRepls[1] = newBR;
        }
        return file.getBlocks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPreferredBlockSize(String path) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return INodeFile.valueOf(this.rootDir.getNode(path), path).getPreferredBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exists(String src) {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode inode = this.rootDir.getNode(src);
            if (inode == null) {
                return false;
            }
            return !inode.isFile() || inode.asFile().getBlocks() != null;
        }
    }

    void setPermission(String src, FsPermission permission) throws IOException {
        this.unprotectedSetPermission(src, permission);
        this.fsImage.getEditLog().logSetPermissions(src, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException, QuotaExceededException, SnapshotAccessControlException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodesInPath iip = this.rootDir.getINodesInPath4Write(src);
            INode inode = iip.getLastINode();
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            inode.setPermission(permissions, iip.getLatestSnapshot(), this.inodeMap);
        }
    }

    void setOwner(String src, String username, String groupname) throws IOException {
        this.unprotectedSetOwner(src, username, groupname);
        this.fsImage.getEditLog().logSetOwner(src, username, groupname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprotectedSetOwner(String src, String username, String groupname) throws FileNotFoundException, QuotaExceededException, SnapshotAccessControlException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodesInPath iip = this.rootDir.getINodesInPath4Write(src);
            INode inode = iip.getLastINode();
            if (inode == null) {
                throw new FileNotFoundException("File does not exist: " + src);
            }
            if (username != null) {
                inode = inode.setUser(username, iip.getLatestSnapshot(), this.inodeMap);
            }
            if (groupname != null) {
                inode.setGroup(groupname, iip.getLatestSnapshot(), this.inodeMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concat(String target, String[] srcs) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.waitForReady();
            long timestamp = FSNamesystem.now();
            this.unprotectedConcat(target, srcs, timestamp);
            this.fsImage.getEditLog().logConcat(target, srcs, timestamp);
        }
    }

    public void unprotectedConcat(String target, String[] srcs, long timestamp) throws SnapshotAccessControlException, QuotaExceededException, SnapshotException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSNamesystem.concat to " + target));
        }
        INodesInPath trgIIP = this.rootDir.getINodesInPath4Write(target);
        INode[] trgINodes = trgIIP.getINodes();
        INodeFile trgInode = trgIIP.getLastINode().asFile();
        INodeDirectory trgParent = trgINodes[trgINodes.length - 2].asDirectory();
        Snapshot trgLatestSnapshot = trgIIP.getLatestSnapshot();
        INodeFile[] allSrcInodes = new INodeFile[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            INodesInPath iip = this.getINodesInPath4Write(srcs[i]);
            Snapshot latest = iip.getLatestSnapshot();
            INode inode = iip.getLastINode();
            if (inode.isInLatestSnapshot(latest)) {
                throw new SnapshotException("Concat: the source file " + srcs[i] + " is in snapshot " + latest);
            }
            if (inode.isReference() && ((INodeReference.WithCount)inode.asReference().getReferredINode()).getReferenceCount() > 1) {
                throw new SnapshotException("Concat: the source file " + srcs[i] + " is referred by some other reference in some snapshot.");
            }
            allSrcInodes[i] = inode.asFile();
        }
        trgInode.concatBlocks(allSrcInodes);
        int count = 0;
        for (INodeFile nodeToRemove : allSrcInodes) {
            if (nodeToRemove == null) continue;
            nodeToRemove.setBlocks(null);
            trgParent.removeChild(nodeToRemove, trgLatestSnapshot, null);
            this.inodeMap.remove(nodeToRemove);
            ++count;
        }
        trgInode.setModificationTime(timestamp, trgLatestSnapshot, this.inodeMap);
        trgParent.setModificationTime(timestamp, trgLatestSnapshot, this.inodeMap);
        this.unprotectedUpdateCount(trgINodes, trgINodes.length - 1, -count, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delete(String src, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws IOException {
        long filesRemoved;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.delete: " + src));
        }
        this.waitForReady();
        long now = FSNamesystem.now();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodesInPath inodesInPath = this.rootDir.getINodesInPath4Write(this.normalizePath(src));
            if (!FSDirectory.deleteAllowed(inodesInPath, src)) {
                filesRemoved = -1L;
            } else {
                INode targetNode = inodesInPath.getLastINode();
                ArrayList<INodeDirectorySnapshottable> snapshottableDirs = new ArrayList<INodeDirectorySnapshottable>();
                FSDirectory.checkSnapshot(targetNode, snapshottableDirs);
                filesRemoved = this.unprotectedDelete(inodesInPath, collectedBlocks, removedINodes, now);
                if (snapshottableDirs.size() > 0) {
                    this.namesystem.removeSnapshottableDirs(snapshottableDirs);
                }
            }
        }
        if (filesRemoved < 0L) {
            return false;
        }
        this.fsImage.getEditLog().logDelete(src, now);
        this.incrDeletedFileCount(filesRemoved);
        FSNamesystem.getFSNamesystem().removePathAndBlocks(src, null, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirEmpty(String src) {
        boolean dirNotEmpty = true;
        if (!this.isDir(src)) {
            return true;
        }
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodesInPath inodesInPath = this.rootDir.getLastINodeInPath(src);
            INode targetNode = inodesInPath.getINode(0);
            assert (targetNode != null) : "should be taken care in isDir() above";
            Snapshot s = inodesInPath.getPathSnapshot();
            if (targetNode.asDirectory().getChildrenList(s).size() != 0) {
                dirNotEmpty = false;
            }
        }
        return dirNotEmpty;
    }

    private static boolean deleteAllowed(INodesInPath iip, String src) {
        INode[] inodes = iip.getINodes();
        if (inodes == null || inodes.length == 0 || inodes[inodes.length - 1] == null) {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist"));
            }
            return false;
        }
        if (inodes.length == 1) {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted"));
            return false;
        }
        return true;
    }

    void unprotectedDelete(String src, long mtime) throws SnapshotAccessControlException, QuotaExceededException, FileNotFoundException {
        long filesRemoved;
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        ArrayList<INode> removedINodes = new ArrayList<INode>();
        INodesInPath inodesInPath = this.rootDir.getINodesInPath4Write(this.normalizePath(src));
        long l = filesRemoved = FSDirectory.deleteAllowed(inodesInPath, src) ? this.unprotectedDelete(inodesInPath, collectedBlocks, removedINodes, mtime) : -1L;
        if (filesRemoved >= 0L) {
            this.namesystem.removePathAndBlocks(src, collectedBlocks, removedINodes);
        }
    }

    long unprotectedDelete(INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, long mtime) throws QuotaExceededException {
        INode targetNode = iip.getLastINode();
        if (targetNode == null) {
            return -1L;
        }
        Snapshot latestSnapshot = iip.getLatestSnapshot();
        targetNode = targetNode.recordModification(latestSnapshot, this.inodeMap);
        iip.setLastINode(targetNode);
        long removed = this.removeLastINode(iip);
        if (removed == -1L) {
            return -1L;
        }
        INodeDirectory parent = targetNode.getParent();
        parent.updateModificationTime(mtime, latestSnapshot, this.inodeMap);
        if (removed == 0L) {
            return 0L;
        }
        long removedNum = 1L;
        if (!targetNode.isInLatestSnapshot(latestSnapshot)) {
            targetNode.destroyAndCollectBlocks(collectedBlocks, removedINodes);
        } else {
            Quota.Counts counts = targetNode.cleanSubtree(null, latestSnapshot, collectedBlocks, removedINodes);
            parent.addSpaceConsumed(-counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE), true, -1);
            removedNum = counts.get(Quota.NAMESPACE);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: " + targetNode.getFullPathName() + " is removed"));
        }
        return removedNum;
    }

    public INodeMap getINodeMap() {
        return this.inodeMap;
    }

    public final void addToInodeMap(INode inode) {
        if (inode instanceof INodeWithAdditionalFields) {
            this.inodeMap.put((INodeWithAdditionalFields)inode);
        }
    }

    public final void removeFromInodeMap(List<? extends INode> inodes) {
        if (inodes != null) {
            for (INode iNode : inodes) {
                if (iNode == null || !(iNode instanceof INodeWithAdditionalFields)) continue;
                this.inodeMap.remove(iNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getInode(long id) {
        FSDirectory fSDirectory = this;
        synchronized (fSDirectory) {
            return this.inodeMap.get(id);
        }
    }

    int getInodeMapSize() {
        return this.inodeMap != null ? this.inodeMap.size() : 0;
    }

    private static void checkSnapshot(INode target, List<INodeDirectorySnapshottable> snapshottableDirs) throws IOException {
        if (target.isDirectory()) {
            INodeDirectory targetDir = target.asDirectory();
            if (targetDir.isSnapshottable()) {
                INodeDirectorySnapshottable ssTargetDir = (INodeDirectorySnapshottable)targetDir;
                if (ssTargetDir.getNumSnapshots() > 0) {
                    throw new IOException("The direcotry " + ssTargetDir.getFullPathName() + " cannot be deleted since " + ssTargetDir.getFullPathName() + " is snapshottable and already has snapshots");
                }
                if (snapshottableDirs != null) {
                    snapshottableDirs.add(ssTargetDir);
                }
            }
            for (INode child : targetDir.getChildrenList(null)) {
                FSDirectory.checkSnapshot(child, snapshottableDirs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceINodeFile(String path, INodeFile oldnode, INodeFile newnode) throws IOException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            this.unprotectedReplaceINodeFile(path, oldnode, newnode);
        }
    }

    void unprotectedReplaceINodeFile(String path, INodeFile oldnode, INodeFile newnode) {
        oldnode.getParent().replaceChild(oldnode, newnode, this.inodeMap);
        oldnode.clear();
        int index = 0;
        for (BlocksMap.BlockInfo b : newnode.getBlocks()) {
            BlocksMap.BlockInfo info = this.namesystem.blocksMap.addINode(b, newnode);
            newnode.setBlock(index, info);
            ++index;
        }
        this.addToInodeMap(newnode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryListing getListing(String src, byte[] startAfter) throws IOException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            if (srcs.endsWith("/.snapshot")) {
                return this.getSnapshotsListing(srcs, startAfter);
            }
            INodesInPath inodesInPath = this.rootDir.getLastINodeInPath(srcs);
            Snapshot snapshot = inodesInPath.getPathSnapshot();
            INode targetNode = inodesInPath.getINode(0);
            if (targetNode == null) {
                return null;
            }
            if (!targetNode.isDirectory()) {
                return new DirectoryListing(new HdfsFileStatus[]{FSDirectory.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode, snapshot)}, 0);
            }
            INodeDirectory dirInode = targetNode.asDirectory();
            ReadOnlyList<INode> contents = dirInode.getChildrenList(snapshot);
            int startChild = INodeDirectory.nextChild(contents, startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, this.lsLimit);
            HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing; ++i) {
                INode cur = contents.get(startChild + i);
                listing[i] = FSDirectory.createFileStatus(cur.getLocalNameBytes(), cur, snapshot);
            }
            return new DirectoryListing(listing, totalNumChildren - startChild - numOfListing);
        }
    }

    private DirectoryListing getSnapshotsListing(String src, byte[] startAfter) throws IOException {
        if (!src.endsWith("/.snapshot")) {
            throw new IllegalArgumentException(src + " does not end with " + "/.snapshot");
        }
        String dirPath = this.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        INodeDirectorySnapshottable dirNode = INodeDirectorySnapshottable.valueOf(node, dirPath);
        ReadOnlyList<Snapshot> snapshots = dirNode.getSnapshotList();
        int skipSize = ReadOnlyList.Util.binarySearch(snapshots, startAfter);
        skipSize = skipSize < 0 ? -skipSize - 1 : skipSize + 1;
        int numOfListing = Math.min(snapshots.size() - skipSize, this.lsLimit);
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing; ++i) {
            Snapshot.Root sRoot = snapshots.get(i + skipSize).getRoot();
            listing[i] = FSDirectory.createFileStatus(sRoot.getLocalNameBytes(), sRoot, null);
        }
        return new DirectoryListing(listing, snapshots.size() - skipSize - numOfListing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtendedDirectoryListing getExtendedListing(String src, byte[] startAfter) throws IOException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            if (srcs.endsWith("/.snapshot")) {
                return this.getExtendedSnapshotsListing(srcs, startAfter);
            }
            INodesInPath inodesInPath = this.rootDir.getLastINodeInPath(srcs);
            Snapshot snapshot = inodesInPath.getPathSnapshot();
            INode targetNode = inodesInPath.getINode(0);
            if (targetNode == null) {
                return null;
            }
            if (!targetNode.isDirectory()) {
                return new ExtendedDirectoryListing();
            }
            INodeDirectory dirInode = targetNode.asDirectory();
            ReadOnlyList<INode> contents = dirInode.getChildrenList(snapshot);
            int startChild = INodeDirectory.nextChild(contents, startAfter);
            int totalNumChildren = contents.size();
            int numOfListing = Math.min(totalNumChildren - startChild, this.lsLimit);
            ExtendedHdfsFileStatus[] listing = new ExtendedHdfsFileStatus[numOfListing];
            for (int i = 0; i < numOfListing; ++i) {
                INode cur = contents.get(startChild + i);
                listing[i] = FSDirectory.createExtendedFileStatus(cur.getLocalNameBytes(), cur, snapshot);
            }
            return new ExtendedDirectoryListing(listing, totalNumChildren - startChild - numOfListing);
        }
    }

    private ExtendedDirectoryListing getExtendedSnapshotsListing(String src, byte[] startAfter) throws IOException {
        if (!src.endsWith("/.snapshot")) {
            throw new IllegalArgumentException(src + " does not end with " + "/.snapshot");
        }
        String dirPath = this.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        INodeDirectorySnapshottable dirNode = INodeDirectorySnapshottable.valueOf(node, dirPath);
        ReadOnlyList<Snapshot> snapshots = dirNode.getSnapshotList();
        int skipSize = ReadOnlyList.Util.binarySearch(snapshots, startAfter);
        skipSize = skipSize < 0 ? -skipSize - 1 : skipSize + 1;
        int numOfListing = Math.min(snapshots.size() - skipSize, this.lsLimit);
        ExtendedHdfsFileStatus[] listing = new ExtendedHdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing; ++i) {
            Snapshot.Root sRoot = snapshots.get(i + skipSize).getRoot();
            listing[i] = FSDirectory.createExtendedFileStatus(sRoot.getLocalNameBytes(), sRoot, null);
        }
        return new ExtendedDirectoryListing(listing, snapshots.size() - skipSize - numOfListing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            if (srcs.endsWith("/.snapshot")) {
                return this.getFileInfo4DotSnapshot(srcs);
            }
            INodesInPath inodesInPath = this.rootDir.getLastINodeInPath(srcs);
            INode i = inodesInPath.getINode(0);
            HdfsFileStatus hdfsFileStatus = i == null ? null : FSDirectory.createFileStatus(HdfsFileStatus.EMPTY_NAME, i, inodesInPath.getPathSnapshot());
            return hdfsFileStatus;
        }
    }

    private HdfsFileStatus getFileInfo4DotSnapshot(String src) {
        if (!src.endsWith("/.snapshot")) {
            throw new IllegalArgumentException(src + " does not end with " + "/.snapshot");
        }
        String dirPath = this.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        if (node != null && node.isDirectory() && node.asDirectory() instanceof INodeDirectorySnapshottable) {
            return new HdfsFileStatus(0L, true, 0, 0L, 0L, 0L, null, null, null, HdfsFileStatus.EMPTY_NAME);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtendedHdfsFileStatus getExtendedFileInfo(String src) {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            if (srcs.endsWith("/.snapshot")) {
                return this.getExtendedFileInfo4DotSnapshot(srcs);
            }
            INodesInPath inodesInPath = this.rootDir.getLastINodeInPath(srcs);
            INode i = inodesInPath.getINode(0);
            ExtendedHdfsFileStatus extendedHdfsFileStatus = i == null ? null : FSDirectory.createExtendedFileStatus(HdfsFileStatus.EMPTY_NAME, i, inodesInPath.getPathSnapshot());
            return extendedHdfsFileStatus;
        }
    }

    ExtendedHdfsFileStatus getExtendedFileInfo4DotSnapshot(String src) {
        if (!src.endsWith("/.snapshot")) {
            throw new IllegalArgumentException(src + " does not end with " + "/.snapshot");
        }
        String dirPath = this.normalizePath(src.substring(0, src.length() - ".snapshot".length()));
        INode node = this.getINode(dirPath);
        if (node != null && node.isDirectory() && node.asDirectory() instanceof INodeDirectorySnapshottable) {
            return new ExtendedHdfsFileStatus();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getFileBlocks(String src) {
        this.waitForReady();
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode i = this.rootDir.getNode(src);
            return i != null && i.isFile() ? i.asFile().getBlocks() : null;
        }
    }

    INodesInPath getExistingPathINodes(byte[][] components) {
        return INodesInPath.resolve(this.rootDir, components);
    }

    public INode getINode(String src) {
        return this.getLastINodeInPath(src).getINode(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodesInPath getLastINodeInPath(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.getLastINodeInPath(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getINode4Write(String src) throws SnapshotAccessControlException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.getINode4Write(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodesInPath getINodesInPath4Write(String src) throws SnapshotAccessControlException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.getINodesInPath4Write(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidToCreate(String src) throws SnapshotAccessControlException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return srcs.startsWith("/") && !srcs.endsWith("/") && this.rootDir.getINode4Write(srcs) == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirMutable(String src) throws SnapshotAccessControlException {
        src = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode node = this.rootDir.getINode4Write(src);
            return node != null && node.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDir(String src) {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode node = this.rootDir.getNode(this.normalizePath(src));
            return node != null && node.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSpaceConsumed(String path, long nsDelta, long dsDelta) throws QuotaExceededException, FileNotFoundException, SnapshotAccessControlException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodesInPath iip = this.rootDir.getINodesInPath4Write(path);
            if (iip.getLastINode() == null) {
                throw new FileNotFoundException(path + " does not exist under rootDir.");
            }
            this.updateCount(iip, nsDelta, dsDelta, true);
        }
    }

    private void updateCount(INodesInPath iip, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        this.updateCount(iip, iip.getINodes().length - 1, nsDelta, dsDelta, checkQuota);
    }

    private void updateCount(INodesInPath iip, int numOfINodes, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException {
        if (!this.ready) {
            return;
        }
        INode[] inodes = iip.getINodes();
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        if (checkQuota) {
            FSDirectory.verifyQuota(inodes, numOfINodes, nsDelta, dsDelta, null);
        }
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodes[i].isQuotaSet()) continue;
            INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
            node.addSpaceConsumed2Cache(nsDelta, dsDelta);
        }
    }

    private void updateCountNoQuotaCheck(INodesInPath inodes, int numOfINodes, long nsDelta, long dsDelta) {
        try {
            this.updateCount(inodes, numOfINodes, nsDelta, dsDelta, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.error((Object)"BUG: unexpected exception ", (Throwable)e);
        }
    }

    void unprotectedUpdateCount(INode[] inodes, int numOfINodes, long nsDelta, long dsDelta) {
        for (int i = 0; i < numOfINodes; ++i) {
            if (!inodes[i].isQuotaSet()) continue;
            INodeDirectoryWithQuota node = (INodeDirectoryWithQuota)inodes[i];
            node.addSpaceConsumed2Cache(nsDelta, dsDelta);
        }
    }

    static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        if (inodes[0].isRoot()) {
            if (pos == 0) {
                return "/";
            }
        } else {
            fullPathName.append(inodes[0].getLocalName());
        }
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    private static INode[] getRelativePathINodes(INode inode, INode ancestor) {
        int depth = 0;
        for (INode i = inode; i != null && !i.equals(ancestor); i = i.getParent()) {
            ++depth;
        }
        INode[] inodes = new INode[depth];
        for (int i = 0; i < depth; ++i) {
            if (inode == null) {
                NameNode.stateChangeLog.warn((Object)"Could not get full path. Corresponding file might have deleted already.");
                return null;
            }
            inodes[depth - i - 1] = inode;
            inode = inode.getParent();
        }
        return inodes;
    }

    private static INode[] getFullPathINodes(INode inode) {
        return FSDirectory.getRelativePathINodes(inode, null);
    }

    static String getFullPathName(INode inode) {
        INode[] inodes = FSDirectory.getFullPathINodes(inode);
        return FSDirectory.getFullPathName(inodes, inodes.length - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mkdirs(String src, PermissionStatus permissions, boolean inheritPermission, long now) throws FileNotFoundException, QuotaExceededException, SnapshotAccessControlException {
        src = this.normalizePath(src);
        String[] names = INode.getPathNames(src);
        byte[][] components = INode.getPathComponents(names);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            int i;
            INodesInPath iip = this.getExistingPathINodes(components);
            if (iip.isSnapshot()) {
                throw new SnapshotAccessControlException("Modification on RO snapshot is disallowed");
            }
            INode[] inodes = iip.getINodes();
            StringBuilder pathbuilder = new StringBuilder();
            for (i = 1; i < inodes.length && inodes[i] != null; ++i) {
                pathbuilder.append("/" + names[i]);
                if (inodes[i].isDirectory()) continue;
                throw new FileNotFoundException("Parent path is not a directory: " + pathbuilder);
            }
            while (i < inodes.length) {
                pathbuilder.append("/" + names[i]);
                String cur = pathbuilder.toString();
                this.unprotectedMkdir(this.namesystem.allocateNewInodeId(), iip, i, components[i], permissions, inheritPermission || i != components.length - 1, now);
                if (inodes[i] == null) {
                    return false;
                }
                if (this.namesystem != null) {
                    NameNode.getNameNodeMetrics().incrNumFilesCreated();
                }
                this.fsImage.getEditLog().logMkDir(cur, inodes[i]);
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.mkdirs: created directory " + cur));
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INode unprotectedMkdir(long id, String src, PermissionStatus permissions, long timestamp) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodesInPath iip = this.getExistingPathINodes(components);
            INode[] inodes = iip.getINodes();
            this.unprotectedMkdir(id, iip, inodes.length - 1, components[inodes.length - 1], permissions, false, timestamp);
            return inodes[inodes.length - 1];
        }
    }

    private void unprotectedMkdir(long id, INodesInPath inodesInPath, int pos, byte[] name, PermissionStatus permission, boolean inheritPermission, long timestamp) throws QuotaExceededException {
        INodeDirectory dir = new INodeDirectory(id, name, permission, timestamp);
        if (this.addChild(inodesInPath, pos, dir, inheritPermission, true)) {
            inodesInPath.setINode(pos, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addINode(String src, INode child, boolean inheritPermission) throws QuotaExceededException {
        byte[][] components = INode.getPathComponents(src);
        child.setLocalName(components[components.length - 1]);
        this.cacheName(child);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.addLastINode(this.getExistingPathINodes(components), child, inheritPermission, true);
        }
    }

    private boolean addLastINode(INodesInPath inodesInPath, INode inode, boolean inheritPermission, boolean checkQuota) throws QuotaExceededException {
        int pos = inodesInPath.getINodes().length - 1;
        return this.addChild(inodesInPath, pos, inode, inheritPermission, checkQuota);
    }

    private static void verifyQuota(INode[] inodes, int pos, long nsDelta, long dsDelta, INode commonAncestor) throws QuotaExceededException {
        if (nsDelta <= 0L && dsDelta <= 0L) {
            return;
        }
        for (int i = (pos > inodes.length ? inodes.length : pos) - 1; i >= 0; --i) {
            if (commonAncestor == inodes[i]) {
                return;
            }
            if (!inodes[i].isQuotaSet()) continue;
            try {
                ((INodeDirectoryWithQuota)inodes[i]).verifyQuota(nsDelta, dsDelta);
                continue;
            }
            catch (QuotaExceededException e) {
                e.setPathName(FSDirectory.getFullPathName(inodes, i));
                throw e;
            }
        }
    }

    private void verifyQuotaForRename(INode[] src, INode[] dst) throws QuotaExceededException {
        if (!this.ready) {
            return;
        }
        int i = 0;
        while (src[i] == dst[i]) {
            ++i;
        }
        Quota.Counts delta = src[src.length - 1].computeQuotaUsage();
        int dstIndex = dst.length - 1;
        if (dst[dstIndex] != null) {
            delta.subtract(dst[dstIndex].computeQuotaUsage());
        }
        FSDirectory.verifyQuota(dst, dstIndex, delta.get(Quota.NAMESPACE), delta.get(Quota.DISKSPACE), src[i - 1]);
    }

    void verifySnapshotName(String snapshotName, String path) {
        byte[] bytes = DFSUtil.string2Bytes(snapshotName);
        this.verifyINodeName(bytes);
    }

    void verifyINodeName(byte[] childName) {
        if (Arrays.equals(HdfsConstants.DOT_SNAPSHOT_DIR_BYTES, childName)) {
            String s = "\".snapshot\" is a reserved name.";
            if (!this.ready) {
                s = s + "  Please rename it before upgrade.";
            }
            throw new IllegalArgumentException(s);
        }
    }

    private boolean addChild(INodesInPath iip, int pos, INode child, boolean inheritPermission, boolean checkQuota) throws QuotaExceededException {
        this.verifyINodeName(child.getLocalNameBytes());
        INode[] inodes = iip.getINodes();
        if (pos == 1 && inodes[0] == this.rootDir && FSDirectory.isReservedName(child)) {
            throw new IllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved and cannot " + "be created. If this is during upgrade change the name of the " + "existing file or directory to another name before upgrading " + "to the new release.");
        }
        Quota.Counts counts = child.computeQuotaUsage();
        this.updateCount(iip, pos, counts.get(Quota.NAMESPACE), counts.get(Quota.DISKSPACE), checkQuota);
        INodeDirectory parent = inodes[pos - 1].asDirectory();
        boolean added = false;
        try {
            added = parent.addChild(child, inheritPermission, iip.getLatestSnapshot(), this.inodeMap);
        }
        catch (QuotaExceededException e) {
            this.updateCountNoQuotaCheck(iip, pos, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
            throw e;
        }
        if (!added) {
            this.updateCountNoQuotaCheck(iip, pos, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
        } else {
            iip.setINode(pos - 1, child.getParent());
            this.addToInodeMap(child);
        }
        return added;
    }

    private boolean addLastINodeNoQuotaCheck(INodesInPath inodesInPath, INode child, boolean inheritPermission) {
        try {
            return this.addLastINode(inodesInPath, child, inheritPermission, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn((Object)"FSDirectory.addChildNoQuotaCheck - unexpected", (Throwable)e);
            return false;
        }
    }

    private long removeLastINode(INodesInPath iip) throws QuotaExceededException {
        Snapshot latestSnapshot = iip.getLatestSnapshot();
        INode last = iip.getLastINode();
        INodeDirectory parent = iip.getINode(-2).asDirectory();
        if (!parent.removeChild(last, latestSnapshot, this.inodeMap)) {
            return -1L;
        }
        INodeDirectory newParent = last.getParent();
        if (parent != newParent) {
            iip.setINode(-2, newParent);
        }
        if (!last.isInLatestSnapshot(latestSnapshot)) {
            Quota.Counts counts = last.computeQuotaUsage();
            this.updateCountNoQuotaCheck(iip, iip.getINodes().length - 1, -counts.get(Quota.NAMESPACE), -counts.get(Quota.DISKSPACE));
            if (INodeReference.tryRemoveReference(last) > 0) {
                return 0L;
            }
            return counts.get(Quota.NAMESPACE);
        }
        return 1L;
    }

    String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws IOException {
        String srcs = this.normalizePath(src);
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INode targetNode = this.rootDir.getNode(srcs);
            if (targetNode == null) {
                throw new FileNotFoundException("File does not exist: " + srcs);
            }
            return targetNode.computeContentSummary();
        }
    }

    INodeDirectory unprotectedSetQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, QuotaExceededException, SnapshotAccessControlException {
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota < -1L || dsQuota < 0L && dsQuota != Long.MAX_VALUE && dsQuota < -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or dsQuota : " + nsQuota + " and " + dsQuota);
        }
        String srcs = this.normalizePath(src);
        INodesInPath iip = this.rootDir.getINodesInPath4Write(srcs);
        INodeDirectory dirNode = INodeDirectory.valueOf(iip.getLastINode(), srcs);
        if (dirNode.isRoot() && nsQuota == -1L) {
            throw new IllegalArgumentException("Cannot clear namespace quota on root.");
        }
        long oldNsQuota = dirNode.getNsQuota();
        long oldDsQuota = dirNode.getDsQuota();
        if (nsQuota == Long.MAX_VALUE) {
            nsQuota = oldNsQuota;
        }
        if (dsQuota == Long.MAX_VALUE) {
            dsQuota = oldDsQuota;
        }
        Snapshot latest = iip.getLatestSnapshot();
        if (dirNode instanceof INodeDirectoryWithQuota) {
            INodeDirectoryWithQuota quotaNode = (INodeDirectoryWithQuota)dirNode;
            Quota.Counts counts = null;
            if (!quotaNode.isQuotaSet()) {
                counts = quotaNode.computeQuotaUsage();
            }
            quotaNode.setQuota(nsQuota, dsQuota);
            if (quotaNode.isQuotaSet() && counts != null) {
                quotaNode.setSpaceConsumed(counts.get(Quota.NAMESPACE), counts.get(Quota.DISKSPACE));
            } else if (!quotaNode.isQuotaSet() && latest == null && !(quotaNode instanceof INodeDirectoryWithSnapshot)) {
                return quotaNode.replaceSelf4INodeDirectory(this.inodeMap);
            }
        } else {
            return dirNode.replaceSelf4Quota(latest, nsQuota, dsQuota, this.inodeMap);
        }
        return oldNsQuota != nsQuota || oldDsQuota != dsQuota ? dirNode : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String src, long nsQuota, long dsQuota) throws FileNotFoundException, QuotaExceededException, SnapshotAccessControlException {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            INodeDirectory dir = this.unprotectedSetQuota(src, nsQuota, dsQuota);
            if (dir != null) {
                this.fsImage.getEditLog().logSetQuota(src, dir.getNsQuota(), dir.getDsQuota());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long totalInodes() {
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            return this.rootDir.numItemsInTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimes(String src, INodeFile inode, long mtime, long atime, boolean force, Snapshot latest) throws QuotaExceededException {
        boolean status = false;
        INodeDirectoryWithQuota iNodeDirectoryWithQuota = this.rootDir;
        synchronized (iNodeDirectoryWithQuota) {
            status = this.unprotectedSetTimes(src, inode, mtime, atime, force, latest);
        }
        if (status) {
            this.fsImage.getEditLog().logTimes(src, mtime, atime);
        }
    }

    boolean unprotectedSetTimes(String src, long mtime, long atime, boolean force) throws QuotaExceededException {
        INodesInPath i = this.getLastINodeInPath(src);
        return this.unprotectedSetTimes(src, i.getLastINode(), mtime, atime, force, i.getLatestSnapshot());
    }

    private boolean unprotectedSetTimes(String src, INode inode, long mtime, long atime, boolean force, Snapshot latest) throws QuotaExceededException {
        boolean status = false;
        if (mtime != -1L) {
            inode = inode.setModificationTime(mtime, latest, this.inodeMap);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime(null);
            if (atime <= inodeTime + this.namesystem.getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime, latest, this.inodeMap);
                status = true;
            }
        }
        return status;
    }

    private static HdfsFileStatus createFileStatus(byte[] path, INode node, Snapshot snapshot) {
        return new HdfsFileStatus(node.isDirectory() ? 0L : node.asFile().computeFileSize(snapshot), node.isDirectory(), node.isDirectory() ? (short)0 : node.asFile().getFileReplication(snapshot), node.isDirectory() ? 0L : node.asFile().getPreferredBlockSize(), node.getModificationTime(snapshot), node.getAccessTime(snapshot), node.getFsPermission(snapshot), node.getUserName(snapshot), node.getGroupName(snapshot), path);
    }

    private static ExtendedHdfsFileStatus createExtendedFileStatus(byte[] path, INode node, Snapshot snapshot) {
        int childrenNum = 0;
        if (node.isDirectory()) {
            ReadOnlyList<INode> contents = ((INodeDirectory)node).getChildrenList(snapshot);
            childrenNum = contents.size();
        }
        return new ExtendedHdfsFileStatus(node.getId(), childrenNum, node.isDirectory() ? 0L : ((INodeFile)node).computeContentSummary().getLength(), node.isDirectory(), node.isDirectory() ? (short)0 : ((INodeFile)node).getBlockReplication(), node.isDirectory() ? 0L : ((INodeFile)node).getPreferredBlockSize(), node.getModificationTime(), node.getAccessTime(), node.getFsPermission(), node.getUserName(), node.getGroupName(), path);
    }

    void cacheName(INode inode) {
        if (!inode.isFile()) {
            return;
        }
        ByteArray name = new ByteArray(inode.getLocalNameBytes());
        if ((name = this.nameCache.put(name)) != null) {
            inode.setLocalName(name.getBytes());
        }
    }

    static byte[][] getPathComponents(INode inode) {
        ArrayList<byte[]> components = new ArrayList<byte[]>();
        components.add(0, inode.getLocalNameBytes());
        while (inode.getParent() != null) {
            components.add(0, inode.getParent().getLocalNameBytes());
            inode = inode.getParent();
        }
        return (byte[][])components.toArray((T[])new byte[components.size()][]);
    }

    static byte[][] getPathComponentsForReservedPath(String src) {
        return !FSDirectory.isReservedName(src) ? (byte[][])null : INode.getPathComponents(src);
    }

    private static boolean isInodesPath(byte[][] pathComponents) {
        if (pathComponents == null || pathComponents.length <= 3) {
            return false;
        }
        return Arrays.equals(DOT_RESERVED, pathComponents[1]) && Arrays.equals(DOT_INODES, pathComponents[2]);
    }

    private static INode getINode(String src, String inodeId, FSDirectory fsd) throws FileNotFoundException {
        INode inode = null;
        try {
            long id = Long.valueOf(inodeId);
            inode = fsd.getInode(id);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (inode == null) {
            throw new FileNotFoundException("File for given inode path does not exist: " + src);
        }
        return inode;
    }

    static String resolvePath(String src, byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException {
        if (!FSDirectory.isInodesPath(pathComponents)) {
            return src;
        }
        INode inode = FSDirectory.getINode(src, DFSUtil.bytes2String(pathComponents[3]), fsd);
        if (pathComponents.length > 4 && DFSUtil.bytes2String(pathComponents[4]).equals("..")) {
            INodeDirectory parent = inode.getParent();
            if (parent == null || ((INode)parent).getId() == 16385L) {
                return "/";
            }
            return parent.getFullPathName();
        }
        long id = inode.getId();
        if (id == 16385L && pathComponents.length == 4) {
            return "/";
        }
        StringBuilder path = id == 16385L ? new StringBuilder() : new StringBuilder(fsd.getInode(id).getFullPathName());
        for (int i = 4; i < pathComponents.length; ++i) {
            path.append("/").append(DFSUtil.bytes2String(pathComponents[i]));
        }
        if (NameNode.LOG.isDebugEnabled()) {
            NameNode.LOG.debug((Object)("Resolved path is " + path));
        }
        return path.toString();
    }

    static INode resolveInode(byte[] path, FSDirectory fsd) throws FileNotFoundException {
        if (path == null || path.length == 0) {
            return null;
        }
        String pathStr = DFSUtil.bytes2String(path);
        String[] pathComponentsStr = INode.getPathNames(pathStr);
        if (pathComponentsStr == null) {
            return null;
        }
        return FSDirectory.resolveInode(pathStr, INode.getPathComponents(pathComponentsStr), fsd);
    }

    static INode resolveInode(String src, byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException {
        if (!FSDirectory.isInodesPath(pathComponents)) {
            return null;
        }
        return FSDirectory.getINode(src, DFSUtil.bytes2String(pathComponents[3]), fsd);
    }

    void shutdown() {
        this.nameCache.reset();
        this.inodeMap.clear();
    }

    public static boolean isReservedName(INode inode) {
        return CHECK_RESERVED_FILE_NAMES && Arrays.equals(inode.getLocalNameBytes(), DOT_RESERVED);
    }

    public static boolean isReservedName(String src) {
        return src.startsWith(DOT_RESERVED_PATH_PREFIX);
    }
}

