/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectoryWithQuota;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileUnderConstructionWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

public class FSImageFormat {
    private static final Log LOG = FSImage.LOG;

    private FSImageFormat() {
    }

    static class Saver {
        private final int namespaceID;
        private final SnapshotFSImageFormat.ReferenceMap referenceMap = new SnapshotFSImageFormat.ReferenceMap();

        Saver(int namespaceID) {
            this.namespaceID = namespaceID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(File newFile) throws IOException {
            FSNamesystem fsNamesys = FSNamesystem.getFSNamesystem();
            FSDirectory fsDir = fsNamesys.dir;
            long startTime = FSNamesystem.now();
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
            try {
                out.writeInt(-44);
                out.writeInt(this.namespaceID);
                out.writeLong(fsDir.rootDir.numItemsInTree());
                out.writeLong(fsNamesys.getGenerationStamp());
                out.writeLong(fsNamesys.getLastInodeId());
                fsNamesys.getSnapshotManager().write(out);
                FSImageSerialization.saveINode2Image(fsDir.rootDir, out, false, this.referenceMap);
                this.saveImage(fsDir.rootDir, out, true);
                fsNamesys.saveFilesUnderConstruction(out);
                fsNamesys.saveSecretManagerState(out);
            }
            finally {
                out.close();
            }
            LOG.info((Object)("Image file of size " + newFile.length() + " saved in " + (FSNamesystem.now() - startTime) / 1000L + " seconds."));
        }

        private void saveImage(INodeDirectory current, DataOutputStream out, boolean toSaveSubtree) throws IOException {
            boolean toSave;
            out.writeLong(current.getId());
            if (!toSaveSubtree) {
                return;
            }
            ReadOnlyList<INode> children = current.getChildrenList(null);
            int dirNum = 0;
            ArrayList<INodeDirectory> snapshotDirs = null;
            if (current instanceof INodeDirectoryWithSnapshot) {
                snapshotDirs = new ArrayList<INodeDirectory>();
                ((INodeDirectoryWithSnapshot)current).getSnapshotDirectory(snapshotDirs);
                dirNum += snapshotDirs.size();
            }
            if (current instanceof INodeDirectorySnapshottable) {
                INodeDirectorySnapshottable snapshottableNode = (INodeDirectorySnapshottable)current;
                SnapshotFSImageFormat.saveSnapshots(snapshottableNode, out);
            } else {
                out.writeInt(-1);
            }
            SnapshotFSImageFormat.saveDirectoryDiffList(current, out, this.referenceMap);
            out.writeInt(dirNum += this.saveChildren(children, out));
            for (INode child : children) {
                if (!child.isDirectory()) continue;
                toSave = child.isReference() ? this.referenceMap.toProcessSubtree(child.getId()) : true;
                this.saveImage(child.asDirectory(), out, toSave);
            }
            if (snapshotDirs != null) {
                for (INodeDirectory subDir : snapshotDirs) {
                    toSave = subDir.getParentReference() != null ? this.referenceMap.toProcessSubtree(subDir.getId()) : true;
                    this.saveImage(subDir, out, toSave);
                }
            }
        }

        private int saveChildren(ReadOnlyList<INode> children, DataOutputStream out) throws IOException {
            out.writeInt(children.size());
            int dirNum = 0;
            for (INode child : children) {
                FSImageSerialization.saveINode2Image(child, out, false, this.referenceMap);
                if (!child.isDirectory()) continue;
                ++dirNum;
            }
            return dirNum;
        }
    }

    public static class Loader {
        private final StorageInfo storage;
        private final FSNamesystem namesystem;
        private final FSDirectory fsDir;
        private Map<Integer, Snapshot> snapshotMap = null;
        private final SnapshotFSImageFormat.ReferenceMap referenceMap = new SnapshotFSImageFormat.ReferenceMap();

        public Loader(StorageInfo storage) {
            this.storage = storage;
            this.namesystem = FSNamesystem.getFSNamesystem();
            this.fsDir = this.namesystem.dir;
        }

        public FSDirectory getFSDirectoryInLoading() {
            return this.namesystem.dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean load(File curFile, boolean loadNamespaceId) throws IOException {
            assert (this.storage.getLayoutVersion() < 0) : "Negative layout version is expected.";
            assert (curFile != null) : "curFile is null";
            boolean needToSave = true;
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(curFile)));
            try {
                int imgVersion = in.readInt();
                int namespaceId = in.readInt();
                if (loadNamespaceId) {
                    this.storage.namespaceID = namespaceId;
                }
                long numFiles = LayoutVersion.supports(LayoutVersion.Feature.NAMESPACE_QUOTA, imgVersion) ? in.readLong() : (long)in.readInt();
                this.storage.layoutVersion = imgVersion;
                if (imgVersion <= -12) {
                    long genstamp = in.readLong();
                    this.namesystem.setGenerationStamp(genstamp);
                }
                boolean bl = needToSave = imgVersion != -44;
                if (LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, imgVersion)) {
                    long lastInodeId = in.readLong();
                    this.namesystem.resetLastInodeId(lastInodeId);
                    LOG.info((Object)("load last allocated InodeId from fsimage:" + lastInodeId));
                } else {
                    LOG.info((Object)"Old layout version doesn't have inode id. Will assign new id for each inode.");
                }
                if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, imgVersion)) {
                    this.snapshotMap = this.namesystem.getSnapshotManager().read(in, this);
                    this.loadLocalNameINodesWithSnapshot(in);
                } else {
                    this.loadFullNameINodes(numFiles, in);
                }
                this.loadDatanodes(imgVersion, in);
                this.loadFilesUnderConstruction(imgVersion, in);
                this.loadSecretManagerState(imgVersion, in, this.namesystem);
            }
            finally {
                in.close();
            }
            return needToSave;
        }

        private void loadLocalNameINodesWithSnapshot(DataInput in) throws IOException {
            this.loadRoot(in);
            this.loadDirectoryWithSnapshot(in);
        }

        private void loadDirectoryWithSnapshot(DataInput in) throws IOException {
            long inodeId = in.readLong();
            INodeDirectory parent = this.namesystem.dir.getInode(inodeId).asDirectory();
            boolean toLoadSubtree = this.referenceMap.toProcessSubtree(parent.getId());
            if (!toLoadSubtree) {
                return;
            }
            int numSnapshots = in.readInt();
            if (numSnapshots >= 0) {
                INodeDirectorySnapshottable snapshottableParent = INodeDirectorySnapshottable.valueOf((INode)parent, parent.getLocalName());
                if (snapshottableParent.getParent() != null) {
                    this.namesystem.getSnapshotManager().addSnapshottable(snapshottableParent);
                }
                SnapshotFSImageFormat.loadSnapshotList(snapshottableParent, numSnapshots, in, this);
            }
            this.loadChildren(parent, in);
            SnapshotFSImageFormat.loadDirectoryDiffList(parent, in, this);
            int numSubTree = in.readInt();
            for (int i = 0; i < numSubTree; ++i) {
                this.loadDirectoryWithSnapshot(in);
            }
        }

        private int loadChildren(INodeDirectory parent, DataInput in) throws IOException {
            int numChildren = in.readInt();
            for (int i = 0; i < numChildren; ++i) {
                INode newNode = this.loadINodeWithLocalName(false, in);
                this.addToParent(parent, newNode);
            }
            return numChildren;
        }

        public INode loadINodeWithLocalName(boolean isSnapshotINode, DataInput in) throws IOException {
            byte[] localName = FSImageSerialization.readLocalName(in);
            boolean supportINodeId = LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.storage.layoutVersion);
            long id = supportINodeId ? in.readLong() : this.namesystem.allocateNewInodeId();
            INode inode = this.loadINode(id, localName, isSnapshotINode, in);
            if (supportINodeId) {
                this.namesystem.dir.addToInodeMap(inode);
            }
            return inode;
        }

        private void loadRoot(DataInput in) throws IOException {
            long id;
            if (in.readShort() != 0) {
                throw new IOException("First node is not root");
            }
            long l = id = LayoutVersion.supports(LayoutVersion.Feature.ADD_INODE_ID, this.storage.layoutVersion) ? in.readLong() : 16385L;
            assert (id == 16385L) : "Unexpected root ID " + id;
            INodeDirectory root = this.loadINode(16385L, null, false, in).asDirectory();
            this.updateRootAttr(root);
        }

        private void loadFullNameINodes(long numFiles, DataInput in) throws IOException {
            LOG.info((Object)("Number of files = " + numFiles));
            Object parentPath = new byte[][]{new byte[0]};
            INodeDirectory parentINode = this.fsDir.rootDir;
            for (long i = 0L; i < numFiles; ++i) {
                byte[][] pathComponents = FSImageSerialization.readPathComponents(in);
                long id = FSNamesystem.getFSNamesystem().allocateNewInodeId();
                INode newNode = this.loadINode(id, pathComponents[pathComponents.length - 1], false, in);
                if (this.isRoot(pathComponents)) {
                    this.updateRootAttr(newNode.asDirectory());
                    continue;
                }
                if (!this.isParent(pathComponents, (byte[][])parentPath)) {
                    parentINode = this.getParentINodeDirectory(pathComponents);
                    parentPath = this.getParent(pathComponents);
                }
                this.addToParent(parentINode, newNode);
            }
        }

        private void addToParent(INodeDirectory parent, INode child) {
            INodeFile file;
            BlocksMap.BlockInfo[] blocks;
            FSDirectory fsDir = this.namesystem.dir;
            if (parent == fsDir.rootDir && FSDirectory.isReservedName(child)) {
                throw new IllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved. Please " + " change the name of the existing file or directory to another " + "name before upgrading to this release.");
            }
            if (!parent.addChild(child)) {
                return;
            }
            this.namesystem.dir.cacheName(child);
            if (child.isFile() && (blocks = (file = child.asFile()).getBlocks()) != null) {
                for (int i = 0; i < blocks.length; ++i) {
                    file.setBlock(i, this.namesystem.blocksMap.addINode(blocks[i], file));
                }
            }
        }

        private boolean isRoot(byte[][] path) {
            return path.length == 1 && path[0] == null;
        }

        private void updateRootAttr(INodeWithAdditionalFields root) {
            long nsQuota = root.getNsQuota();
            long dsQuota = root.getDsQuota();
            if (nsQuota != -1L || dsQuota != -1L) {
                this.fsDir.rootDir.setQuota(nsQuota, dsQuota);
            }
            this.fsDir.rootDir.cloneModificationTime(root);
            this.fsDir.rootDir.clonePermissionStatus(root);
        }

        private INodeDirectory getParentINodeDirectory(byte[][] pathComponents) throws FileNotFoundException {
            if (pathComponents.length < 2) {
                return null;
            }
            INodesInPath inodes = this.namesystem.dir.getExistingPathINodes(pathComponents);
            return INodeDirectory.valueOf(inodes.getINode(-2), pathComponents);
        }

        byte[][] getParent(byte[][] path) {
            byte[][] result = new byte[path.length - 1][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new byte[path[i].length];
                System.arraycopy(path[i], 0, result[i], 0, path[i].length);
            }
            return result;
        }

        private boolean isParent(byte[][] path, byte[][] parent) {
            if (path == null || parent == null) {
                return false;
            }
            if (parent.length == 0 || path.length != parent.length + 1) {
                return false;
            }
            boolean isParent = true;
            for (int i = 0; i < parent.length; ++i) {
                isParent = isParent && Arrays.equals(path[i], parent[i]);
            }
            return isParent;
        }

        private INode loadINode(long id, byte[] localName, boolean isSnapshotINode, DataInput in) throws IOException {
            INodeDirectory dir;
            int layoutVersion = this.storage.getLayoutVersion();
            if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, layoutVersion)) {
                this.namesystem.getFSDirectory().verifyINodeName(localName);
            }
            short replication = FSEditLog.adjustReplication(in.readShort());
            long modificationTime = in.readLong();
            long atime = 0L;
            if (LayoutVersion.supports(LayoutVersion.Feature.FILE_ACCESS_TIME, layoutVersion)) {
                atime = in.readLong();
            }
            long blockSize = 0L;
            if (layoutVersion <= -8) {
                blockSize = in.readLong();
            }
            int numBlocks = in.readInt();
            BlocksMap.BlockInfo[] blocks = null;
            if (-9 <= layoutVersion && numBlocks > 0 || layoutVersion < -9 && numBlocks >= 0) {
                blocks = new BlocksMap.BlockInfo[numBlocks];
                for (int j = 0; j < numBlocks; ++j) {
                    blocks[j] = new BlocksMap.BlockInfo(replication);
                    if (-14 < layoutVersion) {
                        blocks[j].set(in.readLong(), in.readLong(), 0L);
                        continue;
                    }
                    blocks[j].readFields(in);
                }
                if (-8 <= layoutVersion && blockSize == 0L) {
                    if (numBlocks > 1) {
                        blockSize = blocks[0].getNumBytes();
                    } else {
                        long first = numBlocks == 1 ? blocks[0].getNumBytes() : 0L;
                        blockSize = Math.max(this.namesystem.getDefaultBlockSize(), first);
                    }
                }
                String clientName = "";
                String clientMachine = "";
                boolean underConstruction = false;
                FileDiffList fileDiffs = null;
                if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, layoutVersion)) {
                    fileDiffs = SnapshotFSImageFormat.loadFileDiffList(in, this);
                    if (isSnapshotINode && (underConstruction = in.readBoolean())) {
                        clientName = FSImageSerialization.readString(in);
                        clientMachine = FSImageSerialization.readString(in);
                    }
                }
                PermissionStatus permissions = this.namesystem.getUpgradePermission();
                if (layoutVersion <= -11) {
                    permissions = PermissionStatus.read(in);
                }
                INodeFile file = new INodeFile(id, localName, permissions, modificationTime, atime, blocks, replication, blockSize);
                return fileDiffs != null ? new INodeFileWithSnapshot(file, fileDiffs) : (underConstruction ? new INodeFileUnderConstruction(file, clientName, clientMachine, null) : file);
            }
            if (numBlocks == -3) {
                boolean isWithName = in.readBoolean();
                int snapshotId = in.readInt();
                INodeReference.WithCount withCount = this.referenceMap.loadINodeReferenceWithCount(isSnapshotINode, in, this);
                if (isWithName) {
                    return new INodeReference.WithName(null, withCount, localName, snapshotId);
                }
                INodeReference.DstReference ref = new INodeReference.DstReference(null, withCount, snapshotId);
                return ref;
            }
            long nsQuota = -1L;
            if (LayoutVersion.supports(LayoutVersion.Feature.NAMESPACE_QUOTA, layoutVersion)) {
                nsQuota = in.readLong();
            }
            long dsQuota = -1L;
            if (LayoutVersion.supports(LayoutVersion.Feature.DISKSPACE_QUOTA, layoutVersion)) {
                dsQuota = in.readLong();
            }
            boolean snapshottable = false;
            boolean withSnapshot = false;
            if (LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, layoutVersion) && !(snapshottable = in.readBoolean())) {
                withSnapshot = in.readBoolean();
            }
            PermissionStatus permissions = this.namesystem.getUpgradePermission();
            if (layoutVersion <= -11) {
                permissions = PermissionStatus.read(in);
            }
            INodeDirectory iNodeDirectory = dir = nsQuota >= 0L || dsQuota >= 0L ? new INodeDirectoryWithQuota(id, localName, permissions, modificationTime, nsQuota, dsQuota) : new INodeDirectory(id, localName, permissions, modificationTime);
            return snapshottable ? new INodeDirectorySnapshottable(dir) : (withSnapshot ? new INodeDirectoryWithSnapshot(dir) : dir);
        }

        private void loadFilesUnderConstruction(int version, DataInput in) throws IOException {
            if (version > -13) {
                return;
            }
            int size = in.readInt();
            LOG.info((Object)("Number of files under construction = " + size));
            for (int i = 0; i < size; ++i) {
                INodeFileUnderConstruction cons = FSImageSerialization.readINodeUnderConstruction(in, this.namesystem, LayoutVersion.supports(LayoutVersion.Feature.SNAPSHOT, this.storage.layoutVersion));
                String path = cons.getLocalName();
                INodesInPath iip = this.fsDir.getLastINodeInPath(path);
                INodeFile oldnode = INodeFile.valueOf(iip.getINode(0), path);
                cons.setLocalName(oldnode.getLocalNameBytes());
                cons.setParent(oldnode.getParent());
                if (oldnode instanceof INodeFileWithSnapshot) {
                    cons = new INodeFileUnderConstructionWithSnapshot(cons, ((INodeFileWithSnapshot)oldnode).getDiffs());
                }
                this.fsDir.replaceINodeFile(path, oldnode, cons);
                this.namesystem.leaseManager.addLease(cons.clientName, path);
            }
        }

        private void loadSecretManagerState(int version, DataInput in, FSNamesystem fs) throws IOException {
            if (!LayoutVersion.supports(LayoutVersion.Feature.DELEGATION_TOKEN, version)) {
                return;
            }
            fs.loadSecretManagerState(in);
        }

        private void loadDatanodes(int version, DataInputStream in) throws IOException {
            if (version > -3) {
                return;
            }
            if (version <= -12) {
                return;
            }
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                FSImage.DatanodeImage nodeImage = new FSImage.DatanodeImage();
                nodeImage.readFields(in);
            }
        }

        public Snapshot getSnapshot(DataInput in) throws IOException {
            return this.snapshotMap.get(in.readInt());
        }
    }
}

