/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;
import org.apache.hadoop.io.UTF8;

public class FSImageSerialization {
    private static final UTF8 U_STR = new UTF8();
    private static final FsPermission FILE_PERM = new FsPermission(0);

    private FSImageSerialization() {
    }

    public static String readString(DataInput in) throws IOException {
        U_STR.readFields(in);
        return U_STR.toString();
    }

    static String readString_EmptyAsNull(DataInput in) throws IOException {
        String s = FSImageSerialization.readString(in);
        return s.isEmpty() ? null : s;
    }

    static byte[] readBytes(DataInput in) throws IOException {
        U_STR.readFields(in);
        int len = U_STR.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(U_STR.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    public static byte[][] readPathComponents(DataInput in) throws IOException {
        U_STR.readFields(in);
        return DFSUtil.bytes2byteArray(U_STR.getBytes(), U_STR.getLength(), (byte)47);
    }

    static INodeFileUnderConstruction readINodeUnderConstruction(DataInput in, FSNamesystem fsNamesys, boolean toReadInodeId) throws IOException {
        byte[] name = FSImageSerialization.readBytes(in);
        long id = toReadInodeId ? in.readLong() : fsNamesys.allocateNewInodeId();
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlocksMap.BlockInfo[] blocks = new BlocksMap.BlockInfo[numBlocks];
        Block blk = new Block();
        for (int i = 0; i < numBlocks; ++i) {
            blk.readFields(in);
            blocks[i] = new BlocksMap.BlockInfo(blk, blockReplication);
        }
        PermissionStatus perm = PermissionStatus.read(in);
        String clientName = FSImageSerialization.readString(in);
        String clientMachine = FSImageSerialization.readString(in);
        in.readInt();
        return new INodeFileUnderConstruction(id, name, blockReplication, modificationTime, preferredBlockSize, blocks, perm, clientName, clientMachine, null);
    }

    public static void writeString(String str, DataOutput out) throws IOException {
        U_STR.set(str);
        U_STR.write(out);
    }

    private static void writePermissionStatus(INodeWithAdditionalFields inode, DataOutput out) throws IOException {
        FsPermission p = FILE_PERM;
        p.fromShort(inode.getFsPermissionShort());
        PermissionStatus.write(out, inode.getUserName(), inode.getGroupName(), p);
    }

    public static byte[] readLocalName(DataInput in) throws IOException {
        byte[] createdNodeName = new byte[in.readShort()];
        in.readFully(createdNodeName);
        return createdNodeName;
    }

    private static void writeLocalName(INode node, DataOutput out) throws IOException {
        byte[] name = node.getLocalNameBytes();
        out.writeShort(name.length);
        out.write(name);
    }

    private static void writeINodeReference(INodeReference ref, DataOutput out, boolean writeUnderConstruction, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
        FSImageSerialization.writeLocalName(ref, out);
        out.writeLong(ref.getId());
        out.writeShort(0);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-3);
        boolean isWithName = ref instanceof INodeReference.WithName;
        out.writeBoolean(isWithName);
        if (!isWithName) {
            out.writeInt(((INodeReference.DstReference)ref).getDstSnapshotId());
        } else {
            out.writeInt(((INodeReference.WithName)ref).getLastSnapshotId());
        }
        INodeReference.WithCount withCount = (INodeReference.WithCount)ref.getReferredINode();
        referenceMap.writeINodeReferenceWithCount(withCount, out, writeUnderConstruction);
    }

    public static void saveINode2Image(INode node, DataOutput out, boolean writeUnderConstruction, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
        if (node.isReference()) {
            FSImageSerialization.writeINodeReference(node.asReference(), out, writeUnderConstruction, referenceMap);
        } else if (node.isDirectory()) {
            FSImageSerialization.writeINodeDirectory(node.asDirectory(), out);
        } else if (node.isFile()) {
            FSImageSerialization.writeINodeFile(node.asFile(), out, writeUnderConstruction);
        }
    }

    public static void writeINodeFile(INodeFile file, DataOutput out, boolean writeUnderConstruction) throws IOException {
        FSImageSerialization.writeLocalName(file, out);
        out.writeLong(file.getId());
        out.writeShort(file.getFileReplication());
        out.writeLong(file.getModificationTime());
        out.writeLong(file.getAccessTime());
        out.writeLong(file.getPreferredBlockSize());
        FSImageSerialization.writeBlocks(file.getBlocks(), out);
        SnapshotFSImageFormat.saveFileDiffList(file, out);
        if (writeUnderConstruction) {
            if (file instanceof INodeFileUnderConstruction) {
                out.writeBoolean(true);
                INodeFileUnderConstruction uc = (INodeFileUnderConstruction)file;
                FSImageSerialization.writeString(uc.getClientName(), out);
                FSImageSerialization.writeString(uc.getClientMachine(), out);
            } else {
                out.writeBoolean(false);
            }
        }
        FSImageSerialization.writePermissionStatus(file, out);
    }

    public static void writeINodeDirectory(INodeDirectory node, DataOutput out) throws IOException {
        FSImageSerialization.writeLocalName(node, out);
        out.writeLong(node.getId());
        out.writeShort(0);
        out.writeLong(node.getModificationTime());
        out.writeLong(0L);
        out.writeLong(0L);
        out.writeInt(-1);
        out.writeLong(node.getNsQuota());
        out.writeLong(node.getDsQuota());
        if (node instanceof INodeDirectorySnapshottable) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeBoolean(node instanceof INodeDirectoryWithSnapshot);
        }
        FSImageSerialization.writePermissionStatus(node, out);
    }

    private static void writeBlocks(Block[] blocks, DataOutput out) throws IOException {
        if (blocks == null) {
            out.writeInt(0);
        } else {
            out.writeInt(blocks.length);
            for (Block blk : blocks) {
                blk.write(out);
            }
        }
    }

    static void writeINodeUnderConstruction(DataOutput out, INodeFileUnderConstruction cons, String path) throws IOException {
        FSImageSerialization.writeString(path, out);
        out.writeLong(cons.getId());
        out.writeShort(cons.getFileReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        FSImageSerialization.writeBlocks(cons.getBlocks(), out);
        cons.getPermissionStatus().write(out);
        FSImageSerialization.writeString(cons.getClientName(), out);
        FSImageSerialization.writeString(cons.getClientMachine(), out);
        out.writeInt(0);
    }
}

