/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSInodeInfo;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.Diff;

public abstract class INode
implements Diff.Element<byte[]>,
FSInodeInfo {
    public static final Log LOG = LogFactory.getLog(INode.class);
    private INode parent = null;

    INode(INode parent) {
        this.parent = parent;
    }

    public abstract long getId();

    final boolean isRoot() {
        return this.getLocalNameBytes().length == 0;
    }

    abstract PermissionStatus getPermissionStatus(Snapshot var1);

    public final PermissionStatus getPermissionStatus() {
        return this.getPermissionStatus(null);
    }

    public INode getSnapshotINode(Snapshot snapshot) {
        return this;
    }

    abstract String getUserName(Snapshot var1);

    public final String getUserName() {
        return this.getUserName(null);
    }

    abstract void setUser(String var1);

    final INode setUser(String user, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setUser(user);
        return nodeToUpdate;
    }

    abstract String getGroupName(Snapshot var1);

    public final String getGroupName() {
        return this.getGroupName(null);
    }

    abstract void setGroup(String var1);

    final INode setGroup(String group, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setGroup(group);
        return nodeToUpdate;
    }

    abstract FsPermission getFsPermission(Snapshot var1);

    public final FsPermission getFsPermission() {
        return this.getFsPermission(null);
    }

    abstract void setPermission(FsPermission var1);

    INode setPermission(FsPermission permission, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setPermission(permission);
        return nodeToUpdate;
    }

    public final boolean isInLatestSnapshot(Snapshot latest) {
        if (latest == null) {
            return false;
        }
        if (this.parent != null && this.parent.isReference()) {
            return true;
        }
        INodeDirectory parentDir = this.getParent();
        if (parentDir == null) {
            return true;
        }
        if (!parentDir.isInLatestSnapshot(latest)) {
            return false;
        }
        INode child = parentDir.getChild(this.getLocalNameBytes(), latest);
        if (this == child) {
            return true;
        }
        if (child == null || !child.isReference()) {
            return false;
        }
        return this == child.asReference().getReferredINode();
    }

    public final boolean isAncestorDirectory(INodeDirectory dir) {
        for (INodeDirectory p = this.getParent(); p != null; p = p.getParent()) {
            if (p != dir) continue;
            return true;
        }
        return false;
    }

    public final boolean shouldRecordInSrcSnapshot(Snapshot latestInDst) {
        int dstSnapshotId;
        if (this.isReference()) {
            throw new IllegalStateException("should not be a reference node: " + this.toDetailString());
        }
        if (latestInDst == null) {
            return true;
        }
        INodeReference withCount = this.getParentReference();
        return withCount != null && (dstSnapshotId = withCount.getParentReference().getDstSnapshotId()) >= latestInDst.getId();
    }

    public INodeFile asFile() {
        throw new IllegalStateException("Current inode is not a file: " + this.toDetailString());
    }

    public boolean isReference() {
        return false;
    }

    public INodeReference asReference() {
        throw new IllegalStateException("Current inode is not a reference: " + this.toDetailString());
    }

    abstract INode recordModification(Snapshot var1, INodeMap var2) throws QuotaExceededException;

    public boolean isFile() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public abstract Quota.Counts cleanSubtree(Snapshot var1, Snapshot var2, BlocksMapUpdateInfo var3, List<INode> var4) throws QuotaExceededException;

    public abstract void destroyAndCollectBlocks(BlocksMapUpdateInfo var1, List<INode> var2);

    public INodeDirectory asDirectory() {
        throw new IllegalStateException("Current inode is not a directory: " + this.toDetailString());
    }

    public final ContentSummary computeContentSummary() {
        Content.Counts counts = this.computeContentSummary(Content.Counts.newInstance());
        return new ContentSummary(counts.get(Content.LENGTH), counts.get(Content.FILE) + counts.get(Content.SYMLINK), counts.get(Content.DIRECTORY), this.getNsQuota(), counts.get(Content.DISKSPACE), this.getDsQuota());
    }

    public abstract Content.Counts computeContentSummary(Content.Counts var1);

    public void addSpaceConsumed(long nsDelta, long dsDelta, boolean verify, int snapshotId) throws QuotaExceededException {
        if (this.parent != null) {
            this.parent.addSpaceConsumed(nsDelta, dsDelta, verify, snapshotId);
        }
    }

    public void addSpaceConsumedToRenameSrc(long nsDelta, long dsDelta, boolean verify, int snapshotId) throws QuotaExceededException {
        if (this.parent != null) {
            this.parent.addSpaceConsumedToRenameSrc(nsDelta, dsDelta, verify, snapshotId);
        }
    }

    public long getNsQuota() {
        return -1L;
    }

    public long getDsQuota() {
        return -1L;
    }

    public final boolean isQuotaSet() {
        return this.getNsQuota() >= 0L || this.getDsQuota() >= 0L;
    }

    public final Quota.Counts computeQuotaUsage() {
        return this.computeQuotaUsage(new Quota.Counts(), true);
    }

    public abstract Quota.Counts computeQuotaUsage(Quota.Counts var1, boolean var2, int var3);

    public final Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache) {
        return this.computeQuotaUsage(counts, useCache, -1);
    }

    public final String getLocalName() {
        byte[] name = this.getLocalNameBytes();
        return name == null ? null : DFSUtil.bytes2String(name);
    }

    public abstract byte[] getLocalNameBytes();

    @Override
    public final byte[] getKey() {
        return this.getLocalNameBytes();
    }

    public abstract void setLocalName(byte[] var1);

    @Override
    public String getFullPathName() {
        return FSDirectory.getFullPathName(this);
    }

    public String toString() {
        return this.getLocalName();
    }

    public final String getObjectString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
    }

    public final String getParentString() {
        INodeReference parentRef = this.getParentReference();
        if (parentRef != null) {
            return "parentRef=" + parentRef.getLocalName() + "->";
        }
        INodeDirectory parentDir = this.getParent();
        if (parentDir != null) {
            return "parentDir=" + parentDir.getLocalName() + "/";
        }
        return "parent=null";
    }

    public String toDetailString() {
        return this.toString() + "(" + this.getObjectString() + "), " + this.getParentString();
    }

    public final INodeDirectory getParent() {
        return this.parent == null ? null : (this.parent.isReference() ? this.getParentReference().getParent() : this.parent.asDirectory());
    }

    public INodeReference getParentReference() {
        return this.parent == null || !this.parent.isReference() ? null : (INodeReference)this.parent;
    }

    public final void setParent(INodeDirectory parent) {
        this.parent = parent;
    }

    public final void setParentReference(INodeReference parent) {
        this.parent = parent;
    }

    public void clear() {
        this.setParent(null);
    }

    abstract long getModificationTime(Snapshot var1);

    public final long getModificationTime() {
        return this.getModificationTime(null);
    }

    public abstract INode updateModificationTime(long var1, Snapshot var3, INodeMap var4) throws QuotaExceededException;

    public abstract void setModificationTime(long var1);

    public final INode setModificationTime(long modificationTime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setModificationTime(modificationTime);
        return nodeToUpdate;
    }

    abstract long getAccessTime(Snapshot var1);

    public final long getAccessTime() {
        return this.getAccessTime(null);
    }

    public abstract void setAccessTime(long var1);

    public final INode setAccessTime(long accessTime, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INode nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setAccessTime(accessTime);
        return nodeToUpdate;
    }

    static byte[][] getPathComponents(String path) {
        return INode.getPathComponents(INode.getPathNames(path));
    }

    static byte[][] getPathComponents(String[] strings) {
        if (strings.length == 0) {
            return new byte[][]{null};
        }
        byte[][] bytes = new byte[strings.length][];
        for (int i = 0; i < strings.length; ++i) {
            bytes[i] = DFSUtil.string2Bytes(strings[i]);
        }
        return bytes;
    }

    static String[] getPathNames(String path) {
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        return path.split("/");
    }

    @Override
    public int compareTo(byte[] o) {
        return DFSUtil.compareBytes(this.getLocalNameBytes(), o);
    }

    public boolean equals(Object o) {
        if (!(o instanceof INode)) {
            return false;
        }
        INode thatInode = (INode)o;
        byte[] name = this.getLocalNameBytes();
        byte[] thatName = thatInode.getLocalNameBytes();
        return thatName == null ? this.getId() == thatInode.getId() : Arrays.equals(name, thatName);
    }

    public int hashCode() {
        long id = this.getId();
        return (int)(id ^ id >>> 32);
    }

    public final StringBuffer dumpTreeRecursively() {
        StringWriter out = new StringWriter();
        this.dumpTreeRecursively(new PrintWriter((Writer)out, true), new StringBuilder(), null);
        return out.getBuffer();
    }

    public final void dumpTreeRecursively(PrintStream out) {
        this.dumpTreeRecursively(new PrintWriter(out, true), new StringBuilder(), null);
    }

    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, Snapshot snapshot) {
        out.print(prefix);
        out.print(" ");
        String name = this.getLocalName();
        out.print(name.isEmpty() ? "/" : name);
        out.print("   (");
        out.print(this.getObjectString());
        out.print("), ");
        out.print(this.getParentString());
        out.print(", " + this.getPermissionStatus(snapshot));
    }

    public static class BlocksMapUpdateInfo {
        private List<Block> toDeleteList;

        public BlocksMapUpdateInfo(List<Block> toDeleteList) {
            this.toDeleteList = toDeleteList == null ? new ArrayList() : toDeleteList;
        }

        public BlocksMapUpdateInfo() {
            this.toDeleteList = new ArrayList<Block>();
        }

        public List<Block> getToDeleteList() {
            return this.toDeleteList;
        }

        public void addDeleteBlock(Block toDelete) {
            if (toDelete != null) {
                this.toDeleteList.add(toDelete);
            }
        }

        public void clear() {
            this.toDeleteList.clear();
        }
    }
}

