/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.INodeWithAdditionalFields;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

public class INodeFile
extends INodeWithAdditionalFields {
    protected long header = 0L;
    private BlocksMap.BlockInfo[] blocks = null;

    public static INodeFile valueOf(INode inode, String path) throws FileNotFoundException {
        return INodeFile.valueOf(inode, path, false);
    }

    public static INodeFile valueOf(INode inode, String path, boolean acceptNull) throws FileNotFoundException {
        if (inode == null) {
            if (acceptNull) {
                return null;
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!inode.isFile()) {
            throw new FileNotFoundException("Path is not a file: " + path);
        }
        return inode.asFile();
    }

    INodeFile(long id, byte[] name, PermissionStatus permissions, long mtime, long atime, BlocksMap.BlockInfo[] blklist, short replication, long preferredBlockSize) {
        super(id, name, permissions, mtime, atime);
        this.header = HeaderFormat.combineReplication(this.header, replication);
        this.header = HeaderFormat.combinePreferredBlockSize(this.header, preferredBlockSize);
        this.blocks = blklist;
    }

    public INodeFile(INodeFile that) {
        super(that);
        this.header = that.header;
        this.blocks = that.blocks;
    }

    @Override
    public final boolean isFile() {
        return true;
    }

    @Override
    public INodeFile getSnapshotINode(Snapshot snapshot) {
        return this;
    }

    @Override
    public INodeFile recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest)) {
            INodeFileWithSnapshot newFile = this.getParent().replaceChild4INodeFileWithSnapshot(this, inodeMap).recordModification(latest, inodeMap);
            return newFile;
        }
        return this;
    }

    @Override
    final void setPermission(FsPermission permission) {
        super.setPermission(permission);
    }

    @Override
    final INode setPermission(FsPermission permission, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        return super.setPermission(permission, latest, inodeMap);
    }

    public final short getFileReplication(Snapshot snapshot) {
        if (snapshot != null) {
            return this.getSnapshotINode(snapshot).getFileReplication();
        }
        return HeaderFormat.getReplication(this.header);
    }

    public final short getFileReplication() {
        return this.getFileReplication(null);
    }

    public final short getBlockReplication() {
        return this instanceof FileWithSnapshot ? FileWithSnapshot.Util.getBlockReplication((FileWithSnapshot)((Object)this)) : this.getFileReplication(null);
    }

    public final void setFileReplication(short replication) {
        this.header = HeaderFormat.combineReplication(this.header, replication);
    }

    public final INodeFile setFileReplication(short replication, Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        INodeFile nodeToUpdate = this.recordModification(latest, inodeMap);
        nodeToUpdate.setFileReplication(replication);
        return nodeToUpdate;
    }

    @Override
    public final INodeFile asFile() {
        return this;
    }

    public boolean isUnderConstruction() {
        return false;
    }

    public INodeFileUnderConstruction toUnderConstruction(String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        if (this.isUnderConstruction()) {
            throw new IllegalStateException("file is already an INodeFileUnderConstruction");
        }
        return new INodeFileUnderConstruction(this, clientName, clientMachine, clientNode);
    }

    public long getPreferredBlockSize() {
        return HeaderFormat.getPreferredBlockSize(this.header);
    }

    final long getBlockDiskspace() {
        return this.getPreferredBlockSize() * (long)this.getBlockReplication();
    }

    public BlocksMap.BlockInfo[] getBlocks() {
        return this.blocks;
    }

    public int numBlocks() {
        return this.blocks == null ? 0 : this.blocks.length;
    }

    void updateINodeForBlocks() {
        if (this.blocks != null) {
            for (BlocksMap.BlockInfo b : this.blocks) {
                b.setINode(this);
            }
        }
    }

    void concatBlocks(INodeFile[] inodes) {
        int size = this.blocks.length;
        int totalAddedBlocks = 0;
        for (INodeFile f : inodes) {
            totalAddedBlocks += f.blocks.length;
        }
        BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size + totalAddedBlocks];
        System.arraycopy(this.blocks, 0, newlist, 0, size);
        for (INodeFile in : inodes) {
            System.arraycopy(in.blocks, 0, newlist, size, in.blocks.length);
            size += in.blocks.length;
        }
        this.setBlocks(newlist);
        this.updateINodeForBlocks();
    }

    void addBlock(BlocksMap.BlockInfo newblock) {
        if (this.blocks == null) {
            this.setBlocks(new BlocksMap.BlockInfo[]{newblock});
        } else {
            int size = this.blocks.length;
            BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size + 1];
            System.arraycopy(this.blocks, 0, newlist, 0, size);
            newlist[size] = newblock;
            this.setBlocks(newlist);
        }
    }

    void setBlock(int idx, BlocksMap.BlockInfo blk) {
        this.blocks[idx] = blk;
    }

    public void setBlocks(BlocksMap.BlockInfo[] blocks) {
        this.blocks = blocks;
    }

    @Override
    public Quota.Counts cleanSubtree(Snapshot snapshot, Snapshot prior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) throws QuotaExceededException {
        Quota.Counts counts = Quota.Counts.newInstance();
        if (snapshot == null && prior == null) {
            this.computeQuotaUsage(counts, false);
            this.destroyAndCollectBlocks(collectedBlocks, removedINodes);
        }
        return counts;
    }

    @Override
    public void destroyAndCollectBlocks(INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
        if (this.blocks != null && collectedBlocks != null) {
            for (BlocksMap.BlockInfo blk : this.blocks) {
                collectedBlocks.addDeleteBlock(blk);
                blk.setINode(null);
            }
        }
        this.setBlocks(null);
        this.clear();
        removedINodes.add(this);
        if (this instanceof FileWithSnapshot) {
            ((FileWithSnapshot)((Object)this)).getDiffs().clear();
        }
    }

    LocatedBlocks createLocatedBlocks(List<LocatedBlock> blocks, Snapshot snapshot) {
        return new LocatedBlocks(this.computeFileSize(snapshot), blocks, this.isUnderConstruction());
    }

    @Override
    public final Quota.Counts computeQuotaUsage(Quota.Counts counts, boolean useCache, int lastSnapshotId) {
        long dsDelta;
        long nsDelta = 1L;
        if (this instanceof FileWithSnapshot) {
            FileDiffList fileDiffList = ((FileWithSnapshot)((Object)this)).getDiffs();
            Snapshot last = fileDiffList.getLastSnapshot();
            List diffs = fileDiffList.asList();
            if (lastSnapshotId == -1 || last == null) {
                nsDelta += (long)diffs.size();
                dsDelta = this.diskspaceConsumed();
            } else if (last.getId() < lastSnapshotId) {
                dsDelta = this.computeFileSize() * (long)this.getFileReplication();
            } else {
                Snapshot s = fileDiffList.getSnapshotById(lastSnapshotId);
                dsDelta = this.diskspaceConsumed(s);
            }
        } else {
            dsDelta = this.diskspaceConsumed();
        }
        counts.add(Quota.NAMESPACE, nsDelta);
        counts.add(Quota.DISKSPACE, dsDelta);
        return counts;
    }

    @Override
    public final Content.Counts computeContentSummary(Content.Counts counts) {
        this.computeContentSummary4Snapshot(counts);
        this.computeContentSummary4Current(counts);
        return counts;
    }

    private void computeContentSummary4Snapshot(Content.Counts counts) {
        if (this instanceof FileWithSnapshot) {
            FileWithSnapshot withSnapshot = (FileWithSnapshot)((Object)this);
            FileDiffList diffs = withSnapshot.getDiffs();
            int n = diffs.asList().size();
            counts.add(Content.FILE, n);
            if (n > 0 && withSnapshot.isCurrentFileDeleted()) {
                counts.add(Content.LENGTH, ((FileWithSnapshot.FileDiff)diffs.getLast()).getFileSize());
            }
            if (withSnapshot.isCurrentFileDeleted()) {
                long lastFileSize = ((FileWithSnapshot.FileDiff)diffs.getLast()).getFileSize();
                counts.add(Content.DISKSPACE, lastFileSize * (long)this.getBlockReplication());
            }
        }
    }

    private void computeContentSummary4Current(Content.Counts counts) {
        if (this instanceof FileWithSnapshot && ((FileWithSnapshot)((Object)this)).isCurrentFileDeleted()) {
            return;
        }
        counts.add(Content.LENGTH, this.computeFileSize());
        counts.add(Content.FILE, 1L);
        counts.add(Content.DISKSPACE, this.diskspaceConsumed());
    }

    public final long computeFileSize(Snapshot snapshot) {
        FileWithSnapshot.FileDiff d;
        if (snapshot != null && this instanceof FileWithSnapshot && (d = (FileWithSnapshot.FileDiff)((FileWithSnapshot)((Object)this)).getDiffs().getDiff(snapshot)) != null) {
            return d.getFileSize();
        }
        return this.computeFileSize();
    }

    public final long computeFileSize() {
        if (this.blocks == null || this.blocks.length == 0) {
            return 0L;
        }
        long size = 0L;
        for (int i = 0; i < this.blocks.length; ++i) {
            size += this.blocks[i].getNumBytes();
        }
        return size;
    }

    public final long computeFileSize(boolean includesLastUcBlock, boolean usePreferredBlockSize4LastUcBlock) {
        long size;
        if (this.blocks == null || this.blocks.length == 0) {
            return 0L;
        }
        int last = this.blocks.length - 1;
        long l = size = this.blocks[last] != null ? this.blocks[last].getNumBytes() : 0L;
        if (this.isUnderConstruction()) {
            if (!includesLastUcBlock) {
                size = 0L;
            } else if (usePreferredBlockSize4LastUcBlock) {
                size = this.getPreferredBlockSize();
            }
        }
        for (int i = 0; i < last; ++i) {
            size += this.blocks[i].getNumBytes();
        }
        return size;
    }

    public final long diskspaceConsumed() {
        long size = this.computeFileSize();
        if (this.blocks != null && this.blocks.length > 0 && this.blocks[this.blocks.length - 1] != null && this.isUnderConstruction()) {
            size += this.getPreferredBlockSize() - this.blocks[this.blocks.length - 1].getNumBytes();
        }
        return size * (long)this.getBlockReplication();
    }

    Block getPenultimateBlock() {
        if (this.blocks == null || this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    INodeFileUnderConstruction toINodeFileUnderConstruction(String clientName, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        if (this.isUnderConstruction()) {
            return (INodeFileUnderConstruction)this;
        }
        return new INodeFileUnderConstruction(this.getId(), this.getLocalNameBytes(), this.getBlockReplication(), this.getModificationTime(), this.getPreferredBlockSize(), this.blocks, this.getPermissionStatus(), clientName, clientMachine, clientNode);
    }

    BlocksMap.BlockInfo getLastBlock() {
        if (this.blocks == null || this.blocks.length == 0) {
            return null;
        }
        return this.blocks[this.blocks.length - 1];
    }

    public final long diskspaceConsumed(Snapshot lastSnapshot) {
        if (lastSnapshot != null) {
            return this.computeFileSize(lastSnapshot) * (long)this.getFileReplication(lastSnapshot);
        }
        return this.diskspaceConsumed();
    }

    @Override
    public void dumpTreeRecursively(PrintWriter out, StringBuilder prefix, Snapshot snapshot) {
        super.dumpTreeRecursively(out, prefix, snapshot);
        out.print(", fileSize=" + this.computeFileSize(snapshot));
        out.print(", blocks=");
        out.print(this.blocks == null || this.blocks.length == 0 ? null : this.blocks[0]);
        out.println();
    }

    private static class HeaderFormat {
        static final int BLOCKBITS = 48;
        static final long HEADERMASK = -281474976710656L;
        static final long MAX_BLOCK_SIZE = 0xFFFFFFFFFFFFL;

        private HeaderFormat() {
        }

        static short getReplication(long header) {
            return (short)((header & 0xFFFF000000000000L) >> 48);
        }

        static long combineReplication(long header, short replication) {
            if (replication <= 0) {
                throw new IllegalArgumentException("Unexpected value for the replication: " + replication);
            }
            return (long)replication << 48 | header & 0xFFFFFFFFFFFFL;
        }

        static long getPreferredBlockSize(long header) {
            return header & 0xFFFFFFFFFFFFL;
        }

        static long combinePreferredBlockSize(long header, long blockSize) {
            if (blockSize < 0L) {
                throw new IllegalArgumentException("Block size < 0: " + blockSize);
            }
            if (blockSize > 0xFFFFFFFFFFFFL) {
                throw new IllegalArgumentException("Block size = " + blockSize + " > MAX_BLOCK_SIZE = " + 0xFFFFFFFFFFFFL);
            }
            return header & 0xFFFF000000000000L | blockSize & 0xFFFFFFFFFFFFL;
        }
    }
}

